#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 539
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 108
#define ALIAS_COUNT 0
#define TOKEN_COUNT 62
#define EXTERNAL_TOKEN_COUNT 6
#define FIELD_COUNT 22
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 41

enum ts_symbol_identifiers {
  sym_keyword = 1,
  sym_identifier = 2,
  sym_integer_expression = 3,
  sym_float_expression = 4,
  sym__hpath_start = 5,
  sym_spath_expression = 6,
  sym_uri_expression = 7,
  anon_sym_COLON = 8,
  anon_sym_AT = 9,
  anon_sym_LBRACE = 10,
  anon_sym_RBRACE = 11,
  anon_sym_COMMA = 12,
  anon_sym_QMARK = 13,
  sym_ellipses = 14,
  anon_sym_assert = 15,
  anon_sym_SEMI = 16,
  anon_sym_with = 17,
  anon_sym_let = 18,
  anon_sym_in = 19,
  anon_sym_if = 20,
  anon_sym_then = 21,
  anon_sym_else = 22,
  anon_sym_BANG = 23,
  anon_sym_DASH = 24,
  anon_sym_EQ_EQ = 25,
  anon_sym_BANG_EQ = 26,
  anon_sym_LT = 27,
  anon_sym_LT_EQ = 28,
  anon_sym_GT = 29,
  anon_sym_GT_EQ = 30,
  anon_sym_AMP_AMP = 31,
  anon_sym_PIPE_PIPE = 32,
  anon_sym_PLUS = 33,
  anon_sym_STAR = 34,
  anon_sym_SLASH = 35,
  anon_sym_DASH_GT = 36,
  anon_sym_SLASH_SLASH = 37,
  anon_sym_PLUS_PLUS = 38,
  anon_sym_DOT = 39,
  anon_sym_or = 40,
  anon_sym_LPAREN = 41,
  anon_sym_RPAREN = 42,
  anon_sym_rec = 43,
  anon_sym_DQUOTE = 44,
  anon_sym_DOLLAR = 45,
  sym_escape_sequence = 46,
  anon_sym_SQUOTE_SQUOTE = 47,
  sym__indented_escape_sequence = 48,
  anon_sym_EQ = 49,
  anon_sym_inherit = 50,
  anon_sym_DOLLAR_LBRACE = 51,
  anon_sym_DOLLAR_LBRACE2 = 52,
  anon_sym_LBRACK = 53,
  anon_sym_RBRACK = 54,
  sym_comment = 55,
  sym_string_fragment = 56,
  sym__indented_string_fragment = 57,
  sym__path_start = 58,
  sym_path_fragment = 59,
  sym_dollar_escape = 60,
  sym__indented_dollar_escape = 61,
  sym_source_code = 62,
  sym__expression = 63,
  sym_variable_expression = 64,
  sym_path_expression = 65,
  sym_hpath_expression = 66,
  sym__expr_function_expression = 67,
  sym_function_expression = 68,
  sym_formals = 69,
  sym_formal = 70,
  sym_assert_expression = 71,
  sym_with_expression = 72,
  sym_let_expression = 73,
  sym__expr_if = 74,
  sym_if_expression = 75,
  sym__expr_op = 76,
  sym_has_attr_expression = 77,
  sym_unary_expression = 78,
  sym_binary_expression = 79,
  sym__expr_apply_expression = 80,
  sym_apply_expression = 81,
  sym__expr_select_expression = 82,
  sym_select_expression = 83,
  sym__expr_simple = 84,
  sym_parenthesized_expression = 85,
  sym_attrset_expression = 86,
  sym_let_attrset_expression = 87,
  sym_rec_attrset_expression = 88,
  sym_string_expression = 89,
  sym_indented_string_expression = 90,
  sym_binding_set = 91,
  sym_binding = 92,
  sym_inherit = 93,
  sym_inherit_from = 94,
  sym_attrpath = 95,
  sym_inherited_attrs = 96,
  sym__immediate_interpolation = 97,
  sym_interpolation = 98,
  sym_list_expression = 99,
  aux_sym_path_expression_repeat1 = 100,
  aux_sym_formals_repeat1 = 101,
  aux_sym_string_expression_repeat1 = 102,
  aux_sym_indented_string_expression_repeat1 = 103,
  aux_sym_binding_set_repeat1 = 104,
  aux_sym_attrpath_repeat1 = 105,
  aux_sym_inherited_attrs_repeat1 = 106,
  aux_sym_list_expression_repeat1 = 107,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_keyword] = "keyword",
  [sym_identifier] = "identifier",
  [sym_integer_expression] = "integer_expression",
  [sym_float_expression] = "float_expression",
  [sym__hpath_start] = "path_fragment",
  [sym_spath_expression] = "spath_expression",
  [sym_uri_expression] = "uri_expression",
  [anon_sym_COLON] = ":",
  [anon_sym_AT] = "@",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_COMMA] = ",",
  [anon_sym_QMARK] = "\?",
  [sym_ellipses] = "ellipses",
  [anon_sym_assert] = "assert",
  [anon_sym_SEMI] = ";",
  [anon_sym_with] = "with",
  [anon_sym_let] = "let",
  [anon_sym_in] = "in",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_else] = "else",
  [anon_sym_BANG] = "!",
  [anon_sym_DASH] = "-",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PLUS] = "+",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DOT] = ".",
  [anon_sym_or] = "or",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_rec] = "rec",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_DOLLAR] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [anon_sym_SQUOTE_SQUOTE] = "''",
  [sym__indented_escape_sequence] = "escape_sequence",
  [anon_sym_EQ] = "=",
  [anon_sym_inherit] = "inherit",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_DOLLAR_LBRACE2] = "${",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [sym_comment] = "comment",
  [sym_string_fragment] = "string_fragment",
  [sym__indented_string_fragment] = "string_fragment",
  [sym__path_start] = "path_fragment",
  [sym_path_fragment] = "path_fragment",
  [sym_dollar_escape] = "dollar_escape",
  [sym__indented_dollar_escape] = "dollar_escape",
  [sym_source_code] = "source_code",
  [sym__expression] = "_expression",
  [sym_variable_expression] = "variable_expression",
  [sym_path_expression] = "path_expression",
  [sym_hpath_expression] = "hpath_expression",
  [sym__expr_function_expression] = "_expr_function_expression",
  [sym_function_expression] = "function_expression",
  [sym_formals] = "formals",
  [sym_formal] = "formal",
  [sym_assert_expression] = "assert_expression",
  [sym_with_expression] = "with_expression",
  [sym_let_expression] = "let_expression",
  [sym__expr_if] = "_expr_if",
  [sym_if_expression] = "if_expression",
  [sym__expr_op] = "_expr_op",
  [sym_has_attr_expression] = "has_attr_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym__expr_apply_expression] = "_expr_apply_expression",
  [sym_apply_expression] = "apply_expression",
  [sym__expr_select_expression] = "_expr_select_expression",
  [sym_select_expression] = "select_expression",
  [sym__expr_simple] = "_expr_simple",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_attrset_expression] = "attrset_expression",
  [sym_let_attrset_expression] = "let_attrset_expression",
  [sym_rec_attrset_expression] = "rec_attrset_expression",
  [sym_string_expression] = "string_expression",
  [sym_indented_string_expression] = "indented_string_expression",
  [sym_binding_set] = "binding_set",
  [sym_binding] = "binding",
  [sym_inherit] = "inherit",
  [sym_inherit_from] = "inherit_from",
  [sym_attrpath] = "attrpath",
  [sym_inherited_attrs] = "inherited_attrs",
  [sym__immediate_interpolation] = "interpolation",
  [sym_interpolation] = "interpolation",
  [sym_list_expression] = "list_expression",
  [aux_sym_path_expression_repeat1] = "path_expression_repeat1",
  [aux_sym_formals_repeat1] = "formals_repeat1",
  [aux_sym_string_expression_repeat1] = "string_expression_repeat1",
  [aux_sym_indented_string_expression_repeat1] = "indented_string_expression_repeat1",
  [aux_sym_binding_set_repeat1] = "binding_set_repeat1",
  [aux_sym_attrpath_repeat1] = "attrpath_repeat1",
  [aux_sym_inherited_attrs_repeat1] = "inherited_attrs_repeat1",
  [aux_sym_list_expression_repeat1] = "list_expression_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_keyword] = sym_keyword,
  [sym_identifier] = sym_identifier,
  [sym_integer_expression] = sym_integer_expression,
  [sym_float_expression] = sym_float_expression,
  [sym__hpath_start] = sym_path_fragment,
  [sym_spath_expression] = sym_spath_expression,
  [sym_uri_expression] = sym_uri_expression,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [sym_ellipses] = sym_ellipses,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_rec] = anon_sym_rec,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_DOLLAR] = sym_string_fragment,
  [sym_escape_sequence] = sym_escape_sequence,
  [anon_sym_SQUOTE_SQUOTE] = anon_sym_SQUOTE_SQUOTE,
  [sym__indented_escape_sequence] = sym_escape_sequence,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_inherit] = anon_sym_inherit,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_DOLLAR_LBRACE2] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [sym_comment] = sym_comment,
  [sym_string_fragment] = sym_string_fragment,
  [sym__indented_string_fragment] = sym_string_fragment,
  [sym__path_start] = sym_path_fragment,
  [sym_path_fragment] = sym_path_fragment,
  [sym_dollar_escape] = sym_dollar_escape,
  [sym__indented_dollar_escape] = sym_dollar_escape,
  [sym_source_code] = sym_source_code,
  [sym__expression] = sym__expression,
  [sym_variable_expression] = sym_variable_expression,
  [sym_path_expression] = sym_path_expression,
  [sym_hpath_expression] = sym_hpath_expression,
  [sym__expr_function_expression] = sym__expr_function_expression,
  [sym_function_expression] = sym_function_expression,
  [sym_formals] = sym_formals,
  [sym_formal] = sym_formal,
  [sym_assert_expression] = sym_assert_expression,
  [sym_with_expression] = sym_with_expression,
  [sym_let_expression] = sym_let_expression,
  [sym__expr_if] = sym__expr_if,
  [sym_if_expression] = sym_if_expression,
  [sym__expr_op] = sym__expr_op,
  [sym_has_attr_expression] = sym_has_attr_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym__expr_apply_expression] = sym__expr_apply_expression,
  [sym_apply_expression] = sym_apply_expression,
  [sym__expr_select_expression] = sym__expr_select_expression,
  [sym_select_expression] = sym_select_expression,
  [sym__expr_simple] = sym__expr_simple,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_attrset_expression] = sym_attrset_expression,
  [sym_let_attrset_expression] = sym_let_attrset_expression,
  [sym_rec_attrset_expression] = sym_rec_attrset_expression,
  [sym_string_expression] = sym_string_expression,
  [sym_indented_string_expression] = sym_indented_string_expression,
  [sym_binding_set] = sym_binding_set,
  [sym_binding] = sym_binding,
  [sym_inherit] = sym_inherit,
  [sym_inherit_from] = sym_inherit_from,
  [sym_attrpath] = sym_attrpath,
  [sym_inherited_attrs] = sym_inherited_attrs,
  [sym__immediate_interpolation] = sym_interpolation,
  [sym_interpolation] = sym_interpolation,
  [sym_list_expression] = sym_list_expression,
  [aux_sym_path_expression_repeat1] = aux_sym_path_expression_repeat1,
  [aux_sym_formals_repeat1] = aux_sym_formals_repeat1,
  [aux_sym_string_expression_repeat1] = aux_sym_string_expression_repeat1,
  [aux_sym_indented_string_expression_repeat1] = aux_sym_indented_string_expression_repeat1,
  [aux_sym_binding_set_repeat1] = aux_sym_binding_set_repeat1,
  [aux_sym_attrpath_repeat1] = aux_sym_attrpath_repeat1,
  [aux_sym_inherited_attrs_repeat1] = aux_sym_inherited_attrs_repeat1,
  [aux_sym_list_expression_repeat1] = aux_sym_list_expression_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_integer_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_float_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__hpath_start] = {
    .visible = true,
    .named = true,
  },
  [sym_spath_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_uri_expression] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [sym_ellipses] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym__indented_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inherit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym__indented_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym__path_start] = {
    .visible = true,
    .named = true,
  },
  [sym_path_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_dollar_escape] = {
    .visible = true,
    .named = true,
  },
  [sym__indented_dollar_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_source_code] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_variable_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_path_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_hpath_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expr_function_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_function_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_formals] = {
    .visible = true,
    .named = true,
  },
  [sym_formal] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_with_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_let_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expr_if] = {
    .visible = false,
    .named = true,
  },
  [sym_if_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expr_op] = {
    .visible = false,
    .named = true,
  },
  [sym_has_attr_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expr_apply_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_apply_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expr_select_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_select_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expr_simple] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_attrset_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_let_attrset_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_rec_attrset_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_indented_string_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binding_set] = {
    .visible = true,
    .named = true,
  },
  [sym_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_inherit] = {
    .visible = true,
    .named = true,
  },
  [sym_inherit_from] = {
    .visible = true,
    .named = true,
  },
  [sym_attrpath] = {
    .visible = true,
    .named = true,
  },
  [sym_inherited_attrs] = {
    .visible = true,
    .named = true,
  },
  [sym__immediate_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_list_expression] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_path_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formals_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_indented_string_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_binding_set_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attrpath_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inherited_attrs_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_alternative = 1,
  field_argument = 2,
  field_attr = 3,
  field_attrpath = 4,
  field_attrs = 5,
  field_binding = 6,
  field_body = 7,
  field_condition = 8,
  field_consequence = 9,
  field_default = 10,
  field_element = 11,
  field_ellipses = 12,
  field_environment = 13,
  field_expression = 14,
  field_formal = 15,
  field_formals = 16,
  field_function = 17,
  field_left = 18,
  field_name = 19,
  field_operator = 20,
  field_right = 21,
  field_universal = 22,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_attr] = "attr",
  [field_attrpath] = "attrpath",
  [field_attrs] = "attrs",
  [field_binding] = "binding",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_default] = "default",
  [field_element] = "element",
  [field_ellipses] = "ellipses",
  [field_environment] = "environment",
  [field_expression] = "expression",
  [field_formal] = "formal",
  [field_formals] = "formals",
  [field_function] = "function",
  [field_left] = "left",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_right] = "right",
  [field_universal] = "universal",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 1},
  [5] = {.index = 4, .length = 1},
  [6] = {.index = 5, .length = 1},
  [7] = {.index = 6, .length = 2},
  [8] = {.index = 8, .length = 1},
  [9] = {.index = 9, .length = 2},
  [10] = {.index = 11, .length = 2},
  [11] = {.index = 13, .length = 2},
  [12] = {.index = 15, .length = 1},
  [13] = {.index = 16, .length = 1},
  [14] = {.index = 17, .length = 1},
  [15] = {.index = 18, .length = 2},
  [16] = {.index = 20, .length = 1},
  [17] = {.index = 21, .length = 1},
  [18] = {.index = 22, .length = 1},
  [19] = {.index = 23, .length = 2},
  [20] = {.index = 25, .length = 2},
  [21] = {.index = 27, .length = 3},
  [22] = {.index = 30, .length = 3},
  [23] = {.index = 33, .length = 2},
  [24] = {.index = 35, .length = 2},
  [25] = {.index = 37, .length = 1},
  [26] = {.index = 38, .length = 2},
  [27] = {.index = 40, .length = 1},
  [28] = {.index = 41, .length = 2},
  [29] = {.index = 43, .length = 2},
  [30] = {.index = 45, .length = 2},
  [31] = {.index = 47, .length = 2},
  [32] = {.index = 49, .length = 1},
  [33] = {.index = 50, .length = 3},
  [34] = {.index = 53, .length = 2},
  [35] = {.index = 55, .length = 2},
  [36] = {.index = 57, .length = 3},
  [37] = {.index = 60, .length = 3},
  [38] = {.index = 63, .length = 3},
  [39] = {.index = 66, .length = 3},
  [40] = {.index = 69, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_expression, 0},
  [2] =
    {field_expression, 0, .inherited = true},
  [3] =
    {field_attr, 0},
  [4] =
    {field_binding, 0},
  [5] =
    {field_binding, 0, .inherited = true},
  [6] =
    {field_argument, 1},
    {field_operator, 0},
  [8] =
    {field_element, 0},
  [9] =
    {field_argument, 1},
    {field_function, 0},
  [11] =
    {field_body, 2},
    {field_universal, 0},
  [13] =
    {field_attr, 0},
    {field_attr, 1, .inherited = true},
  [15] =
    {field_ellipses, 1},
  [16] =
    {field_attr, 0, .inherited = true},
  [17] =
    {field_formal, 1},
  [18] =
    {field_binding, 0, .inherited = true},
    {field_binding, 1, .inherited = true},
  [20] =
    {field_body, 2},
  [21] =
    {field_expression, 1},
  [22] =
    {field_element, 1, .inherited = true},
  [23] =
    {field_element, 0, .inherited = true},
    {field_element, 1, .inherited = true},
  [25] =
    {field_body, 2},
    {field_formals, 0},
  [27] =
    {field_attrpath, 2},
    {field_expression, 0},
    {field_operator, 1},
  [30] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [33] =
    {field_attrpath, 2},
    {field_expression, 0},
  [35] =
    {field_default, 2},
    {field_name, 0},
  [37] =
    {field_attr, 1},
  [38] =
    {field_attr, 0, .inherited = true},
    {field_attr, 1, .inherited = true},
  [40] =
    {field_attrs, 1},
  [41] =
    {field_formal, 1},
    {field_formal, 2, .inherited = true},
  [43] =
    {field_formal, 0, .inherited = true},
    {field_formal, 1, .inherited = true},
  [45] =
    {field_body, 3},
    {field_condition, 1},
  [47] =
    {field_body, 3},
    {field_environment, 1},
  [49] =
    {field_body, 3},
  [50] =
    {field_body, 4},
    {field_formals, 2},
    {field_universal, 0},
  [53] =
    {field_ellipses, 3},
    {field_formal, 1},
  [55] =
    {field_attrpath, 0},
    {field_expression, 2},
  [57] =
    {field_body, 4},
    {field_formals, 0},
    {field_universal, 2},
  [60] =
    {field_attrpath, 2},
    {field_default, 4},
    {field_expression, 0},
  [63] =
    {field_ellipses, 4},
    {field_formal, 1},
    {field_formal, 2, .inherited = true},
  [66] =
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
  [69] =
    {field_attrs, 4},
    {field_expression, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(128);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '$') ADVANCE(155);
      if (lookahead == '&') ADVANCE(4);
      if (lookahead == '\'') ADVANCE(5);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == '0') ADVANCE(112);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(134);
      if (lookahead == '=') ADVANCE(162);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '@') ADVANCE(120);
      if (lookahead == '[') ADVANCE(165);
      if (lookahead == '\\') ADVANCE(47);
      if (lookahead == ']') ADVANCE(166);
      if (lookahead == 'a') ADVANCE(105);
      if (lookahead == 'e') ADVANCE(100);
      if (lookahead == 'i') ADVANCE(95);
      if (lookahead == 'l') ADVANCE(90);
      if (lookahead == 'o') ADVANCE(103);
      if (lookahead == 'r') ADVANCE(91);
      if (lookahead == 't') ADVANCE(97);
      if (lookahead == 'w') ADVANCE(99);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '|') ADVANCE(40);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '~') ADVANCE(12);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(49)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(15);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '$') ADVANCE(39);
      if (lookahead == '&') ADVANCE(4);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(146);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(133);
      if (lookahead == '=') ADVANCE(162);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '|') ADVANCE(40);
      if (lookahead == '}') ADVANCE(122);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '$') ADVANCE(39);
      if (lookahead == '.') ADVANCE(10);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == 'a') ADVANCE(105);
      if (lookahead == 'e') ADVANCE(100);
      if (lookahead == 'i') ADVANCE(95);
      if (lookahead == 'l') ADVANCE(90);
      if (lookahead == 'r') ADVANCE(91);
      if (lookahead == 't') ADVANCE(97);
      if (lookahead == 'w') ADVANCE(99);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '}') ADVANCE(122);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 3:
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '.') ADVANCE(10);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '}') ADVANCE(122);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 4:
      if (lookahead == '&') ADVANCE(138);
      END_STATE();
    case 5:
      if (lookahead == '\'') ADVANCE(159);
      END_STATE();
    case 6:
      if (lookahead == '\'') ADVANCE(158);
      END_STATE();
    case 7:
      if (lookahead == '*') ADVANCE(9);
      END_STATE();
    case 8:
      if (lookahead == '*') ADVANCE(8);
      if (lookahead == '/') ADVANCE(167);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 9:
      if (lookahead == '*') ADVANCE(8);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 10:
      if (lookahead == '.') ADVANCE(11);
      END_STATE();
    case 11:
      if (lookahead == '.') ADVANCE(125);
      END_STATE();
    case 12:
      if (lookahead == '/') ADVANCE(45);
      END_STATE();
    case 13:
      if (lookahead == '/') ADVANCE(44);
      if (lookahead == '>') ADVANCE(117);
      if (lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(13);
      END_STATE();
    case 14:
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(14);
      END_STATE();
    case 15:
      if (lookahead == '=') ADVANCE(132);
      END_STATE();
    case 16:
      if (lookahead == '=') ADVANCE(131);
      END_STATE();
    case 17:
      if (lookahead == 'c') ADVANCE(59);
      END_STATE();
    case 18:
      if (lookahead == 'e') ADVANCE(59);
      END_STATE();
    case 19:
      if (lookahead == 'e') ADVANCE(36);
      END_STATE();
    case 20:
      if (lookahead == 'e') ADVANCE(17);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(30);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(31);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 24:
      if (lookahead == 'f') ADVANCE(59);
      if (lookahead == 'n') ADVANCE(63);
      END_STATE();
    case 25:
      if (lookahead == 'h') ADVANCE(59);
      END_STATE();
    case 26:
      if (lookahead == 'h') ADVANCE(21);
      END_STATE();
    case 27:
      if (lookahead == 'i') ADVANCE(36);
      END_STATE();
    case 28:
      if (lookahead == 'i') ADVANCE(37);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(35);
      END_STATE();
    case 30:
      if (lookahead == 'n') ADVANCE(59);
      END_STATE();
    case 31:
      if (lookahead == 'r') ADVANCE(36);
      END_STATE();
    case 32:
      if (lookahead == 'r') ADVANCE(27);
      END_STATE();
    case 33:
      if (lookahead == 's') ADVANCE(34);
      END_STATE();
    case 34:
      if (lookahead == 's') ADVANCE(22);
      END_STATE();
    case 35:
      if (lookahead == 's') ADVANCE(18);
      END_STATE();
    case 36:
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 37:
      if (lookahead == 't') ADVANCE(25);
      END_STATE();
    case 38:
      if (lookahead == '{') ADVANCE(163);
      END_STATE();
    case 39:
      if (lookahead == '{') ADVANCE(164);
      END_STATE();
    case 40:
      if (lookahead == '|') ADVANCE(139);
      END_STATE();
    case 41:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(115);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(114);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(115);
      END_STATE();
    case 44:
      if (lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(13);
      END_STATE();
    case 45:
      if (lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 46:
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          ('*' <= lookahead && lookahead <= ':') ||
          lookahead == '=' ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '~') ADVANCE(118);
      END_STATE();
    case 47:
      if (lookahead != 0 &&
          lookahead != '$') ADVANCE(157);
      END_STATE();
    case 48:
      if (lookahead != 0 &&
          lookahead != '$') ADVANCE(160);
      END_STATE();
    case 49:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(128);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '$') ADVANCE(156);
      if (lookahead == '&') ADVANCE(4);
      if (lookahead == '\'') ADVANCE(6);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(147);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == '0') ADVANCE(112);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(134);
      if (lookahead == '=') ADVANCE(162);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '@') ADVANCE(120);
      if (lookahead == '[') ADVANCE(165);
      if (lookahead == ']') ADVANCE(166);
      if (lookahead == 'a') ADVANCE(105);
      if (lookahead == 'e') ADVANCE(100);
      if (lookahead == 'i') ADVANCE(95);
      if (lookahead == 'l') ADVANCE(90);
      if (lookahead == 'o') ADVANCE(103);
      if (lookahead == 'r') ADVANCE(91);
      if (lookahead == 't') ADVANCE(97);
      if (lookahead == 'w') ADVANCE(99);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '|') ADVANCE(40);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '~') ADVANCE(12);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(49)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 50:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '$') ADVANCE(39);
      if (lookahead == '\'') ADVANCE(6);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(129);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(112);
      if (lookahead == '<') ADVANCE(44);
      if (lookahead == '=') ADVANCE(161);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '[') ADVANCE(165);
      if (lookahead == '\\') ADVANCE(47);
      if (lookahead == ']') ADVANCE(166);
      if (lookahead == '_') ADVANCE(110);
      if (lookahead == 'a') ADVANCE(82);
      if (lookahead == 'e') ADVANCE(77);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'l') ADVANCE(67);
      if (lookahead == 'r') ADVANCE(68);
      if (lookahead == 't') ADVANCE(74);
      if (lookahead == 'w') ADVANCE(76);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '~') ADVANCE(12);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(51)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 51:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '$') ADVANCE(39);
      if (lookahead == '\'') ADVANCE(6);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(129);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(112);
      if (lookahead == '<') ADVANCE(44);
      if (lookahead == '=') ADVANCE(161);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '[') ADVANCE(165);
      if (lookahead == ']') ADVANCE(166);
      if (lookahead == '_') ADVANCE(110);
      if (lookahead == 'a') ADVANCE(82);
      if (lookahead == 'e') ADVANCE(77);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'l') ADVANCE(67);
      if (lookahead == 'r') ADVANCE(68);
      if (lookahead == 't') ADVANCE(74);
      if (lookahead == 'w') ADVANCE(76);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '~') ADVANCE(12);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(51)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 52:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(15);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '$') ADVANCE(154);
      if (lookahead == '&') ADVANCE(4);
      if (lookahead == '\'') ADVANCE(6);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == '0') ADVANCE(112);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(134);
      if (lookahead == '=') ADVANCE(16);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '[') ADVANCE(165);
      if (lookahead == ']') ADVANCE(166);
      if (lookahead == '_') ADVANCE(110);
      if (lookahead == 'a') ADVANCE(82);
      if (lookahead == 'e') ADVANCE(77);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'l') ADVANCE(67);
      if (lookahead == 'o') ADVANCE(80);
      if (lookahead == 'r') ADVANCE(68);
      if (lookahead == 't') ADVANCE(74);
      if (lookahead == 'w') ADVANCE(76);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '|') ADVANCE(40);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '~') ADVANCE(12);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(52)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 53:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(15);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '$') ADVANCE(38);
      if (lookahead == '&') ADVANCE(4);
      if (lookahead == '\'') ADVANCE(6);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == '0') ADVANCE(112);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(134);
      if (lookahead == '=') ADVANCE(16);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '@') ADVANCE(120);
      if (lookahead == '[') ADVANCE(165);
      if (lookahead == ']') ADVANCE(166);
      if (lookahead == '_') ADVANCE(110);
      if (lookahead == 'a') ADVANCE(82);
      if (lookahead == 'e') ADVANCE(77);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'l') ADVANCE(67);
      if (lookahead == 'r') ADVANCE(68);
      if (lookahead == 't') ADVANCE(74);
      if (lookahead == 'w') ADVANCE(76);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '|') ADVANCE(40);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '~') ADVANCE(12);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(54)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 54:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(15);
      if (lookahead == '"') ADVANCE(153);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '&') ADVANCE(4);
      if (lookahead == '\'') ADVANCE(6);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == '0') ADVANCE(112);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(134);
      if (lookahead == '=') ADVANCE(16);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '@') ADVANCE(120);
      if (lookahead == '[') ADVANCE(165);
      if (lookahead == ']') ADVANCE(166);
      if (lookahead == '_') ADVANCE(110);
      if (lookahead == 'a') ADVANCE(82);
      if (lookahead == 'e') ADVANCE(77);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'l') ADVANCE(67);
      if (lookahead == 'r') ADVANCE(68);
      if (lookahead == 't') ADVANCE(74);
      if (lookahead == 'w') ADVANCE(76);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '|') ADVANCE(40);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '~') ADVANCE(12);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(54)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 55:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(15);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '$') ADVANCE(39);
      if (lookahead == '&') ADVANCE(4);
      if (lookahead == '\'') ADVANCE(5);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(146);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(133);
      if (lookahead == '=') ADVANCE(162);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == 'a') ADVANCE(33);
      if (lookahead == 'e') ADVANCE(29);
      if (lookahead == 'i') ADVANCE(24);
      if (lookahead == 'l') ADVANCE(19);
      if (lookahead == 'r') ADVANCE(20);
      if (lookahead == 't') ADVANCE(26);
      if (lookahead == 'w') ADVANCE(28);
      if (lookahead == '|') ADVANCE(40);
      if (lookahead == '}') ADVANCE(122);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(56)
      END_STATE();
    case 56:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(15);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '$') ADVANCE(39);
      if (lookahead == '&') ADVANCE(4);
      if (lookahead == '\'') ADVANCE(6);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(146);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(133);
      if (lookahead == '=') ADVANCE(162);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == 'a') ADVANCE(33);
      if (lookahead == 'e') ADVANCE(29);
      if (lookahead == 'i') ADVANCE(24);
      if (lookahead == 'l') ADVANCE(19);
      if (lookahead == 'r') ADVANCE(20);
      if (lookahead == 't') ADVANCE(26);
      if (lookahead == 'w') ADVANCE(28);
      if (lookahead == '|') ADVANCE(40);
      if (lookahead == '}') ADVANCE(122);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(56)
      END_STATE();
    case 57:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(15);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '&') ADVANCE(4);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '.') ADVANCE(146);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ';') ADVANCE(126);
      if (lookahead == '<') ADVANCE(133);
      if (lookahead == '=') ADVANCE(16);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == 'a') ADVANCE(33);
      if (lookahead == 'e') ADVANCE(29);
      if (lookahead == 'i') ADVANCE(24);
      if (lookahead == 'l') ADVANCE(19);
      if (lookahead == 'r') ADVANCE(20);
      if (lookahead == 't') ADVANCE(26);
      if (lookahead == 'w') ADVANCE(28);
      if (lookahead == '|') ADVANCE(40);
      if (lookahead == '}') ADVANCE(122);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(57)
      END_STATE();
    case 58:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_keyword);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 'h') ADVANCE(71);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'h') ADVANCE(94);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'h') ADVANCE(23);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 'c') ADVANCE(61);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 'e') ADVANCE(61);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 'e') ADVANCE(85);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 'e') ADVANCE(65);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 'e') ADVANCE(78);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 'e') ADVANCE(79);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 'e') ADVANCE(81);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 'f') ADVANCE(61);
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 'h') ADVANCE(61);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 'h') ADVANCE(69);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 'i') ADVANCE(85);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 'i') ADVANCE(86);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 'l') ADVANCE(84);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 'n') ADVANCE(61);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 'r') ADVANCE(85);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 'r') ADVANCE(149);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 'r') ADVANCE(75);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 's') ADVANCE(83);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 's') ADVANCE(70);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 's') ADVANCE(66);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 't') ADVANCE(61);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == 't') ADVANCE(73);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(64);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(64);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(108);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(88);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(101);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(102);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(104);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(64);
      if (lookahead == 'n') ADVANCE(62);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(64);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(92);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(108);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(109);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(107);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(64);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(108);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(150);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(98);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(93);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(89);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(64);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(96);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_integer_expression);
      if (lookahead == '.') ADVANCE(114);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_integer_expression);
      if (lookahead == '.') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(113);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_integer_expression);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(113);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_float_expression);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(114);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_float_expression);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(115);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym__hpath_start);
      if (lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_spath_expression);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_uri_expression);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '\'') ||
          ('*' <= lookahead && lookahead <= ':') ||
          lookahead == '=' ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '~') ADVANCE(118);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_ellipses);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(132);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(143);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(135);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(13);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(137);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(145);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(9);
      if (lookahead == '/') ADVANCE(144);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(11);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(114);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(114);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == ':') ADVANCE(46);
      if (lookahead == '\'' ||
          lookahead == '_') ADVANCE(110);
      if (lookahead == '+' ||
          lookahead == '.') ADVANCE(14);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '{') ADVANCE(163);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '{') ADVANCE(164);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_SQUOTE_SQUOTE);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_SQUOTE_SQUOTE);
      if (lookahead == '\'') ADVANCE(160);
      if (lookahead == '\\') ADVANCE(48);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym__indented_escape_sequence);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(131);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE2);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(168);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'e') ADVANCE(2);
      if (lookahead == 'i') ADVANCE(3);
      if (lookahead == 'l') ADVANCE(4);
      if (lookahead == 'r') ADVANCE(5);
      if (lookahead == 't') ADVANCE(6);
      if (lookahead == 'w') ADVANCE(7);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 's') ADVANCE(8);
      END_STATE();
    case 2:
      if (lookahead == 'l') ADVANCE(9);
      END_STATE();
    case 3:
      if (lookahead == 'f') ADVANCE(10);
      if (lookahead == 'n') ADVANCE(11);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(12);
      END_STATE();
    case 5:
      if (lookahead == 'e') ADVANCE(13);
      END_STATE();
    case 6:
      if (lookahead == 'h') ADVANCE(14);
      END_STATE();
    case 7:
      if (lookahead == 'i') ADVANCE(15);
      END_STATE();
    case 8:
      if (lookahead == 's') ADVANCE(16);
      END_STATE();
    case 9:
      if (lookahead == 's') ADVANCE(17);
      END_STATE();
    case 10:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'h') ADVANCE(18);
      END_STATE();
    case 12:
      if (lookahead == 't') ADVANCE(19);
      END_STATE();
    case 13:
      if (lookahead == 'c') ADVANCE(20);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(21);
      END_STATE();
    case 15:
      if (lookahead == 't') ADVANCE(22);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(23);
      END_STATE();
    case 17:
      if (lookahead == 'e') ADVANCE(24);
      END_STATE();
    case 18:
      if (lookahead == 'e') ADVANCE(25);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_rec);
      END_STATE();
    case 21:
      if (lookahead == 'n') ADVANCE(26);
      END_STATE();
    case 22:
      if (lookahead == 'h') ADVANCE(27);
      END_STATE();
    case 23:
      if (lookahead == 'r') ADVANCE(28);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 25:
      if (lookahead == 'r') ADVANCE(29);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 28:
      if (lookahead == 't') ADVANCE(30);
      END_STATE();
    case 29:
      if (lookahead == 'i') ADVANCE(31);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 31:
      if (lookahead == 't') ADVANCE(32);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_inherit);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 50, .external_lex_state = 2},
  [2] = {.lex_state = 50, .external_lex_state = 2},
  [3] = {.lex_state = 50, .external_lex_state = 2},
  [4] = {.lex_state = 50, .external_lex_state = 2},
  [5] = {.lex_state = 50, .external_lex_state = 2},
  [6] = {.lex_state = 50, .external_lex_state = 2},
  [7] = {.lex_state = 50, .external_lex_state = 2},
  [8] = {.lex_state = 50, .external_lex_state = 2},
  [9] = {.lex_state = 50, .external_lex_state = 2},
  [10] = {.lex_state = 50, .external_lex_state = 2},
  [11] = {.lex_state = 50, .external_lex_state = 2},
  [12] = {.lex_state = 50, .external_lex_state = 2},
  [13] = {.lex_state = 50, .external_lex_state = 2},
  [14] = {.lex_state = 50, .external_lex_state = 2},
  [15] = {.lex_state = 50, .external_lex_state = 2},
  [16] = {.lex_state = 50, .external_lex_state = 2},
  [17] = {.lex_state = 50, .external_lex_state = 2},
  [18] = {.lex_state = 50, .external_lex_state = 2},
  [19] = {.lex_state = 50, .external_lex_state = 2},
  [20] = {.lex_state = 50, .external_lex_state = 2},
  [21] = {.lex_state = 50, .external_lex_state = 2},
  [22] = {.lex_state = 50, .external_lex_state = 2},
  [23] = {.lex_state = 50, .external_lex_state = 2},
  [24] = {.lex_state = 53, .external_lex_state = 2},
  [25] = {.lex_state = 50, .external_lex_state = 2},
  [26] = {.lex_state = 50, .external_lex_state = 2},
  [27] = {.lex_state = 50, .external_lex_state = 2},
  [28] = {.lex_state = 50, .external_lex_state = 2},
  [29] = {.lex_state = 50, .external_lex_state = 2},
  [30] = {.lex_state = 50, .external_lex_state = 2},
  [31] = {.lex_state = 50, .external_lex_state = 2},
  [32] = {.lex_state = 50, .external_lex_state = 2},
  [33] = {.lex_state = 50, .external_lex_state = 2},
  [34] = {.lex_state = 50, .external_lex_state = 2},
  [35] = {.lex_state = 50, .external_lex_state = 2},
  [36] = {.lex_state = 50, .external_lex_state = 2},
  [37] = {.lex_state = 50, .external_lex_state = 2},
  [38] = {.lex_state = 50, .external_lex_state = 2},
  [39] = {.lex_state = 50, .external_lex_state = 2},
  [40] = {.lex_state = 50, .external_lex_state = 2},
  [41] = {.lex_state = 50, .external_lex_state = 2},
  [42] = {.lex_state = 50, .external_lex_state = 2},
  [43] = {.lex_state = 50, .external_lex_state = 2},
  [44] = {.lex_state = 50, .external_lex_state = 2},
  [45] = {.lex_state = 50, .external_lex_state = 2},
  [46] = {.lex_state = 50, .external_lex_state = 2},
  [47] = {.lex_state = 50, .external_lex_state = 2},
  [48] = {.lex_state = 50, .external_lex_state = 2},
  [49] = {.lex_state = 50, .external_lex_state = 2},
  [50] = {.lex_state = 50, .external_lex_state = 2},
  [51] = {.lex_state = 50, .external_lex_state = 2},
  [52] = {.lex_state = 50, .external_lex_state = 2},
  [53] = {.lex_state = 50, .external_lex_state = 2},
  [54] = {.lex_state = 50, .external_lex_state = 2},
  [55] = {.lex_state = 50, .external_lex_state = 2},
  [56] = {.lex_state = 50, .external_lex_state = 2},
  [57] = {.lex_state = 50, .external_lex_state = 2},
  [58] = {.lex_state = 50, .external_lex_state = 2},
  [59] = {.lex_state = 50, .external_lex_state = 2},
  [60] = {.lex_state = 50, .external_lex_state = 2},
  [61] = {.lex_state = 50, .external_lex_state = 2},
  [62] = {.lex_state = 50, .external_lex_state = 2},
  [63] = {.lex_state = 50, .external_lex_state = 2},
  [64] = {.lex_state = 50, .external_lex_state = 2},
  [65] = {.lex_state = 50, .external_lex_state = 2},
  [66] = {.lex_state = 50, .external_lex_state = 2},
  [67] = {.lex_state = 50, .external_lex_state = 2},
  [68] = {.lex_state = 50, .external_lex_state = 2},
  [69] = {.lex_state = 50, .external_lex_state = 2},
  [70] = {.lex_state = 50, .external_lex_state = 2},
  [71] = {.lex_state = 50, .external_lex_state = 2},
  [72] = {.lex_state = 50, .external_lex_state = 2},
  [73] = {.lex_state = 50, .external_lex_state = 2},
  [74] = {.lex_state = 50, .external_lex_state = 2},
  [75] = {.lex_state = 50, .external_lex_state = 2},
  [76] = {.lex_state = 53, .external_lex_state = 2},
  [77] = {.lex_state = 53, .external_lex_state = 2},
  [78] = {.lex_state = 53, .external_lex_state = 2},
  [79] = {.lex_state = 53, .external_lex_state = 3},
  [80] = {.lex_state = 53, .external_lex_state = 3},
  [81] = {.lex_state = 53, .external_lex_state = 3},
  [82] = {.lex_state = 53, .external_lex_state = 3},
  [83] = {.lex_state = 53, .external_lex_state = 3},
  [84] = {.lex_state = 53, .external_lex_state = 3},
  [85] = {.lex_state = 52, .external_lex_state = 2},
  [86] = {.lex_state = 53, .external_lex_state = 3},
  [87] = {.lex_state = 52, .external_lex_state = 2},
  [88] = {.lex_state = 52, .external_lex_state = 2},
  [89] = {.lex_state = 53, .external_lex_state = 2},
  [90] = {.lex_state = 52, .external_lex_state = 2},
  [91] = {.lex_state = 53, .external_lex_state = 2},
  [92] = {.lex_state = 52, .external_lex_state = 2},
  [93] = {.lex_state = 52, .external_lex_state = 2},
  [94] = {.lex_state = 52, .external_lex_state = 2},
  [95] = {.lex_state = 53, .external_lex_state = 3},
  [96] = {.lex_state = 53, .external_lex_state = 2},
  [97] = {.lex_state = 53, .external_lex_state = 3},
  [98] = {.lex_state = 53, .external_lex_state = 3},
  [99] = {.lex_state = 53, .external_lex_state = 3},
  [100] = {.lex_state = 53, .external_lex_state = 2},
  [101] = {.lex_state = 53, .external_lex_state = 2},
  [102] = {.lex_state = 53, .external_lex_state = 2},
  [103] = {.lex_state = 53, .external_lex_state = 2},
  [104] = {.lex_state = 53, .external_lex_state = 2},
  [105] = {.lex_state = 53, .external_lex_state = 2},
  [106] = {.lex_state = 53, .external_lex_state = 2},
  [107] = {.lex_state = 53, .external_lex_state = 2},
  [108] = {.lex_state = 53, .external_lex_state = 3},
  [109] = {.lex_state = 53, .external_lex_state = 2},
  [110] = {.lex_state = 53, .external_lex_state = 3},
  [111] = {.lex_state = 52, .external_lex_state = 2},
  [112] = {.lex_state = 53, .external_lex_state = 3},
  [113] = {.lex_state = 53, .external_lex_state = 2},
  [114] = {.lex_state = 53, .external_lex_state = 3},
  [115] = {.lex_state = 53, .external_lex_state = 3},
  [116] = {.lex_state = 53, .external_lex_state = 2},
  [117] = {.lex_state = 53, .external_lex_state = 3},
  [118] = {.lex_state = 53, .external_lex_state = 2},
  [119] = {.lex_state = 53, .external_lex_state = 2},
  [120] = {.lex_state = 53, .external_lex_state = 3},
  [121] = {.lex_state = 53, .external_lex_state = 3},
  [122] = {.lex_state = 53, .external_lex_state = 3},
  [123] = {.lex_state = 53, .external_lex_state = 3},
  [124] = {.lex_state = 53, .external_lex_state = 3},
  [125] = {.lex_state = 53, .external_lex_state = 2},
  [126] = {.lex_state = 50, .external_lex_state = 2},
  [127] = {.lex_state = 50, .external_lex_state = 2},
  [128] = {.lex_state = 50, .external_lex_state = 2},
  [129] = {.lex_state = 50, .external_lex_state = 2},
  [130] = {.lex_state = 50, .external_lex_state = 2},
  [131] = {.lex_state = 50, .external_lex_state = 2},
  [132] = {.lex_state = 50, .external_lex_state = 2},
  [133] = {.lex_state = 50, .external_lex_state = 2},
  [134] = {.lex_state = 50, .external_lex_state = 2},
  [135] = {.lex_state = 50, .external_lex_state = 2},
  [136] = {.lex_state = 50, .external_lex_state = 2},
  [137] = {.lex_state = 50, .external_lex_state = 2},
  [138] = {.lex_state = 50, .external_lex_state = 2},
  [139] = {.lex_state = 50, .external_lex_state = 2},
  [140] = {.lex_state = 50, .external_lex_state = 2},
  [141] = {.lex_state = 50, .external_lex_state = 2},
  [142] = {.lex_state = 50, .external_lex_state = 2},
  [143] = {.lex_state = 50, .external_lex_state = 2},
  [144] = {.lex_state = 50, .external_lex_state = 2},
  [145] = {.lex_state = 50, .external_lex_state = 2},
  [146] = {.lex_state = 50, .external_lex_state = 2},
  [147] = {.lex_state = 50, .external_lex_state = 2},
  [148] = {.lex_state = 50, .external_lex_state = 2},
  [149] = {.lex_state = 50, .external_lex_state = 2},
  [150] = {.lex_state = 50, .external_lex_state = 2},
  [151] = {.lex_state = 50, .external_lex_state = 2},
  [152] = {.lex_state = 50, .external_lex_state = 2},
  [153] = {.lex_state = 50, .external_lex_state = 2},
  [154] = {.lex_state = 50, .external_lex_state = 2},
  [155] = {.lex_state = 50, .external_lex_state = 2},
  [156] = {.lex_state = 50, .external_lex_state = 2},
  [157] = {.lex_state = 50, .external_lex_state = 2},
  [158] = {.lex_state = 50, .external_lex_state = 2},
  [159] = {.lex_state = 50, .external_lex_state = 2},
  [160] = {.lex_state = 50, .external_lex_state = 2},
  [161] = {.lex_state = 53, .external_lex_state = 2},
  [162] = {.lex_state = 50, .external_lex_state = 2},
  [163] = {.lex_state = 50, .external_lex_state = 2},
  [164] = {.lex_state = 50, .external_lex_state = 2},
  [165] = {.lex_state = 50, .external_lex_state = 2},
  [166] = {.lex_state = 50, .external_lex_state = 2},
  [167] = {.lex_state = 50, .external_lex_state = 2},
  [168] = {.lex_state = 50, .external_lex_state = 2},
  [169] = {.lex_state = 50, .external_lex_state = 2},
  [170] = {.lex_state = 50, .external_lex_state = 2},
  [171] = {.lex_state = 53, .external_lex_state = 3},
  [172] = {.lex_state = 53, .external_lex_state = 2},
  [173] = {.lex_state = 52, .external_lex_state = 2},
  [174] = {.lex_state = 53, .external_lex_state = 3},
  [175] = {.lex_state = 52, .external_lex_state = 2},
  [176] = {.lex_state = 53, .external_lex_state = 2},
  [177] = {.lex_state = 53, .external_lex_state = 3},
  [178] = {.lex_state = 53, .external_lex_state = 3},
  [179] = {.lex_state = 52, .external_lex_state = 2},
  [180] = {.lex_state = 52, .external_lex_state = 2},
  [181] = {.lex_state = 52, .external_lex_state = 2},
  [182] = {.lex_state = 53, .external_lex_state = 2},
  [183] = {.lex_state = 53, .external_lex_state = 2},
  [184] = {.lex_state = 53, .external_lex_state = 2},
  [185] = {.lex_state = 53, .external_lex_state = 3},
  [186] = {.lex_state = 52, .external_lex_state = 2},
  [187] = {.lex_state = 53, .external_lex_state = 2},
  [188] = {.lex_state = 52, .external_lex_state = 2},
  [189] = {.lex_state = 52, .external_lex_state = 2},
  [190] = {.lex_state = 53, .external_lex_state = 2},
  [191] = {.lex_state = 53, .external_lex_state = 3},
  [192] = {.lex_state = 52, .external_lex_state = 2},
  [193] = {.lex_state = 52, .external_lex_state = 2},
  [194] = {.lex_state = 52, .external_lex_state = 2},
  [195] = {.lex_state = 52, .external_lex_state = 2},
  [196] = {.lex_state = 52, .external_lex_state = 2},
  [197] = {.lex_state = 52, .external_lex_state = 2},
  [198] = {.lex_state = 52, .external_lex_state = 2},
  [199] = {.lex_state = 52, .external_lex_state = 2},
  [200] = {.lex_state = 52, .external_lex_state = 2},
  [201] = {.lex_state = 52, .external_lex_state = 2},
  [202] = {.lex_state = 52, .external_lex_state = 2},
  [203] = {.lex_state = 52, .external_lex_state = 2},
  [204] = {.lex_state = 52, .external_lex_state = 2},
  [205] = {.lex_state = 53, .external_lex_state = 2},
  [206] = {.lex_state = 53, .external_lex_state = 2},
  [207] = {.lex_state = 53, .external_lex_state = 2},
  [208] = {.lex_state = 53, .external_lex_state = 2},
  [209] = {.lex_state = 53, .external_lex_state = 2},
  [210] = {.lex_state = 53, .external_lex_state = 2},
  [211] = {.lex_state = 53, .external_lex_state = 2},
  [212] = {.lex_state = 53, .external_lex_state = 2},
  [213] = {.lex_state = 53, .external_lex_state = 2},
  [214] = {.lex_state = 53, .external_lex_state = 2},
  [215] = {.lex_state = 53, .external_lex_state = 2},
  [216] = {.lex_state = 53, .external_lex_state = 2},
  [217] = {.lex_state = 53, .external_lex_state = 2},
  [218] = {.lex_state = 53, .external_lex_state = 2},
  [219] = {.lex_state = 52, .external_lex_state = 2},
  [220] = {.lex_state = 53, .external_lex_state = 2},
  [221] = {.lex_state = 53, .external_lex_state = 2},
  [222] = {.lex_state = 53, .external_lex_state = 2},
  [223] = {.lex_state = 53, .external_lex_state = 2},
  [224] = {.lex_state = 53, .external_lex_state = 2},
  [225] = {.lex_state = 52, .external_lex_state = 2},
  [226] = {.lex_state = 53, .external_lex_state = 2},
  [227] = {.lex_state = 53, .external_lex_state = 2},
  [228] = {.lex_state = 53, .external_lex_state = 2},
  [229] = {.lex_state = 53, .external_lex_state = 2},
  [230] = {.lex_state = 53, .external_lex_state = 2},
  [231] = {.lex_state = 53, .external_lex_state = 2},
  [232] = {.lex_state = 53, .external_lex_state = 2},
  [233] = {.lex_state = 53, .external_lex_state = 2},
  [234] = {.lex_state = 53, .external_lex_state = 2},
  [235] = {.lex_state = 52, .external_lex_state = 2},
  [236] = {.lex_state = 53, .external_lex_state = 2},
  [237] = {.lex_state = 53, .external_lex_state = 2},
  [238] = {.lex_state = 53, .external_lex_state = 2},
  [239] = {.lex_state = 53, .external_lex_state = 2},
  [240] = {.lex_state = 53, .external_lex_state = 2},
  [241] = {.lex_state = 53, .external_lex_state = 2},
  [242] = {.lex_state = 53, .external_lex_state = 2},
  [243] = {.lex_state = 53, .external_lex_state = 2},
  [244] = {.lex_state = 53, .external_lex_state = 2},
  [245] = {.lex_state = 53, .external_lex_state = 2},
  [246] = {.lex_state = 53, .external_lex_state = 2},
  [247] = {.lex_state = 53, .external_lex_state = 2},
  [248] = {.lex_state = 53, .external_lex_state = 2},
  [249] = {.lex_state = 53, .external_lex_state = 2},
  [250] = {.lex_state = 53, .external_lex_state = 2},
  [251] = {.lex_state = 53, .external_lex_state = 2},
  [252] = {.lex_state = 53, .external_lex_state = 2},
  [253] = {.lex_state = 53, .external_lex_state = 2},
  [254] = {.lex_state = 53, .external_lex_state = 2},
  [255] = {.lex_state = 53, .external_lex_state = 2},
  [256] = {.lex_state = 53, .external_lex_state = 2},
  [257] = {.lex_state = 53, .external_lex_state = 2},
  [258] = {.lex_state = 53, .external_lex_state = 2},
  [259] = {.lex_state = 50, .external_lex_state = 2},
  [260] = {.lex_state = 50, .external_lex_state = 2},
  [261] = {.lex_state = 50, .external_lex_state = 2},
  [262] = {.lex_state = 50, .external_lex_state = 2},
  [263] = {.lex_state = 50, .external_lex_state = 2},
  [264] = {.lex_state = 50, .external_lex_state = 2},
  [265] = {.lex_state = 50, .external_lex_state = 2},
  [266] = {.lex_state = 50, .external_lex_state = 2},
  [267] = {.lex_state = 50, .external_lex_state = 2},
  [268] = {.lex_state = 50, .external_lex_state = 2},
  [269] = {.lex_state = 50, .external_lex_state = 2},
  [270] = {.lex_state = 50, .external_lex_state = 2},
  [271] = {.lex_state = 50, .external_lex_state = 2},
  [272] = {.lex_state = 55},
  [273] = {.lex_state = 1},
  [274] = {.lex_state = 1},
  [275] = {.lex_state = 1},
  [276] = {.lex_state = 55},
  [277] = {.lex_state = 57},
  [278] = {.lex_state = 57},
  [279] = {.lex_state = 55},
  [280] = {.lex_state = 57},
  [281] = {.lex_state = 57},
  [282] = {.lex_state = 57},
  [283] = {.lex_state = 57},
  [284] = {.lex_state = 57},
  [285] = {.lex_state = 57},
  [286] = {.lex_state = 57},
  [287] = {.lex_state = 57},
  [288] = {.lex_state = 57},
  [289] = {.lex_state = 57},
  [290] = {.lex_state = 57},
  [291] = {.lex_state = 57},
  [292] = {.lex_state = 57},
  [293] = {.lex_state = 57},
  [294] = {.lex_state = 57},
  [295] = {.lex_state = 57},
  [296] = {.lex_state = 57},
  [297] = {.lex_state = 57},
  [298] = {.lex_state = 57},
  [299] = {.lex_state = 57},
  [300] = {.lex_state = 57},
  [301] = {.lex_state = 57},
  [302] = {.lex_state = 57},
  [303] = {.lex_state = 57},
  [304] = {.lex_state = 57},
  [305] = {.lex_state = 57},
  [306] = {.lex_state = 57},
  [307] = {.lex_state = 57},
  [308] = {.lex_state = 57},
  [309] = {.lex_state = 57},
  [310] = {.lex_state = 57},
  [311] = {.lex_state = 57},
  [312] = {.lex_state = 57},
  [313] = {.lex_state = 57},
  [314] = {.lex_state = 57},
  [315] = {.lex_state = 57},
  [316] = {.lex_state = 57},
  [317] = {.lex_state = 57},
  [318] = {.lex_state = 57},
  [319] = {.lex_state = 57},
  [320] = {.lex_state = 57},
  [321] = {.lex_state = 57},
  [322] = {.lex_state = 57},
  [323] = {.lex_state = 57},
  [324] = {.lex_state = 57},
  [325] = {.lex_state = 57},
  [326] = {.lex_state = 57},
  [327] = {.lex_state = 57},
  [328] = {.lex_state = 57},
  [329] = {.lex_state = 57},
  [330] = {.lex_state = 57},
  [331] = {.lex_state = 2},
  [332] = {.lex_state = 2},
  [333] = {.lex_state = 50, .external_lex_state = 2},
  [334] = {.lex_state = 2},
  [335] = {.lex_state = 2},
  [336] = {.lex_state = 2},
  [337] = {.lex_state = 2},
  [338] = {.lex_state = 2},
  [339] = {.lex_state = 2},
  [340] = {.lex_state = 2},
  [341] = {.lex_state = 2},
  [342] = {.lex_state = 2},
  [343] = {.lex_state = 2},
  [344] = {.lex_state = 2},
  [345] = {.lex_state = 2},
  [346] = {.lex_state = 2},
  [347] = {.lex_state = 2},
  [348] = {.lex_state = 2},
  [349] = {.lex_state = 2},
  [350] = {.lex_state = 2},
  [351] = {.lex_state = 2},
  [352] = {.lex_state = 2},
  [353] = {.lex_state = 2},
  [354] = {.lex_state = 2},
  [355] = {.lex_state = 2},
  [356] = {.lex_state = 1},
  [357] = {.lex_state = 1},
  [358] = {.lex_state = 55},
  [359] = {.lex_state = 50, .external_lex_state = 4},
  [360] = {.lex_state = 50, .external_lex_state = 4},
  [361] = {.lex_state = 55, .external_lex_state = 5},
  [362] = {.lex_state = 55},
  [363] = {.lex_state = 55},
  [364] = {.lex_state = 55, .external_lex_state = 5},
  [365] = {.lex_state = 1},
  [366] = {.lex_state = 50, .external_lex_state = 4},
  [367] = {.lex_state = 50, .external_lex_state = 4},
  [368] = {.lex_state = 55, .external_lex_state = 5},
  [369] = {.lex_state = 50, .external_lex_state = 4},
  [370] = {.lex_state = 55, .external_lex_state = 5},
  [371] = {.lex_state = 50, .external_lex_state = 4},
  [372] = {.lex_state = 55},
  [373] = {.lex_state = 55},
  [374] = {.lex_state = 50, .external_lex_state = 4},
  [375] = {.lex_state = 50, .external_lex_state = 4},
  [376] = {.lex_state = 50, .external_lex_state = 4},
  [377] = {.lex_state = 50, .external_lex_state = 4},
  [378] = {.lex_state = 55, .external_lex_state = 5},
  [379] = {.lex_state = 50, .external_lex_state = 4},
  [380] = {.lex_state = 55, .external_lex_state = 5},
  [381] = {.lex_state = 1},
  [382] = {.lex_state = 50, .external_lex_state = 4},
  [383] = {.lex_state = 50, .external_lex_state = 4},
  [384] = {.lex_state = 50, .external_lex_state = 4},
  [385] = {.lex_state = 50, .external_lex_state = 4},
  [386] = {.lex_state = 55, .external_lex_state = 5},
  [387] = {.lex_state = 1},
  [388] = {.lex_state = 50, .external_lex_state = 4},
  [389] = {.lex_state = 50, .external_lex_state = 4},
  [390] = {.lex_state = 55},
  [391] = {.lex_state = 55},
  [392] = {.lex_state = 55},
  [393] = {.lex_state = 55},
  [394] = {.lex_state = 55},
  [395] = {.lex_state = 55, .external_lex_state = 5},
  [396] = {.lex_state = 50, .external_lex_state = 4},
  [397] = {.lex_state = 1},
  [398] = {.lex_state = 50, .external_lex_state = 4},
  [399] = {.lex_state = 50, .external_lex_state = 4},
  [400] = {.lex_state = 50, .external_lex_state = 4},
  [401] = {.lex_state = 55, .external_lex_state = 5},
  [402] = {.lex_state = 1},
  [403] = {.lex_state = 1},
  [404] = {.lex_state = 1},
  [405] = {.lex_state = 1},
  [406] = {.lex_state = 1},
  [407] = {.lex_state = 50},
  [408] = {.lex_state = 1},
  [409] = {.lex_state = 1},
  [410] = {.lex_state = 2},
  [411] = {.lex_state = 1},
  [412] = {.lex_state = 1},
  [413] = {.lex_state = 55, .external_lex_state = 5},
  [414] = {.lex_state = 2},
  [415] = {.lex_state = 2},
  [416] = {.lex_state = 1},
  [417] = {.lex_state = 2},
  [418] = {.lex_state = 2},
  [419] = {.lex_state = 55, .external_lex_state = 5},
  [420] = {.lex_state = 2},
  [421] = {.lex_state = 2},
  [422] = {.lex_state = 50, .external_lex_state = 4},
  [423] = {.lex_state = 50, .external_lex_state = 4},
  [424] = {.lex_state = 2},
  [425] = {.lex_state = 1},
  [426] = {.lex_state = 1},
  [427] = {.lex_state = 3},
  [428] = {.lex_state = 1},
  [429] = {.lex_state = 0},
  [430] = {.lex_state = 50},
  [431] = {.lex_state = 3},
  [432] = {.lex_state = 0},
  [433] = {.lex_state = 0},
  [434] = {.lex_state = 50},
  [435] = {.lex_state = 0},
  [436] = {.lex_state = 3},
  [437] = {.lex_state = 0},
  [438] = {.lex_state = 0},
  [439] = {.lex_state = 0},
  [440] = {.lex_state = 0},
  [441] = {.lex_state = 0},
  [442] = {.lex_state = 0},
  [443] = {.lex_state = 0},
  [444] = {.lex_state = 0},
  [445] = {.lex_state = 0},
  [446] = {.lex_state = 0},
  [447] = {.lex_state = 0},
  [448] = {.lex_state = 0},
  [449] = {.lex_state = 0},
  [450] = {.lex_state = 0},
  [451] = {.lex_state = 1},
  [452] = {.lex_state = 0},
  [453] = {.lex_state = 0},
  [454] = {.lex_state = 0},
  [455] = {.lex_state = 0},
  [456] = {.lex_state = 55},
  [457] = {.lex_state = 0},
  [458] = {.lex_state = 0},
  [459] = {.lex_state = 0},
  [460] = {.lex_state = 0},
  [461] = {.lex_state = 0},
  [462] = {.lex_state = 0},
  [463] = {.lex_state = 0},
  [464] = {.lex_state = 55},
  [465] = {.lex_state = 0},
  [466] = {.lex_state = 0},
  [467] = {.lex_state = 0},
  [468] = {.lex_state = 55},
  [469] = {.lex_state = 0},
  [470] = {.lex_state = 0},
  [471] = {.lex_state = 0},
  [472] = {.lex_state = 0},
  [473] = {.lex_state = 55},
  [474] = {.lex_state = 0},
  [475] = {.lex_state = 0},
  [476] = {.lex_state = 0},
  [477] = {.lex_state = 0},
  [478] = {.lex_state = 0},
  [479] = {.lex_state = 0},
  [480] = {.lex_state = 0},
  [481] = {.lex_state = 0},
  [482] = {.lex_state = 0},
  [483] = {.lex_state = 0},
  [484] = {.lex_state = 0},
  [485] = {.lex_state = 0},
  [486] = {.lex_state = 0},
  [487] = {.lex_state = 55},
  [488] = {.lex_state = 0},
  [489] = {.lex_state = 0},
  [490] = {.lex_state = 0},
  [491] = {.lex_state = 0},
  [492] = {.lex_state = 0},
  [493] = {.lex_state = 0},
  [494] = {.lex_state = 0},
  [495] = {.lex_state = 55},
  [496] = {.lex_state = 0},
  [497] = {.lex_state = 0},
  [498] = {.lex_state = 55},
  [499] = {.lex_state = 1},
  [500] = {.lex_state = 0},
  [501] = {.lex_state = 0},
  [502] = {.lex_state = 55},
  [503] = {.lex_state = 0},
  [504] = {.lex_state = 0},
  [505] = {.lex_state = 0},
  [506] = {.lex_state = 0},
  [507] = {.lex_state = 52},
  [508] = {.lex_state = 0},
  [509] = {.lex_state = 1},
  [510] = {.lex_state = 50},
  [511] = {.lex_state = 0},
  [512] = {.lex_state = 0},
  [513] = {.lex_state = 0},
  [514] = {.lex_state = 0},
  [515] = {.lex_state = 1},
  [516] = {.lex_state = 0},
  [517] = {.lex_state = 0},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 0},
  [520] = {.lex_state = 0},
  [521] = {.lex_state = 0},
  [522] = {.lex_state = 0},
  [523] = {.lex_state = 0},
  [524] = {.lex_state = 1},
  [525] = {.lex_state = 52},
  [526] = {.lex_state = 0},
  [527] = {.lex_state = 0},
  [528] = {.lex_state = 0},
  [529] = {.lex_state = 0},
  [530] = {.lex_state = 50},
  [531] = {.lex_state = 55},
  [532] = {.lex_state = 0},
  [533] = {.lex_state = 55},
  [534] = {.lex_state = 55},
  [535] = {.lex_state = 0},
  [536] = {.lex_state = 55},
  [537] = {.lex_state = 0},
  [538] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_keyword] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_integer_expression] = ACTIONS(1),
    [sym_float_expression] = ACTIONS(1),
    [sym__hpath_start] = ACTIONS(1),
    [sym_spath_expression] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [sym_ellipses] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_rec] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(1),
    [sym__indented_escape_sequence] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_inherit] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE2] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_string_fragment] = ACTIONS(1),
    [sym__indented_string_fragment] = ACTIONS(1),
    [sym__path_start] = ACTIONS(1),
    [sym_path_fragment] = ACTIONS(1),
    [sym_dollar_escape] = ACTIONS(1),
    [sym__indented_dollar_escape] = ACTIONS(1),
  },
  [1] = {
    [sym_source_code] = STATE(529),
    [sym__expression] = STATE(528),
    [sym_variable_expression] = STATE(226),
    [sym_path_expression] = STATE(226),
    [sym_hpath_expression] = STATE(226),
    [sym__expr_function_expression] = STATE(390),
    [sym_function_expression] = STATE(390),
    [sym_formals] = STATE(446),
    [sym_assert_expression] = STATE(390),
    [sym_with_expression] = STATE(390),
    [sym_let_expression] = STATE(390),
    [sym__expr_if] = STATE(390),
    [sym_if_expression] = STATE(390),
    [sym__expr_op] = STATE(326),
    [sym_has_attr_expression] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__expr_apply_expression] = STATE(76),
    [sym_apply_expression] = STATE(76),
    [sym__expr_select_expression] = STATE(76),
    [sym_select_expression] = STATE(76),
    [sym__expr_simple] = STATE(226),
    [sym_parenthesized_expression] = STATE(226),
    [sym_attrset_expression] = STATE(226),
    [sym_let_attrset_expression] = STATE(226),
    [sym_rec_attrset_expression] = STATE(226),
    [sym_string_expression] = STATE(226),
    [sym_indented_string_expression] = STATE(226),
    [sym_list_expression] = STATE(226),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_integer_expression] = ACTIONS(9),
    [sym_float_expression] = ACTIONS(11),
    [sym__hpath_start] = ACTIONS(13),
    [sym_spath_expression] = ACTIONS(11),
    [sym_uri_expression] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_let] = ACTIONS(21),
    [anon_sym_if] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LPAREN] = ACTIONS(29),
    [anon_sym_rec] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [sym_comment] = ACTIONS(3),
    [sym__path_start] = ACTIONS(39),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(372), 1,
      sym__expression,
    STATE(441), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(318), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [97] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(526), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [194] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(512), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [291] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(441), 1,
      sym_formals,
    STATE(534), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(318), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [388] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(508), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [485] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(504), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [582] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(441), 1,
      sym_formals,
    STATE(533), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(318), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [679] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(441), 1,
      sym_formals,
    STATE(495), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(318), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [776] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    STATE(536), 1,
      sym__expression,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [873] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(535), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [970] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(476), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1067] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(532), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1164] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(441), 1,
      sym_formals,
    STATE(531), 1,
      sym__expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(318), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1261] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(486), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1358] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(372), 1,
      sym__expression,
    STATE(438), 1,
      sym_formals,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1455] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(483), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1552] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(480), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1649] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(477), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1746] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    STATE(473), 1,
      sym__expression,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1843] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(469), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [1940] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(372), 1,
      sym__expression,
    STATE(446), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(326), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(226), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2037] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(505), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2134] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    STATE(187), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    ACTIONS(151), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
    ACTIONS(147), 15,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_RPAREN,
  [2217] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(443), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2314] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(453), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2411] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(500), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2508] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(466), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2605] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(372), 1,
      sym__expression,
    STATE(440), 1,
      sym_formals,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2702] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(460), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2799] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(503), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2896] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(454), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [2993] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(482), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3090] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(517), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3187] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    STATE(464), 1,
      sym__expression,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3284] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(459), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3381] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(479), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3478] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(457), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3575] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(478), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3672] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(474), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3769] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    STATE(487), 1,
      sym__expression,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3866] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(488), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [3963] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    STATE(493), 1,
      sym__expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(390), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4060] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(446), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(326), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(362), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(226), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4154] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(373), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4248] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(446), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(326), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(373), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(226), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4342] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(392), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4436] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(441), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(318), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(363), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4530] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(446), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(326), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(363), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(226), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4624] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(393), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4718] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(446), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(326), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(358), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(226), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4812] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(441), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(318), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(373), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [4906] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(441), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(318), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(392), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5000] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(362), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5094] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(362), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5188] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(363), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5282] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(394), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5376] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(446), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(326), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(394), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(226), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5470] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(373), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5564] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(441), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(318), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(362), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5658] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(358), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5752] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(358), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5846] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(391), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [5940] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(363), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6034] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(441), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(318), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(358), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6128] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(391), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6222] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(441), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(318), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(391), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6316] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(441), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(318), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(393), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6410] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(446), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(326), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(393), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(226), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6504] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_identifier,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_assert,
    ACTIONS(121), 1,
      anon_sym_with,
    ACTIONS(123), 1,
      anon_sym_let,
    ACTIONS(125), 1,
      anon_sym_if,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    STATE(438), 1,
      sym_formals,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(300), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(394), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6598] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(53), 1,
      anon_sym_with,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    STATE(441), 1,
      sym_formals,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(318), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(394), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6692] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(392), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6786] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(446), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(326), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(391), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(226), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6880] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_assert,
    ACTIONS(19), 1,
      anon_sym_with,
    ACTIONS(21), 1,
      anon_sym_let,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    STATE(446), 1,
      sym_formals,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(326), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(392), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(226), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [6974] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(83), 1,
      anon_sym_LBRACE,
    ACTIONS(85), 1,
      anon_sym_assert,
    ACTIONS(87), 1,
      anon_sym_with,
    ACTIONS(89), 1,
      anon_sym_let,
    ACTIONS(91), 1,
      anon_sym_if,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    STATE(440), 1,
      sym_formals,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(290), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(393), 7,
      sym__expr_function_expression,
      sym_function_expression,
      sym_assert_expression,
      sym_with_expression,
      sym_let_expression,
      sym__expr_if,
      sym_if_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [7068] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    STATE(258), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    ACTIONS(151), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    STATE(226), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
    ACTIONS(147), 12,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
  [7148] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    STATE(257), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    ACTIONS(151), 6,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(147), 11,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [7228] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    STATE(255), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    ACTIONS(151), 6,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(147), 11,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [7308] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(177), 1,
      sym_path_fragment,
    STATE(80), 1,
      aux_sym_path_expression_repeat1,
    STATE(84), 1,
      sym__immediate_interpolation,
    ACTIONS(171), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(173), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7364] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(183), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(186), 1,
      sym_path_fragment,
    STATE(80), 1,
      aux_sym_path_expression_repeat1,
    STATE(84), 1,
      sym__immediate_interpolation,
    ACTIONS(179), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(181), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7420] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(177), 1,
      sym_path_fragment,
    STATE(80), 1,
      aux_sym_path_expression_repeat1,
    STATE(84), 1,
      sym__immediate_interpolation,
    ACTIONS(189), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(191), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7476] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(197), 1,
      sym_path_fragment,
    STATE(79), 1,
      aux_sym_path_expression_repeat1,
    STATE(84), 1,
      sym__immediate_interpolation,
    ACTIONS(193), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(195), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7532] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(203), 1,
      sym_path_fragment,
    STATE(81), 1,
      aux_sym_path_expression_repeat1,
    STATE(84), 1,
      sym__immediate_interpolation,
    ACTIONS(199), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(201), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7588] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(207), 28,
      sym__path_start,
      sym_path_fragment,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7634] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(213), 1,
      anon_sym_DOT,
    STATE(88), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(209), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(211), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7684] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(217), 28,
      sym__path_start,
      sym_path_fragment,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7730] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(223), 1,
      anon_sym_DOT,
    STATE(87), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(219), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(221), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7780] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(213), 1,
      anon_sym_DOT,
    STATE(87), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(226), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(228), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7830] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(234), 2,
      anon_sym_COLON,
      anon_sym_AT,
    ACTIONS(230), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 25,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [7877] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(236), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(238), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [7922] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(244), 1,
      anon_sym_COLON,
    ACTIONS(246), 1,
      anon_sym_AT,
    ACTIONS(240), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(242), 25,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [7971] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(248), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(250), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8016] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(254), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8061] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(258), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8106] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(260), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(262), 1,
      sym_path_fragment,
    STATE(99), 1,
      aux_sym_path_expression_repeat1,
    STATE(185), 1,
      sym__immediate_interpolation,
    ACTIONS(189), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(191), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8158] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(264), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(266), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8202] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(270), 1,
      sym_path_fragment,
    STATE(115), 1,
      aux_sym_path_expression_repeat1,
    STATE(177), 1,
      sym__immediate_interpolation,
    ACTIONS(199), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(201), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8254] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(272), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(275), 1,
      sym_path_fragment,
    STATE(98), 1,
      aux_sym_path_expression_repeat1,
    STATE(178), 1,
      sym__immediate_interpolation,
    ACTIONS(179), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(181), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8306] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(278), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(281), 1,
      sym_path_fragment,
    STATE(99), 1,
      aux_sym_path_expression_repeat1,
    STATE(185), 1,
      sym__immediate_interpolation,
    ACTIONS(179), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(181), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8358] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(286), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8402] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(230), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8446] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(290), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8490] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(292), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(294), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8534] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(296), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(298), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8578] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(300), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(302), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8622] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      anon_sym_DOT,
    ACTIONS(304), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(306), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8668] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(310), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(312), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8712] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(260), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(262), 1,
      sym_path_fragment,
    STATE(99), 1,
      aux_sym_path_expression_repeat1,
    STATE(185), 1,
      sym__immediate_interpolation,
    ACTIONS(171), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(173), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8764] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(240), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(242), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8808] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(260), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(314), 1,
      sym_path_fragment,
    STATE(95), 1,
      aux_sym_path_expression_repeat1,
    STATE(185), 1,
      sym__immediate_interpolation,
    ACTIONS(199), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(201), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8860] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(320), 1,
      anon_sym_or,
    ACTIONS(316), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(318), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [8906] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(322), 1,
      sym_path_fragment,
    STATE(117), 1,
      aux_sym_path_expression_repeat1,
    STATE(177), 1,
      sym__immediate_interpolation,
    ACTIONS(193), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(195), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [8958] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(324), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(326), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [9002] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(260), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(328), 1,
      sym_path_fragment,
    STATE(108), 1,
      aux_sym_path_expression_repeat1,
    STATE(185), 1,
      sym__immediate_interpolation,
    ACTIONS(193), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(195), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [9054] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(330), 1,
      sym_path_fragment,
    STATE(124), 1,
      aux_sym_path_expression_repeat1,
    STATE(177), 1,
      sym__immediate_interpolation,
    ACTIONS(189), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(191), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [9106] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(258), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [9150] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(330), 1,
      sym_path_fragment,
    STATE(124), 1,
      aux_sym_path_expression_repeat1,
    STATE(177), 1,
      sym__immediate_interpolation,
    ACTIONS(171), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(173), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [9202] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(332), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(334), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [9246] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(338), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [9290] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(342), 1,
      sym_path_fragment,
    STATE(122), 1,
      aux_sym_path_expression_repeat1,
    STATE(178), 1,
      sym__immediate_interpolation,
    ACTIONS(199), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(201), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [9342] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(344), 1,
      sym_path_fragment,
    STATE(123), 1,
      aux_sym_path_expression_repeat1,
    STATE(178), 1,
      sym__immediate_interpolation,
    ACTIONS(193), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(195), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [9394] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(346), 1,
      sym_path_fragment,
    STATE(98), 1,
      aux_sym_path_expression_repeat1,
    STATE(178), 1,
      sym__immediate_interpolation,
    ACTIONS(189), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(191), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [9446] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(346), 1,
      sym_path_fragment,
    STATE(98), 1,
      aux_sym_path_expression_repeat1,
    STATE(178), 1,
      sym__immediate_interpolation,
    ACTIONS(171), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(173), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [9498] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(348), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(351), 1,
      sym_path_fragment,
    STATE(124), 1,
      aux_sym_path_expression_repeat1,
    STATE(177), 1,
      sym__immediate_interpolation,
    ACTIONS(179), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(181), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [9550] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(254), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [9594] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(315), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(226), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [9667] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(321), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(226), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [9740] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(294), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [9813] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(304), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(226), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [9886] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(296), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [9959] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(278), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(226), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10032] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(322), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10105] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(325), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10178] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(302), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10251] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(328), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10324] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(303), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10397] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(305), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10470] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(306), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10543] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(308), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10616] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(309), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10689] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(310), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10762] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(311), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10835] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(299), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10908] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(284), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [10981] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(307), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11054] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(313), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11127] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(316), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11200] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(317), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11273] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(323), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11346] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(327), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11419] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(285), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11492] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(286), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11565] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(297), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11638] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(291), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11711] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(292), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11784] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(330), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(226), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11857] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(278), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [11930] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_DASH,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(78), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(312), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12003] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(329), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(226), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12076] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(324), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(226), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12149] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(354), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(356), 26,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [12192] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(293), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12265] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(320), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(226), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12338] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(278), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12411] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(127), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(77), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(301), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12484] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(298), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(226), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12557] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(278), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12630] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(93), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_DASH,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(24), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(295), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12703] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(314), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(226), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12776] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(25), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(76), 4,
      sym__expr_apply_expression,
      sym_apply_expression,
      sym__expr_select_expression,
      sym_select_expression,
    STATE(319), 4,
      sym__expr_op,
      sym_has_attr_expression,
      sym_unary_expression,
      sym_binary_expression,
    STATE(226), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [12849] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(217), 23,
      sym__path_start,
      sym_path_fragment,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
  [12891] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_COLON,
    ACTIONS(360), 1,
      anon_sym_AT,
    ACTIONS(240), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(242), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [12937] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(362), 1,
      anon_sym_DOT,
    STATE(173), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(219), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(221), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [12983] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(217), 23,
      sym__path_start,
      sym_path_fragment,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
  [13025] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(365), 1,
      anon_sym_DOT,
    STATE(175), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(219), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(221), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13071] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_COLON,
    ACTIONS(370), 1,
      anon_sym_AT,
    ACTIONS(240), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(242), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13117] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(207), 23,
      sym__path_start,
      sym_path_fragment,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
  [13159] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(207), 23,
      sym__path_start,
      sym_path_fragment,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
  [13201] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(372), 1,
      anon_sym_DOT,
    STATE(179), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(219), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(221), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13247] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(375), 1,
      anon_sym_DOT,
    STATE(181), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(209), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(211), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13293] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(375), 1,
      anon_sym_DOT,
    STATE(175), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(226), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(228), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13339] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(234), 2,
      anon_sym_COLON,
      anon_sym_AT,
    ACTIONS(230), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13383] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(234), 2,
      anon_sym_COLON,
      anon_sym_AT,
    ACTIONS(230), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13427] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(234), 2,
      anon_sym_COLON,
      anon_sym_AT,
    ACTIONS(230), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13471] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(207), 24,
      sym__path_start,
      sym_path_fragment,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
  [13513] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(377), 1,
      anon_sym_DOT,
    STATE(188), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(209), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(211), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13559] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(379), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(381), 25,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13601] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(377), 1,
      anon_sym_DOT,
    STATE(179), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(226), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(228), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13647] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(383), 1,
      anon_sym_DOT,
    STATE(192), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(209), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(211), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13693] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 1,
      anon_sym_COLON,
    ACTIONS(387), 1,
      anon_sym_AT,
    ACTIONS(240), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(242), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13739] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(217), 24,
      sym__path_start,
      sym_path_fragment,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_LBRACK,
  [13781] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(383), 1,
      anon_sym_DOT,
    STATE(173), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(226), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(228), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13827] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(258), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13868] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(248), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(250), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13909] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(254), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13950] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(258), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [13991] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(236), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(238), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14032] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(254), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14073] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(258), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14114] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(254), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14155] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(236), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(238), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14196] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(248), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(250), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14237] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(236), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(238), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14278] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(248), 12,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_or,
      anon_sym_rec,
    ACTIONS(250), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14319] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(290), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14359] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(254), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14399] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(258), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14439] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(286), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14479] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(286), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14519] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(332), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(334), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14559] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(230), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14599] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(290), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14639] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(338), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14679] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(332), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(334), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14719] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(292), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(294), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14759] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(300), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(302), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14799] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(258), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14839] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(296), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(298), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14879] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 1,
      anon_sym_or,
    ACTIONS(316), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(318), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14921] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(310), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(312), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [14961] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(296), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(298), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15001] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(338), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15041] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(290), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15081] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(300), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(302), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15121] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(391), 1,
      anon_sym_or,
    ACTIONS(316), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(318), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15163] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 1,
      anon_sym_DOT,
    ACTIONS(304), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(306), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15205] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(286), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15245] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(292), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(294), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15285] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(324), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(326), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15325] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(230), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15365] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(264), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(266), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15405] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(324), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(326), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15445] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(264), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(266), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15485] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(300), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(302), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15525] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(395), 1,
      anon_sym_or,
    ACTIONS(316), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(318), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15567] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(230), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(232), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15607] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(254), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15647] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(310), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(312), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15687] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(254), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15727] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 1,
      anon_sym_DOT,
    ACTIONS(304), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(306), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15769] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(240), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(242), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15809] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(332), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(334), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15849] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      anon_sym_DOT,
    ACTIONS(304), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(306), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15891] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(310), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(312), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15931] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(292), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(294), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [15971] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(338), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16011] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(258), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16051] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(296), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(298), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16091] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(324), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(326), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16131] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(240), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(242), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16171] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(240), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(242), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16211] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(264), 11,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_rec,
    ACTIONS(266), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16251] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(354), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(356), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16290] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(354), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(356), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16329] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(379), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(381), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16368] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(354), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(356), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16407] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(379), 10,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_else,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(381), 21,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16446] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(379), 9,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_rec,
    ACTIONS(381), 22,
      sym__path_start,
      ts_builtin_sym_end,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
  [16485] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(401), 1,
      anon_sym_RBRACK,
    STATE(264), 1,
      aux_sym_list_expression_repeat1,
    STATE(333), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [16550] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(403), 1,
      anon_sym_RBRACK,
    STATE(259), 1,
      aux_sym_list_expression_repeat1,
    STATE(333), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [16615] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(405), 1,
      anon_sym_RBRACK,
    STATE(264), 1,
      aux_sym_list_expression_repeat1,
    STATE(333), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [16680] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(407), 1,
      anon_sym_RBRACK,
    STATE(261), 1,
      aux_sym_list_expression_repeat1,
    STATE(333), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [16745] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(409), 1,
      anon_sym_RBRACK,
    STATE(264), 1,
      aux_sym_list_expression_repeat1,
    STATE(333), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [16810] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(411), 1,
      sym_identifier,
    ACTIONS(414), 1,
      sym_integer_expression,
    ACTIONS(420), 1,
      sym__hpath_start,
    ACTIONS(423), 1,
      anon_sym_LBRACE,
    ACTIONS(426), 1,
      anon_sym_let,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(432), 1,
      anon_sym_rec,
    ACTIONS(435), 1,
      anon_sym_DQUOTE,
    ACTIONS(438), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(441), 1,
      anon_sym_LBRACK,
    ACTIONS(444), 1,
      anon_sym_RBRACK,
    ACTIONS(446), 1,
      sym__path_start,
    STATE(264), 1,
      aux_sym_list_expression_repeat1,
    STATE(333), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(417), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [16875] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(449), 1,
      anon_sym_RBRACK,
    STATE(263), 1,
      aux_sym_list_expression_repeat1,
    STATE(333), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [16940] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(451), 1,
      anon_sym_RBRACK,
    STATE(267), 1,
      aux_sym_list_expression_repeat1,
    STATE(333), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [17005] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    ACTIONS(453), 1,
      anon_sym_RBRACK,
    STATE(264), 1,
      aux_sym_list_expression_repeat1,
    STATE(333), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [17070] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_integer_expression,
    ACTIONS(13), 1,
      sym__hpath_start,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_rec,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(35), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      sym__path_start,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LBRACE,
    ACTIONS(157), 1,
      anon_sym_let,
    STATE(256), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(11), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(226), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [17129] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_integer_expression,
    ACTIONS(81), 1,
      sym__hpath_start,
    ACTIONS(97), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_rec,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(105), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      sym__path_start,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(149), 1,
      anon_sym_let,
    STATE(161), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(79), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(106), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [17188] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      sym_integer_expression,
    ACTIONS(115), 1,
      sym__hpath_start,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_rec,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym__path_start,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_LBRACE,
    ACTIONS(163), 1,
      anon_sym_let,
    STATE(254), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(113), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(240), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [17247] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      sym_integer_expression,
    ACTIONS(47), 1,
      sym__hpath_start,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_rec,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(71), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym__path_start,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    STATE(253), 2,
      sym__expr_select_expression,
      sym_select_expression,
    ACTIONS(45), 3,
      sym_float_expression,
      sym_spath_expression,
      sym_uri_expression,
    STATE(243), 11,
      sym_variable_expression,
      sym_path_expression,
      sym_hpath_expression,
      sym__expr_simple,
      sym_parenthesized_expression,
      sym_attrset_expression,
      sym_let_attrset_expression,
      sym_rec_attrset_expression,
      sym_string_expression,
      sym_indented_string_expression,
      sym_list_expression,
  [17306] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(236), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_EQ,
    ACTIONS(238), 19,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
      anon_sym_RPAREN,
  [17339] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_EQ,
    ACTIONS(254), 19,
      sym_identifier,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [17372] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(248), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_EQ,
    ACTIONS(250), 19,
      sym_identifier,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [17405] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_EQ,
    ACTIONS(258), 19,
      sym_identifier,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [17438] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 1,
      anon_sym_DOT,
    STATE(279), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(226), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_EQ,
    ACTIONS(228), 15,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_RPAREN,
  [17473] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(457), 18,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_RPAREN,
  [17504] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(463), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(461), 18,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_RPAREN,
  [17535] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(465), 1,
      anon_sym_DOT,
    STATE(279), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(219), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_EQ,
    ACTIONS(221), 15,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_RPAREN,
  [17570] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 1,
      anon_sym_DOT,
    STATE(276), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(209), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(211), 15,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_RPAREN,
  [17604] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(468), 1,
      anon_sym_DOT,
    STATE(283), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(209), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(211), 14,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
  [17637] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(470), 1,
      anon_sym_DOT,
    STATE(282), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(219), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(221), 14,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
  [17670] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(468), 1,
      anon_sym_DOT,
    STATE(282), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(226), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(228), 14,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
  [17703] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(485), 1,
      anon_sym_SLASH,
    ACTIONS(487), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(489), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(479), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(481), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 9,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_RPAREN,
  [17745] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(485), 1,
      anon_sym_SLASH,
    ACTIONS(489), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(491), 4,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
    ACTIONS(473), 12,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_RPAREN,
  [17781] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(489), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(491), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_RPAREN,
  [17813] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(248), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(250), 15,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
  [17841] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(254), 15,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
  [17869] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(258), 15,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_then,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS_PLUS,
      anon_sym_DOT,
  [17897] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(485), 1,
      anon_sym_SLASH,
    ACTIONS(487), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(489), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(497), 1,
      anon_sym_AMP_AMP,
    ACTIONS(499), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(501), 1,
      anon_sym_DASH_GT,
    ACTIONS(477), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(479), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(481), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(495), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(493), 4,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RPAREN,
  [17947] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(485), 1,
      anon_sym_SLASH,
    ACTIONS(487), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(489), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(497), 1,
      anon_sym_AMP_AMP,
    ACTIONS(499), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(501), 1,
      anon_sym_DASH_GT,
    ACTIONS(477), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(479), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(481), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(495), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(473), 4,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RPAREN,
  [17997] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(489), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(491), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 13,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_RPAREN,
  [18029] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(485), 1,
      anon_sym_SLASH,
    ACTIONS(487), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(489), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(497), 1,
      anon_sym_AMP_AMP,
    ACTIONS(477), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(479), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(481), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(495), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(473), 6,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_RPAREN,
  [18075] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(485), 1,
      anon_sym_SLASH,
    ACTIONS(487), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(489), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(479), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(481), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(495), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(473), 7,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_RPAREN,
  [18119] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(485), 1,
      anon_sym_SLASH,
    ACTIONS(489), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(463), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(477), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(461), 12,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
      anon_sym_RPAREN,
  [18157] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(485), 1,
      anon_sym_SLASH,
    ACTIONS(487), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(489), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(491), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(473), 11,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_RPAREN,
  [18197] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_QMARK,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(485), 1,
      anon_sym_SLASH,
    ACTIONS(487), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(489), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(477), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(491), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(473), 11,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_RPAREN,
  [18237] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(505), 1,
      anon_sym_STAR,
    ACTIONS(507), 1,
      anon_sym_SLASH,
    ACTIONS(509), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(491), 4,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
    ACTIONS(473), 9,
      ts_builtin_sym_end,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [18270] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(511), 1,
      anon_sym_STAR,
    ACTIONS(513), 1,
      anon_sym_SLASH,
    ACTIONS(515), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(491), 4,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
    ACTIONS(473), 9,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [18303] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(493), 1,
      anon_sym_else,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(511), 1,
      anon_sym_STAR,
    ACTIONS(513), 1,
      anon_sym_SLASH,
    ACTIONS(515), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(525), 1,
      anon_sym_AMP_AMP,
    ACTIONS(527), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(529), 1,
      anon_sym_DASH_GT,
    ACTIONS(531), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(517), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(519), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(521), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(523), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18350] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(511), 1,
      anon_sym_STAR,
    ACTIONS(513), 1,
      anon_sym_SLASH,
    ACTIONS(515), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(463), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(517), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(461), 9,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [18385] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(515), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(491), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 10,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [18414] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(511), 1,
      anon_sym_STAR,
    ACTIONS(513), 1,
      anon_sym_SLASH,
    ACTIONS(515), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(531), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(491), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(517), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(473), 8,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18451] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(505), 1,
      anon_sym_STAR,
    ACTIONS(507), 1,
      anon_sym_SLASH,
    ACTIONS(509), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(463), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(533), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(461), 9,
      ts_builtin_sym_end,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [18486] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      anon_sym_else,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(511), 1,
      anon_sym_STAR,
    ACTIONS(513), 1,
      anon_sym_SLASH,
    ACTIONS(515), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(525), 1,
      anon_sym_AMP_AMP,
    ACTIONS(527), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(529), 1,
      anon_sym_DASH_GT,
    ACTIONS(531), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(517), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(519), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(521), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(523), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18533] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(515), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(491), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 10,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [18562] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(535), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(491), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 10,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [18591] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(511), 1,
      anon_sym_STAR,
    ACTIONS(513), 1,
      anon_sym_SLASH,
    ACTIONS(515), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(525), 1,
      anon_sym_AMP_AMP,
    ACTIONS(531), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(517), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(519), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(521), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(523), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 3,
      anon_sym_else,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18634] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(511), 1,
      anon_sym_STAR,
    ACTIONS(513), 1,
      anon_sym_SLASH,
    ACTIONS(515), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(531), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(517), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(519), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(521), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(523), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 4,
      anon_sym_else,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18675] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(511), 1,
      anon_sym_STAR,
    ACTIONS(513), 1,
      anon_sym_SLASH,
    ACTIONS(515), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(531), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(491), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(517), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(473), 8,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18712] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(511), 1,
      anon_sym_STAR,
    ACTIONS(513), 1,
      anon_sym_SLASH,
    ACTIONS(515), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(531), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(517), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(521), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(523), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 6,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18751] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(535), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(539), 1,
      anon_sym_STAR,
    ACTIONS(541), 1,
      anon_sym_SLASH,
    ACTIONS(463), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(537), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(461), 9,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [18786] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(535), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(539), 1,
      anon_sym_STAR,
    ACTIONS(541), 1,
      anon_sym_SLASH,
    ACTIONS(549), 1,
      anon_sym_AMP_AMP,
    ACTIONS(551), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(537), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(543), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(545), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(547), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 3,
      anon_sym_then,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18829] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(505), 1,
      anon_sym_STAR,
    ACTIONS(507), 1,
      anon_sym_SLASH,
    ACTIONS(509), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(557), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(533), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(553), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(555), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 6,
      ts_builtin_sym_end,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18868] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(505), 1,
      anon_sym_STAR,
    ACTIONS(507), 1,
      anon_sym_SLASH,
    ACTIONS(509), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(557), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(491), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(533), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(473), 8,
      ts_builtin_sym_end,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18905] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(535), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(539), 1,
      anon_sym_STAR,
    ACTIONS(541), 1,
      anon_sym_SLASH,
    ACTIONS(551), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(537), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(543), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(545), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(547), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 4,
      anon_sym_then,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18946] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(535), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(539), 1,
      anon_sym_STAR,
    ACTIONS(541), 1,
      anon_sym_SLASH,
    ACTIONS(551), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(491), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(537), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(473), 8,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [18983] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(493), 1,
      anon_sym_then,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(535), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(539), 1,
      anon_sym_STAR,
    ACTIONS(541), 1,
      anon_sym_SLASH,
    ACTIONS(549), 1,
      anon_sym_AMP_AMP,
    ACTIONS(551), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(559), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(561), 1,
      anon_sym_DASH_GT,
    ACTIONS(537), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(543), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(545), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(547), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [19030] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(505), 1,
      anon_sym_STAR,
    ACTIONS(507), 1,
      anon_sym_SLASH,
    ACTIONS(509), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(557), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(533), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(553), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(555), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(563), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(473), 4,
      ts_builtin_sym_end,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [19071] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(505), 1,
      anon_sym_STAR,
    ACTIONS(507), 1,
      anon_sym_SLASH,
    ACTIONS(509), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(557), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(565), 1,
      anon_sym_AMP_AMP,
    ACTIONS(533), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(553), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(555), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(563), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(473), 3,
      ts_builtin_sym_end,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [19114] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(509), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(491), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 10,
      ts_builtin_sym_end,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [19143] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(535), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(491), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 10,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [19172] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(535), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(539), 1,
      anon_sym_STAR,
    ACTIONS(541), 1,
      anon_sym_SLASH,
    ACTIONS(551), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(537), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(545), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(547), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 6,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [19211] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      ts_builtin_sym_end,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(505), 1,
      anon_sym_STAR,
    ACTIONS(507), 1,
      anon_sym_SLASH,
    ACTIONS(509), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(557), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(565), 1,
      anon_sym_AMP_AMP,
    ACTIONS(567), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(569), 1,
      anon_sym_DASH_GT,
    ACTIONS(533), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(553), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(555), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(563), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [19258] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(535), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(539), 1,
      anon_sym_STAR,
    ACTIONS(541), 1,
      anon_sym_SLASH,
    ACTIONS(551), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(491), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(537), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(473), 8,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [19295] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(493), 1,
      ts_builtin_sym_end,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(505), 1,
      anon_sym_STAR,
    ACTIONS(507), 1,
      anon_sym_SLASH,
    ACTIONS(509), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(557), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(565), 1,
      anon_sym_AMP_AMP,
    ACTIONS(567), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(569), 1,
      anon_sym_DASH_GT,
    ACTIONS(533), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(553), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(555), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(563), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [19342] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(535), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(539), 1,
      anon_sym_STAR,
    ACTIONS(541), 1,
      anon_sym_SLASH,
    ACTIONS(491), 4,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
    ACTIONS(473), 9,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [19375] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      anon_sym_then,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(535), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(539), 1,
      anon_sym_STAR,
    ACTIONS(541), 1,
      anon_sym_SLASH,
    ACTIONS(549), 1,
      anon_sym_AMP_AMP,
    ACTIONS(551), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(559), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(561), 1,
      anon_sym_DASH_GT,
    ACTIONS(537), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(543), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(545), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(547), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [19422] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(505), 1,
      anon_sym_STAR,
    ACTIONS(507), 1,
      anon_sym_SLASH,
    ACTIONS(509), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(557), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(491), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(533), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(473), 8,
      ts_builtin_sym_end,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [19459] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_QMARK,
    ACTIONS(509), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(491), 5,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(473), 10,
      ts_builtin_sym_end,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_DASH_GT,
      anon_sym_SLASH_SLASH,
  [19488] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(571), 1,
      sym_identifier,
    ACTIONS(573), 1,
      anon_sym_RBRACE,
    ACTIONS(575), 1,
      sym_ellipses,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(353), 1,
      aux_sym_binding_set_repeat1,
    STATE(433), 1,
      sym_formal,
    STATE(481), 1,
      sym_binding_set,
    STATE(510), 1,
      sym_attrpath,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(415), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19531] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(571), 1,
      sym_identifier,
    ACTIONS(575), 1,
      sym_ellipses,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(583), 1,
      anon_sym_RBRACE,
    STATE(353), 1,
      aux_sym_binding_set_repeat1,
    STATE(433), 1,
      sym_formal,
    STATE(510), 1,
      sym_attrpath,
    STATE(514), 1,
      sym_binding_set,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(415), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19574] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(585), 4,
      sym_identifier,
      sym_integer_expression,
      anon_sym_let,
      anon_sym_rec,
    ACTIONS(587), 11,
      sym__path_start,
      sym_float_expression,
      sym__hpath_start,
      sym_spath_expression,
      sym_uri_expression,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [19597] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(571), 1,
      sym_identifier,
    ACTIONS(575), 1,
      sym_ellipses,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(589), 1,
      anon_sym_RBRACE,
    STATE(353), 1,
      aux_sym_binding_set_repeat1,
    STATE(433), 1,
      sym_formal,
    STATE(506), 1,
      sym_binding_set,
    STATE(510), 1,
      sym_attrpath,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(415), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19640] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(571), 1,
      sym_identifier,
    ACTIONS(575), 1,
      sym_ellipses,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(591), 1,
      anon_sym_RBRACE,
    STATE(353), 1,
      aux_sym_binding_set_repeat1,
    STATE(433), 1,
      sym_formal,
    STATE(465), 1,
      sym_binding_set,
    STATE(510), 1,
      sym_attrpath,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(415), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19683] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(595), 1,
      anon_sym_LBRACE,
    ACTIONS(597), 1,
      anon_sym_in,
    ACTIONS(599), 1,
      anon_sym_inherit,
    STATE(355), 1,
      aux_sym_binding_set_repeat1,
    STATE(468), 1,
      sym_binding_set,
    STATE(530), 1,
      sym_attrpath,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(418), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19723] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_inherit,
    ACTIONS(601), 1,
      anon_sym_LBRACE,
    ACTIONS(603), 1,
      anon_sym_in,
    STATE(355), 1,
      aux_sym_binding_set_repeat1,
    STATE(502), 1,
      sym_binding_set,
    STATE(530), 1,
      sym_attrpath,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(418), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19763] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_inherit,
    ACTIONS(605), 1,
      anon_sym_LBRACE,
    ACTIONS(607), 1,
      anon_sym_in,
    STATE(355), 1,
      aux_sym_binding_set_repeat1,
    STATE(498), 1,
      sym_binding_set,
    STATE(530), 1,
      sym_attrpath,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(418), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19803] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_inherit,
    ACTIONS(609), 1,
      anon_sym_LBRACE,
    ACTIONS(611), 1,
      anon_sym_in,
    STATE(355), 1,
      aux_sym_binding_set_repeat1,
    STATE(456), 1,
      sym_binding_set,
    STATE(530), 1,
      sym_attrpath,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(418), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19843] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(613), 1,
      anon_sym_RBRACE,
    STATE(353), 1,
      aux_sym_binding_set_repeat1,
    STATE(510), 1,
      sym_attrpath,
    STATE(518), 1,
      sym_binding_set,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(415), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19880] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(615), 1,
      anon_sym_RBRACE,
    STATE(353), 1,
      aux_sym_binding_set_repeat1,
    STATE(462), 1,
      sym_binding_set,
    STATE(510), 1,
      sym_attrpath,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(415), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19917] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(617), 1,
      anon_sym_RBRACE,
    STATE(353), 1,
      aux_sym_binding_set_repeat1,
    STATE(506), 1,
      sym_binding_set,
    STATE(510), 1,
      sym_attrpath,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(415), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19954] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(619), 1,
      anon_sym_RBRACE,
    STATE(353), 1,
      aux_sym_binding_set_repeat1,
    STATE(465), 1,
      sym_binding_set,
    STATE(510), 1,
      sym_attrpath,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(415), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [19991] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(621), 1,
      anon_sym_RBRACE,
    STATE(353), 1,
      aux_sym_binding_set_repeat1,
    STATE(490), 1,
      sym_binding_set,
    STATE(510), 1,
      sym_attrpath,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(415), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20028] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(623), 1,
      anon_sym_RBRACE,
    STATE(353), 1,
      aux_sym_binding_set_repeat1,
    STATE(510), 1,
      sym_attrpath,
    STATE(514), 1,
      sym_binding_set,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(415), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20065] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(625), 1,
      anon_sym_RBRACE,
    STATE(353), 1,
      aux_sym_binding_set_repeat1,
    STATE(491), 1,
      sym_binding_set,
    STATE(510), 1,
      sym_attrpath,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(415), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20102] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(627), 1,
      anon_sym_RBRACE,
    STATE(353), 1,
      aux_sym_binding_set_repeat1,
    STATE(510), 1,
      sym_attrpath,
    STATE(521), 1,
      sym_binding_set,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(415), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20139] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(629), 1,
      anon_sym_RBRACE,
    STATE(353), 1,
      aux_sym_binding_set_repeat1,
    STATE(471), 1,
      sym_binding_set,
    STATE(510), 1,
      sym_attrpath,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(415), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20176] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(631), 1,
      anon_sym_RBRACE,
    STATE(353), 1,
      aux_sym_binding_set_repeat1,
    STATE(461), 1,
      sym_binding_set,
    STATE(510), 1,
      sym_attrpath,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(415), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20213] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(633), 1,
      anon_sym_RBRACE,
    STATE(353), 1,
      aux_sym_binding_set_repeat1,
    STATE(481), 1,
      sym_binding_set,
    STATE(510), 1,
      sym_attrpath,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(415), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20250] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(635), 1,
      anon_sym_RBRACE,
    STATE(353), 1,
      aux_sym_binding_set_repeat1,
    STATE(470), 1,
      sym_binding_set,
    STATE(510), 1,
      sym_attrpath,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(415), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20287] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(637), 1,
      sym_identifier,
    ACTIONS(640), 1,
      anon_sym_in,
    ACTIONS(642), 1,
      anon_sym_DQUOTE,
    ACTIONS(645), 1,
      anon_sym_inherit,
    ACTIONS(648), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(352), 1,
      aux_sym_binding_set_repeat1,
    STATE(530), 1,
      sym_attrpath,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(418), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20321] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_inherit,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(651), 1,
      anon_sym_RBRACE,
    STATE(354), 1,
      aux_sym_binding_set_repeat1,
    STATE(510), 1,
      sym_attrpath,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(415), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20355] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(637), 1,
      sym_identifier,
    ACTIONS(642), 1,
      anon_sym_DQUOTE,
    ACTIONS(648), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(653), 1,
      anon_sym_RBRACE,
    ACTIONS(655), 1,
      anon_sym_inherit,
    STATE(354), 1,
      aux_sym_binding_set_repeat1,
    STATE(510), 1,
      sym_attrpath,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(415), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20389] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(593), 1,
      sym_identifier,
    ACTIONS(599), 1,
      anon_sym_inherit,
    ACTIONS(658), 1,
      anon_sym_in,
    STATE(352), 1,
      aux_sym_binding_set_repeat1,
    STATE(530), 1,
      sym_attrpath,
    STATE(430), 2,
      sym_string_expression,
      sym_interpolation,
    STATE(418), 3,
      sym_binding,
      sym_inherit,
      sym_inherit_from,
  [20423] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(660), 1,
      sym_identifier,
    ACTIONS(662), 1,
      anon_sym_LPAREN,
    STATE(365), 1,
      aux_sym_inherited_attrs_repeat1,
    STATE(496), 1,
      sym_inherited_attrs,
    STATE(428), 2,
      sym_string_expression,
      sym_interpolation,
  [20449] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(660), 1,
      sym_identifier,
    ACTIONS(664), 1,
      anon_sym_LPAREN,
    STATE(365), 1,
      aux_sym_inherited_attrs_repeat1,
    STATE(516), 1,
      sym_inherited_attrs,
    STATE(428), 2,
      sym_string_expression,
      sym_interpolation,
  [20475] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(666), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [20488] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(668), 1,
      anon_sym_DQUOTE,
    ACTIONS(672), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(674), 1,
      sym_dollar_escape,
    ACTIONS(670), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(360), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20509] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(676), 1,
      anon_sym_DQUOTE,
    ACTIONS(681), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(684), 1,
      sym_dollar_escape,
    ACTIONS(678), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(360), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20530] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(687), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(691), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(693), 1,
      sym__indented_dollar_escape,
    ACTIONS(689), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(368), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [20551] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(695), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [20564] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(697), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [20577] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(691), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(693), 1,
      sym__indented_dollar_escape,
    ACTIONS(699), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(701), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(378), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [20598] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(660), 1,
      sym_identifier,
    ACTIONS(703), 1,
      anon_sym_SEMI,
    STATE(381), 1,
      aux_sym_inherited_attrs_repeat1,
    STATE(428), 2,
      sym_string_expression,
      sym_interpolation,
  [20621] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(674), 1,
      sym_dollar_escape,
    ACTIONS(705), 1,
      anon_sym_DQUOTE,
    ACTIONS(707), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(377), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20642] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(674), 1,
      sym_dollar_escape,
    ACTIONS(709), 1,
      anon_sym_DQUOTE,
    ACTIONS(670), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(360), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20663] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(716), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(719), 1,
      sym__indented_dollar_escape,
    ACTIONS(713), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(368), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [20684] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(674), 1,
      sym_dollar_escape,
    ACTIONS(722), 1,
      anon_sym_DQUOTE,
    ACTIONS(724), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(389), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20705] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(691), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(693), 1,
      sym__indented_dollar_escape,
    ACTIONS(726), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(728), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(361), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [20726] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(674), 1,
      sym_dollar_escape,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(732), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(367), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20747] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(734), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [20760] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(736), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [20773] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(674), 1,
      sym_dollar_escape,
    ACTIONS(738), 1,
      anon_sym_DQUOTE,
    ACTIONS(670), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(360), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20794] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(674), 1,
      sym_dollar_escape,
    ACTIONS(740), 1,
      anon_sym_DQUOTE,
    ACTIONS(742), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(376), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20815] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(674), 1,
      sym_dollar_escape,
    ACTIONS(744), 1,
      anon_sym_DQUOTE,
    ACTIONS(670), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(360), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20836] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(674), 1,
      sym_dollar_escape,
    ACTIONS(746), 1,
      anon_sym_DQUOTE,
    ACTIONS(670), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(360), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20857] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(691), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(693), 1,
      sym__indented_dollar_escape,
    ACTIONS(748), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(689), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(368), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [20878] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(674), 1,
      sym_dollar_escape,
    ACTIONS(750), 1,
      anon_sym_DQUOTE,
    ACTIONS(752), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(359), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20899] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(691), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(693), 1,
      sym__indented_dollar_escape,
    ACTIONS(754), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(689), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(368), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [20920] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 1,
      sym_identifier,
    ACTIONS(759), 1,
      anon_sym_SEMI,
    ACTIONS(761), 1,
      anon_sym_DQUOTE,
    ACTIONS(764), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(381), 1,
      aux_sym_inherited_attrs_repeat1,
    STATE(428), 2,
      sym_string_expression,
      sym_interpolation,
  [20943] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(674), 1,
      sym_dollar_escape,
    ACTIONS(767), 1,
      anon_sym_DQUOTE,
    ACTIONS(769), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(383), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20964] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(674), 1,
      sym_dollar_escape,
    ACTIONS(771), 1,
      anon_sym_DQUOTE,
    ACTIONS(670), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(360), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [20985] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(674), 1,
      sym_dollar_escape,
    ACTIONS(773), 1,
      anon_sym_DQUOTE,
    ACTIONS(775), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(388), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21006] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(674), 1,
      sym_dollar_escape,
    ACTIONS(777), 1,
      anon_sym_DQUOTE,
    ACTIONS(779), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(400), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21027] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(691), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(693), 1,
      sym__indented_dollar_escape,
    ACTIONS(781), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(783), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(401), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [21048] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(660), 1,
      sym_identifier,
    STATE(365), 1,
      aux_sym_inherited_attrs_repeat1,
    STATE(485), 1,
      sym_inherited_attrs,
    STATE(428), 2,
      sym_string_expression,
      sym_interpolation,
  [21071] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(674), 1,
      sym_dollar_escape,
    ACTIONS(785), 1,
      anon_sym_DQUOTE,
    ACTIONS(670), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(360), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21092] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(674), 1,
      sym_dollar_escape,
    ACTIONS(787), 1,
      anon_sym_DQUOTE,
    ACTIONS(670), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(360), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21113] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(789), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [21126] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(791), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [21139] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(793), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [21152] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [21165] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 7,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_then,
      anon_sym_else,
      anon_sym_RPAREN,
  [21178] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(691), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(693), 1,
      sym__indented_dollar_escape,
    ACTIONS(799), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(801), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(380), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [21199] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(674), 1,
      sym_dollar_escape,
    ACTIONS(803), 1,
      anon_sym_DQUOTE,
    ACTIONS(805), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(374), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21220] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(660), 1,
      sym_identifier,
    STATE(365), 1,
      aux_sym_inherited_attrs_repeat1,
    STATE(484), 1,
      sym_inherited_attrs,
    STATE(428), 2,
      sym_string_expression,
      sym_interpolation,
  [21243] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(674), 1,
      sym_dollar_escape,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(670), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(360), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21264] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(674), 1,
      sym_dollar_escape,
    ACTIONS(809), 1,
      anon_sym_DQUOTE,
    ACTIONS(811), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(398), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21285] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(674), 1,
      sym_dollar_escape,
    ACTIONS(813), 1,
      anon_sym_DQUOTE,
    ACTIONS(670), 2,
      sym_string_fragment,
      sym_escape_sequence,
    STATE(360), 2,
      sym_interpolation,
      aux_sym_string_expression_repeat1,
  [21306] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(691), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(693), 1,
      sym__indented_dollar_escape,
    ACTIONS(815), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(689), 2,
      sym__indented_string_fragment,
      sym__indented_escape_sequence,
    STATE(368), 2,
      sym_interpolation,
      aux_sym_indented_string_expression_repeat1,
  [21327] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(817), 1,
      sym_identifier,
    ACTIONS(819), 1,
      anon_sym_DQUOTE,
    ACTIONS(821), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(235), 1,
      sym_attrpath,
    STATE(186), 2,
      sym_string_expression,
      sym_interpolation,
  [21347] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(823), 1,
      sym_identifier,
    ACTIONS(825), 1,
      anon_sym_DQUOTE,
    ACTIONS(827), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(111), 1,
      sym_attrpath,
    STATE(85), 2,
      sym_string_expression,
      sym_interpolation,
  [21367] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(829), 1,
      sym_identifier,
    STATE(277), 1,
      sym_attrpath,
    STATE(280), 2,
      sym_string_expression,
      sym_interpolation,
  [21387] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(831), 1,
      sym_identifier,
    ACTIONS(833), 1,
      anon_sym_DQUOTE,
    ACTIONS(835), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(219), 1,
      sym_attrpath,
    STATE(189), 2,
      sym_string_expression,
      sym_interpolation,
  [21407] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(837), 1,
      sym_identifier,
    ACTIONS(839), 1,
      anon_sym_DQUOTE,
    ACTIONS(841), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(225), 1,
      sym_attrpath,
    STATE(180), 2,
      sym_string_expression,
      sym_interpolation,
  [21427] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(211), 1,
      anon_sym_EQ,
    ACTIONS(455), 1,
      anon_sym_DOT,
    ACTIONS(845), 1,
      anon_sym_QMARK,
    STATE(276), 1,
      aux_sym_attrpath_repeat1,
    ACTIONS(843), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [21447] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(847), 1,
      sym_identifier,
    ACTIONS(849), 1,
      anon_sym_DQUOTE,
    ACTIONS(851), 1,
      anon_sym_DOLLAR_LBRACE2,
    STATE(277), 1,
      sym_attrpath,
    STATE(281), 2,
      sym_string_expression,
      sym_interpolation,
  [21467] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DQUOTE,
    ACTIONS(835), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(853), 1,
      sym_identifier,
    STATE(203), 2,
      sym_string_expression,
      sym_interpolation,
  [21484] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(855), 2,
      sym_identifier,
      anon_sym_inherit,
    ACTIONS(857), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [21497] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(849), 1,
      anon_sym_DQUOTE,
    ACTIONS(851), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(859), 1,
      sym_identifier,
    STATE(272), 2,
      sym_string_expression,
      sym_interpolation,
  [21514] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(819), 1,
      anon_sym_DQUOTE,
    ACTIONS(821), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(201), 2,
      sym_string_expression,
      sym_interpolation,
  [21531] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(863), 4,
      sym__indented_string_fragment,
      sym__indented_dollar_escape,
      sym__indented_escape_sequence,
      anon_sym_DOLLAR_LBRACE2,
  [21544] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(865), 2,
      sym_identifier,
      anon_sym_inherit,
    ACTIONS(867), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [21557] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(869), 2,
      sym_identifier,
      anon_sym_inherit,
    ACTIONS(871), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [21570] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(859), 1,
      sym_identifier,
    STATE(272), 2,
      sym_string_expression,
      sym_interpolation,
  [21587] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(873), 2,
      sym_identifier,
      anon_sym_inherit,
    ACTIONS(875), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [21600] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(871), 2,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(869), 3,
      sym_identifier,
      anon_sym_in,
      anon_sym_inherit,
  [21613] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(248), 1,
      anon_sym_SQUOTE_SQUOTE,
    ACTIONS(250), 4,
      sym__indented_string_fragment,
      sym__indented_dollar_escape,
      sym__indented_escape_sequence,
      anon_sym_DOLLAR_LBRACE2,
  [21626] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 2,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(873), 3,
      sym_identifier,
      anon_sym_in,
      anon_sym_inherit,
  [21639] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(867), 2,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(865), 3,
      sym_identifier,
      anon_sym_in,
      anon_sym_inherit,
  [21652] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(250), 5,
      sym_string_fragment,
      sym_dollar_escape,
      anon_sym_DQUOTE,
      sym_escape_sequence,
      anon_sym_DOLLAR_LBRACE2,
  [21663] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(676), 5,
      sym_string_fragment,
      sym_dollar_escape,
      anon_sym_DQUOTE,
      sym_escape_sequence,
      anon_sym_DOLLAR_LBRACE2,
  [21674] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(857), 2,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(855), 3,
      sym_identifier,
      anon_sym_in,
      anon_sym_inherit,
  [21687] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DQUOTE,
    ACTIONS(841), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(877), 1,
      sym_identifier,
    STATE(197), 2,
      sym_string_expression,
      sym_interpolation,
  [21704] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(825), 1,
      anon_sym_DQUOTE,
    ACTIONS(827), 1,
      anon_sym_DOLLAR_LBRACE2,
    ACTIONS(879), 1,
      sym_identifier,
    STATE(90), 2,
      sym_string_expression,
      sym_interpolation,
  [21721] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(575), 1,
      sym_ellipses,
    ACTIONS(881), 1,
      sym_identifier,
    ACTIONS(883), 1,
      anon_sym_RBRACE,
    STATE(433), 1,
      sym_formal,
  [21737] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(885), 4,
      sym_identifier,
      anon_sym_SEMI,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR_LBRACE2,
  [21747] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(887), 1,
      anon_sym_RBRACE,
    ACTIONS(889), 1,
      anon_sym_COMMA,
    STATE(429), 1,
      aux_sym_formals_repeat1,
  [21760] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(211), 1,
      anon_sym_EQ,
    ACTIONS(455), 1,
      anon_sym_DOT,
    STATE(434), 1,
      aux_sym_attrpath_repeat1,
  [21773] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(881), 1,
      sym_identifier,
    ACTIONS(892), 1,
      sym_ellipses,
    STATE(447), 1,
      sym_formal,
  [21786] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(845), 1,
      anon_sym_QMARK,
    ACTIONS(843), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [21797] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(894), 1,
      anon_sym_RBRACE,
    ACTIONS(896), 1,
      anon_sym_COMMA,
    STATE(435), 1,
      aux_sym_formals_repeat1,
  [21810] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(228), 1,
      anon_sym_EQ,
    ACTIONS(455), 1,
      anon_sym_DOT,
    STATE(279), 1,
      aux_sym_attrpath_repeat1,
  [21823] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(898), 1,
      anon_sym_RBRACE,
    ACTIONS(900), 1,
      anon_sym_COMMA,
    STATE(429), 1,
      aux_sym_formals_repeat1,
  [21836] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(881), 1,
      sym_identifier,
    ACTIONS(902), 1,
      sym_ellipses,
    STATE(447), 1,
      sym_formal,
  [21849] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 1,
      anon_sym_LBRACE,
    STATE(455), 1,
      sym_formals,
  [21859] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(906), 1,
      anon_sym_COLON,
    ACTIONS(908), 1,
      anon_sym_AT,
  [21869] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(910), 2,
      anon_sym_COLON,
      anon_sym_AT,
  [21877] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(912), 1,
      anon_sym_COLON,
    ACTIONS(914), 1,
      anon_sym_AT,
  [21887] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(916), 1,
      anon_sym_COLON,
    ACTIONS(918), 1,
      anon_sym_AT,
  [21897] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 2,
      anon_sym_COLON,
      anon_sym_AT,
  [21905] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(922), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [21913] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 1,
      anon_sym_LBRACE,
    STATE(467), 1,
      sym_formals,
  [21923] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 1,
      anon_sym_LBRACE,
    STATE(513), 1,
      sym_formals,
  [21933] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_COLON,
    ACTIONS(926), 1,
      anon_sym_AT,
  [21943] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(928), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [21951] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(930), 2,
      anon_sym_COLON,
      anon_sym_AT,
  [21959] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 1,
      anon_sym_LBRACE,
    STATE(497), 1,
      sym_formals,
  [21969] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 2,
      anon_sym_COLON,
      anon_sym_AT,
  [21977] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(881), 1,
      sym_identifier,
    STATE(447), 1,
      sym_formal,
  [21987] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(934), 2,
      anon_sym_COLON,
      anon_sym_AT,
  [21995] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(936), 1,
      anon_sym_RBRACE,
  [22002] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(938), 1,
      anon_sym_SEMI,
  [22009] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(940), 1,
      anon_sym_COLON,
  [22016] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(942), 1,
      anon_sym_in,
  [22023] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 1,
      anon_sym_RPAREN,
  [22030] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(609), 1,
      anon_sym_LBRACE,
  [22037] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(946), 1,
      anon_sym_RBRACE,
  [22044] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(948), 1,
      anon_sym_RPAREN,
  [22051] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(950), 1,
      anon_sym_RBRACE,
  [22058] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(952), 1,
      anon_sym_RBRACE,
  [22065] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(954), 1,
      anon_sym_COLON,
  [22072] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(956), 1,
      anon_sym_else,
  [22079] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(958), 1,
      anon_sym_RBRACE,
  [22086] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(960), 1,
      anon_sym_RBRACE,
  [22093] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(962), 1,
      anon_sym_COLON,
  [22100] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(964), 1,
      anon_sym_in,
  [22107] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(966), 1,
      anon_sym_RBRACE,
  [22114] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(968), 1,
      anon_sym_RBRACE,
  [22121] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(970), 1,
      anon_sym_RBRACE,
  [22128] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(972), 1,
      anon_sym_COLON,
  [22135] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_else,
  [22142] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(976), 1,
      anon_sym_SEMI,
  [22149] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(595), 1,
      anon_sym_LBRACE,
  [22156] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(978), 1,
      anon_sym_RPAREN,
  [22163] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(980), 1,
      anon_sym_RBRACE,
  [22170] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(982), 1,
      anon_sym_SEMI,
  [22177] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 1,
      anon_sym_RBRACE,
  [22184] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(986), 1,
      anon_sym_RBRACE,
  [22191] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 1,
      anon_sym_RBRACE,
  [22198] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(990), 1,
      anon_sym_SEMI,
  [22205] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 1,
      anon_sym_RBRACE,
  [22212] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(994), 1,
      anon_sym_SEMI,
  [22219] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(996), 1,
      anon_sym_SEMI,
  [22226] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(998), 1,
      anon_sym_RBRACE,
  [22233] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 1,
      anon_sym_else,
  [22240] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1002), 1,
      anon_sym_SEMI,
  [22247] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1004), 1,
      anon_sym_COLON,
  [22254] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1006), 1,
      anon_sym_RBRACE,
  [22261] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1008), 1,
      anon_sym_RBRACE,
  [22268] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACE,
  [22275] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 1,
      anon_sym_RBRACE,
  [22282] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 1,
      anon_sym_LBRACE,
  [22289] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_then,
  [22296] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1016), 1,
      anon_sym_SEMI,
  [22303] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1018), 1,
      anon_sym_COLON,
  [22310] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 1,
      anon_sym_in,
  [22317] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1022), 1,
      sym_identifier,
  [22324] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      anon_sym_RPAREN,
  [22331] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(601), 1,
      anon_sym_LBRACE,
  [22338] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1026), 1,
      anon_sym_in,
  [22345] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_SEMI,
  [22352] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1030), 1,
      anon_sym_SEMI,
  [22359] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1032), 1,
      anon_sym_SEMI,
  [22366] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1034), 1,
      anon_sym_RBRACE,
  [22373] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1036), 1,
      anon_sym_DOLLAR,
  [22380] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1038), 1,
      anon_sym_SEMI,
  [22387] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1040), 1,
      sym_identifier,
  [22394] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1042), 1,
      anon_sym_EQ,
  [22401] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      anon_sym_LBRACE,
  [22408] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1046), 1,
      anon_sym_RBRACE,
  [22415] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1048), 1,
      anon_sym_COLON,
  [22422] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1050), 1,
      anon_sym_RBRACE,
  [22429] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1052), 1,
      sym_identifier,
  [22436] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1054), 1,
      anon_sym_SEMI,
  [22443] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1056), 1,
      anon_sym_RBRACE,
  [22450] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1058), 1,
      anon_sym_RBRACE,
  [22457] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1060), 1,
      anon_sym_RBRACE,
  [22464] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1062), 1,
      anon_sym_LBRACE,
  [22471] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1064), 1,
      anon_sym_RBRACE,
  [22478] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1066), 1,
      anon_sym_COLON,
  [22485] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(234), 1,
      anon_sym_COLON,
  [22492] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1068), 1,
      sym_identifier,
  [22499] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1070), 1,
      anon_sym_DOLLAR,
  [22506] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1072), 1,
      anon_sym_RPAREN,
  [22513] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1074), 1,
      anon_sym_RBRACE,
  [22520] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      ts_builtin_sym_end,
  [22527] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1078), 1,
      ts_builtin_sym_end,
  [22534] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1080), 1,
      anon_sym_EQ,
  [22541] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1082), 1,
      anon_sym_then,
  [22548] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1084), 1,
      anon_sym_RPAREN,
  [22555] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1086), 1,
      anon_sym_then,
  [22562] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1088), 1,
      anon_sym_then,
  [22569] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1090), 1,
      anon_sym_SEMI,
  [22576] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1092), 1,
      anon_sym_else,
  [22583] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1094), 1,
      anon_sym_LBRACE,
  [22590] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1096), 1,
      anon_sym_RBRACE,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 97,
  [SMALL_STATE(4)] = 194,
  [SMALL_STATE(5)] = 291,
  [SMALL_STATE(6)] = 388,
  [SMALL_STATE(7)] = 485,
  [SMALL_STATE(8)] = 582,
  [SMALL_STATE(9)] = 679,
  [SMALL_STATE(10)] = 776,
  [SMALL_STATE(11)] = 873,
  [SMALL_STATE(12)] = 970,
  [SMALL_STATE(13)] = 1067,
  [SMALL_STATE(14)] = 1164,
  [SMALL_STATE(15)] = 1261,
  [SMALL_STATE(16)] = 1358,
  [SMALL_STATE(17)] = 1455,
  [SMALL_STATE(18)] = 1552,
  [SMALL_STATE(19)] = 1649,
  [SMALL_STATE(20)] = 1746,
  [SMALL_STATE(21)] = 1843,
  [SMALL_STATE(22)] = 1940,
  [SMALL_STATE(23)] = 2037,
  [SMALL_STATE(24)] = 2134,
  [SMALL_STATE(25)] = 2217,
  [SMALL_STATE(26)] = 2314,
  [SMALL_STATE(27)] = 2411,
  [SMALL_STATE(28)] = 2508,
  [SMALL_STATE(29)] = 2605,
  [SMALL_STATE(30)] = 2702,
  [SMALL_STATE(31)] = 2799,
  [SMALL_STATE(32)] = 2896,
  [SMALL_STATE(33)] = 2993,
  [SMALL_STATE(34)] = 3090,
  [SMALL_STATE(35)] = 3187,
  [SMALL_STATE(36)] = 3284,
  [SMALL_STATE(37)] = 3381,
  [SMALL_STATE(38)] = 3478,
  [SMALL_STATE(39)] = 3575,
  [SMALL_STATE(40)] = 3672,
  [SMALL_STATE(41)] = 3769,
  [SMALL_STATE(42)] = 3866,
  [SMALL_STATE(43)] = 3963,
  [SMALL_STATE(44)] = 4060,
  [SMALL_STATE(45)] = 4154,
  [SMALL_STATE(46)] = 4248,
  [SMALL_STATE(47)] = 4342,
  [SMALL_STATE(48)] = 4436,
  [SMALL_STATE(49)] = 4530,
  [SMALL_STATE(50)] = 4624,
  [SMALL_STATE(51)] = 4718,
  [SMALL_STATE(52)] = 4812,
  [SMALL_STATE(53)] = 4906,
  [SMALL_STATE(54)] = 5000,
  [SMALL_STATE(55)] = 5094,
  [SMALL_STATE(56)] = 5188,
  [SMALL_STATE(57)] = 5282,
  [SMALL_STATE(58)] = 5376,
  [SMALL_STATE(59)] = 5470,
  [SMALL_STATE(60)] = 5564,
  [SMALL_STATE(61)] = 5658,
  [SMALL_STATE(62)] = 5752,
  [SMALL_STATE(63)] = 5846,
  [SMALL_STATE(64)] = 5940,
  [SMALL_STATE(65)] = 6034,
  [SMALL_STATE(66)] = 6128,
  [SMALL_STATE(67)] = 6222,
  [SMALL_STATE(68)] = 6316,
  [SMALL_STATE(69)] = 6410,
  [SMALL_STATE(70)] = 6504,
  [SMALL_STATE(71)] = 6598,
  [SMALL_STATE(72)] = 6692,
  [SMALL_STATE(73)] = 6786,
  [SMALL_STATE(74)] = 6880,
  [SMALL_STATE(75)] = 6974,
  [SMALL_STATE(76)] = 7068,
  [SMALL_STATE(77)] = 7148,
  [SMALL_STATE(78)] = 7228,
  [SMALL_STATE(79)] = 7308,
  [SMALL_STATE(80)] = 7364,
  [SMALL_STATE(81)] = 7420,
  [SMALL_STATE(82)] = 7476,
  [SMALL_STATE(83)] = 7532,
  [SMALL_STATE(84)] = 7588,
  [SMALL_STATE(85)] = 7634,
  [SMALL_STATE(86)] = 7684,
  [SMALL_STATE(87)] = 7730,
  [SMALL_STATE(88)] = 7780,
  [SMALL_STATE(89)] = 7830,
  [SMALL_STATE(90)] = 7877,
  [SMALL_STATE(91)] = 7922,
  [SMALL_STATE(92)] = 7971,
  [SMALL_STATE(93)] = 8016,
  [SMALL_STATE(94)] = 8061,
  [SMALL_STATE(95)] = 8106,
  [SMALL_STATE(96)] = 8158,
  [SMALL_STATE(97)] = 8202,
  [SMALL_STATE(98)] = 8254,
  [SMALL_STATE(99)] = 8306,
  [SMALL_STATE(100)] = 8358,
  [SMALL_STATE(101)] = 8402,
  [SMALL_STATE(102)] = 8446,
  [SMALL_STATE(103)] = 8490,
  [SMALL_STATE(104)] = 8534,
  [SMALL_STATE(105)] = 8578,
  [SMALL_STATE(106)] = 8622,
  [SMALL_STATE(107)] = 8668,
  [SMALL_STATE(108)] = 8712,
  [SMALL_STATE(109)] = 8764,
  [SMALL_STATE(110)] = 8808,
  [SMALL_STATE(111)] = 8860,
  [SMALL_STATE(112)] = 8906,
  [SMALL_STATE(113)] = 8958,
  [SMALL_STATE(114)] = 9002,
  [SMALL_STATE(115)] = 9054,
  [SMALL_STATE(116)] = 9106,
  [SMALL_STATE(117)] = 9150,
  [SMALL_STATE(118)] = 9202,
  [SMALL_STATE(119)] = 9246,
  [SMALL_STATE(120)] = 9290,
  [SMALL_STATE(121)] = 9342,
  [SMALL_STATE(122)] = 9394,
  [SMALL_STATE(123)] = 9446,
  [SMALL_STATE(124)] = 9498,
  [SMALL_STATE(125)] = 9550,
  [SMALL_STATE(126)] = 9594,
  [SMALL_STATE(127)] = 9667,
  [SMALL_STATE(128)] = 9740,
  [SMALL_STATE(129)] = 9813,
  [SMALL_STATE(130)] = 9886,
  [SMALL_STATE(131)] = 9959,
  [SMALL_STATE(132)] = 10032,
  [SMALL_STATE(133)] = 10105,
  [SMALL_STATE(134)] = 10178,
  [SMALL_STATE(135)] = 10251,
  [SMALL_STATE(136)] = 10324,
  [SMALL_STATE(137)] = 10397,
  [SMALL_STATE(138)] = 10470,
  [SMALL_STATE(139)] = 10543,
  [SMALL_STATE(140)] = 10616,
  [SMALL_STATE(141)] = 10689,
  [SMALL_STATE(142)] = 10762,
  [SMALL_STATE(143)] = 10835,
  [SMALL_STATE(144)] = 10908,
  [SMALL_STATE(145)] = 10981,
  [SMALL_STATE(146)] = 11054,
  [SMALL_STATE(147)] = 11127,
  [SMALL_STATE(148)] = 11200,
  [SMALL_STATE(149)] = 11273,
  [SMALL_STATE(150)] = 11346,
  [SMALL_STATE(151)] = 11419,
  [SMALL_STATE(152)] = 11492,
  [SMALL_STATE(153)] = 11565,
  [SMALL_STATE(154)] = 11638,
  [SMALL_STATE(155)] = 11711,
  [SMALL_STATE(156)] = 11784,
  [SMALL_STATE(157)] = 11857,
  [SMALL_STATE(158)] = 11930,
  [SMALL_STATE(159)] = 12003,
  [SMALL_STATE(160)] = 12076,
  [SMALL_STATE(161)] = 12149,
  [SMALL_STATE(162)] = 12192,
  [SMALL_STATE(163)] = 12265,
  [SMALL_STATE(164)] = 12338,
  [SMALL_STATE(165)] = 12411,
  [SMALL_STATE(166)] = 12484,
  [SMALL_STATE(167)] = 12557,
  [SMALL_STATE(168)] = 12630,
  [SMALL_STATE(169)] = 12703,
  [SMALL_STATE(170)] = 12776,
  [SMALL_STATE(171)] = 12849,
  [SMALL_STATE(172)] = 12891,
  [SMALL_STATE(173)] = 12937,
  [SMALL_STATE(174)] = 12983,
  [SMALL_STATE(175)] = 13025,
  [SMALL_STATE(176)] = 13071,
  [SMALL_STATE(177)] = 13117,
  [SMALL_STATE(178)] = 13159,
  [SMALL_STATE(179)] = 13201,
  [SMALL_STATE(180)] = 13247,
  [SMALL_STATE(181)] = 13293,
  [SMALL_STATE(182)] = 13339,
  [SMALL_STATE(183)] = 13383,
  [SMALL_STATE(184)] = 13427,
  [SMALL_STATE(185)] = 13471,
  [SMALL_STATE(186)] = 13513,
  [SMALL_STATE(187)] = 13559,
  [SMALL_STATE(188)] = 13601,
  [SMALL_STATE(189)] = 13647,
  [SMALL_STATE(190)] = 13693,
  [SMALL_STATE(191)] = 13739,
  [SMALL_STATE(192)] = 13781,
  [SMALL_STATE(193)] = 13827,
  [SMALL_STATE(194)] = 13868,
  [SMALL_STATE(195)] = 13909,
  [SMALL_STATE(196)] = 13950,
  [SMALL_STATE(197)] = 13991,
  [SMALL_STATE(198)] = 14032,
  [SMALL_STATE(199)] = 14073,
  [SMALL_STATE(200)] = 14114,
  [SMALL_STATE(201)] = 14155,
  [SMALL_STATE(202)] = 14196,
  [SMALL_STATE(203)] = 14237,
  [SMALL_STATE(204)] = 14278,
  [SMALL_STATE(205)] = 14319,
  [SMALL_STATE(206)] = 14359,
  [SMALL_STATE(207)] = 14399,
  [SMALL_STATE(208)] = 14439,
  [SMALL_STATE(209)] = 14479,
  [SMALL_STATE(210)] = 14519,
  [SMALL_STATE(211)] = 14559,
  [SMALL_STATE(212)] = 14599,
  [SMALL_STATE(213)] = 14639,
  [SMALL_STATE(214)] = 14679,
  [SMALL_STATE(215)] = 14719,
  [SMALL_STATE(216)] = 14759,
  [SMALL_STATE(217)] = 14799,
  [SMALL_STATE(218)] = 14839,
  [SMALL_STATE(219)] = 14879,
  [SMALL_STATE(220)] = 14921,
  [SMALL_STATE(221)] = 14961,
  [SMALL_STATE(222)] = 15001,
  [SMALL_STATE(223)] = 15041,
  [SMALL_STATE(224)] = 15081,
  [SMALL_STATE(225)] = 15121,
  [SMALL_STATE(226)] = 15163,
  [SMALL_STATE(227)] = 15205,
  [SMALL_STATE(228)] = 15245,
  [SMALL_STATE(229)] = 15285,
  [SMALL_STATE(230)] = 15325,
  [SMALL_STATE(231)] = 15365,
  [SMALL_STATE(232)] = 15405,
  [SMALL_STATE(233)] = 15445,
  [SMALL_STATE(234)] = 15485,
  [SMALL_STATE(235)] = 15525,
  [SMALL_STATE(236)] = 15567,
  [SMALL_STATE(237)] = 15607,
  [SMALL_STATE(238)] = 15647,
  [SMALL_STATE(239)] = 15687,
  [SMALL_STATE(240)] = 15727,
  [SMALL_STATE(241)] = 15769,
  [SMALL_STATE(242)] = 15809,
  [SMALL_STATE(243)] = 15849,
  [SMALL_STATE(244)] = 15891,
  [SMALL_STATE(245)] = 15931,
  [SMALL_STATE(246)] = 15971,
  [SMALL_STATE(247)] = 16011,
  [SMALL_STATE(248)] = 16051,
  [SMALL_STATE(249)] = 16091,
  [SMALL_STATE(250)] = 16131,
  [SMALL_STATE(251)] = 16171,
  [SMALL_STATE(252)] = 16211,
  [SMALL_STATE(253)] = 16251,
  [SMALL_STATE(254)] = 16290,
  [SMALL_STATE(255)] = 16329,
  [SMALL_STATE(256)] = 16368,
  [SMALL_STATE(257)] = 16407,
  [SMALL_STATE(258)] = 16446,
  [SMALL_STATE(259)] = 16485,
  [SMALL_STATE(260)] = 16550,
  [SMALL_STATE(261)] = 16615,
  [SMALL_STATE(262)] = 16680,
  [SMALL_STATE(263)] = 16745,
  [SMALL_STATE(264)] = 16810,
  [SMALL_STATE(265)] = 16875,
  [SMALL_STATE(266)] = 16940,
  [SMALL_STATE(267)] = 17005,
  [SMALL_STATE(268)] = 17070,
  [SMALL_STATE(269)] = 17129,
  [SMALL_STATE(270)] = 17188,
  [SMALL_STATE(271)] = 17247,
  [SMALL_STATE(272)] = 17306,
  [SMALL_STATE(273)] = 17339,
  [SMALL_STATE(274)] = 17372,
  [SMALL_STATE(275)] = 17405,
  [SMALL_STATE(276)] = 17438,
  [SMALL_STATE(277)] = 17473,
  [SMALL_STATE(278)] = 17504,
  [SMALL_STATE(279)] = 17535,
  [SMALL_STATE(280)] = 17570,
  [SMALL_STATE(281)] = 17604,
  [SMALL_STATE(282)] = 17637,
  [SMALL_STATE(283)] = 17670,
  [SMALL_STATE(284)] = 17703,
  [SMALL_STATE(285)] = 17745,
  [SMALL_STATE(286)] = 17781,
  [SMALL_STATE(287)] = 17813,
  [SMALL_STATE(288)] = 17841,
  [SMALL_STATE(289)] = 17869,
  [SMALL_STATE(290)] = 17897,
  [SMALL_STATE(291)] = 17947,
  [SMALL_STATE(292)] = 17997,
  [SMALL_STATE(293)] = 18029,
  [SMALL_STATE(294)] = 18075,
  [SMALL_STATE(295)] = 18119,
  [SMALL_STATE(296)] = 18157,
  [SMALL_STATE(297)] = 18197,
  [SMALL_STATE(298)] = 18237,
  [SMALL_STATE(299)] = 18270,
  [SMALL_STATE(300)] = 18303,
  [SMALL_STATE(301)] = 18350,
  [SMALL_STATE(302)] = 18385,
  [SMALL_STATE(303)] = 18414,
  [SMALL_STATE(304)] = 18451,
  [SMALL_STATE(305)] = 18486,
  [SMALL_STATE(306)] = 18533,
  [SMALL_STATE(307)] = 18562,
  [SMALL_STATE(308)] = 18591,
  [SMALL_STATE(309)] = 18634,
  [SMALL_STATE(310)] = 18675,
  [SMALL_STATE(311)] = 18712,
  [SMALL_STATE(312)] = 18751,
  [SMALL_STATE(313)] = 18786,
  [SMALL_STATE(314)] = 18829,
  [SMALL_STATE(315)] = 18868,
  [SMALL_STATE(316)] = 18905,
  [SMALL_STATE(317)] = 18946,
  [SMALL_STATE(318)] = 18983,
  [SMALL_STATE(319)] = 19030,
  [SMALL_STATE(320)] = 19071,
  [SMALL_STATE(321)] = 19114,
  [SMALL_STATE(322)] = 19143,
  [SMALL_STATE(323)] = 19172,
  [SMALL_STATE(324)] = 19211,
  [SMALL_STATE(325)] = 19258,
  [SMALL_STATE(326)] = 19295,
  [SMALL_STATE(327)] = 19342,
  [SMALL_STATE(328)] = 19375,
  [SMALL_STATE(329)] = 19422,
  [SMALL_STATE(330)] = 19459,
  [SMALL_STATE(331)] = 19488,
  [SMALL_STATE(332)] = 19531,
  [SMALL_STATE(333)] = 19574,
  [SMALL_STATE(334)] = 19597,
  [SMALL_STATE(335)] = 19640,
  [SMALL_STATE(336)] = 19683,
  [SMALL_STATE(337)] = 19723,
  [SMALL_STATE(338)] = 19763,
  [SMALL_STATE(339)] = 19803,
  [SMALL_STATE(340)] = 19843,
  [SMALL_STATE(341)] = 19880,
  [SMALL_STATE(342)] = 19917,
  [SMALL_STATE(343)] = 19954,
  [SMALL_STATE(344)] = 19991,
  [SMALL_STATE(345)] = 20028,
  [SMALL_STATE(346)] = 20065,
  [SMALL_STATE(347)] = 20102,
  [SMALL_STATE(348)] = 20139,
  [SMALL_STATE(349)] = 20176,
  [SMALL_STATE(350)] = 20213,
  [SMALL_STATE(351)] = 20250,
  [SMALL_STATE(352)] = 20287,
  [SMALL_STATE(353)] = 20321,
  [SMALL_STATE(354)] = 20355,
  [SMALL_STATE(355)] = 20389,
  [SMALL_STATE(356)] = 20423,
  [SMALL_STATE(357)] = 20449,
  [SMALL_STATE(358)] = 20475,
  [SMALL_STATE(359)] = 20488,
  [SMALL_STATE(360)] = 20509,
  [SMALL_STATE(361)] = 20530,
  [SMALL_STATE(362)] = 20551,
  [SMALL_STATE(363)] = 20564,
  [SMALL_STATE(364)] = 20577,
  [SMALL_STATE(365)] = 20598,
  [SMALL_STATE(366)] = 20621,
  [SMALL_STATE(367)] = 20642,
  [SMALL_STATE(368)] = 20663,
  [SMALL_STATE(369)] = 20684,
  [SMALL_STATE(370)] = 20705,
  [SMALL_STATE(371)] = 20726,
  [SMALL_STATE(372)] = 20747,
  [SMALL_STATE(373)] = 20760,
  [SMALL_STATE(374)] = 20773,
  [SMALL_STATE(375)] = 20794,
  [SMALL_STATE(376)] = 20815,
  [SMALL_STATE(377)] = 20836,
  [SMALL_STATE(378)] = 20857,
  [SMALL_STATE(379)] = 20878,
  [SMALL_STATE(380)] = 20899,
  [SMALL_STATE(381)] = 20920,
  [SMALL_STATE(382)] = 20943,
  [SMALL_STATE(383)] = 20964,
  [SMALL_STATE(384)] = 20985,
  [SMALL_STATE(385)] = 21006,
  [SMALL_STATE(386)] = 21027,
  [SMALL_STATE(387)] = 21048,
  [SMALL_STATE(388)] = 21071,
  [SMALL_STATE(389)] = 21092,
  [SMALL_STATE(390)] = 21113,
  [SMALL_STATE(391)] = 21126,
  [SMALL_STATE(392)] = 21139,
  [SMALL_STATE(393)] = 21152,
  [SMALL_STATE(394)] = 21165,
  [SMALL_STATE(395)] = 21178,
  [SMALL_STATE(396)] = 21199,
  [SMALL_STATE(397)] = 21220,
  [SMALL_STATE(398)] = 21243,
  [SMALL_STATE(399)] = 21264,
  [SMALL_STATE(400)] = 21285,
  [SMALL_STATE(401)] = 21306,
  [SMALL_STATE(402)] = 21327,
  [SMALL_STATE(403)] = 21347,
  [SMALL_STATE(404)] = 21367,
  [SMALL_STATE(405)] = 21387,
  [SMALL_STATE(406)] = 21407,
  [SMALL_STATE(407)] = 21427,
  [SMALL_STATE(408)] = 21447,
  [SMALL_STATE(409)] = 21467,
  [SMALL_STATE(410)] = 21484,
  [SMALL_STATE(411)] = 21497,
  [SMALL_STATE(412)] = 21514,
  [SMALL_STATE(413)] = 21531,
  [SMALL_STATE(414)] = 21544,
  [SMALL_STATE(415)] = 21557,
  [SMALL_STATE(416)] = 21570,
  [SMALL_STATE(417)] = 21587,
  [SMALL_STATE(418)] = 21600,
  [SMALL_STATE(419)] = 21613,
  [SMALL_STATE(420)] = 21626,
  [SMALL_STATE(421)] = 21639,
  [SMALL_STATE(422)] = 21652,
  [SMALL_STATE(423)] = 21663,
  [SMALL_STATE(424)] = 21674,
  [SMALL_STATE(425)] = 21687,
  [SMALL_STATE(426)] = 21704,
  [SMALL_STATE(427)] = 21721,
  [SMALL_STATE(428)] = 21737,
  [SMALL_STATE(429)] = 21747,
  [SMALL_STATE(430)] = 21760,
  [SMALL_STATE(431)] = 21773,
  [SMALL_STATE(432)] = 21786,
  [SMALL_STATE(433)] = 21797,
  [SMALL_STATE(434)] = 21810,
  [SMALL_STATE(435)] = 21823,
  [SMALL_STATE(436)] = 21836,
  [SMALL_STATE(437)] = 21849,
  [SMALL_STATE(438)] = 21859,
  [SMALL_STATE(439)] = 21869,
  [SMALL_STATE(440)] = 21877,
  [SMALL_STATE(441)] = 21887,
  [SMALL_STATE(442)] = 21897,
  [SMALL_STATE(443)] = 21905,
  [SMALL_STATE(444)] = 21913,
  [SMALL_STATE(445)] = 21923,
  [SMALL_STATE(446)] = 21933,
  [SMALL_STATE(447)] = 21943,
  [SMALL_STATE(448)] = 21951,
  [SMALL_STATE(449)] = 21959,
  [SMALL_STATE(450)] = 21969,
  [SMALL_STATE(451)] = 21977,
  [SMALL_STATE(452)] = 21987,
  [SMALL_STATE(453)] = 21995,
  [SMALL_STATE(454)] = 22002,
  [SMALL_STATE(455)] = 22009,
  [SMALL_STATE(456)] = 22016,
  [SMALL_STATE(457)] = 22023,
  [SMALL_STATE(458)] = 22030,
  [SMALL_STATE(459)] = 22037,
  [SMALL_STATE(460)] = 22044,
  [SMALL_STATE(461)] = 22051,
  [SMALL_STATE(462)] = 22058,
  [SMALL_STATE(463)] = 22065,
  [SMALL_STATE(464)] = 22072,
  [SMALL_STATE(465)] = 22079,
  [SMALL_STATE(466)] = 22086,
  [SMALL_STATE(467)] = 22093,
  [SMALL_STATE(468)] = 22100,
  [SMALL_STATE(469)] = 22107,
  [SMALL_STATE(470)] = 22114,
  [SMALL_STATE(471)] = 22121,
  [SMALL_STATE(472)] = 22128,
  [SMALL_STATE(473)] = 22135,
  [SMALL_STATE(474)] = 22142,
  [SMALL_STATE(475)] = 22149,
  [SMALL_STATE(476)] = 22156,
  [SMALL_STATE(477)] = 22163,
  [SMALL_STATE(478)] = 22170,
  [SMALL_STATE(479)] = 22177,
  [SMALL_STATE(480)] = 22184,
  [SMALL_STATE(481)] = 22191,
  [SMALL_STATE(482)] = 22198,
  [SMALL_STATE(483)] = 22205,
  [SMALL_STATE(484)] = 22212,
  [SMALL_STATE(485)] = 22219,
  [SMALL_STATE(486)] = 22226,
  [SMALL_STATE(487)] = 22233,
  [SMALL_STATE(488)] = 22240,
  [SMALL_STATE(489)] = 22247,
  [SMALL_STATE(490)] = 22254,
  [SMALL_STATE(491)] = 22261,
  [SMALL_STATE(492)] = 22268,
  [SMALL_STATE(493)] = 22275,
  [SMALL_STATE(494)] = 22282,
  [SMALL_STATE(495)] = 22289,
  [SMALL_STATE(496)] = 22296,
  [SMALL_STATE(497)] = 22303,
  [SMALL_STATE(498)] = 22310,
  [SMALL_STATE(499)] = 22317,
  [SMALL_STATE(500)] = 22324,
  [SMALL_STATE(501)] = 22331,
  [SMALL_STATE(502)] = 22338,
  [SMALL_STATE(503)] = 22345,
  [SMALL_STATE(504)] = 22352,
  [SMALL_STATE(505)] = 22359,
  [SMALL_STATE(506)] = 22366,
  [SMALL_STATE(507)] = 22373,
  [SMALL_STATE(508)] = 22380,
  [SMALL_STATE(509)] = 22387,
  [SMALL_STATE(510)] = 22394,
  [SMALL_STATE(511)] = 22401,
  [SMALL_STATE(512)] = 22408,
  [SMALL_STATE(513)] = 22415,
  [SMALL_STATE(514)] = 22422,
  [SMALL_STATE(515)] = 22429,
  [SMALL_STATE(516)] = 22436,
  [SMALL_STATE(517)] = 22443,
  [SMALL_STATE(518)] = 22450,
  [SMALL_STATE(519)] = 22457,
  [SMALL_STATE(520)] = 22464,
  [SMALL_STATE(521)] = 22471,
  [SMALL_STATE(522)] = 22478,
  [SMALL_STATE(523)] = 22485,
  [SMALL_STATE(524)] = 22492,
  [SMALL_STATE(525)] = 22499,
  [SMALL_STATE(526)] = 22506,
  [SMALL_STATE(527)] = 22513,
  [SMALL_STATE(528)] = 22520,
  [SMALL_STATE(529)] = 22527,
  [SMALL_STATE(530)] = 22534,
  [SMALL_STATE(531)] = 22541,
  [SMALL_STATE(532)] = 22548,
  [SMALL_STATE(533)] = 22555,
  [SMALL_STATE(534)] = 22562,
  [SMALL_STATE(535)] = 22569,
  [SMALL_STATE(536)] = 22576,
  [SMALL_STATE(537)] = 22583,
  [SMALL_STATE(538)] = 22590,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_code, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(190),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(226),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(6),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(7),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(338),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(9),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(537),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(176),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(243),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(40),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(39),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(336),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(8),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(511),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(91),
  [77] = {.entry = {.count = 1, .reusable = false}}, SHIFT(106),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [85] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [87] = {.entry = {.count = 1, .reusable = false}}, SHIFT(31),
  [89] = {.entry = {.count = 1, .reusable = false}}, SHIFT(337),
  [91] = {.entry = {.count = 1, .reusable = false}}, SHIFT(14),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [99] = {.entry = {.count = 1, .reusable = false}}, SHIFT(494),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [109] = {.entry = {.count = 1, .reusable = false}}, SHIFT(172),
  [111] = {.entry = {.count = 1, .reusable = false}}, SHIFT(240),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [119] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [121] = {.entry = {.count = 1, .reusable = false}}, SHIFT(32),
  [123] = {.entry = {.count = 1, .reusable = false}}, SHIFT(339),
  [125] = {.entry = {.count = 1, .reusable = false}}, SHIFT(5),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [133] = {.entry = {.count = 1, .reusable = false}}, SHIFT(520),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [143] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [147] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expr_op, 1),
  [149] = {.entry = {.count = 1, .reusable = false}}, SHIFT(501),
  [151] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expr_op, 1),
  [153] = {.entry = {.count = 1, .reusable = false}}, SHIFT(250),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [157] = {.entry = {.count = 1, .reusable = false}}, SHIFT(492),
  [159] = {.entry = {.count = 1, .reusable = false}}, SHIFT(241),
  [161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [163] = {.entry = {.count = 1, .reusable = false}}, SHIFT(458),
  [165] = {.entry = {.count = 1, .reusable = false}}, SHIFT(251),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [169] = {.entry = {.count = 1, .reusable = false}}, SHIFT(475),
  [171] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_hpath_expression, 2),
  [173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_hpath_expression, 2),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [179] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_path_expression_repeat1, 2),
  [181] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2),
  [183] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(26),
  [186] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(80),
  [189] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_path_expression, 2),
  [191] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_path_expression, 2),
  [193] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_hpath_expression, 1),
  [195] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_hpath_expression, 1),
  [197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [199] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_path_expression, 1),
  [201] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_path_expression, 1),
  [203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [205] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_path_expression_repeat1, 1, .production_id = 3),
  [207] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 1, .production_id = 3),
  [209] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attrpath, 1, .production_id = 4),
  [211] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attrpath, 1, .production_id = 4),
  [213] = {.entry = {.count = 1, .reusable = false}}, SHIFT(426),
  [215] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__immediate_interpolation, 3, .production_id = 17),
  [217] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__immediate_interpolation, 3, .production_id = 17),
  [219] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26),
  [221] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26),
  [223] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26), SHIFT_REPEAT(426),
  [226] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attrpath, 2, .production_id = 11),
  [228] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attrpath, 2, .production_id = 11),
  [230] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attrset_expression, 2),
  [232] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attrset_expression, 2),
  [234] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formals, 2),
  [236] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 25),
  [238] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 25),
  [240] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_expression, 1, .production_id = 1),
  [242] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_expression, 1, .production_id = 1),
  [244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [248] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interpolation, 3, .production_id = 17),
  [250] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interpolation, 3, .production_id = 17),
  [252] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_expression, 2),
  [254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_expression, 2),
  [256] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_expression, 3),
  [258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_expression, 3),
  [260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [264] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_indented_string_expression, 2),
  [266] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_indented_string_expression, 2),
  [268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [272] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(37),
  [275] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(98),
  [278] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(4),
  [281] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(99),
  [284] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_attrset_expression, 3),
  [286] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_attrset_expression, 3),
  [288] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3, .production_id = 17),
  [290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3, .production_id = 17),
  [292] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rec_attrset_expression, 3),
  [294] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rec_attrset_expression, 3),
  [296] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_indented_string_expression, 3),
  [298] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_indented_string_expression, 3),
  [300] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attrset_expression, 3),
  [302] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attrset_expression, 3),
  [304] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expr_select_expression, 1),
  [306] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expr_select_expression, 1),
  [308] = {.entry = {.count = 1, .reusable = false}}, SHIFT(403),
  [310] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_expression, 3, .production_id = 18),
  [312] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_expression, 3, .production_id = 18),
  [314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [316] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_select_expression, 3, .production_id = 23),
  [318] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_select_expression, 3, .production_id = 23),
  [320] = {.entry = {.count = 1, .reusable = false}}, SHIFT(269),
  [322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [324] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_expression, 2),
  [326] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_expression, 2),
  [328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [332] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_attrset_expression, 4),
  [334] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_attrset_expression, 4),
  [336] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rec_attrset_expression, 4),
  [338] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rec_attrset_expression, 4),
  [340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [348] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(28),
  [351] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(124),
  [354] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_select_expression, 5, .production_id = 37),
  [356] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_select_expression, 5, .production_id = 37),
  [358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [362] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26), SHIFT_REPEAT(409),
  [365] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26), SHIFT_REPEAT(425),
  [368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [372] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26), SHIFT_REPEAT(412),
  [375] = {.entry = {.count = 1, .reusable = false}}, SHIFT(425),
  [377] = {.entry = {.count = 1, .reusable = false}}, SHIFT(412),
  [379] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_apply_expression, 2, .production_id = 9),
  [381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_apply_expression, 2, .production_id = 9),
  [383] = {.entry = {.count = 1, .reusable = false}}, SHIFT(409),
  [385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [389] = {.entry = {.count = 1, .reusable = false}}, SHIFT(271),
  [391] = {.entry = {.count = 1, .reusable = false}}, SHIFT(268),
  [393] = {.entry = {.count = 1, .reusable = false}}, SHIFT(406),
  [395] = {.entry = {.count = 1, .reusable = false}}, SHIFT(270),
  [397] = {.entry = {.count = 1, .reusable = false}}, SHIFT(402),
  [399] = {.entry = {.count = 1, .reusable = false}}, SHIFT(405),
  [401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [411] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(109),
  [414] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(106),
  [417] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(106),
  [420] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(82),
  [423] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(342),
  [426] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(501),
  [429] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(27),
  [432] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(494),
  [435] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(371),
  [438] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(386),
  [441] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(265),
  [444] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19),
  [446] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 2, .production_id = 19), SHIFT_REPEAT(83),
  [449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [457] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_has_attr_expression, 3, .production_id = 21),
  [459] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_has_attr_expression, 3, .production_id = 21),
  [461] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2, .production_id = 7),
  [463] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2, .production_id = 7),
  [465] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26), SHIFT_REPEAT(416),
  [468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [470] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_attrpath_repeat1, 2, .production_id = 26), SHIFT_REPEAT(411),
  [473] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, .production_id = 22),
  [475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [477] = {.entry = {.count = 1, .reusable = false}}, SHIFT(151),
  [479] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [485] = {.entry = {.count = 1, .reusable = false}}, SHIFT(155),
  [487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [491] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, .production_id = 22),
  [493] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expr_if, 1),
  [495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [507] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [513] = {.entry = {.count = 1, .reusable = false}}, SHIFT(138),
  [515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [517] = {.entry = {.count = 1, .reusable = false}}, SHIFT(143),
  [519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [521] = {.entry = {.count = 1, .reusable = false}}, SHIFT(141),
  [523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [533] = {.entry = {.count = 1, .reusable = false}}, SHIFT(166),
  [535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [537] = {.entry = {.count = 1, .reusable = false}}, SHIFT(150),
  [539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [541] = {.entry = {.count = 1, .reusable = false}}, SHIFT(145),
  [543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [545] = {.entry = {.count = 1, .reusable = false}}, SHIFT(148),
  [547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [553] = {.entry = {.count = 1, .reusable = false}}, SHIFT(126),
  [555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [571] = {.entry = {.count = 1, .reusable = false}}, SHIFT(407),
  [573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [579] = {.entry = {.count = 1, .reusable = false}}, SHIFT(357),
  [581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [585] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_list_expression_repeat1, 1, .production_id = 8),
  [587] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_expression_repeat1, 1, .production_id = 8),
  [589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [593] = {.entry = {.count = 1, .reusable = false}}, SHIFT(430),
  [595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [597] = {.entry = {.count = 1, .reusable = false}}, SHIFT(48),
  [599] = {.entry = {.count = 1, .reusable = false}}, SHIFT(356),
  [601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [603] = {.entry = {.count = 1, .reusable = false}}, SHIFT(64),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [607] = {.entry = {.count = 1, .reusable = false}}, SHIFT(49),
  [609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [611] = {.entry = {.count = 1, .reusable = false}}, SHIFT(56),
  [613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [637] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_binding_set_repeat1, 2, .production_id = 15), SHIFT_REPEAT(430),
  [640] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_binding_set_repeat1, 2, .production_id = 15),
  [642] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_binding_set_repeat1, 2, .production_id = 15), SHIFT_REPEAT(385),
  [645] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_binding_set_repeat1, 2, .production_id = 15), SHIFT_REPEAT(356),
  [648] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_binding_set_repeat1, 2, .production_id = 15), SHIFT_REPEAT(34),
  [651] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binding_set, 1, .production_id = 6),
  [653] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_binding_set_repeat1, 2, .production_id = 15),
  [655] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_binding_set_repeat1, 2, .production_id = 15), SHIFT_REPEAT(357),
  [658] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binding_set, 1, .production_id = 6),
  [660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [666] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_expression, 5, .production_id = 33),
  [668] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [672] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [674] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [676] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_expression_repeat1, 2),
  [678] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_expression_repeat1, 2), SHIFT_REPEAT(360),
  [681] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_expression_repeat1, 2), SHIFT_REPEAT(43),
  [684] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_expression_repeat1, 2), SHIFT_REPEAT(525),
  [687] = {.entry = {.count = 1, .reusable = false}}, SHIFT(221),
  [689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [693] = {.entry = {.count = 1, .reusable = true}}, SHIFT(507),
  [695] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_expression, 3, .production_id = 20),
  [697] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_expression, 3, .production_id = 16),
  [699] = {.entry = {.count = 1, .reusable = false}}, SHIFT(233),
  [701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [703] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inherited_attrs, 1, .production_id = 13),
  [705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [711] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_indented_string_expression_repeat1, 2),
  [713] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_indented_string_expression_repeat1, 2), SHIFT_REPEAT(368),
  [716] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_indented_string_expression_repeat1, 2), SHIFT_REPEAT(36),
  [719] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_indented_string_expression_repeat1, 2), SHIFT_REPEAT(507),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [726] = {.entry = {.count = 1, .reusable = false}}, SHIFT(252),
  [728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [734] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_expression, 6, .production_id = 39),
  [736] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_expression, 3, .production_id = 10),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [748] = {.entry = {.count = 1, .reusable = false}}, SHIFT(248),
  [750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [752] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [754] = {.entry = {.count = 1, .reusable = false}}, SHIFT(218),
  [756] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inherited_attrs_repeat1, 2, .production_id = 26), SHIFT_REPEAT(428),
  [759] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_inherited_attrs_repeat1, 2, .production_id = 26),
  [761] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inherited_attrs_repeat1, 2, .production_id = 26), SHIFT_REPEAT(385),
  [764] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inherited_attrs_repeat1, 2, .production_id = 26), SHIFT_REPEAT(34),
  [767] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [769] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [771] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [773] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [775] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [777] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [779] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [781] = {.entry = {.count = 1, .reusable = false}}, SHIFT(96),
  [783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [785] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [787] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [789] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1),
  [791] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assert_expression, 4, .production_id = 30),
  [793] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_with_expression, 4, .production_id = 31),
  [795] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_expression, 4, .production_id = 32),
  [797] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_expression, 5, .production_id = 36),
  [799] = {.entry = {.count = 1, .reusable = false}}, SHIFT(231),
  [801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [803] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [805] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [809] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [811] = {.entry = {.count = 1, .reusable = true}}, SHIFT(398),
  [813] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [815] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [817] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [819] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [821] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [823] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [825] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [829] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [831] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [835] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [837] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [839] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [841] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [843] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formal, 1, .production_id = 1),
  [845] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [847] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [849] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [851] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [853] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [855] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binding, 4, .production_id = 35),
  [857] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binding, 4, .production_id = 35),
  [859] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [861] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [863] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_indented_string_expression_repeat1, 2),
  [865] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_inherit, 3, .production_id = 27),
  [867] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inherit, 3, .production_id = 27),
  [869] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_binding_set_repeat1, 1, .production_id = 5),
  [871] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_binding_set_repeat1, 1, .production_id = 5),
  [873] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_inherit_from, 6, .production_id = 40),
  [875] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inherit_from, 6, .production_id = 40),
  [877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [879] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [881] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [883] = {.entry = {.count = 1, .reusable = true}}, SHIFT(523),
  [885] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_inherited_attrs_repeat1, 1, .production_id = 4),
  [887] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_formals_repeat1, 2, .production_id = 29),
  [889] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_formals_repeat1, 2, .production_id = 29), SHIFT_REPEAT(451),
  [892] = {.entry = {.count = 1, .reusable = true}}, SHIFT(538),
  [894] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [896] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [898] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [900] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [902] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [904] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [906] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [908] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [910] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formals, 3, .production_id = 14),
  [912] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [914] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [916] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [918] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [920] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formals, 3, .production_id = 12),
  [922] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formal, 3, .production_id = 24),
  [924] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [926] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [928] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_formals_repeat1, 2, .production_id = 14),
  [930] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formals, 4, .production_id = 28),
  [932] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formals, 5, .production_id = 34),
  [934] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formals, 6, .production_id = 38),
  [936] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [938] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [940] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [942] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [944] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [946] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [948] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [950] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [952] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [954] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [956] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [958] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [960] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [962] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [964] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [966] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [968] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [970] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [972] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [974] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [976] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [978] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [980] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [982] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [984] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [986] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [988] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [990] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [992] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [994] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [996] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [998] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [1000] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [1002] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [1004] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [1006] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [1008] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [1010] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [1012] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [1014] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [1016] = {.entry = {.count = 1, .reusable = true}}, SHIFT(421),
  [1018] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [1020] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [1022] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [1024] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [1026] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [1028] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [1030] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [1032] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [1034] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [1036] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [1038] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [1040] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [1042] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [1044] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [1046] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [1048] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [1050] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [1052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(463),
  [1054] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [1056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [1058] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [1060] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [1062] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [1064] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [1066] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [1068] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [1070] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [1072] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [1074] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [1076] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_code, 1, .production_id = 2),
  [1078] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1080] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [1082] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1084] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [1086] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [1088] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [1090] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [1092] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [1094] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [1096] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
};

enum ts_external_scanner_symbol_identifiers {
  ts_external_token_string_fragment = 0,
  ts_external_token__indented_string_fragment = 1,
  ts_external_token__path_start = 2,
  ts_external_token_path_fragment = 3,
  ts_external_token_dollar_escape = 4,
  ts_external_token__indented_dollar_escape = 5,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_string_fragment] = sym_string_fragment,
  [ts_external_token__indented_string_fragment] = sym__indented_string_fragment,
  [ts_external_token__path_start] = sym__path_start,
  [ts_external_token_path_fragment] = sym_path_fragment,
  [ts_external_token_dollar_escape] = sym_dollar_escape,
  [ts_external_token__indented_dollar_escape] = sym__indented_dollar_escape,
};

static const bool ts_external_scanner_states[6][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_string_fragment] = true,
    [ts_external_token__indented_string_fragment] = true,
    [ts_external_token__path_start] = true,
    [ts_external_token_path_fragment] = true,
    [ts_external_token_dollar_escape] = true,
    [ts_external_token__indented_dollar_escape] = true,
  },
  [2] = {
    [ts_external_token__path_start] = true,
  },
  [3] = {
    [ts_external_token__path_start] = true,
    [ts_external_token_path_fragment] = true,
  },
  [4] = {
    [ts_external_token_string_fragment] = true,
    [ts_external_token_dollar_escape] = true,
  },
  [5] = {
    [ts_external_token__indented_string_fragment] = true,
    [ts_external_token__indented_dollar_escape] = true,
  },
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_nix_external_scanner_create(void);
void tree_sitter_nix_external_scanner_destroy(void *);
bool tree_sitter_nix_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_nix_external_scanner_serialize(void *, char *);
void tree_sitter_nix_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_nix(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_keyword,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_nix_external_scanner_create,
      tree_sitter_nix_external_scanner_destroy,
      tree_sitter_nix_external_scanner_scan,
      tree_sitter_nix_external_scanner_serialize,
      tree_sitter_nix_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
