/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fur extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arap";
        final String metaValue_hy = "armen";
        final String metaValue_bn = "bengal\u00eas";
        final String metaValue_got = "gotic";
        final String metaValue_el = "gr\u00eac";
        final String metaValue_gu = "gujarati";
        final String metaValue_ja = "gjapon\u00eas";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "corean";
        final String metaValue_lo = "lao";
        final String metaValue_la = "latin";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongul";
        final String metaValue_or = "oriya";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telegu";
        final String metaValue_tl = "tagalog";
        final String metaValue_th = "thai";
        final String metaValue_bo = "tibetan";
        final String metaValue_peo = "vieri persian";
        final Object[][] data = new Object[][] {
            { "001", "Mont" },
            { "002", "Afriche" },
            { "003", "Americhe dal Nord" },
            { "005", "Americhe meridion\u00e2l" },
            { "009", "Oceanie" },
            { "011", "Afriche ocident\u00e2l" },
            { "013", "Americhe centr\u00e2l" },
            { "014", "Afriche orient\u00e2l" },
            { "015", "Afriche setentrion\u00e2l" },
            { "017", "Afriche di mie\u00e7" },
            { "018", "Afriche meridion\u00e2l" },
            { "019", "Americhis" },
            { "021", "Americhe setentrion\u00e2l" },
            { "029", "caraibic" },
            { "030", "Asie orient\u00e2l" },
            { "034", "Asie meridion\u00e2l" },
            { "035", "Asie sud orient\u00e2l" },
            { "039", "Europe meridion\u00e2l" },
            { "053", "Australie e Gnove Zelande" },
            { "054", "Melanesie" },
            { "057", "Regjon de Micronesie" },
            { "061", "Polinesie" },
            { "142", "Asie" },
            { "143", "Asie centr\u00e2l" },
            { "145", "Asie ocident\u00e2l" },
            { "150", "Europe" },
            { "151", "Europe orient\u00e2l" },
            { "154", "Europe setentrion\u00e2l" },
            { "155", "Europe ocident\u00e2l" },
            { "419", "Americhe latine" },
            { "AD", "Andorra" },
            { "AE", "Emir\u00e2ts araps un\u00eets" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua e Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albanie" },
            { "AM", "Armenie" },
            { "AO", "Angola" },
            { "AQ", "Antartic" },
            { "AR", "Argjentine" },
            { "AS", "Samoa merecanis" },
            { "AT", "Austrie" },
            { "AU", "Australie" },
            { "AW", "Aruba" },
            { "AX", "Isulis Aland" },
            { "AZ", "Azerbaigian" },
            { "BA", "Bosnie e Ercegovine" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgjiche" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarie" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Sant Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivie" },
            { "BR", "Bras\u00eel" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Isule Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Bielorussie" },
            { "BZ", "Belize" },
            { "CA", "Canade" },
            { "CC", "Isulis Cocos" },
            { "CD", "Republiche Democratiche dal Congo" },
            { "CF", "Republiche centri africane" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Svuizare" },
            { "CI", "Cueste di Avoli" },
            { "CK", "Isulis Cook" },
            { "CL", "Cile" },
            { "CM", "Camerun" },
            { "CN", "Cine" },
            { "CO", "Colombie" },
            { "CP", "Isule Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cj\u00e2f vert" },
            { "CX", "Isule Christmas" },
            { "CY", "Cipri" },
            { "CZ", "Republiche ceche" },
            { "DE", "Gjermanie" },
            { "DG", "Diego Garcia" },
            { "DJ", "Gibuti" },
            { "DK", "Danimarcje" },
            { "DM", "Dominiche" },
            { "DO", "Republiche dominicane" },
            { "DZ", "Alzerie" },
            { "EA", "Ceuta e Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonie" },
            { "EG", "Egjit" },
            { "EH", "Sahara ocident\u00e2l" },
            { "ER", "Eritree" },
            { "ES", "Spagne" },
            { "ET", "Etiopie" },
            { "EU", "Union europeane" },
            { "FI", "Finlandie" },
            { "FJ", "Fizi" },
            { "FK", "Isulis Falkland" },
            { "FM", "Micronesie" },
            { "FO", "Isulis Faroe" },
            { "FR", "France" },
            { "GA", "Gabon" },
            { "GB", "Ream un\u00eet" },
            { "GD", "Grenada" },
            { "GE", "Gjeorgjie" },
            { "GF", "Guiana franc\u00eas" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gjibraltar" },
            { "GL", "Groenlande" },
            { "GM", "Gambia" },
            { "GN", "Guinee" },
            { "GP", "Guadalupe" },
            { "GQ", "Guinee ecuatori\u00e2l" },
            { "GR", "Grecie" },
            { "GS", "Georgia dal Sud e Isulis Sandwich dal Sud" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Regjon aministrative speci\u00e2l de Cine di Hong Kong" },
            { "HM", "Isule Heard e Isulis McDonald" },
            { "HN", "Honduras" },
            { "HR", "Cravuazie" },
            { "HT", "Haiti" },
            { "HU", "Ongjarie" },
            { "IC", "Isulis Canariis" },
            { "ID", "Indonesie" },
            { "IE", "Irlande" },
            { "IL", "Isra\u00eal" },
            { "IM", "Isule di Man" },
            { "IN", "India" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Islande" },
            { "IT", "Italie" },
            { "JE", "Jersey" },
            { "JM", "Gjamaiche" },
            { "JO", "Jordanie" },
            { "JP", "Gjapon" },
            { "KE", "Kenya" },
            { "KG", "Kirghizstan" },
            { "KH", "Camboze" },
            { "KI", "Kiribati" },
            { "KM", "Comoris" },
            { "KN", "San Kitts e Nevis" },
            { "KP", "Coree dal nord" },
            { "KR", "Coree dal sud" },
            { "KW", "Kuwait" },
            { "KY", "Isulis Cayman" },
            { "KZ", "Kazachistan" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "LC", "Sante Lusie" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberie" },
            { "LS", "Lesotho" },
            { "LT", "Lituanie" },
            { "LU", "Lussemburc" },
            { "LV", "Letonie" },
            { "LY", "Libie" },
            { "MA", "Maroc" },
            { "MC", "Monaco" },
            { "MD", "Moldavie" },
            { "ME", "Montenegro" },
            { "MF", "Sant Martin" },
            { "MG", "Madagascar" },
            { "MH", "Isulis Marshall" },
            { "ML", "Mali" },
            { "MM", "Birmanie" },
            { "MN", "Mongolie" },
            { "MO", "Regjon aministrative speci\u00e2l de Cine di Macao" },
            { "MP", "Isulis Mariana dal Nord" },
            { "MQ", "Martiniche" },
            { "MR", "Mauritanie" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Maurizi" },
            { "MV", "Maldivis" },
            { "MW", "Malawi" },
            { "MX", "Messic" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambic" },
            { "NA", "Namibie" },
            { "NC", "Gnove Caledonie" },
            { "NE", "Niger" },
            { "NF", "Isole Norfolk" },
            { "NG", "Nigerie" },
            { "NI", "Nicaragua" },
            { "NL", "Pa\u00ees bas" },
            { "NO", "Norvegje" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Gnove Zelande" },
            { "OM", "Oman" },
            { "PA", "Panam\u00e0" },
            { "PE", "Per\u00f9" },
            { "PF", "Polinesie franc\u00eas" },
            { "PG", "Papue Gnove Guinee" },
            { "PH", "Filipinis" },
            { "PK", "Pakistan" },
            { "PL", "Polonie" },
            { "PM", "San Pierre e Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Porto Rico" },
            { "PS", "Teritoris palestin\u00eas" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Oceanie periferiche" },
            { "RE", "Reunion" },
            { "RO", "Romanie" },
            { "RS", "Serbie" },
            { "RU", "Russie" },
            { "RW", "Ruande" },
            { "SA", "Arabie Saudide" },
            { "SB", "Isulis Salomon" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", "Svezie" },
            { "SG", "Singapore" },
            { "SH", "Sante Eline" },
            { "SI", "Slovenie" },
            { "SJ", "Svalbard e Jan Mayen" },
            { "SK", "Slovachie" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marin" },
            { "SN", "Senegal" },
            { "SO", "Somalie" },
            { "SR", "Suriname" },
            { "ST", "Sao Tom\u00e8 e Principe" },
            { "SV", "El Salvador" },
            { "SY", "Sirie" },
            { "SZ", "Swaziland" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Isulis Turks e Caicos" },
            { "TD", "\u00c7ad" },
            { "TF", "Teritoris meridion\u00e2i franc\u00eas" },
            { "TG", "Togo" },
            { "TH", "Tailandie" },
            { "TJ", "Tazikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor orient\u00e2l" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisie" },
            { "TO", "Tonga" },
            { "TR", "Turchie" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzanie" },
            { "UA", "Ucraine" },
            { "UG", "Uganda" },
            { "UM", "Isulis periferichis min\u00f4rs dai St\u00e2ts Un\u00eets" },
            { "US", "St\u00e2ts Un\u00eets" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbechistan" },
            { "VA", "Vatican" },
            { "VC", "San Vincent e lis Grenadinis" },
            { "VE", "Venezuela" },
            { "VG", "Isulis vergjinis britanichis" },
            { "VI", "Isulis vergjinis americanis" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis e Futuna" },
            { "WS", "Samoa" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Sud Afriche" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Regjon no cognossude o no valide" },
            { "aa", "afar" },
            { "ab", "abcazian" },
            { "ae", "avestan" },
            { "af", "afrikaans" },
            { "am", "amaric" },
            { "an", "aragon\u00eas" },
            { "ar", metaValue_ar },
            { "as", "assam\u00eas" },
            { "av", "avar" },
            { "ay", "aymar\u00e0" },
            { "az", "azerbaijani" },
            { "be", "bielor\u00f9s" },
            { "bg", "bulgar" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "breton" },
            { "bs", "bosniac" },
            { "ca", "catalan" },
            { "ce", "cecen" },
            { "ch", "chamorro" },
            { "co", "cors" },
            { "cr", "cree" },
            { "cs", "cec" },
            { "cu", "scl\u00e2f de glesie" },
            { "cy", "gal\u00eas" },
            { "da", "dan\u00eas" },
            { "de", "todesc" },
            { "el", metaValue_el },
            { "en", "ingl\u00eas" },
            { "eo", "esperanto" },
            { "es", "spagn\u00fbl" },
            { "et", "eston" },
            { "eu", "basc" },
            { "fa", "persian" },
            { "ff", "fulah" },
            { "fi", "finland\u00eas" },
            { "fj", "fizian" },
            { "fo", "faro\u00eas" },
            { "fr", "franc\u00eas" },
            { "fy", "frisian" },
            { "ga", "gaelic irland\u00eas" },
            { "gd", "gaelic scoz\u00eas" },
            { "gl", "galizian" },
            { "gn", "guaran\u00ec" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "he", "ebraic" },
            { "hi", "hindi" },
            { "hr", "cravuat" },
            { "ht", "haitian" },
            { "hu", "ongjar\u00eas" },
            { "hy", metaValue_hy },
            { "id", "indonesian" },
            { "ig", "igbo" },
            { "ik", "inupiaq" },
            { "io", "ido" },
            { "is", "island\u00eas" },
            { "it", "talian" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "ka", "gjeorgjian" },
            { "kk", "kazac" },
            { "kl", "kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "ku", "curd" },
            { "kw", "cornuali\u00eas" },
            { "la", metaValue_la },
            { "lb", "lussemburgh\u00eas" },
            { "li", "limburgh\u00eas" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "lituan" },
            { "lv", "leton" },
            { "mg", "malagasy" },
            { "mi", "maori" },
            { "mk", "macedon" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "mal\u00eas" },
            { "mt", "malt\u00eas" },
            { "nb", "norvegj\u00eas bokm\u00e5l" },
            { "nd", "ndebele setentrion\u00e2l" },
            { "ne", "nepal\u00eas" },
            { "nl", "oland\u00eas" },
            { "nn", "norvegj\u00eas nynorsk" },
            { "no", "norvegj\u00eas" },
            { "nv", "navajo" },
            { "oc", "ocitan" },
            { "or", metaValue_or },
            { "os", "osetic" },
            { "pa", "punjabi" },
            { "pl", "polac" },
            { "ps", "pashto" },
            { "pt", "portugh\u00eas" },
            { "qu", "quechua" },
            { "rm", "ruman\u00e7" },
            { "ro", "romen" },
            { "ru", "rus" },
            { "sa", "sanscrit" },
            { "sc", "sardegn\u00fbl" },
            { "sd", "sindhi" },
            { "se", "sami setentrion\u00e2l" },
            { "sg", "sango" },
            { "si", "sinal\u00eas" },
            { "sk", "slovac" },
            { "sl", "sloven" },
            { "sm", "samoan" },
            { "so", "somal" },
            { "sq", "alban\u00eas" },
            { "sr", "serp" },
            { "ss", "swati" },
            { "st", "sotho meridion\u00e2l" },
            { "su", "sundan\u00eas" },
            { "sv", "sved\u00eas" },
            { "sw", "swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tagic" },
            { "th", metaValue_th },
            { "tk", "turcmen" },
            { "tl", metaValue_tl },
            { "tr", "turc" },
            { "tt", "tartar" },
            { "ty", "tahitian" },
            { "ug", "uigur" },
            { "uk", "ucrain" },
            { "ur", "urdu" },
            { "uz", "uzbec" },
            { "ve", "venda" },
            { "vi", "vietnamite" },
            { "wa", "valon" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "yiddish" },
            { "yo", "yoruba" },
            { "zh", "cin\u00eas" },
            { "zu", "zulu" },
            { "ang", "vieri ingl\u00eas" },
            { "arc", "aramaic" },
            { "ast", "asturian" },
            { "cop", "coptic" },
            { "den", "scl\u00e2f" },
            { "egy", "vieri egjizian" },
            { "fil", "filipin" },
            { "fro", "vieri franc\u00eas" },
            { "fur", "furlan" },
            { "got", metaValue_got },
            { "grc", "vieri gr\u00eac" },
            { "lad", "ladin" },
            { "mul", "lenghis multiplis" },
            { "mwl", "mirand\u00eas" },
            { "nap", "napoletan" },
            { "nds", "bas todesc" },
            { "non", "vieri norvegj\u00eas" },
            { "nso", "sotho setentrion\u00e2l" },
            { "ota", "turc otoman" },
            { "pap", "papiamento" },
            { "peo", metaValue_peo },
            { "pro", "vieri provenz\u00e2l" },
            { "scn", "sicilian" },
            { "sco", "scoz\u00eas" },
            { "sga", "vieri irland\u00eas" },
            { "sux", "sumeric" },
            { "tet", "tetum" },
            { "und", "indeterminade" },
            { "Arab", metaValue_ar },
            { "Armn", metaValue_hy },
            { "Bali", "balin\u00eas" },
            { "Beng", metaValue_bn },
            { "Brai", "Braille" },
            { "Bugi", "bugin\u00eas" },
            { "Cans", "Silabari unific\u00e2t aborigjens canad\u00eas" },
            { "Copt", "copt" },
            { "Cprt", "cipriot" },
            { "Cyrl", "cirilic" },
            { "Cyrs", "cirilic dal vieri slavonic de glesie" },
            { "Deva", "devanagari" },
            { "Egyd", "demotic egjizian" },
            { "Egyh", "jeratic egjizian" },
            { "Egyp", "jeroglifics egjizians" },
            { "Ethi", "etiopic" },
            { "Geor", "georgjian" },
            { "Glag", "glagolitic" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Hani", "han" },
            { "Hans", "Han semplific\u00e2t" },
            { "Hant", "Han tradizion\u00e2l" },
            { "Hebr", "ebreu" },
            { "Hrkt", "katakana o hiragana" },
            { "Hung", "vieri ongjar\u00eas" },
            { "Ital", "vieri italic" },
            { "Java", "gjavan\u00eas" },
            { "Jpan", metaValue_ja },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latf", "latin Fraktur" },
            { "Latg", "latin gaelic" },
            { "Latn", metaValue_la },
            { "Lina", "line\u00e2r A" },
            { "Linb", "line\u00e2r B" },
            { "Maya", "jeroglifics Maya" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mymr", "myanmar" },
            { "Orya", metaValue_or },
            { "Runr", "runic" },
            { "Sinh", "sinhala" },
            { "Syrc", "siriac" },
            { "Syre", "siriac Estrangelo" },
            { "Syrj", "siriac ocident\u00e2l" },
            { "Syrn", "siriac orient\u00e2l" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tglg", metaValue_tl },
            { "Thaa", "thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", "ugaritic" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "cuneiform sumeric-acadic" },
            { "Zxxx", "codi\u00e7 pes lenghis no scritis" },
            { "Zyyy", "comun" },
            { "Zzzz", "codi\u00e7 par scrituris no codificadis" },
            { "de_AT", "todesc de Austrie" },
            { "de_CH", "alt todesc de Svuizare" },
            { "en_AU", "ingl\u00eas australian" },
            { "en_CA", "ingl\u00eas canad\u00eas" },
            { "en_GB", "ingl\u00eas britanic" },
            { "en_US", "ingles merecan" },
            { "es_ES", "spagn\u00fbl iberic" },
            { "fr_CA", "franc\u00eas dal Canade" },
            { "fr_CH", "franc\u00eas de Svuizare" },
            { "nl_BE", "flamant" },
            { "pt_BR", "portugh\u00eas brasilian" },
            { "pt_PT", "portugh\u00eas iberic" },
            { "ro_MD", "mold\u00e2f" },
            { "%%1901", "Ortografie todescje tradizion\u00e2l" },
            { "%%1994", "Ortografie resiane standard" },
            { "%%1996", "Ortografie todescje dal 1996" },
            { "es_419", "spagn\u00fbl de Americhe Latine" },
            { "key.ca", "calendari" },
            { "key.co", "ordenament" },
            { "key.cu", "monede" },
            { "%%BISKE", "dialet di San Zor\u00e7 di Resie" },
            { "%%LIPAW", "dialet di Lipovaz dal resian" },
            { "%%NEDIS", "Dialet des valadis dal Nadison" },
            { "%%NJIVA", "dialet di Gnive" },
            { "%%OSOJS", "dialet di Oseac" },
            { "%%ROZAJ", "Resian" },
            { "%%SOLBA", "dialet di Stolvize" },
            { "zh_Hans", "cin\u00eas semplific\u00e2t" },
            { "zh_Hant", "cin\u00eas tradizion\u00e2l" },
            { "%%AREVELA", "armen orient\u00e2l" },
            { "%%AREVMDA", "armen ocident\u00e2l" },
            { "%%POLYTON", "Politoniche" },
            { "%%REVISED", "Ortografie revisade" },
            { "%%VALENCIA", "valenzian" },
            { "type.ca.roc", "calendari de Republiche di Cine" },
            { "type.nu.latn", "numars ocident\u00e2i" },
            { "type.co.ducet", "ordenament predetermin\u00e2t Unicode" },
            { "type.ca.hebrew", "calendari ebreu" },
            { "type.ca.indian", "calendari nazion\u00e2l indian" },
            { "type.co.pinyin", "ordin pinyin" },
            { "type.co.search", "ricercje par fins gjener\u00e2i" },
            { "type.co.stroke", "ordin segns" },
            { "type.ca.chinese", "calendari cin\u00eas" },
            { "type.co.big5han", "ordin cin\u00eas tradizion\u00e2l - Big5" },
            { "type.ca.buddhist", "calendari budist" },
            { "type.ca.japanese", "calendari gjapon\u00eas" },
            { "type.ca.gregorian", "calendari gregorian" },
            { "type.co.gb2312han", "ordin cin\u00eas semplific\u00e2t - GB2312" },
            { "type.co.phonebook", "ordin elenc telefonic" },
            { "type.co.traditional", "ordin tradizion\u00e2l" },
        };
        return data;
    }
}
