/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.runtime.load;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.BlockCanceler;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractLoadService<RESULT>
implements ILoadService<RESULT> {
    private String serviceName;
    private DBRProgressMonitor progressMonitor;
    private AbstractJob ownerJob;

    protected AbstractLoadService(String serviceName) {
        this.serviceName = serviceName;
    }

    protected AbstractLoadService() {
        this("Loading");
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    public void initService(DBRProgressMonitor monitor, AbstractJob ownerJob) {
        this.progressMonitor = monitor;
        this.ownerJob = ownerJob;
    }

    @Override
    public boolean cancel() throws InvocationTargetException {
        if (this.ownerJob != null) {
            return this.ownerJob.cancel();
        }
        if (this.progressMonitor != null) {
            try {
                List<DBRBlockingObject> activeBlocks = this.progressMonitor.getActiveBlocks();
                if (!CommonUtils.isEmpty(activeBlocks)) {
                    BlockCanceler.cancelBlock(this.progressMonitor, activeBlocks.get(activeBlocks.size() - 1));
                }
                Thread.currentThread().interrupt();
                return true;
            }
            catch (DBException e) {
                throw new InvocationTargetException(e);
            }
        }
        return false;
    }
}

