// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-global-network-manager-service/preview/2022-02-15/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// GetClusterAPIInfoReader is a Reader for the GetClusterAPIInfo structure.
type GetClusterAPIInfoReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetClusterAPIInfoReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetClusterAPIInfoOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetClusterAPIInfoDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetClusterAPIInfoOK creates a GetClusterAPIInfoOK with default headers values
func NewGetClusterAPIInfoOK() *GetClusterAPIInfoOK {
	return &GetClusterAPIInfoOK{}
}

/*
GetClusterAPIInfoOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetClusterAPIInfoOK struct {
	Payload *models.HashicorpCloudGlobalNetworkManager20220215GetClusterAPIInfoResponse
}

// IsSuccess returns true when this get cluster Api info o k response has a 2xx status code
func (o *GetClusterAPIInfoOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get cluster Api info o k response has a 3xx status code
func (o *GetClusterAPIInfoOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get cluster Api info o k response has a 4xx status code
func (o *GetClusterAPIInfoOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get cluster Api info o k response has a 5xx status code
func (o *GetClusterAPIInfoOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get cluster Api info o k response a status code equal to that given
func (o *GetClusterAPIInfoOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get cluster Api info o k response
func (o *GetClusterAPIInfoOK) Code() int {
	return 200
}

func (o *GetClusterAPIInfoOK) Error() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/api_information][%d] getClusterApiInfoOK  %+v", 200, o.Payload)
}

func (o *GetClusterAPIInfoOK) String() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/api_information][%d] getClusterApiInfoOK  %+v", 200, o.Payload)
}

func (o *GetClusterAPIInfoOK) GetPayload() *models.HashicorpCloudGlobalNetworkManager20220215GetClusterAPIInfoResponse {
	return o.Payload
}

func (o *GetClusterAPIInfoOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudGlobalNetworkManager20220215GetClusterAPIInfoResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetClusterAPIInfoDefault creates a GetClusterAPIInfoDefault with default headers values
func NewGetClusterAPIInfoDefault(code int) *GetClusterAPIInfoDefault {
	return &GetClusterAPIInfoDefault{
		_statusCode: code,
	}
}

/*
GetClusterAPIInfoDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetClusterAPIInfoDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this get cluster API info default response has a 2xx status code
func (o *GetClusterAPIInfoDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get cluster API info default response has a 3xx status code
func (o *GetClusterAPIInfoDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get cluster API info default response has a 4xx status code
func (o *GetClusterAPIInfoDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get cluster API info default response has a 5xx status code
func (o *GetClusterAPIInfoDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get cluster API info default response a status code equal to that given
func (o *GetClusterAPIInfoDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get cluster API info default response
func (o *GetClusterAPIInfoDefault) Code() int {
	return o._statusCode
}

func (o *GetClusterAPIInfoDefault) Error() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/api_information][%d] GetClusterAPIInfo default  %+v", o._statusCode, o.Payload)
}

func (o *GetClusterAPIInfoDefault) String() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/api_information][%d] GetClusterAPIInfo default  %+v", o._statusCode, o.Payload)
}

func (o *GetClusterAPIInfoDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *GetClusterAPIInfoDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
