// Copyright Louis Dionne 2013-2022
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE.md or copy at http://boost.org/LICENSE_1_0.txt)

#include <boost/hana/detail/variadic/foldl1.hpp>

#include <boost/hana/assert.hpp>
#include <boost/hana/equal.hpp>

#include <laws/base.hpp>
namespace hana = boost::hana;


struct undefined { };

template <int i>
using x = hana::test::ct_eq<i>;

int main() {
    using hana::detail::variadic::foldl1;
    hana::test::_injection<0> f{};

    BOOST_HANA_CONSTANT_CHECK(hana::equal(
        foldl1(undefined{}, x<1>{}),
        x<1>{}
    ));

    BOOST_HANA_CONSTANT_CHECK(hana::equal(
        foldl1(f, x<1>{}, x<2>{}),
        f(x<1>{}, x<2>{})
    ));

    BOOST_HANA_CONSTANT_CHECK(hana::equal(
        foldl1(f, x<1>{}, x<2>{}, x<3>{}),
        f(f(x<1>{}, x<2>{}), x<3>{})
    ));

    BOOST_HANA_CONSTANT_CHECK(hana::equal(
        foldl1(f, x<1>{}, x<2>{}, x<3>{}, x<4>{}),
        f(f(f(x<1>{}, x<2>{}), x<3>{}), x<4>{})
    ));

    BOOST_HANA_CONSTANT_CHECK(hana::equal(
        foldl1(f, x<1>{}, x<2>{}, x<3>{}, x<4>{}, x<5>{}),
        f(f(f(f(x<1>{}, x<2>{}), x<3>{}), x<4>{}), x<5>{})
    ));

    BOOST_HANA_CONSTANT_CHECK(hana::equal(
        foldl1(f, x<1>{}, x<2>{}, x<3>{}, x<4>{}, x<5>{}, x<6>{}),
        f(f(f(f(f(x<1>{}, x<2>{}), x<3>{}), x<4>{}), x<5>{}), x<6>{})
    ));

    BOOST_HANA_CONSTANT_CHECK(hana::equal(
        foldl1(f, x<1>{}, x<2>{}, x<3>{}, x<4>{}, x<5>{}, x<6>{}, x<7>{}),
        f(f(f(f(f(f(x<1>{}, x<2>{}), x<3>{}), x<4>{}), x<5>{}), x<6>{}), x<7>{})
    ));

    BOOST_HANA_CONSTANT_CHECK(hana::equal(
        foldl1(f, x<1>{}, x<2>{}, x<3>{}, x<4>{}, x<5>{}, x<6>{}, x<7>{}, x<8>{}),
        f(f(f(f(f(f(f(x<1>{}, x<2>{}), x<3>{}), x<4>{}), x<5>{}), x<6>{}), x<7>{}), x<8>{})
    ));

    BOOST_HANA_CONSTANT_CHECK(hana::equal(
        foldl1(f, x<1>{},  x<2>{},  x<3>{},  x<4>{},  x<5>{},  x<6>{},  x<7>{},
                  x<8>{},  x<9>{}
        ),
        f(f(f(f(f(f(f(f(
            x<1>{},   x<2>{}),  x<3>{}),  x<4>{}),  x<5>{}),  x<6>{}),  x<7>{}),
            x<8>{}),  x<9>{})
    ));


    BOOST_HANA_CONSTANT_CHECK(hana::equal(
        foldl1(f, x<1>{},  x<2>{},  x<3>{},  x<4>{},  x<5>{},  x<6>{},  x<7>{},
                  x<8>{},  x<9>{},  x<10>{}, x<11>{}, x<12>{}, x<13>{}
        ),
        f(f(f(f(f(f(f(f(f(f(f(f(
            x<1>{},   x<2>{}),  x<3>{}),  x<4>{}),  x<5>{}),  x<6>{}),  x<7>{}),
            x<8>{}),  x<9>{}),  x<10>{}), x<11>{}), x<12>{}), x<13>{})
    ));

    BOOST_HANA_CONSTANT_CHECK(hana::equal(
        foldl1(f, x<1>{},  x<2>{},  x<3>{},  x<4>{},  x<5>{},  x<6>{},  x<7>{},
                  x<8>{},  x<9>{},  x<10>{}, x<11>{}, x<12>{}, x<13>{}, x<14>{}
        ),
        f(f(f(f(f(f(f(f(f(f(f(f(f(
            x<1>{},   x<2>{}),  x<3>{}),  x<4>{}),  x<5>{}),  x<6>{}),  x<7>{}),
            x<8>{}),  x<9>{}),  x<10>{}), x<11>{}), x<12>{}), x<13>{}), x<14>{})
    ));

    BOOST_HANA_CONSTANT_CHECK(hana::equal(
        foldl1(f, x<1>{},  x<2>{},  x<3>{},  x<4>{},  x<5>{},  x<6>{},  x<7>{},
                  x<8>{},  x<9>{},  x<10>{}, x<11>{}, x<12>{}, x<13>{}, x<14>{},
                  x<15>{}
        ),
        f(f(f(f(f(f(f(f(f(f(f(f(f(f(
            x<1>{},   x<2>{}),  x<3>{}),  x<4>{}),  x<5>{}),  x<6>{}),  x<7>{}),
            x<8>{}),  x<9>{}),  x<10>{}), x<11>{}), x<12>{}), x<13>{}), x<14>{}),
            x<15>{})
    ));


    BOOST_HANA_CONSTANT_CHECK(hana::equal(
        foldl1(f, x<1>{},  x<2>{},  x<3>{},  x<4>{},  x<5>{},  x<6>{},  x<7>{},
                  x<8>{},  x<9>{},  x<10>{}, x<11>{}, x<12>{}, x<13>{}, x<14>{},
                  x<15>{}, x<16>{}, x<17>{}, x<18>{}, x<19>{}, x<20>{}, x<21>{},
                  x<22>{}, x<23>{}, x<24>{}, x<25>{}, x<26>{}, x<27>{}
        ),
        f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(
            x<1>{},   x<2>{}),  x<3>{}),  x<4>{}),  x<5>{}),  x<6>{}),  x<7>{}),
            x<8>{}),  x<9>{}),  x<10>{}), x<11>{}), x<12>{}), x<13>{}), x<14>{}),
            x<15>{}), x<16>{}), x<17>{}), x<18>{}), x<19>{}), x<20>{}), x<21>{}),
            x<22>{}), x<23>{}), x<24>{}), x<25>{}), x<26>{}), x<27>{})
    ));

    BOOST_HANA_CONSTANT_CHECK(hana::equal(
        foldl1(f, x<1>{},  x<2>{},  x<3>{},  x<4>{},  x<5>{},  x<6>{},  x<7>{},
                  x<8>{},  x<9>{},  x<10>{}, x<11>{}, x<12>{}, x<13>{}, x<14>{},
                  x<15>{}, x<16>{}, x<17>{}, x<18>{}, x<19>{}, x<20>{}, x<21>{},
                  x<22>{}, x<23>{}, x<24>{}, x<25>{}, x<26>{}, x<27>{}, x<28>{}
        ),
        f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(
            x<1>{},   x<2>{}),  x<3>{}),  x<4>{}),  x<5>{}),  x<6>{}),  x<7>{}),
            x<8>{}),  x<9>{}),  x<10>{}), x<11>{}), x<12>{}), x<13>{}), x<14>{}),
            x<15>{}), x<16>{}), x<17>{}), x<18>{}), x<19>{}), x<20>{}), x<21>{}),
            x<22>{}), x<23>{}), x<24>{}), x<25>{}), x<26>{}), x<27>{}), x<28>{})
    ));

    BOOST_HANA_CONSTANT_CHECK(hana::equal(
        foldl1(f, x<1>{},  x<2>{},  x<3>{},  x<4>{},  x<5>{},  x<6>{},  x<7>{},
                  x<8>{},  x<9>{},  x<10>{}, x<11>{}, x<12>{}, x<13>{}, x<14>{},
                  x<15>{}, x<16>{}, x<17>{}, x<18>{}, x<19>{}, x<20>{}, x<21>{},
                  x<22>{}, x<23>{}, x<24>{}, x<25>{}, x<26>{}, x<27>{}, x<28>{},
                  x<29>{}
        ),
        f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(
            x<1>{},   x<2>{}),  x<3>{}),  x<4>{}),  x<5>{}),  x<6>{}),  x<7>{}),
            x<8>{}),  x<9>{}),  x<10>{}), x<11>{}), x<12>{}), x<13>{}), x<14>{}),
            x<15>{}), x<16>{}), x<17>{}), x<18>{}), x<19>{}), x<20>{}), x<21>{}),
            x<22>{}), x<23>{}), x<24>{}), x<25>{}), x<26>{}), x<27>{}), x<28>{}),
            x<29>{})
    ));


    BOOST_HANA_CONSTANT_CHECK(hana::equal(
        foldl1(f, x<1>{},  x<2>{},  x<3>{},  x<4>{},  x<5>{},  x<6>{},  x<7>{},
                  x<8>{},  x<9>{},  x<10>{}, x<11>{}, x<12>{}, x<13>{}, x<14>{},
                  x<15>{}, x<16>{}, x<17>{}, x<18>{}, x<19>{}, x<20>{}, x<21>{},
                  x<22>{}, x<23>{}, x<24>{}, x<25>{}, x<26>{}, x<27>{}, x<28>{},
                  x<29>{}, x<30>{}, x<31>{}, x<32>{}, x<33>{}, x<34>{}, x<35>{},
                  x<36>{}, x<37>{}, x<38>{}, x<39>{}, x<40>{}, x<41>{}, x<42>{},
                  x<43>{}, x<44>{}, x<45>{}, x<46>{}, x<47>{}, x<48>{}, x<49>{},
                  x<50>{}, x<51>{}, x<52>{}, x<53>{}, x<54>{}, x<55>{}
        ),
        f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(
        f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(
            x<1>{},   x<2>{}),  x<3>{}),  x<4>{}),  x<5>{}),  x<6>{}),  x<7>{}),
            x<8>{}),  x<9>{}),  x<10>{}), x<11>{}), x<12>{}), x<13>{}), x<14>{}),
            x<15>{}), x<16>{}), x<17>{}), x<18>{}), x<19>{}), x<20>{}), x<21>{}),
            x<22>{}), x<23>{}), x<24>{}), x<25>{}), x<26>{}), x<27>{}), x<28>{}),
            x<29>{}), x<30>{}), x<31>{}), x<32>{}), x<33>{}), x<34>{}), x<35>{}),
            x<36>{}), x<37>{}), x<38>{}), x<39>{}), x<40>{}), x<41>{}), x<42>{}),
            x<43>{}), x<44>{}), x<45>{}), x<46>{}), x<47>{}), x<48>{}), x<49>{}),
            x<50>{}), x<51>{}), x<52>{}), x<53>{}), x<54>{}), x<55>{})
    ));

    BOOST_HANA_CONSTANT_CHECK(hana::equal(
        foldl1(f, x<1>{},  x<2>{},  x<3>{},  x<4>{},  x<5>{},  x<6>{},  x<7>{},
                  x<8>{},  x<9>{},  x<10>{}, x<11>{}, x<12>{}, x<13>{}, x<14>{},
                  x<15>{}, x<16>{}, x<17>{}, x<18>{}, x<19>{}, x<20>{}, x<21>{},
                  x<22>{}, x<23>{}, x<24>{}, x<25>{}, x<26>{}, x<27>{}, x<28>{},
                  x<29>{}, x<30>{}, x<31>{}, x<32>{}, x<33>{}, x<34>{}, x<35>{},
                  x<36>{}, x<37>{}, x<38>{}, x<39>{}, x<40>{}, x<41>{}, x<42>{},
                  x<43>{}, x<44>{}, x<45>{}, x<46>{}, x<47>{}, x<48>{}, x<49>{},
                  x<50>{}, x<51>{}, x<52>{}, x<53>{}, x<54>{}, x<55>{}, x<56>{}
        ),
        f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(
        f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(
            x<1>{},   x<2>{}),  x<3>{}),  x<4>{}),  x<5>{}),  x<6>{}),  x<7>{}),
            x<8>{}),  x<9>{}),  x<10>{}), x<11>{}), x<12>{}), x<13>{}), x<14>{}),
            x<15>{}), x<16>{}), x<17>{}), x<18>{}), x<19>{}), x<20>{}), x<21>{}),
            x<22>{}), x<23>{}), x<24>{}), x<25>{}), x<26>{}), x<27>{}), x<28>{}),
            x<29>{}), x<30>{}), x<31>{}), x<32>{}), x<33>{}), x<34>{}), x<35>{}),
            x<36>{}), x<37>{}), x<38>{}), x<39>{}), x<40>{}), x<41>{}), x<42>{}),
            x<43>{}), x<44>{}), x<45>{}), x<46>{}), x<47>{}), x<48>{}), x<49>{}),
            x<50>{}), x<51>{}), x<52>{}), x<53>{}), x<54>{}), x<55>{}), x<56>{})
    ));

    BOOST_HANA_CONSTANT_CHECK(hana::equal(
        foldl1(f, x<1>{},  x<2>{},  x<3>{},  x<4>{},  x<5>{},  x<6>{},  x<7>{},
                  x<8>{},  x<9>{},  x<10>{}, x<11>{}, x<12>{}, x<13>{}, x<14>{},
                  x<15>{}, x<16>{}, x<17>{}, x<18>{}, x<19>{}, x<20>{}, x<21>{},
                  x<22>{}, x<23>{}, x<24>{}, x<25>{}, x<26>{}, x<27>{}, x<28>{},
                  x<29>{}, x<30>{}, x<31>{}, x<32>{}, x<33>{}, x<34>{}, x<35>{},
                  x<36>{}, x<37>{}, x<38>{}, x<39>{}, x<40>{}, x<41>{}, x<42>{},
                  x<43>{}, x<44>{}, x<45>{}, x<46>{}, x<47>{}, x<48>{}, x<49>{},
                  x<50>{}, x<51>{}, x<52>{}, x<53>{}, x<54>{}, x<55>{}, x<56>{},
                  x<57>{}
        ),
        f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(
        f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(f(
            x<1>{},   x<2>{}),  x<3>{}),  x<4>{}),  x<5>{}),  x<6>{}),  x<7>{}),
            x<8>{}),  x<9>{}),  x<10>{}), x<11>{}), x<12>{}), x<13>{}), x<14>{}),
            x<15>{}), x<16>{}), x<17>{}), x<18>{}), x<19>{}), x<20>{}), x<21>{}),
            x<22>{}), x<23>{}), x<24>{}), x<25>{}), x<26>{}), x<27>{}), x<28>{}),
            x<29>{}), x<30>{}), x<31>{}), x<32>{}), x<33>{}), x<34>{}), x<35>{}),
            x<36>{}), x<37>{}), x<38>{}), x<39>{}), x<40>{}), x<41>{}), x<42>{}),
            x<43>{}), x<44>{}), x<45>{}), x<46>{}), x<47>{}), x<48>{}), x<49>{}),
            x<50>{}), x<51>{}), x<52>{}), x<53>{}), x<54>{}), x<55>{}), x<56>{}),
            x<57>{})
    ));
}
