/*========================== begin_copyright_notice ============================

Copyright (C) 2021-2025 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ===========================*/

/*
@file ml_state.h

@brief Stores library state.
*/

#pragma once

namespace ML
{
    //////////////////////////////////////////////////////////////////////////
    /// @brief Base type for ExampleTrait object.
    //////////////////////////////////////////////////////////////////////////
    template <typename T>
    struct StateTrait
    {
        ML_DELETE_DEFAULT_COPY_AND_MOVE( StateTrait );

        //////////////////////////////////////////////////////////////////////////
        /// @brief Query information struct.
        //////////////////////////////////////////////////////////////////////////
        struct Query
        {
            std::atomic_uint m_ReportId;

            //////////////////////////////////////////////////////////////////////////
            /// @brief Query information struct constructor.
            //////////////////////////////////////////////////////////////////////////
            Query()
                : m_ReportId( 0 )
            {
            }
        };

        //////////////////////////////////////////////////////////////////////////
        /// @brief Members.
        //////////////////////////////////////////////////////////////////////////
        Query m_Query;

        //////////////////////////////////////////////////////////////////////////
        /// @brief StateTrait constructor.
        //////////////////////////////////////////////////////////////////////////
        StateTrait()
            : m_Query{}
        {
        }
    };
} // namespace ML
