/*
===========================================================================
Copyright (C) 1999-2005 Id Software, Inc.

This file is part of Quake III Arena source code.

Quake III Arena source code is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the License,
or (at your option) any later version.

Quake III Arena source code is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Quake III Arena source code; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
===========================================================================
*/

/*****************************************************************************
 * name:		be_aas_main.h
 *
 * desc:		AAS
 *
 * $Archive: /source/code/botlib/be_aas_main.h $
 *
 *****************************************************************************/

#ifdef AASINTERN

extern aas_t aasworld;

// AAS error message
void QDECL AAS_Error(char *fmt, ...) __attribute__((format(printf, 1, 2)));
// set AAS initialized
void AAS_SetInitialized(void);
// setup AAS with the given number of entities and clients
int AAS_Setup(void);
// shutdown AAS
void AAS_Shutdown(void);
// start a new map
int AAS_LoadMap(const char *mapname);
// start a new time frame
int AAS_StartFrame(float time);
#endif // AASINTERN

// returns true if AAS is initialized
int AAS_Initialized(void);
// returns true if the AAS file is loaded
int AAS_Loaded(void);
// returns the current time
float AAS_Time(void);

void AAS_ProjectPointOntoVector(vec3_t point, vec3_t vStart, vec3_t vEnd, vec3_t vProj);
