/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.deprecation;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.VersionRequirement;
import org.jetbrains.kotlin.resolve.annotations.UtilsKt;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByAnnotation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByOverridden;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByVersionRequirement;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedTypealiasByAnnotation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;
import org.jetbrains.kotlin.resolve.deprecation.DescriptorBasedDeprecationInfo;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0005\u001a*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0000\u00a8\u0006\u0015"}, d2={"deprecatedByOverriddenMessage", "", "Lorg/jetbrains/kotlin/resolve/deprecation/DescriptorBasedDeprecationInfo;", "deprecatedByAnnotationReplaceWithExpression", "getSinceVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "name", "computeLevelForDeprecatedSinceKotlin", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;", "annotation", "apiVersion", "createDeprecationDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "element", "Lcom/intellij/psi/PsiElement;", "deprecation", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "forceWarningForSimpleDeprecation", "", "frontend"})
@SourceDebugExtension(value={"SMAP\ndeprecationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 deprecationUtil.kt\norg/jetbrains/kotlin/resolve/deprecation/DeprecationUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public final class DeprecationUtilKt {
    @Nullable
    public static final String deprecatedByOverriddenMessage(@NotNull DescriptorBasedDeprecationInfo $this$deprecatedByOverriddenMessage) {
        Intrinsics.checkNotNullParameter($this$deprecatedByOverriddenMessage, "<this>");
        DeprecatedByOverridden deprecatedByOverridden = $this$deprecatedByOverriddenMessage instanceof DeprecatedByOverridden ? (DeprecatedByOverridden)$this$deprecatedByOverriddenMessage : null;
        return deprecatedByOverridden != null ? deprecatedByOverridden.additionalMessage$frontend() : null;
    }

    @Nullable
    public static final String deprecatedByAnnotationReplaceWithExpression(@NotNull DescriptorBasedDeprecationInfo $this$deprecatedByAnnotationReplaceWithExpression) {
        Intrinsics.checkNotNullParameter($this$deprecatedByAnnotationReplaceWithExpression, "<this>");
        DeprecatedByAnnotation deprecatedByAnnotation = $this$deprecatedByAnnotationReplaceWithExpression instanceof DeprecatedByAnnotation ? (DeprecatedByAnnotation)$this$deprecatedByAnnotationReplaceWithExpression : null;
        return deprecatedByAnnotation != null ? deprecatedByAnnotation.getReplaceWithValue$frontend() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final ApiVersion getSinceVersion(@NotNull AnnotationDescriptor $this$getSinceVersion, @NotNull String name2) {
        Object object;
        Intrinsics.checkNotNullParameter($this$getSinceVersion, "<this>");
        Intrinsics.checkNotNullParameter(name2, "name");
        ConstantValue<?> constantValue = UtilsKt.argumentValue($this$getSinceVersion, name2);
        if (!(constantValue instanceof StringValue)) return null;
        StringValue stringValue = (StringValue)constantValue;
        Object object2 = stringValue;
        if (stringValue == null) return null;
        String string = (String)((ConstantValue)object2).getValue();
        object2 = string;
        if (string == null) return null;
        Object p0 = object = object2;
        boolean bl = false;
        if (((CharSequence)p0).length() == 0) {
            return null;
        }
        boolean bl2 = false;
        if (bl2) return null;
        Object object3 = object;
        object2 = object3;
        if (object3 == null) return null;
        object = object2;
        ApiVersion.Companion companion = ApiVersion.Companion;
        Object p02 = object;
        boolean bl3 = false;
        ApiVersion apiVersion = companion.parse((String)p02);
        return apiVersion;
    }

    @Nullable
    public static final DeprecationLevelValue computeLevelForDeprecatedSinceKotlin(@NotNull AnnotationDescriptor annotation, @NotNull ApiVersion apiVersion) {
        Intrinsics.checkNotNullParameter(annotation, "annotation");
        Intrinsics.checkNotNullParameter(apiVersion, "apiVersion");
        ApiVersion hiddenSince = DeprecationUtilKt.getSinceVersion(annotation, "hiddenSince");
        if (hiddenSince != null && apiVersion.compareTo(hiddenSince) >= 0) {
            return DeprecationLevelValue.HIDDEN;
        }
        ApiVersion errorSince = DeprecationUtilKt.getSinceVersion(annotation, "errorSince");
        if (errorSince != null && apiVersion.compareTo(errorSince) >= 0) {
            return DeprecationLevelValue.ERROR;
        }
        ApiVersion warningSince = DeprecationUtilKt.getSinceVersion(annotation, "warningSince");
        if (warningSince != null && apiVersion.compareTo(warningSince) >= 0) {
            return DeprecationLevelValue.WARNING;
        }
        return null;
    }

    @NotNull
    public static final Diagnostic createDeprecationDiagnostic(@NotNull PsiElement element, @NotNull DescriptorBasedDeprecationInfo deprecation, @NotNull LanguageVersionSettings languageVersionSettings, boolean forceWarningForSimpleDeprecation) {
        Diagnostic diagnostic;
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(deprecation, "deprecation");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        DeclarationDescriptor declarationDescriptor = deprecation.getTarget().getOriginal();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getOriginal(...)");
        DeclarationDescriptor targetOriginal = declarationDescriptor;
        DescriptorBasedDeprecationInfo descriptorBasedDeprecationInfo = deprecation;
        if (descriptorBasedDeprecationInfo instanceof DeprecatedByVersionRequirement) {
            String string;
            DiagnosticFactory3<PsiElement, DeclarationDescriptor, VersionRequirement.Version, Pair<String, String>> diagnosticFactory3;
            switch (WhenMappings.$EnumSwitchMapping$0[((DeprecatedByVersionRequirement)deprecation).getDeprecationLevel().ordinal()]) {
                case 1: {
                    diagnosticFactory3 = Errors.VERSION_REQUIREMENT_DEPRECATION;
                    break;
                }
                case 2: 
                case 3: {
                    diagnosticFactory3 = Errors.VERSION_REQUIREMENT_DEPRECATION_ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DiagnosticFactory3<PsiElement, DeclarationDescriptor, VersionRequirement.Version, Pair<String, String>> factory = diagnosticFactory3;
            switch (WhenMappings.$EnumSwitchMapping$1[((DeprecatedByVersionRequirement)deprecation).getVersionRequirement().getKind().ordinal()]) {
                case 1: {
                    string = KotlinCompilerVersion.VERSION;
                    break;
                }
                case 2: {
                    string = languageVersionSettings.getLanguageVersion().getVersionString();
                    break;
                }
                case 3: {
                    string = languageVersionSettings.getApiVersion().getVersionString();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String currentVersionString = string;
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = factory.on(element, targetOriginal, ((DeprecatedByVersionRequirement)deprecation).getVersionRequirement().getVersion(), TuplesKt.to(currentVersionString, ((DeprecatedByVersionRequirement)deprecation).getMessage()));
            Intrinsics.checkNotNull(parametrizedDiagnostic);
            diagnostic = parametrizedDiagnostic;
        } else if (descriptorBasedDeprecationInfo instanceof DeprecatedTypealiasByAnnotation) {
            DiagnosticFactory3<PsiElement, TypeAliasDescriptor, DeclarationDescriptor, String> diagnosticFactory3;
            switch (WhenMappings.$EnumSwitchMapping$0[((DeprecatedTypealiasByAnnotation)deprecation).getDeprecationLevel().ordinal()]) {
                case 1: {
                    diagnosticFactory3 = Errors.TYPEALIAS_EXPANSION_DEPRECATION;
                    break;
                }
                case 2: 
                case 3: {
                    diagnosticFactory3 = Errors.TYPEALIAS_EXPANSION_DEPRECATION_ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DiagnosticFactory3<PsiElement, TypeAliasDescriptor, DeclarationDescriptor, String> factory = diagnosticFactory3;
            TypeAliasDescriptor typeAliasDescriptor = ((DeprecatedTypealiasByAnnotation)deprecation).getTypeAliasTarget().getOriginal();
            DeclarationDescriptor declarationDescriptor2 = ((DeprecatedTypealiasByAnnotation)deprecation).getNested().getTarget().getOriginal();
            String string = ((DeprecatedTypealiasByAnnotation)deprecation).getNested().getMessage();
            if (string == null) {
                string = "";
            }
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = factory.on(element, typeAliasDescriptor, declarationDescriptor2, string);
            Intrinsics.checkNotNull(parametrizedDiagnostic);
            diagnostic = parametrizedDiagnostic;
        } else {
            DiagnosticFactory2<PsiElement, DeclarationDescriptor, String> diagnosticFactory2;
            if (forceWarningForSimpleDeprecation) {
                diagnosticFactory2 = Errors.DEPRECATION;
            } else {
                switch (WhenMappings.$EnumSwitchMapping$0[deprecation.getDeprecationLevel().ordinal()]) {
                    case 1: {
                        diagnosticFactory2 = Errors.DEPRECATION;
                        break;
                    }
                    case 2: 
                    case 3: {
                        diagnosticFactory2 = Errors.DEPRECATION_ERROR;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            DiagnosticFactory2<PsiElement, DeclarationDescriptor, String> factory = diagnosticFactory2;
            String string = deprecation.getMessage();
            if (string == null) {
                string = "";
            }
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = factory.on(element, targetOriginal, string);
            Intrinsics.checkNotNull(parametrizedDiagnostic);
            diagnostic = parametrizedDiagnostic;
        }
        return diagnostic;
    }

    public static /* synthetic */ Diagnostic createDeprecationDiagnostic$default(PsiElement psiElement, DescriptorBasedDeprecationInfo descriptorBasedDeprecationInfo, LanguageVersionSettings languageVersionSettings, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        return DeprecationUtilKt.createDeprecationDiagnostic(psiElement, descriptorBasedDeprecationInfo, languageVersionSettings, bl);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DeprecationLevelValue.values().length];
            try {
                nArray[DeprecationLevelValue.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeprecationLevelValue.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeprecationLevelValue.HIDDEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProtoBuf.VersionRequirement.VersionKind.values().length];
            try {
                nArray[ProtoBuf.VersionRequirement.VersionKind.COMPILER_VERSION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.VersionRequirement.VersionKind.LANGUAGE_VERSION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.VersionRequirement.VersionKind.API_VERSION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

