/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.cfa.FirPropertyInitializationAnalyzerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirControlFlowGraphOwner;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirBackingFieldReference;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedErrorReference;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCandidate;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImplKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeDiagnosticWithCandidates;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeVisibilityError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFileSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.CallableId;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u0013\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u0014\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u0015\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\f\u0010\u0016\u001a\u00020\u0010*\u00020\u0011H\u0002J-\u0010\u0017\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ!\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001bJ+\u0010\u001c\u001a\u00020\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001fR\u0018\u0010\u000f\u001a\u00020\u0010*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0012\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReassignmentAndInvisibleSetterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirVariableAssignmentChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;)V", "checkInvisibleSetter", "isVisibilityError", "", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "(Lorg/jetbrains/kotlin/fir/references/FirReference;)Z", "checkValReassignmentViaBackingField", "checkValReassignmentOnValueParameterOrEnumEntry", "checkVariableExpected", "isConflictingError", "checkValReassignment", "isInFileGraph", "property", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Z", "isInOwnersInitializer", "receiver", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Z", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirReassignmentAndInvisibleSetterChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirReassignmentAndInvisibleSetterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReassignmentAndInvisibleSetterChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n+ 7 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n*L\n1#1,200:1\n18#2:201\n98#3,5:202\n1761#4,3:207\n756#4,10:210\n1563#4:220\n1634#4,3:221\n2851#4,5:224\n2857#4:230\n360#4,7:231\n1#5:229\n162#6:238\n119#6,4:239\n100#6:243\n88#6:244\n94#6:246\n123#6,2:247\n53#7:245\n*S KotlinDebug\n*F\n+ 1 FirReassignmentAndInvisibleSetterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReassignmentAndInvisibleSetterChecker\n*L\n69#1:201\n85#1:202,5\n124#1:207,3\n150#1:210,10\n158#1:220\n158#1:221,3\n162#1:224,5\n162#1:230\n176#1:231,7\n49#1:238\n49#1:239,4\n49#1:243\n49#1:244\n49#1:246\n49#1:247,2\n49#1:245\n*E\n"})
public final class FirReassignmentAndInvisibleSetterChecker
extends FirExpressionChecker<FirVariableAssignment> {
    @NotNull
    public static final FirReassignmentAndInvisibleSetterChecker INSTANCE = new FirReassignmentAndInvisibleSetterChecker();

    private FirReassignmentAndInvisibleSetterChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirVariableAssignment expression2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.checkInvisibleSetter(context2, reporter, expression2);
        this.checkValReassignmentViaBackingField(context2, reporter, expression2);
        this.checkValReassignmentOnValueParameterOrEnumEntry(context2, reporter, expression2);
        this.checkVariableExpected(context2, reporter, expression2);
        this.checkValReassignment(context2, reporter, expression2);
    }

    private final void checkInvisibleSetter(CheckerContext context2, DiagnosticReporter reporter, FirVariableAssignment expression2) {
        block4: {
            Object object;
            KtDiagnosticFactory3<FirPropertySymbol, Visibility, CallableId> ktDiagnosticFactory3;
            AbstractKtSourceElement abstractKtSourceElement;
            DiagnosticContext diagnosticContext2;
            FirCallableSymbol callableSymbol;
            block6: {
                block5: {
                    FirReference firReference = ReferenceUtilsKt.getCalleeReference(expression2);
                    boolean bl = firReference != null ? this.isVisibilityError(firReference) : false;
                    if (bl) {
                        return;
                    }
                    FirReference firReference2 = ReferenceUtilsKt.getCalleeReference(expression2);
                    FirCallableSymbol firCallableSymbol = callableSymbol = firReference2 != null ? FirReferenceUtilsKt.toResolvedCallableSymbol$default(firReference2, false, 1, null) : null;
                    if (!(callableSymbol instanceof FirPropertySymbol) || !FirReassignmentAndInvisibleSetterChecker.checkInvisibleSetter$shouldInvisibleSetterBeReported(context2, expression2, (FirPropertySymbol)callableSymbol)) break block4;
                    diagnosticContext2 = context2;
                    abstractKtSourceElement = expression2.getLValue().getSource();
                    ktDiagnosticFactory3 = FirErrors.INSTANCE.getINVISIBLE_SETTER();
                    object = ((FirPropertySymbol)callableSymbol).getSetterSymbol();
                    if (object == null) break block5;
                    FirCallableSymbol $this$visibility$iv = (FirCallableSymbol)object;
                    boolean $i$f$getVisibility = false;
                    object = $this$visibility$iv.getResolvedStatus().getVisibility();
                    if (object != null) break block6;
                }
                object = Visibilities.Private.INSTANCE;
            }
            CallableId callableId = ((FirPropertySymbol)callableSymbol).getCallableId();
            Intrinsics.checkNotNull(callableId);
            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext2, reporter, abstractKtSourceElement, ktDiagnosticFactory3, (Object)callableSymbol, object, (Object)callableId, null, 64, null);
        }
    }

    private final boolean isVisibilityError(FirReference $this$isVisibilityError) {
        return $this$isVisibilityError instanceof FirResolvedErrorReference && ((FirResolvedErrorReference)$this$isVisibilityError).getDiagnostic() instanceof ConeVisibilityError;
    }

    private final void checkValReassignmentViaBackingField(CheckerContext context2, DiagnosticReporter reporter, FirVariableAssignment expression2) {
        FirBasedSymbol firBasedSymbol;
        FirBackingFieldSymbol propertySymbol;
        FirBackingFieldReference backingFieldReference;
        block7: {
            FirReference firReference = ReferenceUtilsKt.getCalleeReference(expression2);
            FirBackingFieldReference firBackingFieldReference = firReference instanceof FirBackingFieldReference ? (FirBackingFieldReference)firReference : null;
            if (firBackingFieldReference == null) {
                return;
            }
            backingFieldReference = firBackingFieldReference;
            propertySymbol = backingFieldReference.getResolvedSymbol();
            if (propertySymbol.isVar()) {
                return;
            }
            CheckerContext $this$findClosest$iv = context2;
            boolean $i$f$findClosest = false;
            for (FirBasedSymbol<?> it$iv : CollectionsKt.asReversed($this$findClosest$iv.getContainingDeclarations())) {
                FirBasedSymbol<?> firBasedSymbol2 = it$iv;
                if (!(firBasedSymbol2 instanceof FirPropertyAccessorSymbol)) {
                    firBasedSymbol2 = null;
                }
                if ((firBasedSymbol = (FirBasedSymbol)((FirPropertyAccessorSymbol)firBasedSymbol2)) == null) continue;
                FirBasedSymbol firBasedSymbol3 = firBasedSymbol;
                FirPropertyAccessorSymbol it = (FirPropertyAccessorSymbol)firBasedSymbol3;
                boolean bl = false;
                firBasedSymbol = it.isGetter() ? firBasedSymbol3 : null;
                if (firBasedSymbol == null) {
                    continue;
                }
                break block7;
            }
            firBasedSymbol = null;
        }
        FirPropertyAccessorSymbol firPropertyAccessorSymbol = (FirPropertyAccessorSymbol)firBasedSymbol;
        if (firPropertyAccessorSymbol == null) {
            return;
        }
        FirPropertyAccessorSymbol closestGetter = firPropertyAccessorSymbol;
        if (!Intrinsics.areEqual(propertySymbol.getGetterSymbol(), closestGetter)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)backingFieldReference.getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT_VIA_BACKING_FIELD_ERROR(), (Object)propertySymbol, null, 16, null);
    }

    private final void checkValReassignmentOnValueParameterOrEnumEntry(CheckerContext context2, DiagnosticReporter reporter, FirVariableAssignment expression2) {
        FirVariableSymbol symbol;
        FirReference firReference = ReferenceUtilsKt.getCalleeReference(expression2);
        FirVariableSymbol firVariableSymbol = symbol = firReference != null ? FirReferenceUtilsKt.toResolvedVariableSymbol$default(firReference, false, 1, null) : null;
        if (symbol instanceof FirValueParameterSymbol || symbol instanceof FirEnumEntrySymbol) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getLValue().getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT(), (Object)symbol, null, 16, null);
        }
    }

    private final void checkVariableExpected(CheckerContext context2, DiagnosticReporter reporter, FirVariableAssignment expression2) {
        block4: {
            block3: {
                FirReference calleeReference = ReferenceUtilsKt.getCalleeReference(expression2);
                if (!(FirExpressionUtilKt.unwrapLValue(expression2) instanceof FirPropertyAccessExpression)) break block3;
                FirReference firReference = calleeReference;
                if (firReference != null ? this.isConflictingError(firReference) : false) break block4;
                FirReference firReference2 = calleeReference;
                if ((firReference2 != null ? FirReferenceUtilsKt.toResolvedVariableSymbol$default(firReference2, false, 1, null) : null) != null) break block4;
            }
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getLValue().getSource(), FirErrors.INSTANCE.getVARIABLE_EXPECTED(), null, 8, null);
        }
    }

    private final boolean isConflictingError(FirReference $this$isConflictingError) {
        boolean bl;
        block10: {
            if (!FirReferenceUtilsKt.isError($this$isConflictingError)) {
                return false;
            }
            ConeDiagnostic it = ((FirDiagnosticHolder)((Object)$this$isConflictingError)).getDiagnostic();
            if (it instanceof ConeSimpleDiagnostic) {
                bl = ((ConeSimpleDiagnostic)it).getKind() == DiagnosticKind.VariableExpected;
            } else if (it instanceof ConeUnresolvedNameError) {
                bl = true;
            } else if (it instanceof ConeDiagnosticWithCandidates) {
                Iterable $this$any$iv = ((ConeDiagnosticWithCandidates)it).getCandidates();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AbstractCandidate it2 = (AbstractCandidate)element$iv;
                        boolean bl2 = false;
                        if (!(it2.getSymbol() instanceof FirPropertySymbol)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final void checkValReassignment(CheckerContext context2, DiagnosticReporter reporter, FirVariableAssignment expression2) {
        Object object = ReferenceUtilsKt.getCalleeReference(expression2);
        if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) {
            return;
        }
        Object property2 = object;
        if (((FirVariableSymbol)property2).isVar()) {
            return;
        }
        if ((((FirPropertySymbol)property2).isLocal() || this.isInFileGraph(context2, (FirPropertySymbol)property2)) && FirPropertyInitializationAnalyzerKt.requiresInitialization((FirPropertySymbol)property2, false)) {
            return;
        }
        if (FirPropertyInitializationAnalyzerKt.requiresInitialization((FirPropertySymbol)property2, true)) {
            FirExpression firExpression = FirExpressionUtilKt.getDispatchReceiver(expression2);
            if (this.isInOwnersInitializer(context2, firExpression != null ? FirExpressionUtilKt.unwrapSmartcastExpression(firExpression) : null, (FirPropertySymbol)property2)) {
                return;
            }
        }
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getLValue().getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT(), property2, null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isInFileGraph(CheckerContext context2, FirPropertySymbol property2) {
        Object v2;
        void $this$reduceOrNull$iv;
        FirBasedSymbol firBasedSymbol;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable $this$dropWhile$iv = context2.getContainingDeclarations();
        boolean $i$f$dropWhile = false;
        boolean yielding$iv22 = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$dropWhile$iv) {
            if (yielding$iv22) {
                list$iv.add(item$iv);
                continue;
            }
            FirBasedSymbol it = (FirBasedSymbol)item$iv;
            boolean bl = false;
            if (!(it instanceof FirFileSymbol)) continue;
            list$iv.add(item$iv);
            yielding$iv22 = true;
        }
        List declarations2 = list$iv;
        Object yielding$iv22 = CollectionsKt.firstOrNull(declarations2);
        FirFileSymbol firFileSymbol = yielding$iv22 instanceof FirFileSymbol ? (FirFileSymbol)yielding$iv22 : null;
        if (firFileSymbol == null) {
            return false;
        }
        FirFileSymbol file = firFileSymbol;
        if (!Intrinsics.areEqual(file, FirHelpersKt.getContainingSymbol(property2, context2.getSession()))) {
            return false;
        }
        yielding$iv22 = declarations2;
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            firBasedSymbol = (FirBasedSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object e2 = it.getFir();
            FirElement firElement = e2 instanceof FirControlFlowGraphOwner ? (FirControlFlowGraphOwner)e2 : null;
            collection.add(firElement != null && (firElement = firElement.getControlFlowGraphReference()) != null ? FirControlFlowGraphReferenceImplKt.getControlFlowGraph((FirControlFlowGraphReference)firElement) : null);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                FirBasedSymbol firBasedSymbol2;
                void graph2;
                ControlFlowGraph $i$f$mapTo2 = (ControlFlowGraph)iterator$iv.next();
                ControlFlowGraph acc = (ControlFlowGraph)accumulator$iv;
                boolean bl = false;
                if (graph2 != null) {
                    FirBasedSymbol it = firBasedSymbol;
                    boolean bl2 = false;
                    firBasedSymbol2 = acc != null && acc.getSubGraphs().contains(it) ? firBasedSymbol : null;
                } else {
                    firBasedSymbol2 = null;
                }
                accumulator$iv = firBasedSymbol2;
            }
            v2 = accumulator$iv;
        }
        ControlFlowGraph containingGraph = v2;
        return containingGraph != null;
    }

    private final boolean isInOwnersInitializer(CheckerContext context2, FirExpression receiver, FirPropertySymbol property2) {
        int index;
        List<FirBasedSymbol<?>> containingDeclarations;
        block8: {
            int n2;
            Object object = receiver instanceof FirThisReceiverExpression ? (FirThisReceiverExpression)receiver : null;
            if (object == null || (object = ((FirThisReceiverExpression)object).getCalleeReference()) == null || (object = ((FirThisReference)object).getBoundSymbol()) == null) {
                return false;
            }
            Object uninitializedThisSymbol = object;
            if (!Intrinsics.areEqual(uninitializedThisSymbol, FirHelpersKt.getContainingSymbol(property2, context2.getSession()))) {
                return false;
            }
            List<FirBasedSymbol<?>> $this$indexOfFirst$iv = containingDeclarations = context2.getContainingDeclarations();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<FirBasedSymbol<?>> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                FirBasedSymbol<?> item$iv;
                FirBasedSymbol<?> it = item$iv = iterator2.next();
                boolean bl = false;
                if (Intrinsics.areEqual(it, uninitializedThisSymbol)) {
                    n2 = index$iv;
                    break block8;
                }
                ++index$iv;
            }
            n2 = index = -1;
        }
        if (index == -1) {
            return false;
        }
        int n3 = containingDeclarations.size();
        for (int i2 = index; i2 < n3; ++i2) {
            FirBasedSymbol<?> container;
            FirBasedSymbol<Object> firBasedSymbol;
            block11: {
                FirBasedSymbol<?> next;
                block9: {
                    block10: {
                        FirBasedSymbol<?> firBasedSymbol2;
                        if (!(containingDeclarations.get(i2) instanceof FirClassSymbol)) continue;
                        next = CollectionsKt.getOrNull(containingDeclarations, i2 + 1);
                        if (!(next instanceof FirPropertySymbol)) break block9;
                        firBasedSymbol = CollectionsKt.getOrNull(containingDeclarations, i2 + 2);
                        if (firBasedSymbol == null) break block10;
                        FirBasedSymbol<?> it = firBasedSymbol2 = firBasedSymbol;
                        boolean bl = false;
                        firBasedSymbol = it instanceof FirPropertyAccessorSymbol ? firBasedSymbol2 : null;
                        if (firBasedSymbol != null) break block11;
                    }
                    firBasedSymbol = next;
                    break block11;
                }
                firBasedSymbol = next;
            }
            FirBasedSymbol<?> firBasedSymbol3 = container = firBasedSymbol;
            boolean bl = firBasedSymbol3 != null ? !FirPropertyInitializationAnalyzerKt.getEvaluatedInPlace(firBasedSymbol3) : false;
            if (!bl) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static final boolean checkInvisibleSetter$shouldInvisibleSetterBeReported(CheckerContext $context, FirVariableAssignment $expression, FirPropertySymbol symbol) {
        $this$unwrapFakeOverrides$iv = symbol;
        $i$f$unwrapFakeOverrides = false;
        $this$unwrapFakeOverrides$iv$iv = (FirCallableDeclaration)$this$unwrapFakeOverrides$iv.getFir();
        $i$f$unwrapFakeOverrides = false;
        current$iv$iv = $this$unwrapFakeOverrides$iv$iv;
        while (true) {
            $this$originalIfFakeOverride$iv$iv$iv = current$iv$iv;
            $i$f$originalIfFakeOverride = false;
            $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
            $i$f$getOriginalForSubstitutionOverride = false;
            if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv)) ** GOTO lbl-1000
            $this$isSynthetic$iv$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv$iv;
            $i$f$isSynthetic = false;
            if ($this$isSynthetic$iv$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
            // 2 sources

            {
                v0 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv);
            } else {
                v0 = v1 = null;
            }
            if (v0 == null) {
                $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                $i$f$getBaseForIntersectionOverride = false;
                v1 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
            }
            if (v1 == null) break;
            current$iv$iv = next$iv$iv = v1;
        }
        v2 = current$iv$iv.getSymbol();
        if (v2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol");
        }
        v3 = ((FirPropertySymbol)((FirCallableSymbol)((FirPropertySymbol)v2))).getSetterSymbol();
        if (v3 == null) {
            return false;
        }
        setterSymbol = v3;
        v4 = FirVisibilityCheckerKt.getVisibilityChecker($context.getSession());
        v5 = setterSymbol;
        v6 = $context.getSession();
        v7 = $context.getContainingFileSymbol();
        Intrinsics.checkNotNull(v7);
        return FirVisibilityCheckerKt.isVisible$default(v4, v5, v6, v7, $context.getContainingDeclarations(), FirExpressionUtilKt.getDispatchReceiver($expression), false, 32, null) == false;
    }
}

