// Copyright 2019 The Fuchsia Authors
//
// Licensed under a BSD-style license <LICENSE-BSD>, Apache License, Version 2.0
// <LICENSE-APACHE or https://www.apache.org/licenses/LICENSE-2.0>, or the MIT
// license <LICENSE-MIT or https://opensource.org/licenses/MIT>, at your option.
// This file may not be copied, modified, or distributed except according to
// those terms.

#[macro_use]
extern crate zerocopy;

#[path = "../util.rs"]
mod util;

use self::util::{NotZerocopy, AU16};
use zerocopy::KnownLayout;

fn main() {}

// These tests cause errors which are generated by a later compilation pass than
// the other errors we generate, and so if they're compiled in the same file,
// the compiler will never get to that pass, and so we won't get the errors.

//
// FromZeroes errors
//

#[derive(FromZeroes)]
struct FromZeroes1 {
    value: NotZerocopy,
}

//
// FromBytes errors
//

#[derive(FromBytes)]
struct FromBytes1 {
    value: NotZerocopy,
}

//
// AsBytes errors
//

#[derive(AsBytes)]
#[repr(C)]
struct AsBytes1 {
    value: NotZerocopy,
}

//
// Unaligned errors
//

#[derive(Unaligned)]
#[repr(C)]
struct Unaligned1 {
    aligned: AU16,
}

// This specifically tests a bug we had in an old version of the code in which
// the trait bound would only be enforced for the first field's type.
#[derive(Unaligned)]
#[repr(C)]
struct Unaligned2 {
    unaligned: u8,
    aligned: AU16,
}

#[derive(Unaligned)]
#[repr(transparent)]
struct Unaligned3 {
    aligned: AU16,
}
