# The Algol 68 Jargon File

The Algol 68 Jargon File provides definitions for many terms used in
the context of the Algol 68 programming language and associated
technologies.  A ready to browse version of the file can be always
found at https://jemarch.net/a68-jargon .

### Using the jargon file

This package installs the following files in your system:

 * An info manual algol68-jargon.
 * A set of manual pages in section 7algol.

Once installed, the info manual can be easily accessed using any
suitable reader, like the standalone info reader:

```
$ info a68-jargon
```

The manual pages are accessed:

```
$ man 7algol a68-jargon
```

Additionally, PDF and HTML versions of the jargon file can be built
from the sources tree.  See below for instructions on how to do that.

### Building and installing

To build the jargon from a git clone:

```
  $ autoreconf -i
  $ mkdir build
  $ cd build
  $ ../configure
  $ make
  $ make install
```

To build the jargon from a released tarball:

```
  $ tar xzvf algol68-jargon-VERSION.tar.gz
  $ cd algol68-tarball-VERSION
  $ mkdir build
  $ cd build
  $ ../configure
  $ make
  $ make install
```

To build the PDF version of the jargon file:

```
  $ make pdf
```

To build the HTML version of the jargon file:

```
  $ make html
```

The contents of this file are in the public domain.
