---
icon: material/xml
---

# JUnit support

Nextest can produce output in the [JUnit/XUnit XML format](https://llg.cubic.org/docs/junit/). This format is widely understood by test analysis tools and libraries.

To enable JUnit support, add this to your [nextest configuration](../configuration/index.md):

```toml title="Basic JUnit configuration in <code>.config/nextest.toml</code>"
[profile.ci.junit]  # this can be some other profile, too
path = "junit.xml"
```

If `--profile ci` is selected on the command line, a JUnit report will be written out to `target/nextest/ci/junit.xml` within the workspace root.

Some notes about the JUnit support:

- There are several slightly different formats all called "JUnit" or "XUnit". Nextest adheres to the [Jenkins XML format](https://llg.cubic.org/docs/junit/).
- Every test binary forms a single `<testsuite>`. Every test forms a single `<testcase>`.
- Standard output and standard error are included for failed and retried tests. (However, [invalid XML characters](https://en.wikipedia.org/wiki/Valid_characters_in_XML) are stripped out.)

## Configuration

Configuration options supported for JUnit reports, within the `junit` section:

`report-name`
: The name of the report. Defaults to `"nextest-run"`.

`store-success-output`
: Whether to store output for successful tests in the `<system-out>` and `<system-err>` elements. Defaults to false.

`store-failure-output`
: Whether to store output for failing tests in the `<system-out>` and `<system-err>` elements. Defaults to true.

The `store-success-output` and `store-failure-output` configuration can also be configured on a [per-test basis](../configuration/per-test-overrides.md).

### Example configuration

```toml title="Per-test JUnit settings"
[profile.default.junit]
path = "junit.xml"
# These are the default values, specified for clarity.
store-success-output = false
store-failure-output = true

[[profile.default.overrides]]
filter = 'test(important-test)'
junit.store-success-output = true
```

In this example, the JUnit report will contain the output for all failing tests, and for successful tests that contain "important-test" in the name.

## Post-processing

Some tools that read JUnit files don't follow the Jenkins standard. You can post-process the JUnit file in such cases. Here's some recommendations for post-processing tools written by community members:

- CircleCI: [`circleci-junit-fix`](https://github.com/conradludgate/circleci-junit-fix)

## Example

Here's an example JUnit file generated by `cargo-nextest`.

```bash exec="true" result="xml"
cat ../fixtures/nextest-tests-junit.xml
```
