/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import jakarta.inject.Inject;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class MenuManagerServiceFilter
implements Listener {
    private static final String TMP_ORIGINAL_CONTEXT = "MenuServiceFilter.original.context";
    @Inject
    private Logger logger;
    @Inject
    EModelService modelService;

    private static void trace(String msg, Widget menu, MMenu menuModel) {
        WorkbenchSWTActivator.trace((String)"/trace/menus", (String)(msg + ": " + String.valueOf(menu) + ": " + String.valueOf(menuModel)), null);
    }

    public void handleEvent(final Event event) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (MenuManagerServiceFilter.this.logger != null) {
                    MenuManagerServiceFilter.this.logger.error(e);
                }
            }

            public void run() throws Exception {
                MenuManagerServiceFilter.this.safeHandleEvent(event);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void safeHandleEvent(Event event) {
        Object obj;
        void menu;
        if (!(event.widget instanceof Menu)) {
            return;
        }
        Menu menu2 = (Menu)event.widget;
        if (event.type == 12) {
            MenuManagerServiceFilter.trace("handleMenu.Dispose", (Widget)menu, null);
        }
        if ((obj = menu.getData("modelElement")) == null && menu.getParentItem() != null) {
            obj = menu.getParentItem().getData("modelElement");
        }
        if (obj instanceof MPopupMenu) {
            this.handleContextMenu(event, (Menu)menu, (MPopupMenu)obj);
        } else if (obj instanceof MMenu) {
            this.handleMenu(event, (Menu)menu);
        }
    }

    private void handleMenu(Event event, Menu menu) {
        if ((menu.getStyle() & 2) != 0) {
            return;
        }
        switch (event.type) {
            case 22: {
                break;
            }
        }
    }

    private void handleContextMenu(Event event, Menu menu, MPopupMenu menuModel) {
        switch (event.type) {
            case 22: {
                this.showPopup(menuModel);
                break;
            }
            case 23: {
                this.hidePopup(menu, menuModel);
            }
        }
    }

    private void hidePopup(Menu menu, MPopupMenu menuModel) {
        IEclipseContext popupContext = menuModel.getContext();
        IEclipseContext originalChild = (IEclipseContext)popupContext.get(TMP_ORIGINAL_CONTEXT);
        popupContext.remove(TMP_ORIGINAL_CONTEXT);
        if (!menu.isDisposed()) {
            menu.getDisplay().asyncExec(() -> {
                if (originalChild == null) {
                    popupContext.deactivate();
                } else {
                    originalChild.activate();
                }
            });
        }
    }

    private void showPopup(MPopupMenu menuModel) {
        IEclipseContext popupContext = menuModel.getContext();
        IEclipseContext parentContext = popupContext.getParent();
        IEclipseContext originalChild = parentContext.getActiveChild();
        popupContext.activate();
        popupContext.set(TMP_ORIGINAL_CONTEXT, (Object)originalChild);
    }
}

