//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-graphics")]
#[cfg(target_vendor = "apple")]
use objc2_core_graphics::*;
#[cfg(feature = "objc2-core-image")]
#[cfg(target_vendor = "apple")]
use objc2_core_image::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsappkitversionnumberwithpatterncolorleakfix?language=objc)
#[cfg(feature = "NSApplication")]
pub static NSAppKitVersionNumberWithPatternColorLeakFix: NSAppKitVersion = 641.0 as _;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscolortype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSColorType(pub NSInteger);
impl NSColorType {
    #[doc(alias = "NSColorTypeComponentBased")]
    pub const ComponentBased: Self = Self(0);
    #[doc(alias = "NSColorTypePattern")]
    pub const Pattern: Self = Self(1);
    #[doc(alias = "NSColorTypeCatalog")]
    pub const Catalog: Self = Self(2);
}

unsafe impl Encode for NSColorType {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSColorType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscolorsystemeffect?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSColorSystemEffect(pub NSInteger);
impl NSColorSystemEffect {
    #[doc(alias = "NSColorSystemEffectNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "NSColorSystemEffectPressed")]
    pub const Pressed: Self = Self(1);
    #[doc(alias = "NSColorSystemEffectDeepPressed")]
    pub const DeepPressed: Self = Self(2);
    #[doc(alias = "NSColorSystemEffectDisabled")]
    pub const Disabled: Self = Self(3);
    #[doc(alias = "NSColorSystemEffectRollover")]
    pub const Rollover: Self = Self(4);
}

unsafe impl Encode for NSColorSystemEffect {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSColorSystemEffect {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscolor?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSColor;
);

unsafe impl Send for NSColor {}

unsafe impl Sync for NSColor {}

extern_conformance!(
    unsafe impl NSCoding for NSColor {}
);

extern_conformance!(
    unsafe impl NSCopying for NSColor {}
);

unsafe impl CopyingHelper for NSColor {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSColor {}
);

#[cfg(feature = "NSPasteboard")]
extern_conformance!(
    unsafe impl NSPasteboardReading for NSColor {}
);

#[cfg(feature = "NSPasteboard")]
extern_conformance!(
    unsafe impl NSPasteboardWriting for NSColor {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for NSColor {}
);

impl NSColor {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[cfg(all(feature = "NSColorSpace", feature = "objc2-core-foundation"))]
        /// # Safety
        ///
        /// `components` must be a valid pointer.
        #[unsafe(method(colorWithColorSpace:components:count:))]
        #[unsafe(method_family = none)]
        pub unsafe fn colorWithColorSpace_components_count(
            space: &NSColorSpace,
            components: NonNull<CGFloat>,
            number_of_components: NSInteger,
        ) -> Retained<NSColor>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(colorWithSRGBRed:green:blue:alpha:))]
        #[unsafe(method_family = none)]
        pub fn colorWithSRGBRed_green_blue_alpha(
            red: CGFloat,
            green: CGFloat,
            blue: CGFloat,
            alpha: CGFloat,
        ) -> Retained<NSColor>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(colorWithGenericGamma22White:alpha:))]
        #[unsafe(method_family = none)]
        pub fn colorWithGenericGamma22White_alpha(
            white: CGFloat,
            alpha: CGFloat,
        ) -> Retained<NSColor>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(colorWithDisplayP3Red:green:blue:alpha:))]
        #[unsafe(method_family = none)]
        pub fn colorWithDisplayP3Red_green_blue_alpha(
            red: CGFloat,
            green: CGFloat,
            blue: CGFloat,
            alpha: CGFloat,
        ) -> Retained<NSColor>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(colorWithWhite:alpha:))]
        #[unsafe(method_family = none)]
        pub fn colorWithWhite_alpha(white: CGFloat, alpha: CGFloat) -> Retained<NSColor>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(colorWithRed:green:blue:alpha:))]
        #[unsafe(method_family = none)]
        pub fn colorWithRed_green_blue_alpha(
            red: CGFloat,
            green: CGFloat,
            blue: CGFloat,
            alpha: CGFloat,
        ) -> Retained<NSColor>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(colorWithHue:saturation:brightness:alpha:))]
        #[unsafe(method_family = none)]
        pub fn colorWithHue_saturation_brightness_alpha(
            hue: CGFloat,
            saturation: CGFloat,
            brightness: CGFloat,
            alpha: CGFloat,
        ) -> Retained<NSColor>;

        #[cfg(all(feature = "NSColorSpace", feature = "objc2-core-foundation"))]
        #[unsafe(method(colorWithColorSpace:hue:saturation:brightness:alpha:))]
        #[unsafe(method_family = none)]
        pub fn colorWithColorSpace_hue_saturation_brightness_alpha(
            space: &NSColorSpace,
            hue: CGFloat,
            saturation: CGFloat,
            brightness: CGFloat,
            alpha: CGFloat,
        ) -> Retained<NSColor>;

        #[cfg(feature = "NSColorList")]
        #[unsafe(method(colorWithCatalogName:colorName:))]
        #[unsafe(method_family = none)]
        pub fn colorWithCatalogName_colorName(
            list_name: &NSColorListName,
            color_name: &NSColorName,
        ) -> Option<Retained<NSColor>>;

        #[cfg(feature = "NSColorList")]
        #[unsafe(method(colorNamed:bundle:))]
        #[unsafe(method_family = none)]
        pub fn colorNamed_bundle(
            name: &NSColorName,
            bundle: Option<&NSBundle>,
        ) -> Option<Retained<NSColor>>;

        #[cfg(feature = "NSColorList")]
        #[unsafe(method(colorNamed:))]
        #[unsafe(method_family = none)]
        pub fn colorNamed(name: &NSColorName) -> Option<Retained<NSColor>>;

        #[cfg(all(feature = "NSAppearance", feature = "NSColorList", feature = "block2"))]
        /// # Safety
        ///
        /// `dynamic_provider` block's return must be a valid pointer.
        #[unsafe(method(colorWithName:dynamicProvider:))]
        #[unsafe(method_family = none)]
        pub unsafe fn colorWithName_dynamicProvider(
            color_name: Option<&NSColorName>,
            dynamic_provider: &block2::DynBlock<dyn Fn(NonNull<NSAppearance>) -> NonNull<NSColor>>,
        ) -> Retained<NSColor>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(colorWithDeviceWhite:alpha:))]
        #[unsafe(method_family = none)]
        pub fn colorWithDeviceWhite_alpha(white: CGFloat, alpha: CGFloat) -> Retained<NSColor>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(colorWithDeviceRed:green:blue:alpha:))]
        #[unsafe(method_family = none)]
        pub fn colorWithDeviceRed_green_blue_alpha(
            red: CGFloat,
            green: CGFloat,
            blue: CGFloat,
            alpha: CGFloat,
        ) -> Retained<NSColor>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(colorWithDeviceHue:saturation:brightness:alpha:))]
        #[unsafe(method_family = none)]
        pub fn colorWithDeviceHue_saturation_brightness_alpha(
            hue: CGFloat,
            saturation: CGFloat,
            brightness: CGFloat,
            alpha: CGFloat,
        ) -> Retained<NSColor>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(colorWithDeviceCyan:magenta:yellow:black:alpha:))]
        #[unsafe(method_family = none)]
        pub fn colorWithDeviceCyan_magenta_yellow_black_alpha(
            cyan: CGFloat,
            magenta: CGFloat,
            yellow: CGFloat,
            black: CGFloat,
            alpha: CGFloat,
        ) -> Retained<NSColor>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(colorWithCalibratedWhite:alpha:))]
        #[unsafe(method_family = none)]
        pub fn colorWithCalibratedWhite_alpha(white: CGFloat, alpha: CGFloat) -> Retained<NSColor>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(colorWithCalibratedRed:green:blue:alpha:))]
        #[unsafe(method_family = none)]
        pub fn colorWithCalibratedRed_green_blue_alpha(
            red: CGFloat,
            green: CGFloat,
            blue: CGFloat,
            alpha: CGFloat,
        ) -> Retained<NSColor>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(colorWithCalibratedHue:saturation:brightness:alpha:))]
        #[unsafe(method_family = none)]
        pub fn colorWithCalibratedHue_saturation_brightness_alpha(
            hue: CGFloat,
            saturation: CGFloat,
            brightness: CGFloat,
            alpha: CGFloat,
        ) -> Retained<NSColor>;

        #[cfg(feature = "NSImage")]
        #[unsafe(method(colorWithPatternImage:))]
        #[unsafe(method_family = none)]
        pub fn colorWithPatternImage(image: &NSImage) -> Retained<NSColor>;

        #[unsafe(method(type))]
        #[unsafe(method_family = none)]
        pub fn r#type(&self) -> NSColorType;

        #[unsafe(method(colorUsingType:))]
        #[unsafe(method_family = none)]
        pub fn colorUsingType(&self, r#type: NSColorType) -> Option<Retained<NSColor>>;

        #[cfg(feature = "NSColorSpace")]
        #[unsafe(method(colorUsingColorSpace:))]
        #[unsafe(method_family = none)]
        pub fn colorUsingColorSpace(&self, space: &NSColorSpace) -> Option<Retained<NSColor>>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Generates an HDR color in the extended sRGB colorspace by applying an exposure to the SDR color defined by the red, green, and blue components. The `red`, `green`, and `blue` components have a nominal range of [0..1], `exposure` is a value >= 0. To produce an HDR color, we process the given color in a linear color space, multiplying component values by `2^exposure`. The produced color will have a `contentHeadroom` equal to the linearized exposure value. Each whole value of exposure produces a color that is twice as bright.
        #[unsafe(method(colorWithRed:green:blue:alpha:exposure:))]
        #[unsafe(method_family = none)]
        pub fn colorWithRed_green_blue_alpha_exposure(
            red: CGFloat,
            green: CGFloat,
            blue: CGFloat,
            alpha: CGFloat,
            exposure: CGFloat,
        ) -> Retained<NSColor>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Generates an HDR color in the extended sRGB colorspace by applying an exposure to the SDR color defined by the red, green, and blue components. The `red`, `green`, and `blue` components have a nominal range of [0..1], `linearExposure` is a value >= 1. To produce an HDR color, we process the given color in a linear color space, multiplying component values by `linearExposure `. The produced color will have a `contentHeadroom` equal to `linearExposure`. Each doubling of `linearExposure` produces a color that is twice as bright.
        #[unsafe(method(colorWithRed:green:blue:alpha:linearExposure:))]
        #[unsafe(method_family = none)]
        pub fn colorWithRed_green_blue_alpha_linearExposure(
            red: CGFloat,
            green: CGFloat,
            blue: CGFloat,
            alpha: CGFloat,
            linear_exposure: CGFloat,
        ) -> Retained<NSColor>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Reinterpret the color by applying a new `contentHeadroom` without changing the color components. Changing the `contentHeadroom` redefines the color relative to a different peak white, changing its behavior under tone mapping and the result of calling `standardDynamicRangeColor`. The new color will have a `contentHeadroom` >= 1.0. If called on a color with a color space that does not support extended range, or does not have an equivalent extended range counterpart, this will return `self`.
        #[unsafe(method(colorByApplyingContentHeadroom:))]
        #[unsafe(method_family = none)]
        pub fn colorByApplyingContentHeadroom(
            &self,
            content_headroom: CGFloat,
        ) -> Retained<NSColor>;

        /// In some cases it is useful to recover the color that was base the SDR color that was exposed to generate an HDR color. If a color's `linearExposure` is > 1, then this will return the base SDR color. If the color is not an HDR color, this will return `self`.
        #[unsafe(method(standardDynamicRangeColor))]
        #[unsafe(method_family = none)]
        pub fn standardDynamicRangeColor(&self) -> Retained<NSColor>;

        #[unsafe(method(blackColor))]
        #[unsafe(method_family = none)]
        pub fn blackColor() -> Retained<NSColor>;

        #[unsafe(method(darkGrayColor))]
        #[unsafe(method_family = none)]
        pub fn darkGrayColor() -> Retained<NSColor>;

        #[unsafe(method(lightGrayColor))]
        #[unsafe(method_family = none)]
        pub fn lightGrayColor() -> Retained<NSColor>;

        #[unsafe(method(whiteColor))]
        #[unsafe(method_family = none)]
        pub fn whiteColor() -> Retained<NSColor>;

        #[unsafe(method(grayColor))]
        #[unsafe(method_family = none)]
        pub fn grayColor() -> Retained<NSColor>;

        #[unsafe(method(redColor))]
        #[unsafe(method_family = none)]
        pub fn redColor() -> Retained<NSColor>;

        #[unsafe(method(greenColor))]
        #[unsafe(method_family = none)]
        pub fn greenColor() -> Retained<NSColor>;

        #[unsafe(method(blueColor))]
        #[unsafe(method_family = none)]
        pub fn blueColor() -> Retained<NSColor>;

        #[unsafe(method(cyanColor))]
        #[unsafe(method_family = none)]
        pub fn cyanColor() -> Retained<NSColor>;

        #[unsafe(method(yellowColor))]
        #[unsafe(method_family = none)]
        pub fn yellowColor() -> Retained<NSColor>;

        #[unsafe(method(magentaColor))]
        #[unsafe(method_family = none)]
        pub fn magentaColor() -> Retained<NSColor>;

        #[unsafe(method(orangeColor))]
        #[unsafe(method_family = none)]
        pub fn orangeColor() -> Retained<NSColor>;

        #[unsafe(method(purpleColor))]
        #[unsafe(method_family = none)]
        pub fn purpleColor() -> Retained<NSColor>;

        #[unsafe(method(brownColor))]
        #[unsafe(method_family = none)]
        pub fn brownColor() -> Retained<NSColor>;

        #[unsafe(method(clearColor))]
        #[unsafe(method_family = none)]
        pub fn clearColor() -> Retained<NSColor>;

        #[unsafe(method(labelColor))]
        #[unsafe(method_family = none)]
        pub fn labelColor() -> Retained<NSColor>;

        #[unsafe(method(secondaryLabelColor))]
        #[unsafe(method_family = none)]
        pub fn secondaryLabelColor() -> Retained<NSColor>;

        #[unsafe(method(tertiaryLabelColor))]
        #[unsafe(method_family = none)]
        pub fn tertiaryLabelColor() -> Retained<NSColor>;

        #[unsafe(method(quaternaryLabelColor))]
        #[unsafe(method_family = none)]
        pub fn quaternaryLabelColor() -> Retained<NSColor>;

        #[unsafe(method(quinaryLabelColor))]
        #[unsafe(method_family = none)]
        pub fn quinaryLabelColor() -> Retained<NSColor>;

        /// Used for large scale images or subtle decorative elements; not for general foreground content.
        #[unsafe(method(linkColor))]
        #[unsafe(method_family = none)]
        pub fn linkColor() -> Retained<NSColor>;

        #[unsafe(method(placeholderTextColor))]
        #[unsafe(method_family = none)]
        pub fn placeholderTextColor() -> Retained<NSColor>;

        #[unsafe(method(windowFrameTextColor))]
        #[unsafe(method_family = none)]
        pub fn windowFrameTextColor() -> Retained<NSColor>;

        #[unsafe(method(selectedMenuItemTextColor))]
        #[unsafe(method_family = none)]
        pub fn selectedMenuItemTextColor() -> Retained<NSColor>;

        #[unsafe(method(alternateSelectedControlTextColor))]
        #[unsafe(method_family = none)]
        pub fn alternateSelectedControlTextColor() -> Retained<NSColor>;

        #[unsafe(method(headerTextColor))]
        #[unsafe(method_family = none)]
        pub fn headerTextColor() -> Retained<NSColor>;

        #[unsafe(method(separatorColor))]
        #[unsafe(method_family = none)]
        pub fn separatorColor() -> Retained<NSColor>;

        #[unsafe(method(gridColor))]
        #[unsafe(method_family = none)]
        pub fn gridColor() -> Retained<NSColor>;

        #[unsafe(method(windowBackgroundColor))]
        #[unsafe(method_family = none)]
        pub fn windowBackgroundColor() -> Retained<NSColor>;

        #[unsafe(method(underPageBackgroundColor))]
        #[unsafe(method_family = none)]
        pub fn underPageBackgroundColor() -> Retained<NSColor>;

        #[unsafe(method(controlBackgroundColor))]
        #[unsafe(method_family = none)]
        pub fn controlBackgroundColor() -> Retained<NSColor>;

        #[unsafe(method(selectedContentBackgroundColor))]
        #[unsafe(method_family = none)]
        pub fn selectedContentBackgroundColor() -> Retained<NSColor>;

        #[unsafe(method(unemphasizedSelectedContentBackgroundColor))]
        #[unsafe(method_family = none)]
        pub fn unemphasizedSelectedContentBackgroundColor() -> Retained<NSColor>;

        #[unsafe(method(alternatingContentBackgroundColors))]
        #[unsafe(method_family = none)]
        pub fn alternatingContentBackgroundColors() -> Retained<NSArray<NSColor>>;

        #[unsafe(method(findHighlightColor))]
        #[unsafe(method_family = none)]
        pub fn findHighlightColor() -> Retained<NSColor>;

        #[unsafe(method(textColor))]
        #[unsafe(method_family = none)]
        pub fn textColor() -> Retained<NSColor>;

        #[unsafe(method(textBackgroundColor))]
        #[unsafe(method_family = none)]
        pub fn textBackgroundColor() -> Retained<NSColor>;

        #[unsafe(method(textInsertionPointColor))]
        #[unsafe(method_family = none)]
        pub fn textInsertionPointColor() -> Retained<NSColor>;

        #[unsafe(method(selectedTextColor))]
        #[unsafe(method_family = none)]
        pub fn selectedTextColor() -> Retained<NSColor>;

        #[unsafe(method(selectedTextBackgroundColor))]
        #[unsafe(method_family = none)]
        pub fn selectedTextBackgroundColor() -> Retained<NSColor>;

        #[unsafe(method(unemphasizedSelectedTextBackgroundColor))]
        #[unsafe(method_family = none)]
        pub fn unemphasizedSelectedTextBackgroundColor() -> Retained<NSColor>;

        #[unsafe(method(unemphasizedSelectedTextColor))]
        #[unsafe(method_family = none)]
        pub fn unemphasizedSelectedTextColor() -> Retained<NSColor>;

        #[unsafe(method(controlColor))]
        #[unsafe(method_family = none)]
        pub fn controlColor() -> Retained<NSColor>;

        #[unsafe(method(controlTextColor))]
        #[unsafe(method_family = none)]
        pub fn controlTextColor() -> Retained<NSColor>;

        #[unsafe(method(selectedControlColor))]
        #[unsafe(method_family = none)]
        pub fn selectedControlColor() -> Retained<NSColor>;

        #[unsafe(method(selectedControlTextColor))]
        #[unsafe(method_family = none)]
        pub fn selectedControlTextColor() -> Retained<NSColor>;

        #[unsafe(method(disabledControlTextColor))]
        #[unsafe(method_family = none)]
        pub fn disabledControlTextColor() -> Retained<NSColor>;

        #[unsafe(method(keyboardFocusIndicatorColor))]
        #[unsafe(method_family = none)]
        pub fn keyboardFocusIndicatorColor() -> Retained<NSColor>;

        #[unsafe(method(scrubberTexturedBackgroundColor))]
        #[unsafe(method_family = none)]
        pub fn scrubberTexturedBackgroundColor() -> Retained<NSColor>;

        #[unsafe(method(systemRedColor))]
        #[unsafe(method_family = none)]
        pub fn systemRedColor() -> Retained<NSColor>;

        #[unsafe(method(systemGreenColor))]
        #[unsafe(method_family = none)]
        pub fn systemGreenColor() -> Retained<NSColor>;

        #[unsafe(method(systemBlueColor))]
        #[unsafe(method_family = none)]
        pub fn systemBlueColor() -> Retained<NSColor>;

        #[unsafe(method(systemOrangeColor))]
        #[unsafe(method_family = none)]
        pub fn systemOrangeColor() -> Retained<NSColor>;

        #[unsafe(method(systemYellowColor))]
        #[unsafe(method_family = none)]
        pub fn systemYellowColor() -> Retained<NSColor>;

        #[unsafe(method(systemBrownColor))]
        #[unsafe(method_family = none)]
        pub fn systemBrownColor() -> Retained<NSColor>;

        #[unsafe(method(systemPinkColor))]
        #[unsafe(method_family = none)]
        pub fn systemPinkColor() -> Retained<NSColor>;

        #[unsafe(method(systemPurpleColor))]
        #[unsafe(method_family = none)]
        pub fn systemPurpleColor() -> Retained<NSColor>;

        #[unsafe(method(systemGrayColor))]
        #[unsafe(method_family = none)]
        pub fn systemGrayColor() -> Retained<NSColor>;

        #[unsafe(method(systemTealColor))]
        #[unsafe(method_family = none)]
        pub fn systemTealColor() -> Retained<NSColor>;

        #[unsafe(method(systemIndigoColor))]
        #[unsafe(method_family = none)]
        pub fn systemIndigoColor() -> Retained<NSColor>;

        #[unsafe(method(systemMintColor))]
        #[unsafe(method_family = none)]
        pub fn systemMintColor() -> Retained<NSColor>;

        #[unsafe(method(systemCyanColor))]
        #[unsafe(method_family = none)]
        pub fn systemCyanColor() -> Retained<NSColor>;

        /// Fill colors for UI elements.
        /// These are meant to be used over the background colors, since their alpha component is less than 1.
        ///
        /// systemFillColor is appropriate for filling thin shapes, such as the track of a slider.
        #[unsafe(method(systemFillColor))]
        #[unsafe(method_family = none)]
        pub fn systemFillColor() -> Retained<NSColor>;

        /// secondarySystemFillColor is appropriate for filling small-size shapes, such as the backing of a progress indicator.
        #[unsafe(method(secondarySystemFillColor))]
        #[unsafe(method_family = none)]
        pub fn secondarySystemFillColor() -> Retained<NSColor>;

        /// tertiarySystemFillColor is appropriate for filling medium-size shapes,  such as the backing of a switch.
        #[unsafe(method(tertiarySystemFillColor))]
        #[unsafe(method_family = none)]
        pub fn tertiarySystemFillColor() -> Retained<NSColor>;

        /// quaternarySystemFillColor is appropriate for filling large areas, such as a group box or tab pane.
        #[unsafe(method(quaternarySystemFillColor))]
        #[unsafe(method_family = none)]
        pub fn quaternarySystemFillColor() -> Retained<NSColor>;

        /// quinarySystemFillColor is appropriate for filling large areas that require subtle emphasis, such as content of a form..
        #[unsafe(method(quinarySystemFillColor))]
        #[unsafe(method_family = none)]
        pub fn quinarySystemFillColor() -> Retained<NSColor>;

        /// A dynamic color that reflects the user's current preferred accent color. This color automatically updates when the accent color preference changes. Do not make assumptions about the color space of this color, which may change across releases.
        #[unsafe(method(controlAccentColor))]
        #[unsafe(method_family = none)]
        pub fn controlAccentColor() -> Retained<NSColor>;

        #[cfg(feature = "NSCell")]
        #[unsafe(method(currentControlTint))]
        #[unsafe(method_family = none)]
        pub fn currentControlTint() -> NSControlTint;

        #[cfg(feature = "NSCell")]
        #[deprecated = "NSControlTint does not describe the full range of available control accent colors. Use +[NSColor controlAccentColor] instead."]
        #[unsafe(method(colorForControlTint:))]
        #[unsafe(method_family = none)]
        pub fn colorForControlTint(control_tint: NSControlTint) -> Retained<NSColor>;

        #[unsafe(method(highlightColor))]
        #[unsafe(method_family = none)]
        pub fn highlightColor() -> Retained<NSColor>;

        #[unsafe(method(shadowColor))]
        #[unsafe(method_family = none)]
        pub fn shadowColor() -> Retained<NSColor>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(highlightWithLevel:))]
        #[unsafe(method_family = none)]
        pub fn highlightWithLevel(&self, val: CGFloat) -> Option<Retained<NSColor>>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(shadowWithLevel:))]
        #[unsafe(method_family = none)]
        pub fn shadowWithLevel(&self, val: CGFloat) -> Option<Retained<NSColor>>;

        /// Returns a color representing the base color with a system defined effect applied to it. This color is safe to create before draw time, as the resolution of the final color only happens when being `-set`, retrieving its `CGColor`, resolving with `-colorWithType:`, etc. The return color type is `.named`.
        #[unsafe(method(colorWithSystemEffect:))]
        #[unsafe(method_family = none)]
        pub fn colorWithSystemEffect(
            &self,
            system_effect: NSColorSystemEffect,
        ) -> Retained<NSColor>;

        #[unsafe(method(set))]
        #[unsafe(method_family = none)]
        pub fn set(&self);

        #[unsafe(method(setFill))]
        #[unsafe(method_family = none)]
        pub fn setFill(&self);

        #[unsafe(method(setStroke))]
        #[unsafe(method_family = none)]
        pub fn setStroke(&self);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(blendedColorWithFraction:ofColor:))]
        #[unsafe(method_family = none)]
        pub fn blendedColorWithFraction_ofColor(
            &self,
            fraction: CGFloat,
            color: &NSColor,
        ) -> Option<Retained<NSColor>>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(colorWithAlphaComponent:))]
        #[unsafe(method_family = none)]
        pub fn colorWithAlphaComponent(&self, alpha: CGFloat) -> Retained<NSColor>;

        #[cfg(feature = "NSColorList")]
        /// * Methods to get various components of colors. Not all of the methods apply to all colors; if called, they raise. **
        #[unsafe(method(catalogNameComponent))]
        #[unsafe(method_family = none)]
        pub fn catalogNameComponent(&self) -> Retained<NSColorListName>;

        #[cfg(feature = "NSColorList")]
        #[unsafe(method(colorNameComponent))]
        #[unsafe(method_family = none)]
        pub fn colorNameComponent(&self) -> Retained<NSColorName>;

        #[unsafe(method(localizedCatalogNameComponent))]
        #[unsafe(method_family = none)]
        pub fn localizedCatalogNameComponent(&self) -> Retained<NSString>;

        #[unsafe(method(localizedColorNameComponent))]
        #[unsafe(method_family = none)]
        pub fn localizedColorNameComponent(&self) -> Retained<NSString>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(redComponent))]
        #[unsafe(method_family = none)]
        pub fn redComponent(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(greenComponent))]
        #[unsafe(method_family = none)]
        pub fn greenComponent(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(blueComponent))]
        #[unsafe(method_family = none)]
        pub fn blueComponent(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// # Safety
        ///
        /// - `red` must be a valid pointer or null.
        /// - `green` must be a valid pointer or null.
        /// - `blue` must be a valid pointer or null.
        /// - `alpha` must be a valid pointer or null.
        #[unsafe(method(getRed:green:blue:alpha:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getRed_green_blue_alpha(
            &self,
            red: *mut CGFloat,
            green: *mut CGFloat,
            blue: *mut CGFloat,
            alpha: *mut CGFloat,
        );

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(hueComponent))]
        #[unsafe(method_family = none)]
        pub fn hueComponent(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(saturationComponent))]
        #[unsafe(method_family = none)]
        pub fn saturationComponent(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(brightnessComponent))]
        #[unsafe(method_family = none)]
        pub fn brightnessComponent(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// # Safety
        ///
        /// - `hue` must be a valid pointer or null.
        /// - `saturation` must be a valid pointer or null.
        /// - `brightness` must be a valid pointer or null.
        /// - `alpha` must be a valid pointer or null.
        #[unsafe(method(getHue:saturation:brightness:alpha:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getHue_saturation_brightness_alpha(
            &self,
            hue: *mut CGFloat,
            saturation: *mut CGFloat,
            brightness: *mut CGFloat,
            alpha: *mut CGFloat,
        );

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(whiteComponent))]
        #[unsafe(method_family = none)]
        pub fn whiteComponent(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// # Safety
        ///
        /// - `white` must be a valid pointer or null.
        /// - `alpha` must be a valid pointer or null.
        #[unsafe(method(getWhite:alpha:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getWhite_alpha(&self, white: *mut CGFloat, alpha: *mut CGFloat);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(cyanComponent))]
        #[unsafe(method_family = none)]
        pub fn cyanComponent(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(magentaComponent))]
        #[unsafe(method_family = none)]
        pub fn magentaComponent(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(yellowComponent))]
        #[unsafe(method_family = none)]
        pub fn yellowComponent(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(blackComponent))]
        #[unsafe(method_family = none)]
        pub fn blackComponent(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// # Safety
        ///
        /// - `cyan` must be a valid pointer or null.
        /// - `magenta` must be a valid pointer or null.
        /// - `yellow` must be a valid pointer or null.
        /// - `black` must be a valid pointer or null.
        /// - `alpha` must be a valid pointer or null.
        #[unsafe(method(getCyan:magenta:yellow:black:alpha:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getCyan_magenta_yellow_black_alpha(
            &self,
            cyan: *mut CGFloat,
            magenta: *mut CGFloat,
            yellow: *mut CGFloat,
            black: *mut CGFloat,
            alpha: *mut CGFloat,
        );

        #[cfg(feature = "NSColorSpace")]
        #[unsafe(method(colorSpace))]
        #[unsafe(method_family = none)]
        pub fn colorSpace(&self) -> Retained<NSColorSpace>;

        #[unsafe(method(numberOfComponents))]
        #[unsafe(method_family = none)]
        pub fn numberOfComponents(&self) -> NSInteger;

        #[cfg(feature = "objc2-core-foundation")]
        /// # Safety
        ///
        /// `components` must be a valid pointer.
        #[unsafe(method(getComponents:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getComponents(&self, components: NonNull<CGFloat>);

        #[cfg(feature = "NSImage")]
        #[unsafe(method(patternImage))]
        #[unsafe(method_family = none)]
        pub fn patternImage(&self) -> Retained<NSImage>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(alphaComponent))]
        #[unsafe(method_family = none)]
        pub fn alphaComponent(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// For HDR colors, the linear brightness multiplier that was applied when generating the color. Colors created with an exposure by NSColor create CGColors that are tagged with a contentHeadroom value. While CGColors created without a contentHeadroom tag will return 0 from CGColorGetHeadroom, NSColors generated in a similar fashion return a linearExposure of 1.0.
        #[unsafe(method(linearExposure))]
        #[unsafe(method_family = none)]
        pub fn linearExposure(&self) -> CGFloat;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(colorFromPasteboard:))]
        #[unsafe(method_family = none)]
        pub fn colorFromPasteboard(paste_board: &NSPasteboard) -> Option<Retained<NSColor>>;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(writeToPasteboard:))]
        #[unsafe(method_family = none)]
        pub fn writeToPasteboard(&self, paste_board: &NSPasteboard);

        #[unsafe(method(drawSwatchInRect:))]
        #[unsafe(method_family = none)]
        pub fn drawSwatchInRect(&self, rect: NSRect);

        #[cfg(feature = "objc2-core-graphics")]
        #[cfg(target_vendor = "apple")]
        #[unsafe(method(colorWithCGColor:))]
        #[unsafe(method_family = none)]
        pub fn colorWithCGColor(cg_color: &CGColor) -> Option<Retained<NSColor>>;

        #[cfg(feature = "objc2-core-graphics")]
        #[cfg(target_vendor = "apple")]
        #[unsafe(method(CGColor))]
        #[unsafe(method_family = none)]
        pub fn CGColor(&self) -> Retained<CGColor>;

        #[deprecated = "Use `showsAlpha` in `NSColorPanel` and `supportsAlpha` in `NSColorWell` to control alpha behavior for individual controls."]
        #[unsafe(method(ignoresAlpha))]
        #[unsafe(method_family = none)]
        pub fn ignoresAlpha(mtm: MainThreadMarker) -> bool;

        /// Setter for [`ignoresAlpha`][Self::ignoresAlpha].
        #[deprecated = "Use `showsAlpha` in `NSColorPanel` and `supportsAlpha` in `NSColorWell` to control alpha behavior for individual controls."]
        #[unsafe(method(setIgnoresAlpha:))]
        #[unsafe(method_family = none)]
        pub fn setIgnoresAlpha(ignores_alpha: bool, mtm: MainThreadMarker);
    );
}

/// Methods declared on superclass `NSObject`.
impl NSColor {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSColor {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

/// NSDeprecated.
impl NSColor {
    extern_methods!(
        /// Historically used as the inner border highlight color for beveled buttons. No longer used.
        #[deprecated = "Use a color that matches the semantics being used, such as `separatorColor`"]
        #[unsafe(method(controlHighlightColor))]
        #[unsafe(method_family = none)]
        pub fn controlHighlightColor() -> Retained<NSColor>;

        /// Historically used as the outer border highlight color for beveled buttons. No longer used.
        #[deprecated = "Use a color that matches the semantics being used, such as `separatorColor`"]
        #[unsafe(method(controlLightHighlightColor))]
        #[unsafe(method_family = none)]
        pub fn controlLightHighlightColor() -> Retained<NSColor>;

        /// Historically used as the inner border shadow color for beveled buttons. No longer used.
        #[deprecated = "Use a color that matches the semantics being used, such as `separatorColor`"]
        #[unsafe(method(controlShadowColor))]
        #[unsafe(method_family = none)]
        pub fn controlShadowColor() -> Retained<NSColor>;

        /// Historically used as the outer border shadow color for beveled buttons. No longer used.
        #[deprecated = "Use a color that matches the semantics being used, such as `separatorColor`"]
        #[unsafe(method(controlDarkShadowColor))]
        #[unsafe(method_family = none)]
        pub fn controlDarkShadowColor() -> Retained<NSColor>;

        /// Historically used as the color of scroll bars. No longer used.
        #[deprecated = "Use NSScroller instead"]
        #[unsafe(method(scrollBarColor))]
        #[unsafe(method_family = none)]
        pub fn scrollBarColor() -> Retained<NSColor>;

        /// Historically used as the color of scroll bar knobs. No longer used.
        #[deprecated = "Use NSScroller instead"]
        #[unsafe(method(knobColor))]
        #[unsafe(method_family = none)]
        pub fn knobColor() -> Retained<NSColor>;

        /// Historically used as the color of scroll bar knobs being dragged. No longer used.
        #[deprecated = "Use NSScroller instead"]
        #[unsafe(method(selectedKnobColor))]
        #[unsafe(method_family = none)]
        pub fn selectedKnobColor() -> Retained<NSColor>;

        /// Historically used as the color of the window chrome, which is no longer able to be represented by a color. No longer used.
        #[deprecated = "Use NSVisualEffectMaterialTitlebar"]
        #[unsafe(method(windowFrameColor))]
        #[unsafe(method_family = none)]
        pub fn windowFrameColor() -> Retained<NSColor>;

        /// Historically used as the color of selected menu items, which is no longer a color but a tinted blur effect. No longer used.
        #[deprecated = "Use NSVisualEffectMaterialSelection"]
        #[unsafe(method(selectedMenuItemColor))]
        #[unsafe(method_family = none)]
        pub fn selectedMenuItemColor() -> Retained<NSColor>;

        /// Historically used as the color of table headers, which is no longer a color but a tinted blur effect.
        #[deprecated = "Use NSVisualEffectMaterialHeaderView"]
        #[unsafe(method(headerColor))]
        #[unsafe(method_family = none)]
        pub fn headerColor() -> Retained<NSColor>;

        /// The background color of selected content or text that is unemphasized. Older alias for +unemphasizedSelectedContentBackgroundColor and +unemphasizedSelectedTextBackgroundColor
        #[deprecated]
        #[unsafe(method(secondarySelectedControlColor))]
        #[unsafe(method_family = none)]
        pub fn secondarySelectedControlColor() -> Retained<NSColor>;

        /// The background color of selected and emphasized (focused) content: table views rows, collection views, etc. Older alias for +selectedContentBackgroundColor
        #[deprecated]
        #[unsafe(method(alternateSelectedControlColor))]
        #[unsafe(method_family = none)]
        pub fn alternateSelectedControlColor() -> Retained<NSColor>;

        /// The background colors for alternating content items: such as table view rows, collection view items. Older alias for +alternatingContentBackgroundColors
        #[deprecated]
        #[unsafe(method(controlAlternatingRowBackgroundColors))]
        #[unsafe(method_family = none)]
        pub fn controlAlternatingRowBackgroundColors() -> Retained<NSArray<NSColor>>;

        #[cfg(feature = "NSGraphics")]
        #[deprecated = "Use -type and NSColorType instead"]
        #[unsafe(method(colorSpaceName))]
        #[unsafe(method_family = none)]
        pub fn colorSpaceName(&self) -> Retained<NSColorSpaceName>;

        #[cfg(feature = "NSGraphics")]
        /// # Safety
        ///
        /// `device_description` generic should be of the correct type.
        #[deprecated = "Use -colorUsingType: or -colorUsingColorSpace: instead"]
        #[unsafe(method(colorUsingColorSpaceName:device:))]
        #[unsafe(method_family = none)]
        pub unsafe fn colorUsingColorSpaceName_device(
            &self,
            name: Option<&NSColorSpaceName>,
            device_description: Option<&NSDictionary<NSDeviceDescriptionKey, AnyObject>>,
        ) -> Option<Retained<NSColor>>;

        #[cfg(feature = "NSGraphics")]
        #[deprecated = "Use -colorUsingType: or -colorUsingColorSpace: instead"]
        #[unsafe(method(colorUsingColorSpaceName:))]
        #[unsafe(method_family = none)]
        pub fn colorUsingColorSpaceName(
            &self,
            name: &NSColorSpaceName,
        ) -> Option<Retained<NSColor>>;
    );
}

/// NSQuartzCoreAdditions.
impl NSColor {
    extern_methods!(
        #[cfg(feature = "objc2-core-image")]
        #[cfg(target_vendor = "apple")]
        #[unsafe(method(colorWithCIColor:))]
        #[unsafe(method_family = none)]
        pub fn colorWithCIColor(color: &CIColor) -> Retained<NSColor>;
    );
}

mod private_CIColorNSAppKitAdditions {
    pub trait Sealed {}
}

/// Category "NSAppKitAdditions" on [`CIColor`].
#[doc(alias = "NSAppKitAdditions")]
pub unsafe trait CIColorNSAppKitAdditions:
    ClassType + Sized + private_CIColorNSAppKitAdditions::Sealed
{
    extern_methods!(
        #[unsafe(method(initWithColor:))]
        #[unsafe(method_family = init)]
        fn initWithColor(this: Allocated<Self>, color: &NSColor) -> Option<Retained<Self>>;
    );
}

#[cfg(feature = "objc2-core-image")]
#[cfg(target_vendor = "apple")]
impl private_CIColorNSAppKitAdditions::Sealed for CIColor {}
#[cfg(feature = "objc2-core-image")]
#[cfg(target_vendor = "apple")]
unsafe impl CIColorNSAppKitAdditions for CIColor {}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssystemcolorsdidchangenotification?language=objc)
    pub static NSSystemColorsDidChangeNotification: &'static NSNotificationName;
}
