/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.jfr;

import java.lang.management.ManagementPermission;
import java.security.Permission;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import jdk.jfr.internal.management.ManagementSupport;

final class MBeanUtils {
    private static final Permission monitor = new ManagementPermission("monitor");
    private static final Permission control = new ManagementPermission("control");

    MBeanUtils() {
    }

    static ObjectName createObjectName() {
        try {
            return new ObjectName("jdk.management.jfr:type=FlightRecorder");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new Error("Can't happen", malformedObjectNameException);
        }
    }

    static void checkControl() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(control);
        }
    }

    static void checkMonitor() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(monitor);
        }
    }

    static <T, R> List<R> transformList(List<T> list, Function<T, R> function) {
        return list.stream().map(function).collect(Collectors.toList());
    }

    static boolean booleanValue(String string) {
        if ("true".equals(string)) {
            return true;
        }
        if ("false".equals(string)) {
            return false;
        }
        throw new IllegalArgumentException("Value must be true or false.");
    }

    static Duration duration(String string) throws NumberFormatException {
        if (string == null) {
            return null;
        }
        long l = ManagementSupport.parseTimespan(string);
        if (l == 0L) {
            return null;
        }
        return Duration.ofNanos(l);
    }

    public static Instant parseTimestamp(String string, Instant instant) {
        if (string == null) {
            return instant;
        }
        try {
            return Instant.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                return Instant.ofEpochMilli(Long.parseLong(string));
            }
            catch (NumberFormatException | DateTimeException runtimeException) {
                throw new IllegalArgumentException("Not a valid timestamp " + string);
            }
        }
    }

    static Long size(String string) throws NumberFormatException {
        long l = Long.parseLong(string);
        if (l < 0L) {
            throw new IllegalArgumentException("Negative size not allowed");
        }
        return l;
    }

    public static int parseBlockSize(String string, int n) {
        if (string == null) {
            return n;
        }
        int n2 = Integer.parseInt(string);
        if (n2 < 1) {
            throw new IllegalArgumentException("Block size must be at least 1 byte");
        }
        return n2;
    }
}

