/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaIcon;
import com.apple.laf.ScreenMenuItem;
import com.apple.laf.ScreenMenuItemCheckbox;
import com.apple.laf.ScreenMenuPropertyHandler;
import com.apple.laf.ScreenMenuPropertyListener;
import java.awt.Component;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.peer.MenuComponentPeer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import sun.awt.SunToolkit;
import sun.lwawt.LWToolkit;
import sun.lwawt.macosx.CMenu;
import sun.lwawt.macosx.CMenuItem;
import sun.lwawt.macosx.LWCToolkit;

final class ScreenMenu
extends Menu
implements ContainerListener,
ComponentListener,
ScreenMenuPropertyHandler {
    private transient long fModelPtr;
    private final Hashtable<Component, MenuItem> fItems;
    private final JMenu fInvoker;
    private Component fLastMouseEventTarget;
    private Rectangle fLastTargetRect;
    private volatile Rectangle[] fItemBounds;
    private ScreenMenuPropertyListener fPropertyListener;
    private int[] childHashArray;

    private static native long addMenuListeners(ScreenMenu var0, long var1);

    private static native void removeMenuListeners(long var0);

    ScreenMenu(JMenu jMenu) {
        super(jMenu.getText());
        this.fInvoker = jMenu;
        int n = this.fInvoker.getMenuComponentCount();
        if (n < 5) {
            n = 5;
        }
        this.fItems = new Hashtable(n);
        this.setEnabled(this.fInvoker.isEnabled());
        this.updateItems();
    }

    private static boolean needsUpdate(Component[] componentArray, int[] nArray) {
        if (componentArray == null || nArray == null) {
            return true;
        }
        if (nArray.length != componentArray.length) {
            return true;
        }
        for (int i = 0; i < componentArray.length; ++i) {
            int n = ScreenMenu.getHashCode(componentArray[i]);
            if (n == nArray[i]) continue;
            return true;
        }
        return false;
    }

    private void updateItems() {
        int n = this.fInvoker.getMenuComponentCount();
        Component[] componentArray = this.fInvoker.getMenuComponents();
        if (ScreenMenu.needsUpdate(componentArray, this.childHashArray)) {
            this.removeAll();
            this.fItems.clear();
            if (n <= 0) {
                return;
            }
            this.childHashArray = new int[n];
            for (int i = 0; i < n; ++i) {
                this.addItem(componentArray[i]);
                this.childHashArray[i] = ScreenMenu.getHashCode(componentArray[i]);
            }
        }
    }

    public void invokeOpenLater() {
        final JMenu jMenu = this.fInvoker;
        if (jMenu == null) {
            System.err.println("invoker is null!");
            return;
        }
        try {
            LWCToolkit.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jMenu.setSelected(true);
                    jMenu.validate();
                    ScreenMenu.this.updateItems();
                    ScreenMenu.access$102(ScreenMenu.this, new Rectangle[jMenu.getMenuComponentCount()]);
                }
            }, (Component)jMenu);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    public void invokeMenuClosing() {
        final JMenu jMenu = this.fInvoker;
        if (jMenu == null) {
            return;
        }
        try {
            LWCToolkit.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jMenu.setSelected(false);
                    if (ScreenMenu.this.fItemBounds != null) {
                        for (int i = 0; i < ScreenMenu.this.fItemBounds.length; ++i) {
                            ((ScreenMenu)ScreenMenu.this).fItemBounds[i] = null;
                        }
                    }
                    ScreenMenu.access$102(ScreenMenu.this, null);
                }
            }, (Component)jMenu);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void handleItemTargeted(int n, int n2, int n3, int n4, int n5) {
        Rectangle rectangle;
        if (this.fItemBounds == null || n < 0 || n > this.fItemBounds.length - 1) {
            return;
        }
        this.fItemBounds[n] = rectangle = new Rectangle(n3, n2, n5 - n3, n4 - n2);
    }

    public void handleMouseEvent(final int n, final int n2, final int n3, final int n4, final long l) {
        if (n == 0) {
            return;
        }
        if (this.fItemBounds == null) {
            return;
        }
        SunToolkit.executeOnEventHandlerThread(this.fInvoker, new Runnable(){

            @Override
            public void run() {
                Component component = null;
                Rectangle rectangle = null;
                for (int i = 0; i < ScreenMenu.this.fItemBounds.length; ++i) {
                    Rectangle rectangle2 = ScreenMenu.this.fItemBounds[i];
                    if (rectangle2 == null || !rectangle2.contains(n2, n3)) continue;
                    component = ScreenMenu.this.fInvoker.getMenuComponent(i);
                    rectangle = rectangle2;
                    break;
                }
                if (component == null && ScreenMenu.this.fLastMouseEventTarget == null) {
                    return;
                }
                if (component != ScreenMenu.this.fLastMouseEventTarget) {
                    if (ScreenMenu.this.fLastMouseEventTarget != null) {
                        LWToolkit.postEvent(new MouseEvent(ScreenMenu.this.fLastMouseEventTarget, 505, l, n4, n2 - ((ScreenMenu)ScreenMenu.this).fLastTargetRect.x, n3 - ((ScreenMenu)ScreenMenu.this).fLastTargetRect.y, 0, false));
                    }
                    if (component != null) {
                        LWToolkit.postEvent(new MouseEvent(component, 504, l, n4, n2 - rectangle.x, n3 - rectangle.y, 0, false));
                    }
                    ScreenMenu.this.fLastMouseEventTarget = component;
                    ScreenMenu.this.fLastTargetRect = rectangle;
                }
                if (component == null) {
                    return;
                }
                LWToolkit.postEvent(new MouseEvent(component, n, l, n4, n2 - rectangle.x, n3 - rectangle.y, 0, false));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.addNotify();
            if (this.fModelPtr == 0L) {
                MenuComponentPeer menuComponentPeer;
                String string;
                this.fInvoker.getPopupMenu().addContainerListener(this);
                this.fInvoker.addComponentListener(this);
                this.fPropertyListener = new ScreenMenuPropertyListener(this);
                this.fInvoker.addPropertyChangeListener(this.fPropertyListener);
                Icon icon = this.fInvoker.getIcon();
                if (icon != null) {
                    this.setIcon(icon);
                }
                if ((string = this.fInvoker.getToolTipText()) != null) {
                    this.setToolTipText(string);
                }
                if ((menuComponentPeer = this.getPeer()) instanceof CMenu) {
                    CMenu cMenu = (CMenu)menuComponentPeer;
                    long l = cMenu.getNativeMenu();
                    this.fModelPtr = ScreenMenu.addMenuListeners(this, l);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.removeNotify();
            this.fItems.clear();
            if (this.fModelPtr != 0L) {
                ScreenMenu.removeMenuListeners(this.fModelPtr);
                this.fModelPtr = 0L;
                this.fInvoker.getPopupMenu().removeContainerListener(this);
                this.fInvoker.removeComponentListener(this);
                this.fInvoker.removePropertyChangeListener(this.fPropertyListener);
            }
        }
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        this.addItem(containerEvent.getChild());
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        MenuItem menuItem = this.fItems.remove(component);
        if (menuItem == null) {
            return;
        }
        this.remove(menuItem);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.setVisible(true);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.setVisible(false);
    }

    private void setVisible(boolean bl) {
        MenuContainer menuContainer = this.getParent();
        if (menuContainer != null && menuContainer instanceof ScreenMenu) {
            ScreenMenu screenMenu = (ScreenMenu)menuContainer;
            screenMenu.setChildVisible(this.fInvoker, bl);
        }
    }

    @Override
    public void setChildVisible(JMenuItem jMenuItem, boolean bl) {
        this.fItems.remove(jMenuItem);
        this.updateItems();
    }

    @Override
    public void setAccelerator(KeyStroke keyStroke) {
    }

    @Override
    public void setIndeterminate(boolean bl) {
    }

    @Override
    public void setToolTipText(String string) {
        MenuComponentPeer menuComponentPeer = this.getPeer();
        if (!(menuComponentPeer instanceof CMenuItem)) {
            return;
        }
        CMenuItem cMenuItem = (CMenuItem)menuComponentPeer;
        cMenuItem.setToolTipText(string);
    }

    @Override
    public void setIcon(Icon icon) {
        MenuComponentPeer menuComponentPeer = this.getPeer();
        if (!(menuComponentPeer instanceof CMenuItem)) {
            return;
        }
        CMenuItem cMenuItem = (CMenuItem)menuComponentPeer;
        Image image = null;
        if (icon != null && icon.getIconWidth() > 0 && icon.getIconHeight() > 0) {
            image = AquaIcon.getImageForIcon(icon);
        }
        cMenuItem.setImage(image);
    }

    private static int getHashCode(Component component) {
        int n = component.hashCode();
        if (component instanceof JMenuItem) {
            KeyStroke keyStroke;
            Action action;
            Icon icon;
            Icon icon2;
            JMenuItem jMenuItem = (JMenuItem)component;
            String string = jMenuItem.getText();
            if (string != null) {
                n ^= string.hashCode();
            }
            if ((icon2 = jMenuItem.getIcon()) != null) {
                n ^= icon2.hashCode();
            }
            if ((icon = jMenuItem.getDisabledIcon()) != null) {
                n ^= icon.hashCode();
            }
            if ((action = jMenuItem.getAction()) != null) {
                n ^= action.hashCode();
            }
            if ((keyStroke = jMenuItem.getAccelerator()) != null) {
                n ^= keyStroke.hashCode();
            }
            n ^= Boolean.valueOf(jMenuItem.isVisible()).hashCode();
            n ^= Boolean.valueOf(jMenuItem.isEnabled()).hashCode();
            n ^= Boolean.valueOf(jMenuItem.isSelected()).hashCode();
        } else if (component instanceof JSeparator) {
            n ^= "-".hashCode();
        }
        return n;
    }

    private void addItem(Component component) {
        if (!component.isVisible()) {
            return;
        }
        MenuItem menuItem = this.fItems.get(component);
        if (menuItem == null) {
            if (component instanceof JMenu) {
                menuItem = new ScreenMenu((JMenu)component);
            } else if (component instanceof JCheckBoxMenuItem) {
                menuItem = new ScreenMenuItemCheckbox((JCheckBoxMenuItem)component);
            } else if (component instanceof JRadioButtonMenuItem) {
                menuItem = new ScreenMenuItemCheckbox((JRadioButtonMenuItem)component);
            } else if (component instanceof JMenuItem) {
                menuItem = new ScreenMenuItem((JMenuItem)component);
            } else if (component instanceof JPopupMenu.Separator || component instanceof JSeparator) {
                menuItem = new MenuItem("-");
            }
            if (menuItem != null) {
                this.fItems.put(component, menuItem);
            }
        }
        if (menuItem != null) {
            this.add(menuItem);
        }
    }

    static /* synthetic */ Rectangle[] access$102(ScreenMenu screenMenu, Rectangle[] rectangleArray) {
        screenMenu.fItemBounds = rectangleArray;
        return rectangleArray;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("awt");
                return null;
            }
        });
    }
}

