/*
 * Decompiled with CFR 0.152.
 */
package net.dot.android.crypto;

import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.X509KeyManager;

public final class DotnetX509KeyManager
implements X509KeyManager {
    private static final String CLIENT_CERTIFICATE_ALIAS = "DOTNET_SSLStream_ClientCertificateContext";
    private final PrivateKey privateKey;
    private final X509Certificate[] certificateChain;

    public DotnetX509KeyManager(KeyStore.PrivateKeyEntry privateKeyEntry) {
        if (privateKeyEntry == null) {
            throw new IllegalArgumentException("PrivateKeyEntry must not be null");
        }
        this.privateKey = privateKeyEntry.getPrivateKey();
        Certificate[] certificateArray = privateKeyEntry.getCertificateChain();
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        for (Certificate certificate : certificateArray) {
            if (!(certificate instanceof X509Certificate)) continue;
            arrayList.add((X509Certificate)certificate);
        }
        if (arrayList.size() == 0) {
            throw new IllegalArgumentException("No valid X509 certificates found in the chain");
        }
        this.certificateChain = arrayList.toArray(new X509Certificate[0]);
    }

    @Override
    public String[] getClientAliases(String string, Principal[] principalArray) {
        return new String[]{CLIENT_CERTIFICATE_ALIAS};
    }

    @Override
    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        return CLIENT_CERTIFICATE_ALIAS;
    }

    @Override
    public String[] getServerAliases(String string, Principal[] principalArray) {
        return new String[0];
    }

    @Override
    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        return this.certificateChain;
    }

    @Override
    public PrivateKey getPrivateKey(String string) {
        return this.privateKey;
    }
}

