/*
  Copyright (C) 2022 Ángel Ruiz Fernández

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation, version 3.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this program.  If not, see
  <http://www.gnu.org/licenses/>
*/

#ifndef _UTIL_UNISTD_H
#define _UTIL_UNISTD_H

#include <unistd.h>

#include "win32-fcntl.h"

#ifndef _SC_NPROCESSORS_ONLN
#  define _SC_NPROCESSORS_ONLN 84
#endif /* _SC_NPROCESSORS_ONLN */

#define pipe(fds) _pipe(fds, 4096, _O_BINARY)

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

long sysconf(int name);
int getpagesize();

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _UTIL_UNISTD_H */
