SYD-X(1)

# NAME

*syd-x* - Check executability of files, list executables of processes

# SYNOPSIS

*syd-x* _[-hcv]_ _[-l pid...]_ _[files...]_

# DESCRIPTION

*syd-x* checks executability of the given files or lists executables of
the given processes. The file executability check uses the _execveat_(2)
system call with the flag "AT_EXECVE_CHECK" on Linux>=6.14 and falls
back to the _faccessat_(2) system call with the flag "X_OK" on older
Linux.  If the _-l_ option is specified, list mode is activated: all
following arguments are interpreted as process IDs, not files. In list
mode, executable file listing is done using the "PROCMAP_QUERY"
_ioctl_(2) request on Linux>=6.11 and falls back to parsing the
_proc_pid_maps_(5) file textually on older Linux.

# OPTIONS

|[ *-h*
:< Display help.
|[ *-c*
:< Exit with success if the "AT_EXECVE_CHECK" flag is supported.
|[ *-l* _pid_
:< Specify a process ID to list the executables of, may be repeated.
|[ *-v*
:< Print file check status information on standard error.

# EXIT STATUS

*syd-x* exits with 0 on success or with the errno number on failure.

# SEE ALSO

_syd_(1), _syd_(2), _syd_(5)

- *syd* homepage: https://sydbox.exherbo.org/
- Executability check: https://docs.kernel.org/next/userspace-api/check_exec.html

# AUTHORS

Maintained by Ali Polatel. Up-to-date sources can be found at
https://gitlab.exherbo.org/sydbox/sydbox.git and bugs/patches can be
submitted to https://gitlab.exherbo.org/groups/sydbox/-/issues. Discuss
in #sydbox on Libera Chat or in #sydbox:mailstation.de on Matrix.
