/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.EdtReplacementThread;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.EdtInvocationManager;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J+\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J)\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\r0\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\nH\u0007J!\u0010\u0018\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\r0\u001aH\u0007\u00a2\u0006\u0002\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/application/ex/ApplicationUtil;", "", "()V", "invokeAndWaitSomewhere", "", "thread", "Lcom/intellij/openapi/application/EdtReplacementThread;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "r", "Ljava/lang/Runnable;", "invokeLaterSomewhere", "runWithCheckCanceled", "T", "callable", "Ljava/util/concurrent/Callable;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Ljava/util/concurrent/Callable;Lcom/intellij/openapi/progress/ProgressIndicator;)Ljava/lang/Object;", "future", "Ljava/util/concurrent/Future;", "(Ljava/util/concurrent/Future;Lcom/intellij/openapi/progress/ProgressIndicator;)Ljava/lang/Object;", "showDialogAfterWriteAction", "runnable", "tryRunReadAction", "computable", "Lcom/intellij/openapi/util/Computable;", "(Lcom/intellij/openapi/util/Computable;)Ljava/lang/Object;", "CannotRunReadActionException", "intellij.platform.core.impl"})
public final class ApplicationUtil {
    @NotNull
    public static final ApplicationUtil INSTANCE = new ApplicationUtil();

    private ApplicationUtil() {
    }

    @JvmStatic
    public static final void invokeLaterSomewhere(@NotNull EdtReplacementThread thread, @NotNull ModalityState modalityState, @NotNull Runnable r2) {
        Intrinsics.checkNotNullParameter((Object)thread, "thread");
        Intrinsics.checkNotNullParameter(modalityState, "modalityState");
        Intrinsics.checkNotNullParameter(r2, "r");
        switch (WhenMappings.$EnumSwitchMapping$0[thread.ordinal()]) {
            case 1: {
                SwingUtilities.invokeLater(r2);
                break;
            }
            case 2: {
                ApplicationManager.getApplication().invokeLaterOnWriteThread(r2, modalityState);
                break;
            }
            case 3: {
                ApplicationManager.getApplication().invokeLater(r2, modalityState);
            }
        }
    }

    @JvmStatic
    public static final void invokeAndWaitSomewhere(@NotNull EdtReplacementThread thread, @NotNull ModalityState modalityState, @NotNull Runnable r2) {
        Intrinsics.checkNotNullParameter((Object)thread, "thread");
        Intrinsics.checkNotNullParameter(modalityState, "modalityState");
        Intrinsics.checkNotNullParameter(r2, "r");
        switch (WhenMappings.$EnumSwitchMapping$0[thread.ordinal()]) {
            case 1: {
                if (!SwingUtilities.isEventDispatchThread() && ApplicationManager.getApplication().isWriteIntentLockAcquired()) {
                    Logger.getInstance(ApplicationUtil.class).error("Can't invokeAndWait from WT to EDT: probably leads to deadlock");
                }
                EdtInvocationManager.invokeAndWaitIfNeeded(r2);
                break;
            }
            case 2: {
                if (ApplicationManager.getApplication().isWriteIntentLockAcquired()) {
                    r2.run();
                    break;
                }
                if (SwingUtilities.isEventDispatchThread()) {
                    Logger.getInstance(ApplicationUtil.class).error("Can't invokeAndWait from EDT to WT");
                    break;
                }
                Semaphore s2 = new Semaphore(1);
                AtomicReference throwable = new AtomicReference();
                ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> ApplicationUtil.invokeAndWaitSomewhere$lambda$4(r2, throwable, s2), modalityState);
                s2.waitFor();
                if (throwable.get() == null) break;
                ExceptionUtil.rethrow((Throwable)throwable.get());
                break;
            }
            case 3: {
                if (!SwingUtilities.isEventDispatchThread() && ApplicationManager.getApplication().isWriteIntentLockAcquired()) {
                    Logger.getInstance(ApplicationUtil.class).error("Can't invokeAndWait from WT to EDT: probably leads to deadlock");
                }
                ApplicationManager.getApplication().invokeAndWait(r2, modalityState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void invokeAndWaitSomewhere$lambda$4(Runnable $r, AtomicReference $throwable, Semaphore $s) {
        Intrinsics.checkNotNullParameter($r, "$r");
        Intrinsics.checkNotNullParameter($throwable, "$throwable");
        Intrinsics.checkNotNullParameter($s, "$s");
        try {
            $r.run();
        }
        catch (Throwable t2) {
            $throwable.set(t2);
        }
        finally {
            $s.up();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EdtReplacementThread.values().length];
            try {
                nArray[EdtReplacementThread.EDT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EdtReplacementThread.WT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EdtReplacementThread.EDT_WITH_IW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

