/*
 * Decompiled with CFR 0.152.
 */
package kotlin.metadata.internal.protobuf;

import kotlin.metadata.internal.protobuf.ByteString;

public final class WireFormat {
    static final int MESSAGE_SET_ITEM_TAG = WireFormat.makeTag(1, 3);
    static final int MESSAGE_SET_ITEM_END_TAG = WireFormat.makeTag(1, 4);
    static final int MESSAGE_SET_TYPE_ID_TAG = WireFormat.makeTag(2, 0);
    static final int MESSAGE_SET_MESSAGE_TAG = WireFormat.makeTag(3, 2);

    static int getTagWireType(int tag) {
        return tag & 7;
    }

    public static int getTagFieldNumber(int tag) {
        return tag >>> 3;
    }

    static int makeTag(int fieldNumber, int wireType) {
        return fieldNumber << 3 | wireType;
    }

    public static class FieldType
    extends Enum<FieldType> {
        public static final /* enum */ FieldType DOUBLE = new FieldType(JavaType.DOUBLE, 1);
        public static final /* enum */ FieldType FLOAT = new FieldType(JavaType.FLOAT, 5);
        public static final /* enum */ FieldType INT64 = new FieldType(JavaType.LONG, 0);
        public static final /* enum */ FieldType UINT64 = new FieldType(JavaType.LONG, 0);
        public static final /* enum */ FieldType INT32 = new FieldType(JavaType.INT, 0);
        public static final /* enum */ FieldType FIXED64 = new FieldType(JavaType.LONG, 1);
        public static final /* enum */ FieldType FIXED32 = new FieldType(JavaType.INT, 5);
        public static final /* enum */ FieldType BOOL = new FieldType(JavaType.BOOLEAN, 0);
        public static final /* enum */ FieldType STRING = new FieldType(JavaType.STRING, 2){

            @Override
            public boolean isPackable() {
                return false;
            }
        };
        public static final /* enum */ FieldType GROUP = new FieldType(JavaType.MESSAGE, 3){

            @Override
            public boolean isPackable() {
                return false;
            }
        };
        public static final /* enum */ FieldType MESSAGE = new FieldType(JavaType.MESSAGE, 2){

            @Override
            public boolean isPackable() {
                return false;
            }
        };
        public static final /* enum */ FieldType BYTES = new FieldType(JavaType.BYTE_STRING, 2){

            @Override
            public boolean isPackable() {
                return false;
            }
        };
        public static final /* enum */ FieldType UINT32 = new FieldType(JavaType.INT, 0);
        public static final /* enum */ FieldType ENUM = new FieldType(JavaType.ENUM, 0);
        public static final /* enum */ FieldType SFIXED32 = new FieldType(JavaType.INT, 5);
        public static final /* enum */ FieldType SFIXED64 = new FieldType(JavaType.LONG, 1);
        public static final /* enum */ FieldType SINT32 = new FieldType(JavaType.INT, 0);
        public static final /* enum */ FieldType SINT64 = new FieldType(JavaType.LONG, 0);
        private final JavaType javaType;
        private final int wireType;
        private static final /* synthetic */ FieldType[] $VALUES;

        public static FieldType[] values() {
            return (FieldType[])$VALUES.clone();
        }

        private FieldType(JavaType javaType, int wireType) {
            this.javaType = javaType;
            this.wireType = wireType;
        }

        public JavaType getJavaType() {
            return this.javaType;
        }

        public int getWireType() {
            return this.wireType;
        }

        public boolean isPackable() {
            return true;
        }

        static {
            $VALUES = new FieldType[]{DOUBLE, FLOAT, INT64, UINT64, INT32, FIXED64, FIXED32, BOOL, STRING, GROUP, MESSAGE, BYTES, UINT32, ENUM, SFIXED32, SFIXED64, SINT32, SINT64};
        }
    }

    public static final class JavaType
    extends Enum<JavaType> {
        public static final /* enum */ JavaType INT = new JavaType(0);
        public static final /* enum */ JavaType LONG = new JavaType(0L);
        public static final /* enum */ JavaType FLOAT = new JavaType(Float.valueOf(0.0f));
        public static final /* enum */ JavaType DOUBLE = new JavaType(0.0);
        public static final /* enum */ JavaType BOOLEAN = new JavaType(false);
        public static final /* enum */ JavaType STRING = new JavaType("");
        public static final /* enum */ JavaType BYTE_STRING = new JavaType(ByteString.EMPTY);
        public static final /* enum */ JavaType ENUM = new JavaType(null);
        public static final /* enum */ JavaType MESSAGE = new JavaType(null);
        private final Object defaultDefault;
        private static final /* synthetic */ JavaType[] $VALUES;

        public static JavaType[] values() {
            return (JavaType[])$VALUES.clone();
        }

        private JavaType(Object defaultDefault) {
            this.defaultDefault = defaultDefault;
        }

        static {
            $VALUES = new JavaType[]{INT, LONG, FLOAT, DOUBLE, BOOLEAN, STRING, BYTE_STRING, ENUM, MESSAGE};
        }
    }
}

