/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.ObjectContributorManager;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.decorators.DecorationBuilder;
import org.eclipse.ui.internal.decorators.DecorationResult;
import org.eclipse.ui.internal.decorators.DecoratorDefinition;
import org.eclipse.ui.internal.decorators.DecoratorManager;
import org.eclipse.ui.internal.decorators.LightweightDecoratorDefinition;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.util.Util;

public class LightweightDecoratorManager
extends ObjectContributorManager {
    private final LightweightRunnable runnable = new LightweightRunnable();
    private LightweightDecoratorDefinition[] lightweightDefinitions;
    private static final LightweightDecoratorDefinition[] EMPTY_LIGHTWEIGHT_DEF = new LightweightDecoratorDefinition[0];

    LightweightDecoratorManager(LightweightDecoratorDefinition[] definitions) {
        this.lightweightDefinitions = definitions;
        this.buildContributors();
    }

    LightweightDecoratorDefinition[] getDefinitions() {
        return this.lightweightDefinitions;
    }

    private void buildContributors() {
        LightweightDecoratorDefinition[] lightweightDecoratorDefinitionArray = this.lightweightDefinitions;
        int n = this.lightweightDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            LightweightDecoratorDefinition decorator = lightweightDecoratorDefinitionArray[n2];
            String[] stringArray = this.getTargetTypes(decorator);
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String type = stringArray[n4];
                this.registerContributor(decorator, type);
                ++n4;
            }
            ++n2;
        }
    }

    public boolean addDecorator(LightweightDecoratorDefinition decorator) {
        if (this.getLightweightDecoratorDefinition(decorator.getId()) == null) {
            String[] types;
            LightweightDecoratorDefinition[] oldDefs = this.lightweightDefinitions;
            this.lightweightDefinitions = new LightweightDecoratorDefinition[this.lightweightDefinitions.length + 1];
            System.arraycopy(oldDefs, 0, this.lightweightDefinitions, 0, oldDefs.length);
            this.lightweightDefinitions[oldDefs.length] = decorator;
            String[] stringArray = types = this.getTargetTypes(decorator);
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                this.registerContributor(decorator, type);
                ++n2;
            }
            return true;
        }
        return false;
    }

    private String[] getTargetTypes(LightweightDecoratorDefinition decorator) {
        return decorator.getObjectClasses();
    }

    public boolean removeDecorator(LightweightDecoratorDefinition decorator) {
        int idx = this.getLightweightDecoratorDefinitionIdx(decorator.getId());
        if (idx != -1) {
            Object[] oldDefs = this.lightweightDefinitions;
            this.lightweightDefinitions = new LightweightDecoratorDefinition[this.lightweightDefinitions.length - 1];
            Util.arrayCopyWithRemoval(oldDefs, this.lightweightDefinitions, idx);
            String[] stringArray = this.getTargetTypes(decorator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                this.unregisterContributor(decorator, type);
                ++n2;
            }
            return true;
        }
        return false;
    }

    private LightweightDecoratorDefinition getLightweightDecoratorDefinition(String decoratorId) {
        int idx = this.getLightweightDecoratorDefinitionIdx(decoratorId);
        if (idx != -1) {
            return this.lightweightDefinitions[idx];
        }
        return null;
    }

    private int getLightweightDecoratorDefinitionIdx(String decoratorId) {
        int i = 0;
        while (i < this.lightweightDefinitions.length) {
            if (this.lightweightDefinitions[i].getId().equals(decoratorId)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    LightweightDecoratorDefinition[] enabledDefinitions() {
        ArrayList<LightweightDecoratorDefinition> result = new ArrayList<LightweightDecoratorDefinition>();
        LightweightDecoratorDefinition[] lightweightDecoratorDefinitionArray = this.lightweightDefinitions;
        int n = this.lightweightDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            LightweightDecoratorDefinition lightweightDefinition = lightweightDecoratorDefinitionArray[n2];
            if (lightweightDefinition.isEnabled()) {
                result.add(lightweightDefinition);
            }
            ++n2;
        }
        LightweightDecoratorDefinition[] returnArray = new LightweightDecoratorDefinition[result.size()];
        result.toArray(returnArray);
        return returnArray;
    }

    boolean hasEnabledDefinitions() {
        LightweightDecoratorDefinition[] lightweightDecoratorDefinitionArray = this.lightweightDefinitions;
        int n = this.lightweightDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            LightweightDecoratorDefinition lightweightDefinition = lightweightDecoratorDefinitionArray[n2];
            if (lightweightDefinition.isEnabled()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    void reset() {
        this.runnable.clearReferences();
    }

    void shutdown() {
        LightweightDecoratorDefinition[] lightweightDecoratorDefinitionArray = this.lightweightDefinitions;
        int n = this.lightweightDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            LightweightDecoratorDefinition lightweightDefinition = lightweightDecoratorDefinitionArray[n2];
            if (lightweightDefinition.isEnabled()) {
                lightweightDefinition.setEnabled(false);
            }
            ++n2;
        }
    }

    LightweightDecoratorDefinition getDecoratorDefinition(String decoratorId) {
        LightweightDecoratorDefinition[] lightweightDecoratorDefinitionArray = this.lightweightDefinitions;
        int n = this.lightweightDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            LightweightDecoratorDefinition lightweightDefinition = lightweightDecoratorDefinitionArray[n2];
            if (lightweightDefinition.getId().equals(decoratorId)) {
                return lightweightDefinition;
            }
            ++n2;
        }
        return null;
    }

    LightweightDecoratorDefinition[] getDecoratorsFor(Object element) {
        Collection<DecoratorDefinition> decorators;
        if (element == null) {
            return EMPTY_LIGHTWEIGHT_DEF;
        }
        ArrayList<Object> elements = new ArrayList<Object>(1);
        elements.add(element);
        LightweightDecoratorDefinition[] decoratorArray = EMPTY_LIGHTWEIGHT_DEF;
        List contributors = this.getContributors(elements);
        if (!contributors.isEmpty() && (decorators = DecoratorManager.getDecoratorsFor(element, contributors.toArray(new DecoratorDefinition[contributors.size()]))).size() > 0) {
            decoratorArray = new LightweightDecoratorDefinition[decorators.size()];
            decorators.toArray(decoratorArray);
        }
        return decoratorArray;
    }

    public void getDecorations(Object element, DecorationBuilder decoration) {
        LightweightDecoratorDefinition[] lightweightDecoratorDefinitionArray = this.getDecoratorsFor(element);
        int n = lightweightDecoratorDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            LightweightDecoratorDefinition decorator = lightweightDecoratorDefinitionArray[n2];
            decoration.setCurrentDefinition(decorator);
            this.decorate(element, decoration, decorator);
            ++n2;
        }
    }

    private void decorate(Object element, DecorationBuilder decoration, LightweightDecoratorDefinition decorator) {
        this.runnable.setValues(element, decoration, decorator);
        SafeRunner.run((ISafeRunnable)this.runnable);
    }

    public DecorationResult getDecorationResult(Object object) {
        DecorationBuilder builder = new DecorationBuilder();
        this.getDecorations(object, builder);
        return builder.createResult();
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
    }

    private static class LightweightRunnable
    implements ISafeRunnable {
        private volatile RunnableData data = new RunnableData(null, null, null);

        private LightweightRunnable() {
        }

        void setValues(Object object, DecorationBuilder builder, LightweightDecoratorDefinition definition) {
            this.data = new RunnableData(object, builder, definition);
        }

        public void handleException(Throwable exception) {
            String message;
            IStatus status = StatusUtil.newStatus(4, exception.getMessage(), exception);
            LightweightDecoratorDefinition decorator = this.data.decorator;
            if (decorator == null) {
                message = WorkbenchMessages.DecoratorError;
            } else {
                String name = decorator.getName();
                if (name == null) {
                    name = decorator.getId();
                }
                message = NLS.bind((String)WorkbenchMessages.DecoratorWillBeDisabled, (Object)name);
            }
            WorkbenchPlugin.log(message, status);
            if (decorator != null) {
                decorator.crashDisable();
            }
            this.clearReferences();
        }

        public void run() throws Exception {
            RunnableData data = this.data;
            if (data.isConsistent()) {
                data.decorator.decorate(data.element, data.builder);
            }
            this.clearReferences();
        }

        void clearReferences() {
            this.data = new RunnableData(null, null, null);
        }

        static class RunnableData {
            final DecorationBuilder builder;
            final LightweightDecoratorDefinition decorator;
            final Object element;

            public RunnableData(Object object, DecorationBuilder builder, LightweightDecoratorDefinition definition) {
                this.element = object;
                this.builder = builder;
                this.decorator = definition;
            }

            boolean isConsistent() {
                return this.builder != null && this.decorator != null && this.element != null;
            }
        }
    }
}

