/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;

public class CapturingContext {
    private static ThreadLocal<CapturingContext> activeContexts = new ThreadLocal();
    private int start;
    private int end;
    private Scope scope;
    private CapturingContext previous;
    private boolean isCaptureInProgress;

    private CapturingContext(int start, int end, Scope scope, CapturingContext previous) {
        this.start = start;
        this.end = end;
        this.scope = scope;
        this.previous = previous;
    }

    public static void enter(int start, int end, Scope scope) {
        activeContexts.set(new CapturingContext(start, end, scope, activeContexts.get()));
    }

    public static void leave() {
        CapturingContext inst = activeContexts.get();
        activeContexts.remove();
        if (inst != null && inst.previous != null) {
            activeContexts.set(inst.previous);
        }
    }

    public static ReferenceBinding maybeCapture(ReferenceBinding type) {
        if (type instanceof ParameterizedTypeBinding) {
            CapturingContext inst;
            ParameterizedTypeBinding ptb = (ParameterizedTypeBinding)type;
            if (!ptb.isCaptureInProgress && (inst = activeContexts.get()) != null && !inst.isCaptureInProgress) {
                try {
                    inst.isCaptureInProgress = true;
                    ParameterizedTypeBinding parameterizedTypeBinding = ptb.capture(inst.scope, inst.start, inst.end);
                    return parameterizedTypeBinding;
                }
                finally {
                    inst.isCaptureInProgress = false;
                }
            }
        }
        return type;
    }

    public static boolean isActive() {
        return activeContexts.get() != null;
    }
}

