/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.datastore.core.tests.historytree.overlapping;

import java.io.File;
import java.io.IOException;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.datastore.core.tests.historytree.AbstractHistoryTreeTestBase;
import org.eclipse.tracecompass.datastore.core.tests.historytree.HtTestUtils;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.overlapping.AbstractOverlappingHistoryTree;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.overlapping.OverlappingNode;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractOverlappingHistoryTreeTestBase<E extends IHTInterval, N extends OverlappingNode<E>>
extends AbstractHistoryTreeTestBase<E, N> {
    @Override
    protected abstract AbstractOverlappingHistoryTree<E, N> createHistoryTree(File var1, int var2, int var3, int var4, long var5) throws IOException;

    @Override
    protected abstract AbstractOverlappingHistoryTree<E, N> createHistoryTree(File var1, int var2) throws IOException;

    @Test
    public void testChildrenTimes() {
        AbstractOverlappingHistoryTree ht = (AbstractOverlappingHistoryTree)this.setupSmallTree();
        OverlappingNode node = ht.getLatestLeaf();
        long time = this.fillValues(ht, node.getNodeFreeSpace(), 1L);
        Assert.assertEquals((long)1L, (long)ht.getNodeCount());
        Assert.assertEquals((long)1L, (long)ht.getDepth());
        ht.insert(this.createInterval(time, time + 1L));
        Assert.assertEquals((long)3L, (long)ht.getNodeCount());
        Assert.assertEquals((long)2L, (long)ht.getDepth());
        OverlappingNode parent = ht.getLatestNode(0);
        Assert.assertEquals((long)time, (long)node.getNodeEnd());
        Assert.assertEquals((long)time, (long)parent.getChildEnd(0));
        Assert.assertEquals((long)node.getNodeStart(), (long)parent.getChildStart(0));
        node = ht.getLatestLeaf();
        ++time;
        time = this.fillValues(ht, node.getNodeFreeSpace(), time);
        ht.insert(this.createInterval(time, time + 1L));
        Assert.assertEquals((long)4L, (long)ht.getNodeCount());
        Assert.assertEquals((long)2L, (long)ht.getDepth());
        Assert.assertEquals((long)time, (long)node.getNodeEnd());
        Assert.assertEquals((long)time, (long)parent.getChildEnd(1));
        Assert.assertEquals((long)node.getNodeStart(), (long)parent.getChildStart(1));
        node = ht.getLatestLeaf();
        ++time;
        time = this.fillValues(ht, node.getNodeFreeSpace(), time);
        ht.insert(this.createInterval(time, time + 1L));
        Assert.assertEquals((long)7L, (long)ht.getNodeCount());
        Assert.assertEquals((long)3L, (long)ht.getDepth());
        Assert.assertEquals((long)time, (long)node.getNodeEnd());
        Assert.assertEquals((long)time, (long)parent.getChildEnd(2));
        Assert.assertEquals((long)node.getNodeStart(), (long)parent.getChildStart(2));
        node = parent;
        parent = ht.getLatestNode(0);
        Assert.assertEquals((long)time, (long)node.getNodeEnd());
        Assert.assertEquals((long)time, (long)parent.getChildEnd(0));
        ht.closeTree(ht.getTreeEnd());
        time = ht.getTreeEnd();
        Assert.assertEquals((long)time, (long)ht.getLatestNode(2).getNodeEnd());
        Assert.assertEquals((long)time, (long)ht.getLatestNode(1).getNodeEnd());
        Assert.assertEquals((long)time, (long)ht.getLatestNode(1).getChildEnd(0));
        Assert.assertEquals((long)time, (long)parent.getNodeEnd());
        Assert.assertEquals((long)time, (long)parent.getChildEnd(1));
        HtTestUtils.assertTreeIntegrity(ht);
    }
}

