/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.clipboard;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.security.InvalidParameterException;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class ImageArrayTransfer
extends ByteArrayTransfer {
    private static ImageArrayTransfer imageArrayTransferWindows = new ImageArrayTransfer(0);
    private static ImageArrayTransfer imageArrayTransferLinux = new ImageArrayTransfer(5);
    private int imageCode;
    private String typeName;
    private String[] typeNames;
    private int[] typeIds;

    public static ImageArrayTransfer getInstanceWindows() {
        return imageArrayTransferWindows;
    }

    public static ImageArrayTransfer getInstanceLinux() {
        return imageArrayTransferLinux;
    }

    private ImageArrayTransfer(int imageCode) {
        this.imageCode = imageCode;
        if (imageCode == 0) {
            this.typeName = "image/bmp";
        } else if (imageCode == 5) {
            this.typeName = "image/png";
        } else {
            throw new InvalidParameterException("Only SWT.IMAGE_BMP and SWT.IMAGE_PNG are allowed.");
        }
        this.typeNames = new String[]{this.typeName};
        this.typeIds = new int[]{ImageArrayTransfer.registerType((String)this.typeName)};
    }

    protected String[] getTypeNames() {
        return this.typeNames;
    }

    protected int[] getTypeIds() {
        return this.typeIds;
    }

    protected void javaToNative(Object object, TransferData transferData) {
        if (object instanceof ImageData && this.isSupportedType(transferData)) {
            ImageData imageData = (ImageData)object;
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    ImageLoader imageLoader = new ImageLoader();
                    imageLoader.data = new ImageData[]{imageData};
                    imageLoader.save((OutputStream)byteArrayOutputStream, this.imageCode);
                    super.javaToNative((Object)byteArrayOutputStream.toByteArray(), transferData);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

