/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.search.quickscan;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.wst.common.core.search.document.SearchDocument;
import org.eclipse.wst.common.core.search.pattern.SearchPattern;
import org.eclipse.wst.xml.core.internal.search.matching.PatternMatcher;
import org.eclipse.wst.xml.core.internal.search.quickscan.XMLQuickScanContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XMLQuickScan {
    private static XMLReader reader;

    public static boolean populateSearchDocument(SearchDocument document, PatternMatcher matcher, SearchPattern pattern) {
        XMLQuickScanContentHandler handler = new XMLQuickScanContentHandler(document, matcher, pattern);
        XMLQuickScan.parseFile(document.getPath(), handler);
        return handler.hasMatch();
    }

    private static XMLReader getOrCreateReader() {
        if (reader == null) {
            ClassLoader originalClzLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(XMLQuickScan.class.getClassLoader());
            try {
                try {
                    SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                    reader = parser.getXMLReader();
                    reader.setFeature("http://xml.org/sax/features/namespaces", true);
                    reader.setErrorHandler(new InternalErrorHandler());
                }
                catch (Exception exception) {
                    Thread.currentThread().setContextClassLoader(originalClzLoader);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClzLoader);
            }
        }
        return reader;
    }

    private static synchronized void parseFile(String fullFilePath, XMLQuickScanContentHandler handler) {
        block14: {
            FileInputStream inputStream = null;
            ClassLoader originalClzLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(XMLQuickScan.class.getClassLoader());
            try {
                try {
                    inputStream = new FileInputStream(new File(fullFilePath));
                    XMLReader reader = XMLQuickScan.getOrCreateReader();
                    reader.setContentHandler(handler);
                    reader.parse(new InputSource(inputStream));
                }
                catch (Exception exception) {
                    Thread.currentThread().setContextClassLoader(originalClzLoader);
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                Thread.currentThread().setContextClassLoader(originalClzLoader);
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            Thread.currentThread().setContextClassLoader(originalClzLoader);
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static class InternalErrorHandler
    implements ErrorHandler {
        InternalErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }
    }
}

