/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.variants;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.AbstractResourceVariantTree;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.ResourceVariantByteStore;

public abstract class ResourceVariantTree
extends AbstractResourceVariantTree {
    private final ResourceVariantByteStore store;

    protected ResourceVariantTree(ResourceVariantByteStore store) {
        this.store = store;
    }

    @Override
    public IResource[] members(IResource resource) throws TeamException {
        return this.getByteStore().members(resource);
    }

    @Override
    public boolean hasResourceVariant(IResource resource) throws TeamException {
        return this.getByteStore().getBytes(resource) != null;
    }

    @Override
    public void flushVariants(IResource resource, int depth) throws TeamException {
        this.getByteStore().flushBytes(resource, depth);
    }

    @Override
    protected boolean setVariant(IResource local, IResourceVariant remote) throws TeamException {
        ResourceVariantByteStore cache = this.getByteStore();
        byte[] newRemoteBytes = this.getBytes(local, remote);
        boolean changed = newRemoteBytes == null ? cache.deleteBytes(local) : cache.setBytes(local, newRemoteBytes);
        return changed;
    }

    protected ResourceVariantByteStore getByteStore() {
        return this.store;
    }

    protected byte[] getBytes(IResource local, IResourceVariant remote) throws TeamException {
        if (remote == null) {
            return null;
        }
        return remote.asBytes();
    }

    @Override
    protected IResource[] collectChanges(IResource local, IResourceVariant remote, int depth, IProgressMonitor monitor) throws TeamException {
        IResource[][] resources = new IResource[1][];
        this.getByteStore().run(local, monitor1 -> {
            IResource[] iResourceArray2 = ResourceVariantTree.super.collectChanges(local, remote, depth, monitor1);
        }, monitor);
        return resources[0];
    }
}

