/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.plugin;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.validation.internal.IProjectValidationHelper;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class ValidationHelperRegistryReader {
    public static final String VALIDATION_HELPER = "validationHelper";
    static final String ATT_ID = "id";
    static final String ATT_HELPER_CLASS = "helperClass";
    private static ValidationHelperRegistryReader INSTANCE = null;
    private List<IProjectValidationHelper> _validationHelpers;

    public static ValidationHelperRegistryReader getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ValidationHelperRegistryReader();
            INSTANCE.readRegistry();
        }
        return INSTANCE;
    }

    public void readRegistry() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.wst.validation", VALIDATION_HELPER);
        if (point == null) {
            return;
        }
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            this.internalReadElement(elements[i]);
            ++i;
        }
    }

    private void internalReadElement(IConfigurationElement element) {
        boolean recognized = this.readElement(element);
        if (!recognized) {
            this.logError(element, "Error processing extension: " + String.valueOf(element));
        }
    }

    protected void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        StringBuffer buf = new StringBuffer();
        buf.append("Plugin " + extension.getContributor().getName() + ", extension " + extension.getExtensionPointUniqueIdentifier());
        buf.append("\n" + text);
        ValidationPlugin.getPlugin().logMessage(4, buf.toString());
    }

    private List<IProjectValidationHelper> getValidationHelpers() {
        if (this._validationHelpers == null) {
            this._validationHelpers = new ArrayList<IProjectValidationHelper>();
        }
        return this._validationHelpers;
    }

    public boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals(VALIDATION_HELPER)) {
            return false;
        }
        IProjectValidationHelper helper = null;
        try {
            helper = (IProjectValidationHelper)element.createExecutableExtension(ATT_HELPER_CLASS);
            this.getValidationHelpers().add(helper);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public IProjectValidationHelper getValidationHelper() {
        if (this.getValidationHelpers().isEmpty()) {
            return null;
        }
        return this.getValidationHelpers().get(0);
    }
}

