/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class HelpUIResources {
    private static final String LEAF = "_leaf";
    private static final String CLOSED = "_closed";
    private static final String OPEN = "_open";
    private static final String EXT_PT = "org.eclipse.help.toc";
    private static final String TOC_ICON_ELEMENT = "tocIcon";
    private static final String TOC_ICON_ID = "id";
    private static final String OPEN_ICON_PATH = "openIcon";
    private static final String CLOSED_ICON_PATH = "closedIcon";
    private static final String LEAF_ICON_PATH = "leafIcon";
    private static boolean iconsInitialized = false;

    public static URL getImagePath(String name) {
        IPath path = IPath.fromOSString((String)"$nl$/icons/").append(name);
        return FileLocator.find((Bundle)HelpUIPlugin.getDefault().getBundle(), (IPath)path, null);
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        URL imagePath = HelpUIResources.getImagePath(name);
        ImageRegistry registry = HelpUIPlugin.getDefault().getImageRegistry();
        ImageDescriptor desc = registry.getDescriptor(name);
        if (desc == null) {
            desc = ImageDescriptor.createFromURL((URL)imagePath);
            registry.put(name, desc);
        }
        return desc;
    }

    public static ImageDescriptor getImageDescriptor(String bundleId, String name) {
        ImageRegistry registry = HelpUIPlugin.getDefault().getImageRegistry();
        ImageDescriptor desc = registry.getDescriptor(name);
        if (desc == null) {
            Bundle bundle = Platform.getBundle((String)bundleId);
            if (bundle == null) {
                return null;
            }
            URL url = FileLocator.find((Bundle)bundle, (IPath)IPath.fromOSString((String)name), null);
            desc = ImageDescriptor.createFromURL((URL)url);
            registry.put(name, desc);
        }
        return desc;
    }

    public static ImageDescriptor getIconImageDescriptor(String bundleId, String path, String key) {
        ImageRegistry registry = HelpUIPlugin.getDefault().getImageRegistry();
        ImageDescriptor desc = registry.getDescriptor(key);
        if (desc == null) {
            Bundle bundle = Platform.getBundle((String)bundleId);
            if (bundle == null) {
                return null;
            }
            URL url = FileLocator.find((Bundle)bundle, (IPath)IPath.fromOSString((String)path), null);
            desc = ImageDescriptor.createFromURL((URL)url);
            registry.put(key, desc);
        }
        return desc;
    }

    public static Image getIconImage(String key) {
        ImageRegistry registry = HelpUIPlugin.getDefault().getImageRegistry();
        return registry.get(key);
    }

    public static Image getImageFromId(String iconId, boolean isOpen, boolean isLeaf) {
        if (iconId == null) {
            return null;
        }
        HelpUIResources.initializeTocIcons();
        String suffix = isOpen ? OPEN : (isLeaf ? LEAF : CLOSED);
        Image result = HelpUIResources.lookupImage(iconId + suffix);
        if (result != null || isOpen) {
            return result;
        }
        return HelpUIResources.lookupImage(iconId + OPEN);
    }

    private static Image lookupImage(String name) {
        ImageRegistry registry = HelpUIPlugin.getDefault().getImageRegistry();
        return registry.get(name);
    }

    private static void initializeTocIcons() {
        if (iconsInitialized) {
            return;
        }
        iconsInitialized = true;
        IExtension[] extensionsFound = Platform.getExtensionRegistry().getExtensionPoint(EXT_PT).getExtensions();
        int i = 0;
        while (i < extensionsFound.length) {
            IConfigurationElement[] configElements = extensionsFound[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals(TOC_ICON_ELEMENT)) {
                    IConfigurationElement iconElem = configElements[j];
                    String[] attrs = iconElem.getAttributeNames();
                    String contributorID = iconElem.getContributor().getName();
                    int k = 0;
                    while (k < attrs.length) {
                        if (attrs[k].equals(OPEN_ICON_PATH)) {
                            HelpUIResources.getIconImageDescriptor(contributorID, iconElem.getAttribute(OPEN_ICON_PATH), iconElem.getAttribute(TOC_ICON_ID) + OPEN);
                        }
                        if (attrs[k].equals(CLOSED_ICON_PATH)) {
                            HelpUIResources.getIconImageDescriptor(contributorID, iconElem.getAttribute(CLOSED_ICON_PATH), iconElem.getAttribute(TOC_ICON_ID) + CLOSED);
                        }
                        if (attrs[k].equals(LEAF_ICON_PATH)) {
                            HelpUIResources.getIconImageDescriptor(contributorID, iconElem.getAttribute(LEAF_ICON_PATH), iconElem.getAttribute(TOC_ICON_ID) + LEAF);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static Image getImage(String name) {
        ImageRegistry registry = HelpUIPlugin.getDefault().getImageRegistry();
        HelpUIResources.getImageDescriptor(name);
        return registry.get(name);
    }

    public static Image getImage(URL url) {
        String name;
        ImageRegistry registry = HelpUIPlugin.getDefault().getImageRegistry();
        ImageDescriptor desc = registry.getDescriptor(name = url.toString());
        if (desc == null) {
            desc = ImageDescriptor.createFromURL((URL)url);
            registry.put(name, desc);
        }
        return registry.get(name);
    }
}

