/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers;

import org.eclipse.tracecompass.analysis.os.linux.core.kernel.StateValues;
import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandlerUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class IrqEntryHandler
extends KernelEventHandler {
    public IrqEntryHandler(IKernelAnalysisEventLayout layout) {
        super(layout);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) throws AttributeNotFoundException {
        Integer cpu = KernelEventHandlerUtils.getCpu(event);
        if (cpu == null) {
            return;
        }
        Integer irqId = ((Long)event.getContent().getField(new String[]{this.getLayout().fieldIrq()}).getValue()).intValue();
        String name = event.getContent().getField(new String[]{this.getLayout().fieldName()}).getValue().toString();
        int quark = ss.getQuarkRelativeAndAdd(KernelEventHandlerUtils.getNodeIRQs(cpu, ss), new String[]{irqId.toString() + "/" + name});
        long timestamp = KernelEventHandlerUtils.getTimestamp(event);
        ss.modifyAttribute(timestamp, (Object)cpu, quark);
        quark = KernelEventHandlerUtils.getCurrentThreadNode(cpu, ss);
        ss.modifyAttribute(timestamp, ProcessStatus.INTERRUPTED.getStateValue().unboxValue(), quark);
        quark = KernelEventHandlerUtils.getCurrentCPUNode(cpu, ss);
        ss.modifyAttribute(timestamp, StateValues.CPU_STATUS_IRQ_VALUE.unboxValue(), quark);
        int aggregateQuark = ss.getQuarkAbsoluteAndAdd(new String[]{"IRQs", irqId.toString() + "/" + name});
        ss.modifyAttribute(timestamp, (Object)cpu, aggregateQuark);
    }
}

