/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public class WeakHashSet<T> {
    HashableWeakReference<T>[] values;
    public int elementSize = 0;
    int threshold;
    ReferenceQueue<T> referenceQueue = new ReferenceQueue();

    public WeakHashSet() {
        this(5);
    }

    public WeakHashSet(int size) {
        this.threshold = size;
        int extraRoom = (int)((float)size * 1.75f);
        if (this.threshold == extraRoom) {
            ++extraRoom;
        }
        HashableWeakReference[] references = new HashableWeakReference[extraRoom];
        this.values = references;
    }

    public T add(T obj) {
        HashableWeakReference<T> currentValue;
        this.cleanupGarbageCollectedValues();
        int valuesLength = this.values.length;
        int index = (obj.hashCode() & Integer.MAX_VALUE) % valuesLength;
        while ((currentValue = this.values[index]) != null) {
            Object referent = currentValue.get();
            if (obj.equals(referent)) {
                return referent;
            }
            if (++index != valuesLength) continue;
            index = 0;
        }
        this.values[index] = new HashableWeakReference<T>(obj, this.referenceQueue);
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return obj;
    }

    private void addValue(HashableWeakReference<T> value) {
        HashableWeakReference<T> currentValue;
        Object obj = value.get();
        if (obj == null) {
            return;
        }
        int valuesLength = this.values.length;
        int index = (value.hashCode & Integer.MAX_VALUE) % valuesLength;
        while ((currentValue = this.values[index]) != null) {
            if (obj.equals(currentValue.get())) {
                return;
            }
            if (++index != valuesLength) continue;
            index = 0;
        }
        this.values[index] = value;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
    }

    private void cleanupGarbageCollectedValues() {
        Reference<T> toBeRemoved;
        block0: while ((toBeRemoved = this.referenceQueue.poll()) != null) {
            HashableWeakReference<T> currentValue;
            int hashCode = toBeRemoved.hashCode();
            int valuesLength = this.values.length;
            int index = (hashCode & Integer.MAX_VALUE) % valuesLength;
            while ((currentValue = this.values[index]) != null) {
                if (currentValue == toBeRemoved) {
                    int current;
                    int sameHash = index;
                    while ((currentValue = this.values[current = (sameHash + 1) % valuesLength]) != null && currentValue.hashCode == hashCode) {
                        sameHash = current;
                    }
                    this.values[index] = this.values[sameHash];
                    this.values[sameHash] = null;
                    --this.elementSize;
                    continue block0;
                }
                if (++index != valuesLength) continue;
                index = 0;
            }
        }
    }

    public boolean contains(T obj) {
        return this.get(obj) != null;
    }

    public T get(T obj) {
        HashableWeakReference<T> currentValue;
        this.cleanupGarbageCollectedValues();
        int valuesLength = this.values.length;
        int index = (obj.hashCode() & Integer.MAX_VALUE) % valuesLength;
        while ((currentValue = this.values[index]) != null) {
            Object referent = currentValue.get();
            if (obj.equals(referent)) {
                return referent;
            }
            if (++index != valuesLength) continue;
            index = 0;
        }
        return null;
    }

    private void rehash() {
        WeakHashSet<T> newHashSet = new WeakHashSet<T>(this.elementSize * 2);
        newHashSet.referenceQueue = this.referenceQueue;
        HashableWeakReference<T>[] hashableWeakReferenceArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            HashableWeakReference<T> value = hashableWeakReferenceArray[n2];
            HashableWeakReference<T> currentValue = value;
            if (currentValue != null) {
                newHashSet.addValue(currentValue);
            }
            ++n2;
        }
        this.values = newHashSet.values;
        this.threshold = newHashSet.threshold;
        this.elementSize = newHashSet.elementSize;
    }

    public T remove(T obj) {
        HashableWeakReference<T> currentValue;
        this.cleanupGarbageCollectedValues();
        int valuesLength = this.values.length;
        int index = (obj.hashCode() & Integer.MAX_VALUE) % valuesLength;
        while ((currentValue = this.values[index]) != null) {
            Object referent = currentValue.get();
            if (obj.equals(referent)) {
                --this.elementSize;
                this.values[index] = null;
                this.rehash();
                return referent;
            }
            if (++index != valuesLength) continue;
            index = 0;
        }
        return null;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("{");
        HashableWeakReference<T>[] hashableWeakReferenceArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Object ref;
            HashableWeakReference<T> value = hashableWeakReferenceArray[n2];
            if (value != null && (ref = value.get()) != null) {
                buffer.append(ref.toString());
                buffer.append(", ");
            }
            ++n2;
        }
        buffer.append("}");
        return buffer.toString();
    }

    public static class HashableWeakReference<T>
    extends WeakReference<T> {
        public int hashCode;

        public HashableWeakReference(T referent, ReferenceQueue<T> queue) {
            super(referent, queue);
            this.hashCode = referent.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof HashableWeakReference)) {
                return false;
            }
            Object referent = this.get();
            HashableWeakReference ref = (HashableWeakReference)obj;
            Object other = ref.get();
            if (referent == null) {
                return other == null;
            }
            return referent.equals(other);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            Object referent = this.get();
            if (referent == null) {
                return "[hashCode=" + this.hashCode + "] <referent was garbage collected>";
            }
            return "[hashCode=" + this.hashCode + "] " + referent.toString();
        }
    }
}

