/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfigParamDescriptor;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfigurationSourceType;

public class TmfConfigurationSourceType
implements ITmfConfigurationSourceType {
    private final String fId;
    private final String fName;
    private final String fDescription;
    private final @Nullable File fSchemaFile;
    private final List<ITmfConfigParamDescriptor> fParamDescriptors;

    private TmfConfigurationSourceType(Builder builder) {
        this.fId = builder.fId;
        this.fName = builder.fName;
        this.fDescription = builder.fDescription;
        this.fParamDescriptors = builder.fDescriptors;
        this.fSchemaFile = builder.fSchemaFile;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public String getDescription() {
        return this.fDescription;
    }

    @Override
    public List<ITmfConfigParamDescriptor> getConfigParamDescriptors() {
        return this.fParamDescriptors;
    }

    @Override
    public @Nullable File getSchemaFile() {
        return this.fSchemaFile;
    }

    public String toString() {
        File schemaFile = this.getSchemaFile();
        String schemaFileName = schemaFile == null ? "null" : schemaFile.getName();
        return this.getClass().getSimpleName() + "[" + "fName=" + this.getName() + ", fDescription=" + this.getDescription() + ", fId=" + this.getId() + ", fKeys=" + this.getConfigParamDescriptors() + ", fSchemaFile=" + schemaFileName + "]";
    }

    public boolean equals(@Nullable Object arg0) {
        if (!(arg0 instanceof TmfConfigurationSourceType)) {
            return false;
        }
        TmfConfigurationSourceType other = (TmfConfigurationSourceType)arg0;
        return Objects.equals(this.fName, other.fName) && Objects.equals(this.fId, other.fId) && Objects.equals(this.fDescription, other.fDescription) && Objects.equals(this.fParamDescriptors, other.fParamDescriptors) && Objects.equals(this.fSchemaFile, other.fSchemaFile);
    }

    public int hashCode() {
        return Objects.hash(this.fName, this.fId, this.fParamDescriptors, this.fDescription);
    }

    public static class Builder {
        private String fId = "";
        private String fName = "";
        private String fDescription = "";
        private @Nullable File fSchemaFile = null;
        private List<ITmfConfigParamDescriptor> fDescriptors = new ArrayList<ITmfConfigParamDescriptor>();

        public Builder setId(String id) {
            this.fId = id;
            return this;
        }

        public Builder setName(String name) {
            this.fName = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.fDescription = description;
            return this;
        }

        public Builder setConfigParamDescriptors(List<ITmfConfigParamDescriptor> descriptors) {
            this.fDescriptors = descriptors;
            return this;
        }

        public Builder setSchemaFile(@Nullable File schema) {
            this.fSchemaFile = schema;
            return this;
        }

        public ITmfConfigurationSourceType build() {
            if (this.fId.isBlank()) {
                throw new IllegalStateException("Configuration source type ID not set");
            }
            if (this.fName.isBlank()) {
                throw new IllegalStateException("Configuration source type name not set");
            }
            if (this.fSchemaFile != null && !this.fSchemaFile.exists()) {
                throw new IllegalStateException("Configuration source type schema file doesn't exist");
            }
            return new TmfConfigurationSourceType(this);
        }
    }
}

