/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.cdtvariables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.utils.cdtvariables.ICdtVariableSupplier;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;

public class SupplierBasedCdtVariableManager {
    public static ICdtVariable getVariable(String macroName, IVariableContextInfo contextInfo, boolean includeParentContexts) {
        if (contextInfo == null || macroName == null) {
            return null;
        }
        do {
            ICdtVariableSupplier[] suppliers;
            if ((suppliers = contextInfo.getSuppliers()) == null) continue;
            ICdtVariableSupplier[] iCdtVariableSupplierArray = suppliers;
            int n = suppliers.length;
            int n2 = 0;
            while (n2 < n) {
                ICdtVariableSupplier supplier = iCdtVariableSupplierArray[n2];
                ICdtVariable macro = supplier.getVariable(macroName, contextInfo);
                if (macro != null) {
                    return macro;
                }
                ++n2;
            }
        } while (includeParentContexts && (contextInfo = contextInfo.getNext()) != null);
        return null;
    }

    public static ICdtVariable[] getVariables(IVariableContextInfo contextInfo, boolean includeParentContexts) {
        IVariableContextInfo[] iVariableContextInfoArray;
        if (contextInfo == null) {
            return new ICdtVariable[0];
        }
        HashMap<String, ICdtVariable> map = new HashMap<String, ICdtVariable>();
        if (includeParentContexts) {
            iVariableContextInfoArray = SupplierBasedCdtVariableManager.getAllVariableContextInfos(contextInfo);
        } else {
            IVariableContextInfo[] iVariableContextInfoArray2 = new IVariableContextInfo[1];
            iVariableContextInfoArray = iVariableContextInfoArray2;
            iVariableContextInfoArray2[0] = contextInfo;
        }
        IVariableContextInfo[] infos = iVariableContextInfoArray;
        int k = infos.length - 1;
        while (k >= 0) {
            contextInfo = infos[k];
            ICdtVariableSupplier[] suppliers = contextInfo.getSuppliers();
            if (suppliers != null) {
                int i = suppliers.length - 1;
                while (i >= 0) {
                    ICdtVariable[] macros = suppliers[i].getVariables(contextInfo);
                    if (macros != null) {
                        ICdtVariable[] iCdtVariableArray = macros;
                        int n = macros.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ICdtVariable macro = iCdtVariableArray[n2];
                            map.put(macro.getName(), macro);
                            ++n2;
                        }
                    }
                    --i;
                }
            }
            --k;
        }
        Collection values = map.values();
        return values.toArray(new ICdtVariable[values.size()]);
    }

    private static IVariableContextInfo[] getAllVariableContextInfos(IVariableContextInfo contextInfo) {
        if (contextInfo == null) {
            return null;
        }
        ArrayList<IVariableContextInfo> list = new ArrayList<IVariableContextInfo>();
        list.add(contextInfo);
        while ((contextInfo = contextInfo.getNext()) != null) {
            list.add(contextInfo);
        }
        return list.toArray(new IVariableContextInfo[list.size()]);
    }

    public static boolean checkParentContextRelation(IVariableContextInfo child, IVariableContextInfo parent) {
        if (child == null || parent == null) {
            return false;
        }
        IVariableContextInfo enumInfo = child;
        do {
            if (!parent.equals(enumInfo)) continue;
            return true;
        } while ((enumInfo = enumInfo.getNext()) != null);
        return false;
    }
}

