/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.trace;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceVersionHeader;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.parser.BinaryFTraceFileParser;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.strategies.BinaryFTraceV6Strategy;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.strategies.IBinaryFTraceStrategy;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.trace.GenericFtrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.project.model.ITmfPropertiesProvider;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;

public class BinaryFTrace
extends GenericFtrace
implements ITmfPropertiesProvider {
    private static final String TRACE_CMD = "trace-cmd";
    private static final String REPORT = "report";
    private final @NonNull Map<@NonNull String, @NonNull String> fProperties = new LinkedHashMap<String, String>();
    private IBinaryFTraceStrategy fStrategy;

    public IStatus validate(IProject project, String path) {
        File file = new File(path);
        if (!file.exists()) {
            return new Status(4, "org.eclipse.tracecompass.incubator.ftrace.core", "File not found: " + path);
        }
        if (!file.isFile()) {
            return new Status(4, "org.eclipse.tracecompass.incubator.ftrace.core", "Not a file. It's a directory: " + path);
        }
        int confidence = 32;
        try {
            if (!TmfTraceUtils.isText((File)file)) {
                IBinaryFTraceStrategy strategy = this.getStrategy(file);
                if (strategy != null) {
                    return new TraceValidationStatus(confidence, "org.eclipse.tracecompass.incubator.ftrace.core");
                }
                int magicLength = TRACE_CMD_DAT_MAGIC.length;
                if (file.length() < (long)magicLength || !BinaryFTrace.convertTraceToText(file)) {
                    return new Status(4, "org.eclipse.tracecompass.incubator.ftrace.core", "Magic mismatch");
                }
            }
        }
        catch (IOException e) {
            Activator.getInstance().logError("Error validating file: " + path, (Throwable)e);
            if (e.getMessage().startsWith("Cannot run program: \"trace-cmd\": error=2,")) {
                return new Status(4, "org.eclipse.tracecompass.incubator.ftrace.core", "It appears trace-cmd is not available on your machine. Please install it to use the binary ftrace parser. (sudo apt install trace-cmd)", (Throwable)e);
            }
            return new Status(4, "org.eclipse.tracecompass.incubator.ftrace.core", "IOException validating file: " + path, (Throwable)e);
        }
        return new Status(4, "org.eclipse.tracecompass.incubator.ftrace.core", "Not an FTrace bin");
    }

    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> type, String name, String traceTypeId) throws TmfTraceException {
        super.initTrace(resource, path, type, name, traceTypeId);
        this.fProperties.put("Type", "Trace-Event");
        File file = new File(path);
        this.fStrategy = this.getStrategy(file);
        if (this.fStrategy != null) {
            this.fStrategy.initTrace(path);
        } else {
            String dir = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)this);
            if (!new File(dir).exists()) {
                throw new TmfTraceException("Could not create temporary folder " + dir);
            }
            file = new File(dir + new File(path).getName());
            BinaryFTrace.initTraceAsText(file);
        }
        this.setFile(file);
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        if (this.fStrategy != null) {
            this.fStrategy.dispose();
        }
    }

    private static File initTraceAsText(File file) throws TmfTraceException {
        if (!file.exists()) {
            ProcessBuilder pb = new ProcessBuilder(TRACE_CMD, REPORT, "-i", file.getAbsolutePath(), "-R");
            pb.redirectOutput(file);
            try {
                pb.start().waitFor();
            }
            catch (IOException e) {
                throw new TmfTraceException(e.getMessage(), (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new TmfTraceException(e.getMessage(), (Throwable)e);
            }
            if (!file.exists()) {
                throw new TmfTraceException("Could not create temporary file " + file.getAbsolutePath());
            }
            if (file.length() <= 0L) {
                throw new TmfTraceException("Empty temporary file " + file.getAbsolutePath());
            }
        }
        return file;
    }

    private IBinaryFTraceStrategy getStrategy(File file) {
        BinaryFTraceV6Strategy strategy = null;
        try {
            BinaryFTraceVersionHeader versionHeader = BinaryFTraceFileParser.getFtraceVersionHeader(file.getAbsolutePath());
            if (BinaryFTraceV6Strategy.validate(versionHeader)) {
                strategy = new BinaryFTraceV6Strategy(this);
            }
        }
        catch (TmfTraceException e) {
            Activator.getInstance().logError("Invalid binary ftrace file.", (Throwable)e);
        }
        return strategy;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean convertTraceToText(File file) throws IOException {
        int magicLength = TRACE_CMD_DAT_MAGIC.length;
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            BufferedReader br;
            block14: {
                String line;
                FileInputStream fis = new FileInputStream(file);
                byte[] start = new byte[magicLength];
                int read = fis.read(start);
                if (read != magicLength) return false;
                if (!Arrays.equals(TRACE_CMD_DAT_MAGIC, start)) return false;
                ProcessBuilder pb = new ProcessBuilder(TRACE_CMD);
                Process traceCmd = pb.start();
                Throwable throwable2 = null;
                Object var10_13 = null;
                try {
                    br = new BufferedReader(new InputStreamReader(traceCmd.getInputStream(), StandardCharsets.UTF_8));
                    line = br.readLine();
                    {
                        catch (Throwable throwable3) {
                            if (br == null) throw throwable3;
                            br.close();
                            throw throwable3;
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    }
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                    throw throwable2;
                }
                finally {
                    if (line == null) break block14;
                }
            }
            if (br == null) return false;
            br.close();
            return false;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    public synchronized ITmfEvent getNext(ITmfContext context) {
        if (this.fStrategy != null) {
            return this.fStrategy.getNext(context);
        }
        return super.getNext(context);
    }

    public @Nullable ITmfContext createIterator() throws IOException {
        if (this.fStrategy != null) {
            return this.fStrategy.createIterator();
        }
        return null;
    }

    @Override
    public ITmfContext seekEvent(ITmfLocation location) {
        if (this.fStrategy != null) {
            return this.fStrategy.seekEvent(location);
        }
        return super.seekEvent(location);
    }

    public void setStartTime(@NonNull ITmfTimestamp startTime) {
        super.setStartTime(startTime);
    }

    public void setEndTime(@NonNull ITmfTimestamp endTime) {
        super.setEndTime(endTime);
    }

    public synchronized void updateAttributes(ITmfContext context, @NonNull ITmfEvent event) {
        super.updateAttributes(context, event);
    }

    public @NonNull Map<@NonNull String, @NonNull String> getProperties() {
        return this.fProperties;
    }
}

