/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.remote.core.IRemoteConnectionProviderService;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.RemoteConnectionChangeEvent;
import org.eclipse.remote.internal.core.RemoteConnectionType;
import org.eclipse.remote.internal.core.RemoteCorePlugin;
import org.osgi.service.prefs.Preferences;

public class RemoteServicesManager
implements IRemoteServicesManager {
    private static final String LOCAL_SERVICES_ID = "org.eclipse.remote.LocalServices";
    private final Map<String, RemoteConnectionType> connectionTypeMap = new HashMap<String, RemoteConnectionType>();
    private final Map<String, IRemoteConnectionType> schemeMap = new HashMap<String, IRemoteConnectionType>();
    private final List<IRemoteConnectionChangeListener> listeners = new LinkedList<IRemoteConnectionChangeListener>();
    private boolean inited;

    protected void init() {
        IConfigurationElement ce;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        if (this.inited) {
            return;
        }
        this.inited = true;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(RemoteCorePlugin.getUniqueIdentifier(), "remoteServices");
        IExtension[] iExtensionArray = point.getExtensions();
        int n3 = iExtensionArray.length;
        int n4 = 0;
        while (n4 < n3) {
            IExtension iExtension = iExtensionArray[n4];
            iConfigurationElementArray = iExtension.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                ce = iConfigurationElementArray[n];
                if (ce.getName().equals("connectionType")) {
                    RemoteConnectionType services = new RemoteConnectionType(ce, this);
                    this.connectionTypeMap.put(services.getId(), services);
                    String scheme = services.getScheme();
                    if (scheme != null) {
                        this.schemeMap.put(scheme, services);
                    }
                }
                ++n;
            }
            ++n4;
        }
        iExtensionArray = point.getExtensions();
        n3 = iExtensionArray.length;
        n4 = 0;
        while (n4 < n3) {
            IExtension iExtension = iExtensionArray[n4];
            iConfigurationElementArray = iExtension.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                String id;
                RemoteConnectionType services;
                ce = iConfigurationElementArray[n];
                String name = ce.getName();
                if ((name.equals("connectionTypeService") || name.equals("connectionService") || name.equals("processService")) && (services = this.connectionTypeMap.get(id = ce.getAttribute("connectionTypeId"))) != null) {
                    services.addService(ce);
                }
                ++n;
            }
            ++n4;
        }
        for (IRemoteConnectionType iRemoteConnectionType : this.connectionTypeMap.values()) {
            IRemoteConnectionProviderService providerService = iRemoteConnectionType.getService(IRemoteConnectionProviderService.class);
            if (providerService == null) continue;
            providerService.init();
        }
    }

    public Preferences getPreferenceNode() {
        return InstanceScope.INSTANCE.getNode(RemoteCorePlugin.getUniqueIdentifier()).node("connections");
    }

    public ISecurePreferences getSecurePreferenceNode() {
        return SecurePreferencesFactory.getDefault().node(RemoteCorePlugin.getUniqueIdentifier()).node("connections");
    }

    @Override
    public IRemoteConnectionType getConnectionType(String id) {
        this.init();
        return this.connectionTypeMap.get(id);
    }

    @Override
    public IRemoteConnectionType getConnectionType(URI uri) {
        this.init();
        return this.schemeMap.get(uri.getScheme());
    }

    @Override
    public IRemoteConnectionType getLocalConnectionType() {
        return this.getConnectionType(LOCAL_SERVICES_ID);
    }

    @Override
    public List<IRemoteConnectionType> getAllConnectionTypes() {
        this.init();
        return new ArrayList<IRemoteConnectionType>(this.connectionTypeMap.values());
    }

    @Override
    @SafeVarargs
    public final List<IRemoteConnectionType> getConnectionTypesSupporting(Class<? extends IRemoteConnection.Service> ... services) {
        ArrayList<IRemoteConnectionType> connTypes = new ArrayList<IRemoteConnectionType>();
        block0: for (IRemoteConnectionType connType : this.getAllConnectionTypes()) {
            Class<? extends IRemoteConnection.Service>[] classArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                Class<? extends IRemoteConnection.Service> service = classArray[n2];
                if (connType.hasConnectionService(service)) {
                    connTypes.add(connType);
                    continue block0;
                }
                ++n2;
            }
        }
        return connTypes;
    }

    @Override
    @SafeVarargs
    public final List<IRemoteConnectionType> getConnectionTypesByService(Class<? extends IRemoteConnectionType.Service> ... services) {
        ArrayList<IRemoteConnectionType> connTypes = new ArrayList<IRemoteConnectionType>();
        block0: for (IRemoteConnectionType connType : this.getAllConnectionTypes()) {
            Class<? extends IRemoteConnectionType.Service>[] classArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                Class<? extends IRemoteConnectionType.Service> service = classArray[n2];
                if (!connType.hasService(service)) {
                    connTypes.add(connType);
                    continue block0;
                }
                ++n2;
            }
        }
        return connTypes;
    }

    @Override
    public List<IRemoteConnectionType> getRemoteConnectionTypes() {
        this.init();
        ArrayList<IRemoteConnectionType> connTypes = new ArrayList<IRemoteConnectionType>(this.connectionTypeMap.values().size() - 1);
        IRemoteConnectionType localServices = this.getLocalConnectionType();
        for (IRemoteConnectionType iRemoteConnectionType : this.connectionTypeMap.values()) {
            if (iRemoteConnectionType.equals(localServices)) continue;
            connTypes.add(iRemoteConnectionType);
        }
        return connTypes;
    }

    @Override
    public List<IRemoteConnection> getAllRemoteConnections() {
        ArrayList<IRemoteConnection> connections = new ArrayList<IRemoteConnection>();
        for (IRemoteConnectionType connType : this.getAllConnectionTypes()) {
            connections.addAll(connType.getConnections());
        }
        return connections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRemoteConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        List<IRemoteConnectionChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRemoteConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        List<IRemoteConnectionChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireRemoteConnectionChangeEvent(RemoteConnectionChangeEvent event) {
        ArrayList<IRemoteConnectionChangeListener> iListeners;
        List<IRemoteConnectionChangeListener> list = this.listeners;
        synchronized (list) {
            iListeners = new ArrayList<IRemoteConnectionChangeListener>(this.listeners);
        }
        for (IRemoteConnectionChangeListener listener : iListeners) {
            listener.connectionChanged(event);
        }
    }
}

