/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers;

import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.FusedVMEventHandlerUtils;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.FusedVirtualMachineStateProvider;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.VMKernelEventHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualCPU;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualMachine;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class KvmExitHandler
extends VMKernelEventHandler {
    public KvmExitHandler(IKernelAnalysisEventLayout layout, FusedVirtualMachineStateProvider sp) {
        super(layout, sp);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) {
        Integer cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
        if (cpu == null) {
            return;
        }
        FusedVirtualMachineStateProvider sp = this.getStateProvider();
        int currentCPUNode = FusedVMEventHandlerUtils.getCurrentCPUNode(cpu, ss);
        VirtualMachine host = sp.getCurrentMachine(event);
        if (host == null) {
            return;
        }
        if (host.isHost() && host.isGuest()) {
            return;
        }
        VirtualCPU hostCpu = VirtualCPU.getVirtualCPU(host, cpu.longValue());
        long timestamp = FusedVMEventHandlerUtils.getTimestamp(event);
        Integer currentThread = hostCpu.getCurrentThread();
        HostThread ht = new HostThread(host.getHostId(), currentThread);
        VirtualCPU vcpu = sp.getVirtualCpu(ht);
        if (vcpu == null) {
            return;
        }
        if (host.isThreadReadyForNextLayer(ht) && (vcpu = vcpu.getNextLayerVCPU()) == null) {
            return;
        }
        int quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Status"});
        Object status = ss.queryOngoing(quark);
        if (!(status instanceof Integer)) {
            return;
        }
        vcpu.setCurrentState((Integer)status);
        ss.modifyAttribute(timestamp, (Object)hostCpu.getCurrentState(), quark);
        quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Current_thread"});
        status = ss.queryOngoing(quark);
        if (!(status instanceof Integer)) {
            return;
        }
        vcpu.setCurrentThread((Integer)status);
        ss.modifyAttribute(timestamp, (Object)hostCpu.getCurrentThread(), quark);
        quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Condition"});
        ss.modifyAttribute(timestamp, (Object)1, quark);
        int machineNameQuark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Machine_name"});
        ss.modifyAttribute(timestamp, (Object)event.getTrace().getHostId(), machineNameQuark);
    }
}

