/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.cdt.utils.WindowsRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class MinGW {
    public static final String ENV_MINGW_HOME = "MINGW_HOME";
    public static final String ENV_MSYS_HOME = "MSYS_HOME";
    private static final String ENV_PATH = "PATH";
    private static final Set<String> MSYS2_64BIT_NAMES = Set.of("MSYS2", "MSYS2 64bit");
    private static final List<String> MSYS2_MINGW_SUBSYSTEMS = List.of("ucrt64", "mingw64", "mingw32");
    private static final List<String> MSYS2_MINGW_SUBSYSTEM_SELECTION_TOOLS = List.of("clangd", "clang", "gcc");
    private static final boolean isWindowsPlatform = Platform.getOS().equals("win32");
    private static String envPathValueCached = null;
    private static String envMinGWHomeValueCached = null;
    private static String minGWLocation = null;
    private static boolean isMinGWLocationCached = false;
    private static String envMinGWHomeValueCached_msys = null;
    private static String mSysLocation = null;
    private static boolean isMSysLocationCached = false;
    private static final Map<String, String> mingwLocationCache = Collections.synchronizedMap(new WeakHashMap(1));

    private static String findMinGWRoot(String envPathValue, String envMinGWHomeValue) {
        Path mingwBinDir;
        Object rootValue;
        block13: {
            String subkey;
            Path installPath;
            IPath mingwBinDir2;
            rootValue = null;
            if (envMinGWHomeValue != null && !envMinGWHomeValue.isEmpty() && (mingwBinDir = new Path(envMinGWHomeValue + "\\bin")).toFile().isDirectory()) {
                rootValue = mingwBinDir.removeLastSegments(1).toOSString();
            }
            if (rootValue == null && (mingwBinDir2 = (installPath = new Path(Platform.getInstallLocation().getURL().getFile())).append("mingw\\bin")).toFile().isDirectory()) {
                rootValue = mingwBinDir2.removeLastSegments(1).toOSString();
            }
            if (rootValue == null) {
                rootValue = MinGW.findMingwInPath(envPathValue);
            }
            if (rootValue != null) break block13;
            WindowsRegistry registry = WindowsRegistry.getRegistry();
            String uninstallKey = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
            boolean on64bit = Platform.getOSArch().equals("x86_64") || Platform.getOSArch().equals("aarch64");
            String key32bit = null;
            int i = 0;
            while ((subkey = registry.getCurrentUserKeyName(uninstallKey, i)) != null) {
                block14: {
                    String mingwLocation;
                    File gccFile;
                    String installLocation;
                    String displayName;
                    String compKey;
                    block15: {
                        block16: {
                            compKey = uninstallKey + "\\" + subkey;
                            displayName = registry.getCurrentUserValue(compKey, "DisplayName");
                            if (displayName == null) break block14;
                            if (!on64bit) break block15;
                            if (!MSYS2_64BIT_NAMES.contains(displayName)) break block16;
                            installLocation = registry.getCurrentUserValue(compKey, "InstallLocation");
                            for (String subsys : MSYS2_MINGW_SUBSYSTEMS) {
                                String mingwLocation2 = installLocation + "\\" + subsys;
                                for (String toolName : MSYS2_MINGW_SUBSYSTEM_SELECTION_TOOLS) {
                                    File toolFile = new File(mingwLocation2 + "\\bin\\" + toolName + ".exe");
                                    if (!toolFile.canExecute()) continue;
                                    rootValue = mingwLocation2;
                                    break;
                                }
                                if (rootValue != null) break;
                            }
                            if (rootValue != null) {
                                break;
                            }
                            break block14;
                        }
                        if (!"MSYS2 32bit".equals(displayName)) break block14;
                        key32bit = compKey;
                        break block14;
                    }
                    if ("MSYS2 32bit".equals(displayName) && (gccFile = new File((mingwLocation = (installLocation = registry.getCurrentUserValue(compKey, "InstallLocation")) + "\\mingw32") + "\\bin\\gcc.exe")).canExecute()) {
                        rootValue = mingwLocation;
                        break;
                    }
                }
                ++i;
            }
            if (on64bit && key32bit != null) {
                String installLocation = registry.getCurrentUserValue(key32bit, "InstallLocation");
                String mingwLocation = installLocation + "\\mingw64";
                File gccFile = new File(mingwLocation + "\\bin\\gcc.exe");
                if (gccFile.canExecute()) {
                    rootValue = mingwLocation;
                } else {
                    mingwLocation = installLocation + "\\mingw32";
                    gccFile = new File(mingwLocation + "\\bin\\gcc.exe");
                    if (gccFile.canExecute()) {
                        rootValue = mingwLocation;
                    }
                }
            }
        }
        if (rootValue == null && (mingwBinDir = new Path("C:\\MinGW")).toFile().isDirectory()) {
            rootValue = mingwBinDir.toOSString();
        }
        return rootValue;
    }

    private static Optional<String> findMinGwInstallationLocation(String exeName, String envPath) {
        IPath exeLocation = PathUtil.findProgramLocation(exeName, envPath);
        if (exeLocation != null) {
            return Optional.of(exeLocation.removeLastSegments(2).toOSString());
        }
        return Optional.empty();
    }

    private static String findMingwInPath(String envPath) {
        String mingwLocation;
        IEnvironmentVariable varPath;
        if (envPath == null && (varPath = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariable(ENV_PATH, (ICConfigurationDescription)null, true)) != null) {
            envPath = varPath.getValue();
        }
        if ((mingwLocation = mingwLocationCache.get(envPath)) == null && !mingwLocationCache.containsKey(envPath)) {
            if ("x86_64".equals(Platform.getOSArch())) {
                mingwLocation = MinGW.findMinGwInstallationLocation("x86_64-w64-mingw32-gcc.exe", envPath).orElse(null);
            } else if ("aarch64".equals(Platform.getOSArch())) {
                mingwLocation = MinGW.findMinGwInstallationLocation("aarch64-w64-mingw32-gcc.exe", envPath).orElse(null);
            }
            if (mingwLocation == null) {
                mingwLocation = MinGW.findMinGwInstallationLocation("mingw32-gcc.exe", envPath).orElse(null);
            }
            if (mingwLocation == null) {
                mingwLocation = MinGW.findMinGwInstallationLocation("gcc.exe", envPath).filter(path -> path.toLowerCase().contains("mingw")).orElse(null);
            }
            mingwLocationCache.put(envPath, mingwLocation);
        }
        return mingwLocation;
    }

    private static String findMSysRoot(String envMinGWHomeValue) {
        Path defaultMsysBin;
        Path minGwMsysBin;
        String msysHome;
        block8: {
            String home;
            String subkey;
            msysHome = null;
            Path installPath = new Path(Platform.getInstallLocation().getURL().getFile());
            IPath installMsysBin = installPath.append("msys\\bin");
            if (installMsysBin.toFile().isDirectory()) {
                msysHome = installMsysBin.removeLastSegments(1).toOSString();
            }
            if (msysHome == null && envMinGWHomeValue != null && !envMinGWHomeValue.isEmpty() && (minGwMsysBin = new Path(envMinGWHomeValue + "\\msys\\1.0\\bin")).toFile().isDirectory()) {
                msysHome = minGwMsysBin.removeLastSegments(1).toOSString();
            }
            if (msysHome != null) break block8;
            WindowsRegistry registry = WindowsRegistry.getRegistry();
            String uninstallKey = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
            boolean on64bit = Platform.getOSArch().equals("x86_64") || Platform.getOSArch().equals("aarch64");
            String key32bit = null;
            int i = 0;
            while ((subkey = registry.getCurrentUserKeyName(uninstallKey, i)) != null) {
                block9: {
                    String home2;
                    String displayName;
                    String compKey;
                    block10: {
                        block11: {
                            compKey = uninstallKey + "\\" + subkey;
                            displayName = registry.getCurrentUserValue(compKey, "DisplayName");
                            if (displayName == null) break block9;
                            if (!on64bit) break block10;
                            if (!MSYS2_64BIT_NAMES.contains(displayName)) break block11;
                            home2 = registry.getCurrentUserValue(compKey, "InstallLocation");
                            if (new File(home2).isDirectory()) {
                                msysHome = home2;
                                break;
                            }
                            break block9;
                        }
                        if (!"MSYS2 32bit".equals(displayName)) break block9;
                        key32bit = compKey;
                        break block9;
                    }
                    if ("MSYS2 32bit".equals(displayName) && new File(home2 = registry.getCurrentUserValue(compKey, "InstallLocation")).isDirectory()) {
                        msysHome = home2;
                        break;
                    }
                }
                ++i;
            }
            if (on64bit && key32bit != null && new File(home = registry.getCurrentUserValue(key32bit, "InstallLocation")).isDirectory()) {
                msysHome = home;
            }
        }
        if (msysHome == null && (minGwMsysBin = new Path("C:\\MinGW\\msys\\1.0\\bin")).toFile().isDirectory()) {
            msysHome = minGwMsysBin.removeLastSegments(1).toOSString();
        }
        if (msysHome == null && (defaultMsysBin = new Path("C:\\msys\\1.0\\bin")).toFile().isDirectory()) {
            msysHome = defaultMsysBin.removeLastSegments(1).toOSString();
        }
        return msysHome;
    }

    public static String getMinGWHome() {
        String envMinGWHomeValue;
        if (!isWindowsPlatform) {
            return null;
        }
        IEnvironmentVariable varPath = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariable(ENV_PATH, (ICConfigurationDescription)null, true);
        String envPathValue = varPath != null ? varPath.getValue() : null;
        IEnvironmentVariable varMinGWHome = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariable(ENV_MINGW_HOME, (ICConfigurationDescription)null, true);
        String string = envMinGWHomeValue = varMinGWHome != null ? varMinGWHome.getValue() : null;
        if (isMinGWLocationCached && Objects.equals(envPathValue, envPathValueCached) && Objects.equals(envMinGWHomeValue, envMinGWHomeValueCached)) {
            return minGWLocation;
        }
        minGWLocation = MinGW.findMinGWRoot(envPathValue, envMinGWHomeValue);
        envPathValueCached = envPathValue;
        envMinGWHomeValueCached = envMinGWHomeValue;
        isMinGWLocationCached = true;
        return minGWLocation;
    }

    public static String getMSysHome() {
        String msysHomeValue;
        if (!isWindowsPlatform) {
            return null;
        }
        IEnvironmentVariable varMsysHome = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariable(ENV_MSYS_HOME, (ICConfigurationDescription)null, true);
        String string = msysHomeValue = varMsysHome != null ? varMsysHome.getValue() : null;
        if (msysHomeValue != null) {
            return msysHomeValue;
        }
        String envMinGWHomeValue = MinGW.getMinGWHome();
        if (isMSysLocationCached && Objects.equals(envMinGWHomeValue, envMinGWHomeValueCached_msys)) {
            return mSysLocation;
        }
        mSysLocation = MinGW.findMSysRoot(envMinGWHomeValue);
        envMinGWHomeValueCached_msys = envMinGWHomeValue;
        isMSysLocationCached = true;
        return mSysLocation;
    }

    public static boolean isAvailable(String envPath) {
        return isWindowsPlatform && MinGW.findMinGWRoot(envPath, null) != null;
    }

    public static boolean isAvailable() {
        return isWindowsPlatform && MinGW.findMingwInPath(null) != null;
    }
}

