/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlTimeGraphViewCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlXYViewCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlOutputElement;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenTimeGraphProviderFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenXYProviderFactory;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.model.DataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TmfTimeGraphCompositeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.TmfTreeXYCompositeDataProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.w3c.dom.Element;

public class XmlDataProviderManager {
    private static @Nullable XmlDataProviderManager INSTANCE;
    private static final String ID_ATTRIBUTE = "id";
    private final Table<ITmfTrace, String, ITmfTreeXYDataProvider<@NonNull ITmfTreeDataModel>> fXyProviders = HashBasedTable.create();
    private final Table<ITmfTrace, String, ITimeGraphDataProvider<@NonNull TimeGraphEntryModel>> fTimeGraphProviders = HashBasedTable.create();
    private final Map<String, @Nullable DataDrivenTimeGraphProviderFactory> fTimeGraphFactories = new HashMap<String, DataDrivenTimeGraphProviderFactory>();
    private final Map<String, @Nullable DataDrivenXYProviderFactory> fXYFactories = new HashMap<String, DataDrivenXYProviderFactory>();

    public static synchronized XmlDataProviderManager getInstance() {
        XmlDataProviderManager instance = INSTANCE;
        if (instance == null) {
            INSTANCE = instance = new XmlDataProviderManager();
        }
        return instance;
    }

    public static synchronized void dispose() {
        XmlDataProviderManager manager = INSTANCE;
        if (manager != null) {
            TmfSignalManager.deregister((Object)manager);
            manager.fXyProviders.clear();
            manager.fTimeGraphProviders.clear();
        }
        INSTANCE = null;
    }

    private XmlDataProviderManager() {
        TmfSignalManager.register((Object)this);
    }

    public synchronized @Nullable DataDrivenXYProviderFactory getXyProviderFactory(Element viewElement) {
        if (!viewElement.hasAttribute(ID_ATTRIBUTE)) {
            return null;
        }
        String viewId = viewElement.getAttribute(ID_ATTRIBUTE);
        if (this.fXYFactories.containsKey(viewId)) {
            return this.fXYFactories.get(viewId);
        }
        DataDrivenXYProviderFactory factory = null;
        TmfXmlXYViewCu tgViewCu = TmfXmlXYViewCu.compile(new AnalysisCompilationData(), viewElement);
        if (tgViewCu != null) {
            factory = tgViewCu.generate();
        }
        this.fXYFactories.put(viewId, factory);
        return factory;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public synchronized @Nullable ITmfTreeXYDataProvider<@NonNull ITmfTreeDataModel> getXyProvider(ITmfTrace trace, Element viewElement) {
        DataDrivenXYProviderFactory xyFactory;
        if (!viewElement.hasAttribute(ID_ATTRIBUTE)) {
            return null;
        }
        String viewId = viewElement.getAttribute(ID_ATTRIBUTE);
        @NonNull ITmfTreeXYDataProvider provider = (ITmfTreeXYDataProvider)this.fXyProviders.get((Object)trace, (Object)viewId);
        if (provider != null) {
            return provider;
        }
        if (Iterables.any((Iterable)TmfTraceManager.getInstance().getOpenedTraces(), opened -> TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)opened).contains(trace)) && (xyFactory = this.getXyProviderFactory(viewElement)) != null) {
            return this.createXYProvider(trace, viewId, xyFactory);
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public synchronized @Nullable ITmfTreeXYDataProvider<@NonNull ITmfTreeDataModel> getXyProvider(ITmfTrace trace, String providerId) {
        @NonNull ITmfTreeXYDataProvider provider = (ITmfTreeXYDataProvider)this.fXyProviders.get((Object)trace, (Object)providerId);
        if (provider != null) {
            return provider;
        }
        DataDrivenXYProviderFactory factory = this.fXYFactories.get(providerId);
        if (factory != null) {
            return this.createXYProvider(trace, providerId, factory);
        }
        return null;
    }

    private @Nullable ITmfTreeXYDataProvider<@NonNull ITmfTreeDataModel> createXYProvider(ITmfTrace trace, String providerId, DataDrivenXYProviderFactory xyFactory) {
        ITmfTreeXYDataProvider<@NonNull ITmfTreeDataModel> provider = xyFactory.create(trace);
        if (provider == null && trace instanceof TmfExperiment) {
            provider = this.generateExperimentProviderXy(TmfTraceManager.getTraceSet((ITmfTrace)trace), providerId);
        }
        if (provider != null) {
            this.fXyProviders.put((Object)trace, (Object)providerId, provider);
        }
        return provider;
    }

    private @Nullable ITmfTreeXYDataProvider<@NonNull ITmfTreeDataModel> generateExperimentProviderXy(Collection<@NonNull ITmfTrace> traces, String providerId) {
        ArrayList<@NonNull ITmfTreeXYDataProvider<@NonNull ITmfTreeDataModel>> providers = new ArrayList<ITmfTreeXYDataProvider<ITmfTreeDataModel>>();
        for (ITmfTrace child : traces) {
            ITmfTreeXYDataProvider<@NonNull ITmfTreeDataModel> childProvider = this.getXyProvider(child, providerId);
            if (childProvider == null) continue;
            providers.add(childProvider);
        }
        if (providers.isEmpty()) {
            return null;
        }
        if (providers.size() == 1) {
            return (ITmfTreeXYDataProvider)providers.get(0);
        }
        return new TmfTreeXYCompositeDataProvider(providers, "org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlXYDataProvider", "org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlXYDataProvider");
    }

    public synchronized @Nullable DataDrivenTimeGraphProviderFactory getTimeGraphProviderFactory(Element viewElement) {
        if (!viewElement.hasAttribute(ID_ATTRIBUTE)) {
            return null;
        }
        String viewId = viewElement.getAttribute(ID_ATTRIBUTE);
        if (this.fTimeGraphFactories.containsKey(viewId)) {
            return this.fTimeGraphFactories.get(viewId);
        }
        DataDrivenTimeGraphProviderFactory factory = null;
        TmfXmlTimeGraphViewCu tgViewCu = TmfXmlTimeGraphViewCu.compile(new AnalysisCompilationData(), viewElement);
        if (tgViewCu != null) {
            factory = tgViewCu.generate();
        }
        this.fTimeGraphFactories.put(viewId, factory);
        return factory;
    }

    public synchronized @Nullable ITimeGraphDataProvider<@NonNull TimeGraphEntryModel> getTimeGraphProvider(ITmfTrace trace, Element viewElement) {
        TmfXmlTimeGraphViewCu tgViewCu;
        if (!viewElement.hasAttribute(ID_ATTRIBUTE)) {
            return null;
        }
        String viewId = viewElement.getAttribute(ID_ATTRIBUTE);
        ITimeGraphDataProvider<@NonNull TimeGraphEntryModel> provider = (ITimeGraphDataProvider<TimeGraphEntryModel>)this.fTimeGraphProviders.get((Object)trace, (Object)viewId);
        if (provider != null) {
            return provider;
        }
        if (Iterables.any((Iterable)TmfTraceManager.getInstance().getOpenedTraces(), opened -> TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)opened).contains(trace)) && (tgViewCu = TmfXmlTimeGraphViewCu.compile(new AnalysisCompilationData(), viewElement)) != null) {
            DataDrivenTimeGraphProviderFactory timeGraphFactory = tgViewCu.generate();
            provider = timeGraphFactory.create(trace);
            if (provider == null && trace instanceof TmfExperiment) {
                provider = this.generateExperimentProviderTimeGraph(TmfTraceManager.getTraceSet((ITmfTrace)trace), viewElement);
            }
            if (provider != null) {
                this.fTimeGraphProviders.put((Object)trace, (Object)viewId, provider);
            }
            return provider;
        }
        return null;
    }

    private @Nullable ITimeGraphDataProvider<@NonNull TimeGraphEntryModel> generateExperimentProviderTimeGraph(Collection<@NonNull ITmfTrace> traces, Element viewElement) {
        ArrayList<@NonNull ITimeGraphDataProvider<@NonNull TimeGraphEntryModel>> providers = new ArrayList<ITimeGraphDataProvider<TimeGraphEntryModel>>();
        for (ITmfTrace child : traces) {
            ITimeGraphDataProvider<@NonNull TimeGraphEntryModel> childProvider = this.getTimeGraphProvider(child, viewElement);
            if (childProvider == null) continue;
            providers.add(childProvider);
        }
        if (providers.isEmpty()) {
            return null;
        }
        if (providers.size() == 1) {
            return (ITimeGraphDataProvider)providers.get(0);
        }
        return new TmfTimeGraphCompositeDataProvider(providers, "org.eclipse.tracecompass.tmf.analysis.xml.core.output.DataDrivenTimeGraphDataProvider");
    }

    @TmfSignalHandler
    public synchronized void traceClosed(TmfTraceClosedSignal signal) {
        for (ITmfTrace trace : TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)signal.getTrace())) {
            this.fXyProviders.row((Object)trace).clear();
            this.fTimeGraphProviders.row((Object)trace).clear();
        }
    }

    public void refreshDataProviderFactories() {
        this.fTimeGraphFactories.clear();
        this.fXYFactories.clear();
    }

    public <P extends ITmfTreeDataProvider<? extends ITmfTreeDataModel>> @Nullable P getXmlProvider(ITmfTrace trace, String id, Set<XmlUtils.OutputType> types) {
        for (XmlUtils.OutputType viewType : types) {
            for (XmlOutputElement element2 : Iterables.filter((Iterable)XmlUtils.getXmlOutputElements().values(), element -> element.getXmlElem().equals(viewType.getXmlElem()) && id.equals(element.getId()))) {
                Element viewElement = TmfXmlUtils.getElementInFile(element2.getPath(), viewType.getXmlElem(), id);
                if (viewElement != null && viewType == XmlUtils.OutputType.XY) {
                    return (P)this.getXyProvider(trace, viewElement);
                }
                if (viewElement == null || viewType != XmlUtils.OutputType.TIME_GRAPH) continue;
                return (P)this.getTimeGraphProvider(trace, viewElement);
            }
        }
        return null;
    }

    public List<IDataProviderDescriptor> getXmlDataProviderDescriptors(ITmfTrace trace, Set<XmlUtils.OutputType> types) {
        ArrayList<IDataProviderDescriptor> descriptors = new ArrayList<IDataProviderDescriptor>();
        HashSet<String> existingDps = new HashSet<String>();
        for (ITmfTrace tr : TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)trace)) {
            Map modules = TmfAnalysisManager.getAnalysisModules(tr.getClass());
            for (XmlUtils.OutputType viewType : types) {
                block2: for (XmlOutputElement element2 : Iterables.filter((Iterable)XmlUtils.getXmlOutputElements().values(), element -> element.getXmlElem().equals(viewType.getXmlElem()))) {
                    DataProviderDescriptor.Builder builder = new DataProviderDescriptor.Builder();
                    String label = String.valueOf(element2.getLabel());
                    String elemId = element2.getId();
                    if (elemId == null) continue;
                    builder.setId(elemId);
                    if (viewType == XmlUtils.OutputType.XY) {
                        builder.setProviderType(IDataProviderDescriptor.ProviderType.TREE_TIME_XY);
                    } else if (viewType == XmlUtils.OutputType.TIME_GRAPH) {
                        builder.setProviderType(IDataProviderDescriptor.ProviderType.TIME_GRAPH);
                    }
                    for (String id : element2.getAnalyses()) {
                        if (!modules.containsKey(id) || existingDps.contains(elemId)) continue;
                        String analysisName = Objects.requireNonNull((IAnalysisModuleHelper)modules.get(id)).getName();
                        builder.setName(analysisName + ": " + label);
                        builder.setDescription(label + " provided by Analysis module: " + analysisName);
                        descriptors.add(builder.build());
                        existingDps.add(elemId);
                        continue block2;
                    }
                }
            }
        }
        return descriptors;
    }
}

