/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.enumeration;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.CtfCoreLoggerUtil;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMemberMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.UnaryIntegerParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.UnaryStringParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class EnumeratorParser
implements ICommonTreeParser {
    private static final String MAPPINGS = "mappings";
    public static final EnumeratorParser INSTANCE = new EnumeratorParser();

    private EnumeratorParser() {
    }

    @Override
    public Long parse(ICTFMetadataNode enumerator, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        EnumDeclaration enumDeclaration = ((Param)param).fEnumDeclaration;
        long low = 0L;
        long high = 0L;
        boolean valueSpecified = false;
        String label = null;
        if (enumerator instanceof JsonStructureFieldMemberMetadataNode) {
            JsonObject fieldClass;
            JsonStructureFieldMemberMetadataNode jsonEnum = (JsonStructureFieldMemberMetadataNode)enumerator;
            if (jsonEnum.getFieldClass().isJsonObject() && (fieldClass = jsonEnum.getFieldClass().getAsJsonObject()).has(MAPPINGS)) {
                JsonObject mappings = fieldClass.get(MAPPINGS).getAsJsonObject();
                Set enumerations = mappings.entrySet();
                for (Map.Entry enumeration : enumerations) {
                    label = (String)enumeration.getKey();
                    JsonArray range = ((JsonElement)enumeration.getValue()).getAsJsonArray().get(0).getAsJsonArray();
                    low = range.get(0).getAsLong();
                    high = range.get(1).getAsLong();
                    EnumeratorParser.setEnumeration(enumDeclaration, low, high, true, label);
                }
            }
        } else {
            List<ICTFMetadataNode> children = enumerator.getChildren();
            for (ICTFMetadataNode child : children) {
                if (TsdlUtils.isAnyUnaryString(child)) {
                    label = UnaryStringParser.INSTANCE.parse(child, null);
                    continue;
                }
                if (CTFParser.tokenNames[96].equals(child.getType())) {
                    valueSpecified = true;
                    high = low = UnaryIntegerParser.INSTANCE.parse(child.getChild(0), null).longValue();
                    continue;
                }
                if (CTFParser.tokenNames[97].equals(child.getType())) {
                    valueSpecified = true;
                    low = UnaryIntegerParser.INSTANCE.parse(child.getChild(0), null);
                    high = UnaryIntegerParser.INSTANCE.parse(child.getChild(1), null);
                    continue;
                }
                throw TsdlUtils.childTypeError(child);
            }
            EnumeratorParser.setEnumeration(enumDeclaration, low, high, valueSpecified, label);
        }
        return high;
    }

    private static void setEnumeration(EnumDeclaration enumDeclaration, long low, long high, boolean valueSpecified, String label) throws ParseException {
        if (low > high) {
            throw new ParseException("enum low value greater than high value");
        }
        if (valueSpecified && !enumDeclaration.add(low, high, label)) {
            CtfCoreLoggerUtil.logWarning("enum declarator values overlap. " + String.valueOf(enumDeclaration.getLabels()) + " and " + label);
        } else if (!valueSpecified && !enumDeclaration.add(label)) {
            throw new ParseException("enum cannot add element " + label);
        }
        IntegerDeclaration enumContainerType = enumDeclaration.getContainerType();
        if (valueSpecified && (BigInteger.valueOf(low).compareTo(enumContainerType.getMinValue()) < 0 || BigInteger.valueOf(high).compareTo(enumContainerType.getMaxValue()) > 0)) {
            throw new ParseException(String.format("enum value ( %d - %d ) is not in range ( %d - %d )", low, high, enumContainerType.getMinValue(), enumContainerType.getMinValue()));
        }
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final EnumDeclaration fEnumDeclaration;

        public Param(EnumDeclaration enumDeclaration) {
            this.fEnumDeclaration = enumDeclaration;
        }
    }
}

