/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.dpdk.core.mempool.analysis;

import java.util.Iterator;
import java.util.Objects;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.Activator;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.analysis.IDpdkEventHandler;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.mempool.analysis.DpdkMempoolEventLayout;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemBuilderUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class DpdkMempoolEventHandler
implements IDpdkEventHandler {
    DpdkMempoolEventHandler() {
    }

    private static void updateThreadCount(ITmfStateSystemBuilder ssb, Long mempoolId, String threadName, String metricLabel, int nbObjs, long ts) {
        int mempoolQuark = ssb.optQuarkAbsolute(new String[]{"Mempools", mempoolId.toString()});
        if (mempoolQuark != -2) {
            int threadsQuark = -2;
            try {
                threadsQuark = ssb.getQuarkRelativeAndAdd(mempoolQuark, new String[]{"threads"});
            }
            catch (IndexOutOfBoundsException e) {
                Activator.getInstance().logError(e.getMessage());
            }
            if (threadsQuark != -2) {
                int threadQuark = ssb.getQuarkRelativeAndAdd(threadsQuark, new String[]{threadName});
                int metricQuark = ssb.getQuarkRelativeAndAdd(threadQuark, new String[]{metricLabel});
                StateSystemBuilderUtils.incrementAttributeLong((ITmfStateSystemBuilder)ssb, (long)ts, (int)metricQuark, (long)nbObjs);
            }
        }
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ssb, ITmfEvent event) {
        String eventName = event.getName();
        long ts = event.getTimestamp().getValue();
        Long mempoolId = (Long)event.getContent().getFieldValue(Long.class, new String[]{DpdkMempoolEventLayout.fieldMempoolId()});
        Objects.requireNonNull(mempoolId);
        if (eventName.equals(DpdkMempoolEventLayout.eventMempoolCreate()) || eventName.equals(DpdkMempoolEventLayout.eventMempoolCreateEmpty())) {
            String mempoolName = (String)event.getContent().getFieldValue(String.class, new String[]{DpdkMempoolEventLayout.fieldMempoolName()});
            if (mempoolName != null) {
                int mempoolQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"Mempools", String.valueOf(mempoolId)});
                int nameQuark = ssb.getQuarkRelativeAndAdd(mempoolQuark, new String[]{"name"});
                ssb.modifyAttribute(ts, (Object)mempoolName, nameQuark);
            }
        } else if (eventName.equals(DpdkMempoolEventLayout.eventMempoolFree())) {
            int mempoolQuark = ssb.optQuarkAbsolute(new String[]{"Mempools", mempoolId.toString()});
            if (mempoolQuark != -2) {
                Iterator iterator = ssb.getSubAttributes(mempoolQuark, true).iterator();
                while (iterator.hasNext()) {
                    int quark = (Integer)iterator.next();
                    ssb.modifyAttribute(ts, null, quark);
                }
            }
        } else if (eventName.equals(DpdkMempoolEventLayout.eventMempoolGenericPut())) {
            String threadName = (String)event.getContent().getFieldValue(String.class, new String[]{DpdkMempoolEventLayout.fieldThreadName()});
            Integer nbObjs = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{DpdkMempoolEventLayout.fieldMempoolNbObjs()});
            if (threadName != null && nbObjs != null) {
                DpdkMempoolEventHandler.updateThreadCount(ssb, mempoolId, threadName, "free", nbObjs, ts);
            }
        } else if (eventName.equals(DpdkMempoolEventLayout.eventMempoolGenericGet())) {
            String threadName = (String)event.getContent().getFieldValue(String.class, new String[]{DpdkMempoolEventLayout.fieldThreadName()});
            Integer nbObjs = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{DpdkMempoolEventLayout.fieldMempoolNbObjs()});
            if (threadName != null && nbObjs != null) {
                DpdkMempoolEventHandler.updateThreadCount(ssb, mempoolId, threadName, "alloc", nbObjs, ts);
            }
        } else {
            Activator.getInstance().logError(eventName + " is an unexpected event!");
        }
    }
}

