/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.eclipse.core.runtime.Assert;

public class ProcessClosure {
    protected static int fCounter = 0;
    protected Process fProcess;
    protected OutputStream fOutput;
    protected OutputStream fError;
    protected ReaderThread fOutputReader;
    protected ReaderThread fErrorReader;

    public ProcessClosure(Process process, OutputStream outputStream, OutputStream errorStream) {
        this.fProcess = process;
        this.fOutput = outputStream;
        this.fError = errorStream;
    }

    public void runNonBlocking() {
        ThreadGroup group = new ThreadGroup("CBuilder" + fCounter++);
        InputStream stdin = this.fProcess.getInputStream();
        InputStream stderr = this.fProcess.getErrorStream();
        this.fOutputReader = new ReaderThread(group, "OutputReader", stdin, this.fOutput);
        this.fErrorReader = new ReaderThread(group, "ErrorReader", stderr, this.fError);
        this.fOutputReader.start();
        this.fErrorReader.start();
    }

    public void runBlocking() {
        this.runNonBlocking();
        boolean finished = false;
        while (!finished) {
            try {
                this.fProcess.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.fProcess.exitValue();
                finished = true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
        if (!this.fOutputReader.finished()) {
            this.fOutputReader.waitFor();
        }
        if (!this.fErrorReader.finished()) {
            this.fErrorReader.waitFor();
        }
        this.fOutputReader.close();
        this.fErrorReader.close();
        this.fProcess = null;
        this.fOutputReader = null;
        this.fErrorReader = null;
    }

    public boolean isAlive() {
        if (this.fProcess != null) {
            if (this.fOutputReader.isAlive() || this.fErrorReader.isAlive()) {
                return true;
            }
            this.fProcess = null;
            this.fOutputReader.close();
            this.fErrorReader.close();
            this.fOutputReader = null;
            this.fErrorReader = null;
        }
        return false;
    }

    public boolean isRunning() {
        if (this.fProcess != null) {
            if (this.fOutputReader.isAlive() || this.fErrorReader.isAlive()) {
                return true;
            }
            this.fProcess = null;
        }
        return false;
    }

    public void terminate() {
        if (this.fProcess != null) {
            this.fProcess.destroy();
            this.fProcess = null;
        }
        if (this.fOutputReader != null) {
            if (!this.fOutputReader.finished()) {
                this.fOutputReader.waitFor();
            }
            this.fOutputReader.close();
        }
        if (this.fErrorReader != null) {
            if (!this.fErrorReader.finished()) {
                this.fErrorReader.waitFor();
            }
            this.fErrorReader.close();
        }
        this.fOutputReader = null;
        this.fErrorReader = null;
    }

    protected static class ReaderThread
    extends Thread {
        private InputStream fInputStream;
        private OutputStream fOutputStream;
        private boolean fFinished = false;
        private String lineSeparator;

        public ReaderThread(ThreadGroup group, String name, InputStream in, OutputStream out) {
            super(group, name);
            Assert.isNotNull((Object)in);
            Assert.isNotNull((Object)out);
            this.fOutputStream = out;
            this.fInputStream = in;
            this.setDaemon(true);
            this.lineSeparator = System.getProperty("line.separator");
        }

        @Override
        public void run() {
            try {
                try {
                    try {
                        Object line;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(this.fInputStream));
                        while ((line = reader.readLine()) != null) {
                            line = (String)line + this.lineSeparator;
                            this.fOutputStream.write(((String)line).getBytes());
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            this.fOutputStream.flush();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                        try {
                            this.fInputStream.close();
                        }
                        catch (IOException iOException3) {}
                    }
                }
                finally {
                    try {
                        this.fOutputStream.flush();
                    }
                    catch (IOException iOException) {}
                    try {
                        this.fInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                this.complete();
            }
        }

        public synchronized boolean finished() {
            return this.fFinished;
        }

        public synchronized void waitFor() {
            while (!this.fFinished) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public synchronized void complete() {
            this.fFinished = true;
            this.notify();
        }

        public void close() {
            try {
                this.fOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

