/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ctf.core.event.aspect;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.event.types.ICompositeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.internal.tmf.ctf.core.event.aspect.Messages;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEventField;

public class CtfEventContextAspect
implements ITmfEventAspect<List<ITmfEventField>> {
    private static final @NonNull String ANON = "";
    private static ITmfEventAspect<List<ITmfEventField>> sInstance = null;

    public static @NonNull ITmfEventAspect<List<ITmfEventField>> getInstance() {
        CtfEventContextAspect instance = sInstance;
        if (instance == null) {
            sInstance = instance = new CtfEventContextAspect();
        }
        return instance;
    }

    private CtfEventContextAspect() {
    }

    public List<ITmfEventField> resolve(ITmfEvent event) {
        if (!(event instanceof CtfTmfEvent)) {
            return null;
        }
        ICompositeDefinition eventContext = ((CtfTmfEvent)event).getEventContext();
        if (eventContext == null) {
            return null;
        }
        Object value = CtfTmfEventField.parseField((IDefinition)eventContext, ANON).getValue();
        if (value instanceof ITmfEventField[]) {
            return Arrays.asList((ITmfEventField[])value);
        }
        return null;
    }

    public @NonNull String getName() {
        return Messages.getMessage(Messages.CtfEventContextAspect_name);
    }

    public @NonNull String getHelpText() {
        return Messages.getMessage(Messages.CtfEventContextAspect_description);
    }

    public boolean isHiddenByDefault() {
        return true;
    }
}

