/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.callstack;

import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.base.IDataPalette;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.AggregatedCallSite;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.CallGraph;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.ICallGraphProvider2;
import org.eclipse.tracecompass.analysis.profiling.core.callstack2.CallStackHostUtils;
import org.eclipse.tracecompass.analysis.profiling.core.callstack2.CallStackSeries;
import org.eclipse.tracecompass.analysis.profiling.core.instrumented.IFlameChartProvider;
import org.eclipse.tracecompass.analysis.profiling.core.instrumented.SymbolAspect;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeGroupDescriptor;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.CallGraphAnalysis;
import org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented.FunctionTidAspect;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.callstack.CallstackXmlModuleHelper;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.w3c.dom.Element;

public class CallstackXmlAnalysis
extends TmfAbstractAnalysisModule
implements IFlameChartProvider,
ITmfAnalysisModuleWithStateSystems,
ICallGraphProvider2 {
    private final Path fSourceFile;
    private final CallstackXmlModuleHelper.ISubModuleHelper fHelper;
    private @Nullable IAnalysisModule fModule = null;
    private @Nullable CallStackSeries fCallStacks = null;
    private final CallGraphAnalysis fCallGraph;
    private boolean fHasTid = false;
    private final ListenerList<IAnalysisProgressListener> fListeners = new ListenerList(1);

    public CallstackXmlAnalysis(Path sourceFile, CallstackXmlModuleHelper.ISubModuleHelper helper) {
        this.fSourceFile = sourceFile;
        this.fHelper = helper;
        this.fCallGraph = new CallGraphAnalysis((IFlameChartProvider)this);
    }

    public @Nullable CallStackSeries getCallStackSeries() {
        CallStackSeries series = this.fCallStacks;
        if (series == null) {
            Element hostElement;
            String attribute;
            IAnalysisModule module = this.getAnalysisModule();
            if (!(module instanceof ITmfAnalysisModuleWithStateSystems)) {
                return null;
            }
            Iterator stateSystems = ((ITmfAnalysisModuleWithStateSystems)module).getStateSystems().iterator();
            if (!stateSystems.hasNext()) {
                return null;
            }
            ITmfStateSystem ss = (ITmfStateSystem)stateSystems.next();
            Path xmlFile = this.fSourceFile;
            String pathString = xmlFile.toString();
            Element doc = TmfXmlUtils.getElementInFile(pathString, "callstack", this.getId());
            if (doc == null) {
                this.fCallStacks = null;
                return null;
            }
            List<Element> callStackElements = TmfXmlUtils.getChildElements(doc, "callstackGroup");
            if (callStackElements.size() > 1) {
                Activator.logWarning("More than one callstack series defined. Only the first one will be displayed");
            } else if (callStackElements.isEmpty()) {
                this.fCallStacks = null;
                return null;
            }
            Element callStackElement = callStackElements.get(0);
            ArrayList<String[]> patterns = new ArrayList<String[]>();
            for (Element child : TmfXmlUtils.getChildElements(callStackElement, "level")) {
                String attribute2 = child.getAttribute("path");
                patterns.add(attribute2.split("/"));
            }
            List<Element> childElements = TmfXmlUtils.getChildElements(callStackElement, "thread");
            Object resolver = null;
            if (!childElements.isEmpty()) {
                Element threadElement = childElements.get(0);
                String attribute3 = threadElement.getAttribute("cpu");
                if (!attribute3.isEmpty()) {
                    resolver = new CallStackSeries.CpuResolver(attribute3.split("/"));
                } else {
                    attribute3 = threadElement.getAttribute("level");
                    if (!attribute3.isEmpty()) {
                        String type = threadElement.getAttribute("type");
                        resolver = type.equals("value") ? new CallStackSeries.AttributeValueThreadResolver(Integer.valueOf(attribute3).intValue()) : new CallStackSeries.AttributeNameThreadResolver(Integer.valueOf(attribute3).intValue());
                    }
                }
            }
            this.fHasTid = resolver != null;
            childElements = TmfXmlUtils.getChildElements(callStackElement, "host");
            Object hostResolver = null;
            if (!childElements.isEmpty() && !(attribute = (hostElement = childElements.get(0)).getAttribute("level")).isEmpty()) {
                String type = hostElement.getAttribute("type");
                hostResolver = type.equals("value") ? new CallStackHostUtils.AttributeValueHostResolver(Integer.valueOf(attribute).intValue()) : new CallStackHostUtils.AttributeNameHostResolver(Integer.valueOf(attribute).intValue());
            }
            hostResolver = hostResolver == null ? new CallStackHostUtils.TraceHostIdResolver(Objects.requireNonNull(this.getTrace())) : hostResolver;
            this.fHasTid = resolver != null;
            this.fCallStacks = series = new CallStackSeries(ss, patterns, 0, callStackElement.getAttribute("name"), (CallStackHostUtils.IHostIdResolver)hostResolver, (CallStackSeries.IThreadIdResolver)resolver);
        }
        return series;
    }

    protected boolean executeAnalysis(IProgressMonitor monitor) throws TmfAnalysisException {
        IAnalysisModule analysisModule = this.getAnalysisModule();
        if (analysisModule == null) {
            return false;
        }
        boolean ret = analysisModule.waitForCompletion(monitor);
        if (!ret) {
            return ret;
        }
        ISegmentStore<ISegment> segmentStore = this.getSegmentStore();
        if (segmentStore != null) {
            this.sendUpdate(segmentStore);
        }
        this.fCallGraph.schedule();
        return true;
    }

    protected void canceling() {
        IAnalysisModule analysisModule = this.getAnalysisModule();
        if (analysisModule != null) {
            analysisModule.cancel();
        }
        this.fCallGraph.cancel();
    }

    public void dispose() {
        super.dispose();
        IAnalysisModule analysisModule = this.getAnalysisModule();
        if (analysisModule != null) {
            analysisModule.dispose();
        }
        this.fCallGraph.dispose();
    }

    public boolean setTrace(ITmfTrace trace) throws TmfAnalysisException {
        if (!super.setTrace(trace)) {
            return false;
        }
        return this.fCallGraph.setTrace(trace);
    }

    public void setName(String name) {
        super.setName(name);
        this.fCallGraph.setName(name);
    }

    protected Iterable<IAnalysisModule> getDependentAnalyses() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            throw new NullPointerException("Trace should not be null at this point");
        }
        IAnalysisModule module = this.getAnalysisModule();
        if (module == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(module);
    }

    private synchronized @Nullable IAnalysisModule getAnalysisModule() {
        IAnalysisModule module = this.fModule;
        if (module == null) {
            ITmfTrace trace = this.getTrace();
            if (trace == null) {
                return null;
            }
            module = this.fHelper.getAnalysis(trace);
            if (module != null) {
                this.fModule = module;
            }
        }
        return module;
    }

    public @Nullable ITmfStateSystem getStateSystem(String id) {
        IAnalysisModule analysisModule = this.getAnalysisModule();
        if (analysisModule instanceof ITmfAnalysisModuleWithStateSystems) {
            return ((ITmfAnalysisModuleWithStateSystems)analysisModule).getStateSystem(id);
        }
        return null;
    }

    public Iterable<ITmfStateSystem> getStateSystems() {
        IAnalysisModule analysisModule = this.getAnalysisModule();
        if (analysisModule instanceof ITmfAnalysisModuleWithStateSystems) {
            return ((ITmfAnalysisModuleWithStateSystems)analysisModule).getStateSystems();
        }
        return Collections.emptyList();
    }

    public boolean waitForInitialization() {
        IAnalysisModule analysisModule = this.getAnalysisModule();
        if (analysisModule instanceof ITmfAnalysisModuleWithStateSystems) {
            return ((ITmfAnalysisModuleWithStateSystems)analysisModule).waitForInitialization();
        }
        return false;
    }

    public Collection<IWeightedTreeGroupDescriptor> getGroupDescriptors() {
        this.fCallGraph.schedule();
        this.fCallGraph.waitForCompletion();
        return this.fCallGraph.getGroupDescriptors();
    }

    public CallGraph getCallGraph(ITmfTimestamp start, ITmfTimestamp end) {
        this.fCallGraph.schedule();
        this.fCallGraph.waitForCompletion();
        return this.fCallGraph.getCallGraph(start, end);
    }

    public CallGraph getCallGraph() {
        this.fCallGraph.schedule();
        this.fCallGraph.waitForCompletion();
        return this.fCallGraph.getCallGraph();
    }

    public AggregatedCallSite createCallSite(Object symbol) {
        return this.fCallGraph.createCallSite(symbol);
    }

    public String getTitle() {
        return this.fCallGraph.getTitle();
    }

    public void addListener(IAnalysisProgressListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeListener(IAnalysisProgressListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public Iterable<ISegmentAspect> getSegmentAspects() {
        if (this.fHasTid) {
            return ImmutableList.of((Object)FunctionTidAspect.TID_ASPECT, (Object)SymbolAspect.SYMBOL_ASPECT);
        }
        return Collections.singletonList(SymbolAspect.SYMBOL_ASPECT);
    }

    public @Nullable ISegmentStore<ISegment> getSegmentStore() {
        CallStackSeries series = this.getCallStackSeries();
        if (series == null) {
            return null;
        }
        return series;
    }

    protected Iterable<IAnalysisProgressListener> getListeners() {
        ArrayList<IAnalysisProgressListener> listeners = new ArrayList<IAnalysisProgressListener>();
        Object[] objectArray = this.fListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (listener != null) {
                listeners.add((IAnalysisProgressListener)listener);
            }
            ++n2;
        }
        return listeners;
    }

    protected void sendUpdate(ISegmentStore<ISegment> store) {
        for (IAnalysisProgressListener listener : this.getListeners()) {
            listener.onComplete((ISegmentStoreProvider)this, store);
        }
    }

    public boolean isComplete() {
        if (!this.waitForInitialization()) {
            return true;
        }
        Iterator<ITmfStateSystem> iterator = this.getStateSystems().iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException("The initialization is complete, so the state system must not be null");
        }
        return iterator.next().waitUntilBuilt(0L);
    }

    public long getEnd() {
        if (!this.waitForInitialization()) {
            return Integer.MIN_VALUE;
        }
        Iterator<ITmfStateSystem> iterator = this.getStateSystems().iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException("The initialization is complete, so the state system must not be null");
        }
        return iterator.next().getCurrentEndTime();
    }

    public List<String> getExtraDataSets() {
        return this.fCallGraph.getExtraDataSets();
    }

    public IWeightedTreeProvider.MetricType getWeightType() {
        return this.fCallGraph.getWeightType();
    }

    public List<IWeightedTreeProvider.MetricType> getAdditionalMetrics() {
        return this.fCallGraph.getAdditionalMetrics();
    }

    public String toDisplayString(AggregatedCallSite object) {
        return this.fCallGraph.toDisplayString(object);
    }

    public Object getAdditionalMetric(AggregatedCallSite object, int metricIndex) {
        return this.fCallGraph.getAdditionalMetric(object, metricIndex);
    }

    public IDataPalette getPalette() {
        this.fCallGraph.schedule();
        this.fCallGraph.waitForCompletion();
        return this.fCallGraph.getPalette();
    }

    public CallStackHostUtils.IHostIdResolver getHostIdResolver() {
        return new CallStackHostUtils.TraceHostIdResolver(this.getTrace());
    }
}

