/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.core.callstack;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.ust.core.callstack.Messages;
import org.eclipse.tracecompass.lttng2.ust.core.trace.layout.ILttngUstEventLayout;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAnalysisEventFieldRequirement;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfCompositeAnalysisRequirement;

@NonNullByDefault
public class LttngUstCallStackAnalysisRequirement
extends TmfCompositeAnalysisRequirement {
    public LttngUstCallStackAnalysisRequirement(ILttngUstEventLayout layout) {
        super(LttngUstCallStackAnalysisRequirement.getSubRequirements(layout), TmfAbstractAnalysisRequirement.PriorityLevel.AT_LEAST_ONE);
        this.addInformation(NonNullUtils.nullToEmptyString((Object)Messages.LttnUstCallStackAnalysisModule_EventsLoadingInformation));
    }

    private static Collection<TmfAbstractAnalysisRequirement> getSubRequirements(ILttngUstEventLayout layout) {
        Set<@NonNull String> requiredEventsFields = Collections.singleton(layout.contextVtid());
        TmfAnalysisEventFieldRequirement entryReq = new TmfAnalysisEventFieldRequirement(layout.eventCygProfileFuncEntry(), requiredEventsFields, TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        TmfAnalysisEventFieldRequirement exitReq = new TmfAnalysisEventFieldRequirement(layout.eventCygProfileFuncExit(), requiredEventsFields, TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        TmfCompositeAnalysisRequirement cygProfile = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)entryReq, (Object)exitReq), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        entryReq = new TmfAnalysisEventFieldRequirement(layout.eventCygProfileFastFuncEntry(), requiredEventsFields, TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        exitReq = new TmfAnalysisEventFieldRequirement(layout.eventCygProfileFastFuncExit(), requiredEventsFields, TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        TmfCompositeAnalysisRequirement cygProfileFast = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)entryReq, (Object)exitReq), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        return ImmutableSet.of((Object)cygProfile, (Object)cygProfileFast);
    }
}

