/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public final class LoggedCreateTargetChange
extends JDTChange {
    private final ICreateTargetQueries fQueries;
    private Object fSelection;

    public LoggedCreateTargetChange(Object selection, ICreateTargetQueries queries) {
        this.fSelection = selection;
        this.fQueries = queries;
    }

    public Object getModifiedElement() {
        return null;
    }

    public String getName() {
        return RefactoringCoreMessages.LoggedCreateTargetChange_change_name;
    }

    public RefactoringStatus isValid(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        IResource resource;
        if (this.fSelection instanceof IJavaScriptElement) {
            IJavaScriptElement element = (IJavaScriptElement)this.fSelection;
            if (!Checks.isAvailable(element)) {
                RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.RenameResourceChange_does_not_exist, JavaScriptElementLabels.getTextLabel(this.fSelection, 0x20000AL)));
            }
        } else if (this.fSelection instanceof IResource && !(resource = (IResource)this.fSelection).exists()) {
            RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.RenameResourceChange_does_not_exist, JavaScriptElementLabels.getTextLabel(this.fSelection, 0x20000AL)));
        }
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor monitor) throws CoreException {
        this.fQueries.createNewPackageQuery().getCreatedTarget(this.fSelection);
        return null;
    }
}

