/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.window.WindowManager;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchWindow;

public final class WorkbenchConfigurer
implements IWorkbenchConfigurer {
    private Map extraData = new HashMap();
    private boolean saveAndRestore = false;
    private boolean isEmergencyClosing = false;
    private boolean exitOnLastWindowClose = true;

    WorkbenchConfigurer() {
    }

    @Override
    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    @Override
    public WindowManager getWorkbenchWindowManager() {
        return null;
    }

    @Override
    public void declareImage(String symbolicName, ImageDescriptor descriptor, boolean shared) {
        if (symbolicName == null || descriptor == null) {
            throw new IllegalArgumentException();
        }
        WorkbenchImages.declareImage(symbolicName, descriptor, shared);
    }

    @Override
    public IWorkbenchWindowConfigurer getWindowConfigurer(IWorkbenchWindow window) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        return ((WorkbenchWindow)window).getWindowConfigurer();
    }

    @Override
    public boolean getSaveAndRestore() {
        return this.saveAndRestore;
    }

    @Override
    public void setSaveAndRestore(boolean enabled) {
        this.saveAndRestore = enabled;
    }

    @Override
    public Object getData(String key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.extraData.get(key);
    }

    @Override
    public void setData(String key, Object data) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (data != null) {
            this.extraData.put(key, data);
        } else {
            this.extraData.remove(key);
        }
    }

    @Override
    public void emergencyClose() {
        if (!this.isEmergencyClosing) {
            this.isEmergencyClosing = true;
            if (Workbench.getInstance() != null && !Workbench.getInstance().isClosing()) {
                Workbench.getInstance().close(3, true);
            }
        }
    }

    @Override
    public boolean emergencyClosing() {
        return this.isEmergencyClosing;
    }

    @Override
    public IStatus restoreState() {
        return Status.OK_STATUS;
    }

    @Override
    public void openFirstTimeWindow() {
        ((Workbench)this.getWorkbench()).openFirstTimeWindow();
    }

    @Override
    public IWorkbenchWindowConfigurer restoreWorkbenchWindow(IMemento memento) {
        return this.getWindowConfigurer(null);
    }

    @Override
    public boolean getExitOnLastWindowClose() {
        return this.exitOnLastWindowClose;
    }

    @Override
    public void setExitOnLastWindowClose(boolean enabled) {
        this.exitOnLastWindowClose = enabled;
    }
}

