/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.analysis.profiling.core.base.ICallStackSymbol;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.AggregatedCallSite;
import org.eclipse.tracecompass.analysis.profiling.core.tree.WeightedTree;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.AbstractCalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.AggregatedCalledFunctionStatistics;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.AggregatedThreadStatus;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.Messages;
import org.eclipse.tracecompass.internal.analysis.profiling.core.model.ProcessStatusInterval;

public class AggregatedCalledFunction
extends AggregatedCallSite {
    private final AggregatedCalledFunctionStatistics fStatistics;
    private long fDuration = 0L;
    private long fSelfTime = 0L;
    private long fCpuTime = -1L;
    private int fProcessId;
    private Map<ProcessStatus, AggregatedThreadStatus> fProcessStatuses = new HashMap<ProcessStatus, AggregatedThreadStatus>();

    public AggregatedCalledFunction(ICallStackSymbol symbol) {
        super(symbol, 0L);
        this.fStatistics = new AggregatedCalledFunctionStatistics();
        this.fProcessId = -1;
    }

    public AggregatedCalledFunction(AggregatedCalledFunction toCopy) {
        super(toCopy);
        this.fStatistics = new AggregatedCalledFunctionStatistics();
        this.fStatistics.merge(toCopy.fStatistics);
        this.fProcessId = toCopy.fProcessId;
        this.fDuration = toCopy.fDuration;
        this.fSelfTime = toCopy.fSelfTime;
        this.fCpuTime = toCopy.fCpuTime;
        this.mergeProcessStatuses(toCopy);
    }

    @Override
    public long getWeight() {
        return this.getDuration();
    }

    @Override
    public AggregatedCalledFunction copyOf() {
        return new AggregatedCalledFunction(this);
    }

    @Override
    protected void mergeData(WeightedTree<ICallStackSymbol> other) {
        if (!(other instanceof AggregatedCalledFunction)) {
            return;
        }
        AggregatedCalledFunction otherFct = (AggregatedCalledFunction)other;
        this.addToDuration(otherFct.getDuration());
        this.addToSelfTime(otherFct.getSelfTime());
        this.addToCpuTime(otherFct.getCpuTime());
        this.getFunctionStatistics().merge(otherFct.getFunctionStatistics(), true);
        this.mergeProcessStatuses(otherFct);
    }

    private void mergeProcessStatuses(AggregatedCalledFunction other) {
        Map<ProcessStatus, AggregatedThreadStatus> processStatuses = other.fProcessStatuses;
        for (Map.Entry<ProcessStatus, AggregatedThreadStatus> entry : processStatuses.entrySet()) {
            AggregatedThreadStatus status = this.fProcessStatuses.get(entry.getKey());
            if (status == null) {
                status = new AggregatedThreadStatus(entry.getKey());
            }
            status.merge(entry.getValue());
            this.fProcessStatuses.put(entry.getKey(), status);
        }
    }

    @Override
    public Map<String, IStatistics<?>> getStatistics() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)String.valueOf(Messages.CallGraphStats_Duration), this.getFunctionStatistics().getDurationStatistics());
        builder.put((Object)String.valueOf(Messages.CallGraphStats_SelfTime), this.getFunctionStatistics().getSelfTimeStatistics());
        builder.put((Object)String.valueOf(Messages.CallGraphStats_CpuTime), this.getFunctionStatistics().getCpuTimesStatistics());
        return builder.build();
    }

    public synchronized void addChild(AbstractCalledFunction child, AggregatedCalledFunction aggregatedChild) {
        this.fSelfTime -= aggregatedChild.getDuration();
        aggregatedChild.addFunctionCall(child);
        super.addChild(aggregatedChild);
    }

    public synchronized void addFunctionCall(AbstractCalledFunction function) {
        this.addToDuration(function.getLength());
        this.addToSelfTime(function.getSelfTime());
        this.addToCpuTime(function.getCpuTime());
        this.fProcessId = function.getProcessId();
        this.getFunctionStatistics().update(function);
    }

    private void addToDuration(long duration) {
        this.fDuration += duration;
    }

    private void addToCpuTime(long cpuTime) {
        if (cpuTime != -1L) {
            if (this.fCpuTime < 0L) {
                this.fCpuTime = 0L;
            }
            this.fCpuTime += cpuTime;
        }
    }

    public long getDuration() {
        return this.fDuration;
    }

    public long getNbCalls() {
        return this.fStatistics.getDurationStatistics().getNbElements();
    }

    public long getSelfTime() {
        return this.fSelfTime;
    }

    private void addToSelfTime(long selfTime) {
        this.fSelfTime += selfTime;
    }

    public long getCpuTime() {
        return this.fCpuTime;
    }

    public int getProcessId() {
        return this.fProcessId;
    }

    public void addKernelStatus(ProcessStatusInterval interval) {
        ProcessStatus processStatus = interval.getProcessStatus();
        AggregatedThreadStatus status = this.fProcessStatuses.get(processStatus);
        if (status == null) {
            status = new AggregatedThreadStatus(processStatus);
            this.fProcessStatuses.put(processStatus, status);
        }
        status.update(interval);
    }

    @Override
    public @NonNull Collection<WeightedTree<ICallStackSymbol>> getExtraDataTrees(int index) {
        if (index == 0) {
            return ImmutableList.copyOf(this.fProcessStatuses.values());
        }
        return Collections.emptyList();
    }

    @Override
    public @Nullable IStatistics<?> getStatistics(int metricIndex) {
        if (metricIndex < 0) {
            return this.getFunctionStatistics().getDurationStatistics();
        }
        if (metricIndex == 0) {
            return this.getFunctionStatistics().getSelfTimeStatistics();
        }
        if (metricIndex == 1) {
            return this.getFunctionStatistics().getCpuTimesStatistics();
        }
        return null;
    }

    public AggregatedCalledFunctionStatistics getFunctionStatistics() {
        return this.fStatistics;
    }

    @Override
    public String toString() {
        return "Aggregate Function: " + String.valueOf(this.getObject()) + ", Duration: " + this.getDuration() + ", Self Time: " + this.fSelfTime + " on " + this.getNbCalls() + " calls";
    }
}

