/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.comment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.Logger;

public abstract class CommentingStrategy {
    private boolean fHasRequiredPartitionTypes = false;
    private List fRequriedPartitionTypeIDs = Collections.EMPTY_LIST;
    private boolean fAllPartitionTypesAllowable = false;
    private List fAllowablePartitionTypeIDs = Collections.EMPTY_LIST;
    private String fAssociatedCommentPartitionTypeID = null;

    protected final void setPartitionInformation(List allowablePartitionTypeIDs, boolean allPartitionTypesAllowable, List requiredPartitionTypeIDs, String associatedCommentPartitionTypeID) {
        this.fAllPartitionTypesAllowable = allPartitionTypesAllowable;
        this.fRequriedPartitionTypeIDs = requiredPartitionTypeIDs;
        if (this.fRequriedPartitionTypeIDs == null) {
            this.fRequriedPartitionTypeIDs = Collections.EMPTY_LIST;
        }
        this.fHasRequiredPartitionTypes = this.fRequriedPartitionTypeIDs.size() != 0;
        this.fAllowablePartitionTypeIDs = allowablePartitionTypeIDs;
        if (this.fAllowablePartitionTypeIDs == null) {
            this.fAllowablePartitionTypeIDs = Collections.EMPTY_LIST;
        }
        this.fAssociatedCommentPartitionTypeID = associatedCommentPartitionTypeID;
    }

    public abstract void apply(IStructuredDocument var1, int var2, int var3) throws BadLocationException;

    public abstract void remove(IStructuredDocument var1, int var2, int var3, boolean var4) throws BadLocationException;

    public abstract boolean alreadyCommenting(IStructuredDocument var1, IRegion var2) throws BadLocationException;

    public abstract Object clone();

    public final boolean isApplicableFor(ITypedRegion[] regions) {
        List partitionTypeIDs = CommentingStrategy.getPartitionTypeIDs(regions);
        boolean foundAssociatedCommentPartitions = false;
        if (this.fAssociatedCommentPartitionTypeID != null && (foundAssociatedCommentPartitions = partitionTypeIDs.contains(this.fAssociatedCommentPartitionTypeID))) {
            boolean removed;
            while (removed = partitionTypeIDs.remove(this.fAssociatedCommentPartitionTypeID)) {
            }
        }
        boolean requiredPartitionsRequirementsMet = !this.fHasRequiredPartitionTypes || partitionTypeIDs.removeAll(this.fRequriedPartitionTypeIDs);
        boolean allowablePartitionsRequirementsMet = false;
        if (this.fAllPartitionTypesAllowable) {
            allowablePartitionsRequirementsMet = true;
        } else {
            partitionTypeIDs.removeAll(this.fAllowablePartitionTypeIDs);
            boolean bl = allowablePartitionsRequirementsMet = partitionTypeIDs.size() == 0;
        }
        return (requiredPartitionsRequirementsMet || foundAssociatedCommentPartitions) && allowablePartitionsRequirementsMet;
    }

    public final boolean alreadyCommenting(IStructuredDocument document, IRegion[] regions) throws BadLocationException {
        boolean alreadyCommenting = false;
        if (regions != null && regions.length > 0) {
            int offset = regions[0].getOffset();
            int length = regions[regions.length - 1].getOffset() + regions[regions.length - 1].getLength() - offset;
            Region region = new Region(offset, length);
            alreadyCommenting = this.alreadyCommenting(document, (IRegion)region);
        }
        return alreadyCommenting;
    }

    protected List getAssociatedCommentedRegions(ITypedRegion[] typedRegions) {
        ArrayList<ITypedRegion> commentedRegions = new ArrayList<ITypedRegion>();
        int i = 0;
        while (i < typedRegions.length) {
            if (typedRegions[i].getType().equals(this.fAssociatedCommentPartitionTypeID)) {
                commentedRegions.add(typedRegions[i]);
            }
            ++i;
        }
        return commentedRegions;
    }

    private static List getPartitionTypeIDs(ITypedRegion[] regions) {
        ArrayList<String> partitionTypes = new ArrayList<String>(regions.length);
        int i = 0;
        while (i < regions.length) {
            partitionTypes.add(regions[i].getType());
            ++i;
        }
        return partitionTypes;
    }

    protected static void uncomment(IDocument document, int commentPrefixOffset, String commentPrefix, int commentSuffixOffset, String commentSuffix) {
        try {
            int commentPrefixLength = commentPrefix.length();
            String postCommentPrefixChar = document.get(commentPrefixOffset + commentPrefix.length(), 1);
            if (postCommentPrefixChar.equals(" ")) {
                ++commentPrefixLength;
            }
            document.replace(commentPrefixOffset, commentPrefixLength, "");
            if (commentSuffix != null) {
                int commentSuffixLength = commentSuffix.length();
                String preCommentSuffixChar = document.get((commentSuffixOffset -= commentPrefixLength) - 1, 1);
                if (preCommentSuffixChar.equals(" ")) {
                    ++commentSuffixLength;
                    --commentSuffixOffset;
                }
                document.replace(commentSuffixOffset, commentSuffixLength, "");
            }
        }
        catch (BadLocationException e) {
            Logger.log(202, e.getMessage(), e);
        }
    }
}

