/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaElementDeltaBuilder;
import org.eclipse.wst.jsdt.internal.core.JavaModelOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class CommitWorkingCopyOperation
extends JavaModelOperation {
    public CommitWorkingCopyOperation(IJavaScriptUnit element, boolean force) {
        super(new IJavaScriptElement[]{element}, force);
    }

    @Override
    protected void executeOperation() throws JavaScriptModelException {
        try {
            this.beginTask(Messages.workingCopy_commit, 2);
            CompilationUnit workingCopy = this.getCompilationUnit();
            if (" ".equals(workingCopy.getJavaScriptProject().getElementName())) {
                workingCopy.getBuffer().save(this.progressMonitor, this.force);
                return;
            }
            IJavaScriptUnit primary = workingCopy.getPrimary();
            boolean isPrimary = workingCopy.isPrimary();
            JavaElementDeltaBuilder deltaBuilder = null;
            PackageFragmentRoot root = (PackageFragmentRoot)workingCopy.getAncestor(3);
            boolean isIncluded = !Util.isExcluded(workingCopy);
            IFile resource = (IFile)workingCopy.getResource();
            IJavaScriptProject project = root.getJavaScriptProject();
            if (isPrimary || root.validateOnClasspath().isOK() && isIncluded && resource.isAccessible() && Util.isValidCompilationUnitName(workingCopy.getElementName(), project.getOption("org.eclipse.wst.jsdt.core.compiler.source", true), project.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true))) {
                if (!isPrimary && !primary.isOpen()) {
                    primary.open(null);
                }
                if (!(!isIncluded || isPrimary && workingCopy.isConsistent())) {
                    deltaBuilder = new JavaElementDeltaBuilder(primary);
                }
                IBuffer primaryBuffer = primary.getBuffer();
                if (!isPrimary) {
                    if (primaryBuffer == null) {
                        return;
                    }
                    char[] primaryContents = primaryBuffer.getCharacters();
                    boolean hasSaved = false;
                    try {
                        IBuffer workingCopyBuffer = workingCopy.getBuffer();
                        if (workingCopyBuffer == null) {
                            return;
                        }
                        primaryBuffer.setContents(workingCopyBuffer.getCharacters());
                        primaryBuffer.save(this.progressMonitor, this.force);
                        primary.makeConsistent(this);
                        hasSaved = true;
                    }
                    finally {
                        if (!hasSaved) {
                            primaryBuffer.setContents(primaryContents);
                        }
                    }
                } else {
                    primaryBuffer.save(this.progressMonitor, this.force);
                    primary.makeConsistent(this);
                }
            } else {
                String encoding = null;
                try {
                    encoding = resource.getCharset();
                }
                catch (CoreException coreException) {}
                String contents = workingCopy.getSource();
                if (contents == null) {
                    return;
                }
                try {
                    byte[] bytes = encoding == null ? contents.getBytes() : contents.getBytes(encoding);
                    ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                    if (resource.exists()) {
                        resource.setContents((InputStream)stream, this.force ? 3 : 2, null);
                    } else {
                        resource.create((InputStream)stream, this.force, this.progressMonitor);
                    }
                }
                catch (CoreException e) {
                    throw new JavaScriptModelException(e);
                }
                catch (UnsupportedEncodingException e) {
                    throw new JavaScriptModelException(e, 985);
                }
            }
            CommitWorkingCopyOperation.setAttribute("hasModifiedResource", "true");
            workingCopy.updateTimeStamp((CompilationUnit)primary);
            workingCopy.makeConsistent(this);
            this.worked(1);
            if (deltaBuilder != null) {
                deltaBuilder.buildDeltas();
                if (deltaBuilder.delta != null) {
                    this.addDelta(deltaBuilder.delta);
                }
            }
            this.worked(1);
        }
        finally {
            this.done();
        }
    }

    protected CompilationUnit getCompilationUnit() {
        return (CompilationUnit)this.getElementToProcess();
    }

    @Override
    protected ISchedulingRule getSchedulingRule() {
        IResource resource = this.getElementToProcess().getResource();
        if (resource == null) {
            return null;
        }
        IWorkspace workspace = resource.getWorkspace();
        if (resource.exists()) {
            return workspace.getRuleFactory().modifyRule(resource);
        }
        return workspace.getRuleFactory().createRule(resource);
    }

    @Override
    public IJavaScriptModelStatus verify() {
        CompilationUnit cu = this.getCompilationUnit();
        if (!cu.isWorkingCopy()) {
            return new JavaModelStatus(967, cu);
        }
        if (cu.hasResourceChanged() && !this.force) {
            return new JavaModelStatus(981);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

