/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.MappedSeriesSettings;
import org.eclipse.swtchart.extensions.core.MappingsSupport;
import org.eclipse.swtchart.extensions.core.MappingsType;

public class SeriesMapper {
    private static final String KEY_DELIMITER = "_";
    private static final Map<String, ISeriesSettings> MAPPINGS = new HashMap<String, ISeriesSettings>();

    private SeriesMapper() {
    }

    public static String getKey(MappingsType mappingsType, String id) {
        return String.valueOf(mappingsType.name()) + KEY_DELIMITER + id;
    }

    public static void clear() {
        MAPPINGS.clear();
    }

    public static void remove(String key) {
        MAPPINGS.remove(key);
    }

    public static void remove(MappingsType mappingsType, String id) {
        SeriesMapper.remove(SeriesMapper.getKey(mappingsType, id));
    }

    public static void put(MappingsType mappingsType, String id, ISeriesSettings seriesSettings) {
        if (id != null && SeriesMapper.isValidMappingsType(mappingsType)) {
            SeriesMapper.put(SeriesMapper.getKey(mappingsType, id), seriesSettings);
        }
    }

    public static void put(String key, ISeriesSettings seriesSettings) {
        if (seriesSettings != null) {
            MAPPINGS.put(key, seriesSettings);
        }
    }

    public static ISeriesSettings get(ISeries<?> series, BaseChart baseChart) {
        String id;
        ISeriesSettings seriesSettings;
        MappingsType mappingsType;
        ISeriesSettings seriesSettingsMapped = null;
        if (baseChart != null && SeriesMapper.isValidMappingsType(mappingsType = MappingsSupport.getMappingsType(seriesSettings = baseChart.getSeriesSettings(id = series.getId())))) {
            String key = SeriesMapper.getKey(mappingsType, id);
            seriesSettingsMapped = MAPPINGS.get(key);
        }
        return seriesSettingsMapped;
    }

    public static void map(ISeries<?> series, BaseChart baseChart) {
        String id = series.getId();
        ISeriesSettings seriesSettings = baseChart.getSeriesSettings(id);
        ISeriesSettings seriesSettingsCopy = MappingsSupport.copySettings(seriesSettings);
        if (seriesSettingsCopy != null) {
            MappingsType mappingsType = MappingsSupport.getMappingsType(seriesSettings);
            SeriesMapper.put(mappingsType, id, seriesSettingsCopy);
        }
    }

    public static void unmap(ISeries<?> series, BaseChart baseChart) {
        String id = series.getId();
        ISeriesSettings seriesSettings = baseChart.getSeriesSettings(id);
        MappingsType mappingsType = MappingsSupport.getMappingsType(seriesSettings);
        SeriesMapper.remove(mappingsType, id);
        baseChart.resetSeriesSettings(series);
    }

    public static List<MappedSeriesSettings> getMappings() {
        ArrayList<MappedSeriesSettings> mappings = new ArrayList<MappedSeriesSettings>();
        for (Map.Entry<String, ISeriesSettings> entry : MAPPINGS.entrySet()) {
            String value;
            MappingsType mappingsType;
            String key = entry.getKey();
            int index = key.indexOf(KEY_DELIMITER);
            if (index <= 0 || MappingsType.NONE.equals((Object)(mappingsType = MappingsSupport.getMappingsType(value = key.substring(0, index))))) continue;
            String id = key.substring(index + 1, key.length());
            ISeriesSettings seriesSettings = entry.getValue();
            mappings.add(new MappedSeriesSettings(mappingsType, id, seriesSettings));
        }
        return mappings;
    }

    public static void update(BaseChart baseChart) {
        ISeriesSet seriesSet = baseChart.getSeriesSet();
        ISeries[] iSeriesArray = seriesSet.getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            String id = series.getId();
            ISeriesSettings seriesSettings = baseChart.getSeriesSettings(id);
            MappingsType mappingsType = MappingsSupport.getMappingsType(seriesSettings);
            String key = SeriesMapper.getKey(mappingsType, id);
            if (MAPPINGS.containsKey(key)) {
                baseChart.applySeriesSettings(series, seriesSettings);
            }
            ++n2;
        }
    }

    private static boolean isValidMappingsType(MappingsType mappingsType) {
        return !MappingsType.NONE.equals((Object)mappingsType);
    }
}

